/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ValueTest {
    private CommandLine _cl = null;
    private final Options opts = new Options();

    @Before
    public void setUp() throws Exception {
        this.opts.addOption("a", false, "toggle -a");
        this.opts.addOption("b", true, "set -b");
        this.opts.addOption("c", "c", false, "toggle -c");
        this.opts.addOption("d", "d", true, "set -d");
        OptionBuilder.hasOptionalArg();
        this.opts.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withLongOpt((String)"fish");
        this.opts.addOption(OptionBuilder.create());
        OptionBuilder.hasOptionalArgs();
        OptionBuilder.withLongOpt((String)"gravy");
        this.opts.addOption(OptionBuilder.create());
        OptionBuilder.hasOptionalArgs((int)2);
        OptionBuilder.withLongOpt((String)"hide");
        this.opts.addOption(OptionBuilder.create());
        OptionBuilder.hasOptionalArgs((int)2);
        this.opts.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.hasOptionalArgs();
        this.opts.addOption(OptionBuilder.create((char)'j'));
        String[] args = new String[]{"-a", "-b", "foo", "--c", "--d", "bar"};
        PosixParser parser = new PosixParser();
        this._cl = parser.parse(this.opts, args);
    }

    @Test
    public void testShortNoArg() {
        Assert.assertTrue((boolean)this._cl.hasOption("a"));
        Assert.assertNull((Object)this._cl.getOptionValue("a"));
    }

    @Test
    public void testShortWithArg() {
        Assert.assertTrue((boolean)this._cl.hasOption("b"));
        Assert.assertNotNull((Object)this._cl.getOptionValue("b"));
        Assert.assertEquals((Object)this._cl.getOptionValue("b"), (Object)"foo");
    }

    @Test
    public void testLongNoArg() {
        Assert.assertTrue((boolean)this._cl.hasOption("c"));
        Assert.assertNull((Object)this._cl.getOptionValue("c"));
    }

    @Test
    public void testLongWithArg() {
        Assert.assertTrue((boolean)this._cl.hasOption("d"));
        Assert.assertNotNull((Object)this._cl.getOptionValue("d"));
        Assert.assertEquals((Object)this._cl.getOptionValue("d"), (Object)"bar");
    }

    @Test
    public void testShortOptionalArgNoValue() throws Exception {
        String[] args = new String[]{"-e"};
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(this.opts, args);
        Assert.assertTrue((boolean)cmd.hasOption("e"));
        Assert.assertNull((Object)cmd.getOptionValue("e"));
    }

    @Test
    public void testShortOptionalArgValue() throws Exception {
        String[] args = new String[]{"-e", "everything"};
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(this.opts, args);
        Assert.assertTrue((boolean)cmd.hasOption("e"));
        Assert.assertEquals((Object)"everything", (Object)cmd.getOptionValue("e"));
    }

    @Test
    public void testLongOptionalNoValue() throws Exception {
        String[] args = new String[]{"--fish"};
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(this.opts, args);
        Assert.assertTrue((boolean)cmd.hasOption("fish"));
        Assert.assertNull((Object)cmd.getOptionValue("fish"));
    }

    @Test
    public void testLongOptionalArgValue() throws Exception {
        String[] args = new String[]{"--fish", "face"};
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(this.opts, args);
        Assert.assertTrue((boolean)cmd.hasOption("fish"));
        Assert.assertEquals((Object)"face", (Object)cmd.getOptionValue("fish"));
    }

    @Test
    public void testShortOptionalArgValues() throws Exception {
        String[] args = new String[]{"-j", "ink", "idea"};
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(this.opts, args);
        Assert.assertTrue((boolean)cmd.hasOption("j"));
        Assert.assertEquals((Object)"ink", (Object)cmd.getOptionValue("j"));
        Assert.assertEquals((Object)"ink", (Object)cmd.getOptionValues("j")[0]);
        Assert.assertEquals((Object)"idea", (Object)cmd.getOptionValues("j")[1]);
        Assert.assertEquals((long)cmd.getArgs().length, (long)0L);
    }

    @Test
    public void testLongOptionalArgValues() throws Exception {
        String[] args = new String[]{"--gravy", "gold", "garden"};
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(this.opts, args);
        Assert.assertTrue((boolean)cmd.hasOption("gravy"));
        Assert.assertEquals((Object)"gold", (Object)cmd.getOptionValue("gravy"));
        Assert.assertEquals((Object)"gold", (Object)cmd.getOptionValues("gravy")[0]);
        Assert.assertEquals((Object)"garden", (Object)cmd.getOptionValues("gravy")[1]);
        Assert.assertEquals((long)cmd.getArgs().length, (long)0L);
    }

    @Test
    public void testShortOptionalNArgValues() throws Exception {
        String[] args = new String[]{"-i", "ink", "idea", "isotope", "ice"};
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(this.opts, args);
        Assert.assertTrue((boolean)cmd.hasOption("i"));
        Assert.assertEquals((Object)"ink", (Object)cmd.getOptionValue("i"));
        Assert.assertEquals((Object)"ink", (Object)cmd.getOptionValues("i")[0]);
        Assert.assertEquals((Object)"idea", (Object)cmd.getOptionValues("i")[1]);
        Assert.assertEquals((long)cmd.getArgs().length, (long)2L);
        Assert.assertEquals((Object)"isotope", (Object)cmd.getArgs()[0]);
        Assert.assertEquals((Object)"ice", (Object)cmd.getArgs()[1]);
    }

    @Test
    public void testLongOptionalNArgValues() throws Exception {
        String[] args = new String[]{"--hide", "house", "hair", "head"};
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(this.opts, args);
        Assert.assertTrue((boolean)cmd.hasOption("hide"));
        Assert.assertEquals((Object)"house", (Object)cmd.getOptionValue("hide"));
        Assert.assertEquals((Object)"house", (Object)cmd.getOptionValues("hide")[0]);
        Assert.assertEquals((Object)"hair", (Object)cmd.getOptionValues("hide")[1]);
        Assert.assertEquals((long)cmd.getArgs().length, (long)1L);
        Assert.assertEquals((Object)"head", (Object)cmd.getArgs()[0]);
    }
}

