/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.bug;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Types;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BugCLI162Test {
    private static final String CR = System.getProperty("line.separator");
    private HelpFormatter formatter;
    private StringWriter sw;

    @Before
    public void setUp() throws Exception {
        this.formatter = new HelpFormatter();
        this.sw = new StringWriter();
    }

    @Test
    public void testInfiniteLoop() {
        Options options = new Options();
        options.addOption("h", "help", false, "This is a looooong description");
        this.formatter.printHelp(new PrintWriter(this.sw), 20, "app", null, options, 1, 3, null);
        String expected = "usage: app" + CR + " -h,--help   This is" + CR + "             a" + CR + "             looooon" + CR + "             g" + CR + "             descrip" + CR + "             tion" + CR;
        Assert.assertEquals((Object)expected, (Object)this.sw.toString());
    }

    @Test
    public void testPrintHelpLongLines() {
        String OPT = "-";
        String OPT_COLUMN_NAMES = "l";
        String OPT_CONNECTION = "c";
        String OPT_DESCRIPTION = "e";
        String OPT_DRIVER = "d";
        String OPT_DRIVER_INFO = "n";
        String OPT_FILE_BINDING = "b";
        String OPT_FILE_JDBC = "j";
        String OPT_FILE_SFMD = "f";
        String OPT_HELP = "h";
        String OPT_HELP_ = "help";
        String OPT_INTERACTIVE = "i";
        String OPT_JDBC_TO_SFMD = "2";
        String OPT_JDBC_TO_SFMD_L = "jdbc2sfmd";
        String OPT_METADATA = "m";
        String OPT_PARAM_MODES_INT = "o";
        String OPT_PARAM_MODES_NAME = "O";
        String OPT_PARAM_NAMES = "a";
        String OPT_PARAM_TYPES_INT = "y";
        String OPT_PARAM_TYPES_NAME = "Y";
        String OPT_PASSWORD = "p";
        String OPT_PASSWORD_L = "password";
        String OPT_SQL = "s";
        String OPT_SQL_L = "sql";
        String OPT_SQL_SPLIT_DEFAULT = "###";
        String OPT_SQL_SPLIT_L = "splitSql";
        String OPT_STACK_TRACE = "t";
        String OPT_TIMING = "g";
        String OPT_TRIM_L = "trim";
        String OPT_USER = "u";
        String OPT_WRITE_TO_FILE = "w";
        String _PMODE_IN = "IN";
        String _PMODE_INOUT = "INOUT";
        String _PMODE_OUT = "OUT";
        String _PMODE_UNK = "Unknown";
        String PMODES = "IN, INOUT, OUT, Unknown";
        Options commandLineOptions = new Options();
        commandLineOptions.addOption("h", "help", false, "Prints help and quits");
        commandLineOptions.addOption("d", "driver", true, "JDBC driver class name");
        commandLineOptions.addOption("n", "info", false, "Prints driver information and properties. If -c is not specified, all drivers on the classpath are displayed.");
        commandLineOptions.addOption("c", "url", true, "Connection URL");
        commandLineOptions.addOption("u", "user", true, "A database user name");
        commandLineOptions.addOption("p", "password", true, "The database password for the user specified with the -u option. You can obfuscate the password with org.mortbay.jetty.security.Password, see http://docs.codehaus.org/display/JETTY/Securing+Passwords");
        commandLineOptions.addOption("s", "sql", true, "Runs SQL or {call stored_procedure(?, ?)} or {?=call function(?, ?)}");
        commandLineOptions.addOption("f", "sfmd", true, "Writes a SFMD file for the given SQL");
        commandLineOptions.addOption("b", "jdbc", true, "Writes a JDBC binding node file for the given SQL");
        commandLineOptions.addOption("j", "node", true, "Writes a JDBC node file for the given SQL (internal debugging)");
        commandLineOptions.addOption("w", "outfile", true, "Writes the SQL output to the given file");
        commandLineOptions.addOption("e", "description", true, "SFMD description. A default description is used if omited. Example: -e \"Runs such and such\"");
        commandLineOptions.addOption("i", "interactive", false, "Runs in interactive mode, reading and writing from the console, 'go' or '/' sends a statement");
        commandLineOptions.addOption("g", "printTiming", false, "Prints timing information");
        commandLineOptions.addOption("m", "printMetaData", false, "Prints metadata information");
        commandLineOptions.addOption("t", "printStack", false, "Prints stack traces on errors");
        Option option = new Option("l", "columnNames", true, "Column XML names; default names column labels. Example: -l \"cname1 cname2\"");
        commandLineOptions.addOption(option);
        option = new Option("a", "paramNames", true, "Parameter XML names; default names are param1, param2, etc. Example: -a \"pname1 pname2\"");
        commandLineOptions.addOption(option);
        OptionGroup pOutTypesOptionGroup = new OptionGroup();
        String pOutTypesOptionGroupDoc = "-y and -Y are mutually exclusive.";
        String typesClassName = Types.class.getName();
        option = new Option("y", "paramTypes", true, "Parameter types from " + typesClassName + ". " + pOutTypesOptionGroupDoc + " Example: " + "-" + "y" + " \"-10 12\"");
        commandLineOptions.addOption(option);
        option = new Option("Y", "paramTypeNames", true, "Parameter " + typesClassName + " names. " + pOutTypesOptionGroupDoc + " Example: " + "-" + "Y" + " \"CURSOR VARCHAR\"");
        commandLineOptions.addOption(option);
        commandLineOptions.addOptionGroup(pOutTypesOptionGroup);
        OptionGroup modesOptionGroup = new OptionGroup();
        String modesOptionGroupDoc = "-o and -O are mutually exclusive.";
        option = new Option("o", "paramModes", true, "Parameters modes (1=IN, 2=INOUT, 4=OUT, 0=Unknown). " + modesOptionGroupDoc + " Example for 2 parameters, OUT and IN: " + "-" + "o" + " \"" + 4 + " " + 1 + "\"");
        modesOptionGroup.addOption(option);
        option = new Option("O", "paramModeNames", true, "Parameters mode names (IN, INOUT, OUT, Unknown). " + modesOptionGroupDoc + " Example for 2 parameters, OUT and IN: " + "-" + "O" + " \"" + "OUT" + " " + "IN" + "\"");
        modesOptionGroup.addOption(option);
        commandLineOptions.addOptionGroup(modesOptionGroup);
        option = new Option(null, "trim", true, "Trims leading and trailing spaces from all column values. Column XML names can be optionally specified to set which columns to trim.");
        option.setOptionalArg(true);
        commandLineOptions.addOption(option);
        option = new Option("2", "jdbc2sfmd", true, "Converts the JDBC file in the first argument to an SMFD file specified in the second argument.");
        option.setArgs(2);
        commandLineOptions.addOption(option);
        this.formatter.printHelp(new PrintWriter(this.sw), 74, this.getClass().getName(), null, commandLineOptions, 1, 3, null);
        String expected = "usage: org.apache.commons.cli.bug.BugCLI162Test" + CR + " -2,--jdbc2sfmd <arg>        Converts the JDBC file in the first argument" + CR + "                             to an SMFD file specified in the second" + CR + "                             argument." + CR + " -a,--paramNames <arg>       Parameter XML names; default names are" + CR + "                             param1, param2, etc. Example: -a \"pname1" + CR + "                             pname2\"" + CR + " -b,--jdbc <arg>             Writes a JDBC binding node file for the given" + CR + "                             SQL" + CR + " -c,--url <arg>              Connection URL" + CR + " -d,--driver <arg>           JDBC driver class name" + CR + " -e,--description <arg>      SFMD description. A default description is" + CR + "                             used if omited. Example: -e \"Runs such and" + CR + "                             such\"" + CR + " -f,--sfmd <arg>             Writes a SFMD file for the given SQL" + CR + " -g,--printTiming            Prints timing information" + CR + " -h,--help                   Prints help and quits" + CR + " -i,--interactive            Runs in interactive mode, reading and writing" + CR + "                             from the console, 'go' or '/' sends a" + CR + "                             statement" + CR + " -j,--node <arg>             Writes a JDBC node file for the given SQL" + CR + "                             (internal debugging)" + CR + " -l,--columnNames <arg>      Column XML names; default names column" + CR + "                             labels. Example: -l \"cname1 cname2\"" + CR + " -m,--printMetaData          Prints metadata information" + CR + " -n,--info                   Prints driver information and properties. If" + CR + "                             -c is not specified, all drivers on the" + CR + "                             classpath are displayed." + CR + " -o,--paramModes <arg>       Parameters modes (1=IN, 2=INOUT, 4=OUT," + CR + "                             0=Unknown). -o and -O are mutually exclusive." + CR + "                             Example for 2 parameters, OUT and IN: -o \"4" + CR + "                             1\"" + CR + " -O,--paramModeNames <arg>   Parameters mode names (IN, INOUT, OUT," + CR + "                             Unknown). -o and -O are mutually exclusive." + CR + "                             Example for 2 parameters, OUT and IN: -O \"OUT" + CR + "                             IN\"" + CR + " -p,--password <arg>         The database password for the user specified" + CR + "                             with the -u option. You can obfuscate the" + CR + "                             password with" + CR + "                             org.mortbay.jetty.security.Password, see" + CR + "                             http://docs.codehaus.org/display/JETTY/Securi" + CR + "                             ng+Passwords" + CR + " -s,--sql <arg>              Runs SQL or {call stored_procedure(?, ?)} or" + CR + "                             {?=call function(?, ?)}" + CR + " -t,--printStack             Prints stack traces on errors" + CR + "    --trim <arg>             Trims leading and trailing spaces from all" + CR + "                             column values. Column XML names can be" + CR + "                             optionally specified to set which columns to" + CR + "                             trim." + CR + " -u,--user <arg>             A database user name" + CR + " -w,--outfile <arg>          Writes the SQL output to the given file" + CR + " -y,--paramTypes <arg>       Parameter types from java.sql.Types. -y and" + CR + "                             -Y are mutually exclusive. Example: -y \"-10" + CR + "                             12\"" + CR + " -Y,--paramTypeNames <arg>   Parameter java.sql.Types names. -y and -Y are" + CR + "                             mutually exclusive. Example: -Y \"CURSOR" + CR + "                             VARCHAR\"" + CR;
        Assert.assertEquals((Object)expected, (Object)this.sw.toString());
    }

    @Test
    public void testLongLineChunking() {
        Options options = new Options();
        options.addOption("x", "extralongarg", false, "This description has ReallyLongValuesThatAreLongerThanTheWidthOfTheColumns and also other ReallyLongValuesThatAreHugerAndBiggerThanTheWidthOfTheColumnsBob, yes. ");
        this.formatter.printHelp(new PrintWriter(this.sw), 35, this.getClass().getName(), "Header", options, 0, 5, "Footer");
        String expected = "usage:" + CR + "       org.apache.commons.cli.bug.B" + CR + "       ugCLI162Test" + CR + "Header" + CR + "-x,--extralongarg     This" + CR + "                      description" + CR + "                      has" + CR + "                      ReallyLongVal" + CR + "                      uesThatAreLon" + CR + "                      gerThanTheWid" + CR + "                      thOfTheColumn" + CR + "                      s and also" + CR + "                      other" + CR + "                      ReallyLongVal" + CR + "                      uesThatAreHug" + CR + "                      erAndBiggerTh" + CR + "                      anTheWidthOfT" + CR + "                      heColumnsBob," + CR + "                      yes." + CR + "Footer" + CR;
        Assert.assertEquals((String)"Long arguments did not split as expected", (Object)expected, (Object)this.sw.toString());
    }

    @Test
    public void testLongLineChunkingIndentIgnored() {
        Options options = new Options();
        options.addOption("x", "extralongarg", false, "This description is Long.");
        this.formatter.printHelp(new PrintWriter(this.sw), 22, this.getClass().getName(), "Header", options, 0, 5, "Footer");
        String expected = "usage:" + CR + "       org.apache.comm" + CR + "       ons.cli.bug.Bug" + CR + "       CLI162Test" + CR + "Header" + CR + "-x,--extralongarg" + CR + " This description is" + CR + " Long." + CR + "Footer" + CR;
        Assert.assertEquals((String)"Long arguments did not split as expected", (Object)expected, (Object)this.sw.toString());
    }
}

