/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.junit.Assert;
import org.junit.Test;

public class OptionBuilderTest {
    @Test
    public void testCompleteOption() {
        OptionBuilder.withLongOpt((String)"simple option");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.hasArgs();
        OptionBuilder.withType(Float.class);
        OptionBuilder.withDescription((String)"this is a simple option");
        Option simple = OptionBuilder.create((char)'s');
        Assert.assertEquals((Object)"s", (Object)simple.getOpt());
        Assert.assertEquals((Object)"simple option", (Object)simple.getLongOpt());
        Assert.assertEquals((Object)"this is a simple option", (Object)simple.getDescription());
        Assert.assertEquals((Object)simple.getType(), Float.class);
        Assert.assertTrue((boolean)simple.hasArg());
        Assert.assertTrue((boolean)simple.isRequired());
        Assert.assertTrue((boolean)simple.hasArgs());
    }

    @Test
    public void testTwoCompleteOptions() {
        OptionBuilder.withLongOpt((String)"simple option");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.hasArgs();
        OptionBuilder.withType(Float.class);
        OptionBuilder.withDescription((String)"this is a simple option");
        Option simple = OptionBuilder.create((char)'s');
        Assert.assertEquals((Object)"s", (Object)simple.getOpt());
        Assert.assertEquals((Object)"simple option", (Object)simple.getLongOpt());
        Assert.assertEquals((Object)"this is a simple option", (Object)simple.getDescription());
        Assert.assertEquals((Object)simple.getType(), Float.class);
        Assert.assertTrue((boolean)simple.hasArg());
        Assert.assertTrue((boolean)simple.isRequired());
        Assert.assertTrue((boolean)simple.hasArgs());
        OptionBuilder.withLongOpt((String)"dimple option");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"this is a dimple option");
        simple = OptionBuilder.create((char)'d');
        Assert.assertEquals((Object)"d", (Object)simple.getOpt());
        Assert.assertEquals((Object)"dimple option", (Object)simple.getLongOpt());
        Assert.assertEquals((Object)"this is a dimple option", (Object)simple.getDescription());
        Assert.assertEquals(String.class, (Object)simple.getType());
        Assert.assertTrue((boolean)simple.hasArg());
        Assert.assertTrue((!simple.isRequired() ? 1 : 0) != 0);
        Assert.assertTrue((!simple.hasArgs() ? 1 : 0) != 0);
    }

    @Test
    public void testBaseOptionCharOpt() {
        OptionBuilder.withDescription((String)"option description");
        Option base = OptionBuilder.create((char)'o');
        Assert.assertEquals((Object)"o", (Object)base.getOpt());
        Assert.assertEquals((Object)"option description", (Object)base.getDescription());
        Assert.assertTrue((!base.hasArg() ? 1 : 0) != 0);
    }

    @Test
    public void testBaseOptionStringOpt() {
        OptionBuilder.withDescription((String)"option description");
        Option base = OptionBuilder.create((String)"o");
        Assert.assertEquals((Object)"o", (Object)base.getOpt());
        Assert.assertEquals((Object)"option description", (Object)base.getDescription());
        Assert.assertTrue((!base.hasArg() ? 1 : 0) != 0);
    }

    @Test
    public void testSpecialOptChars() throws Exception {
        OptionBuilder.withDescription((String)"help options");
        Option opt1 = OptionBuilder.create((char)'?');
        Assert.assertEquals((Object)"?", (Object)opt1.getOpt());
        OptionBuilder.withDescription((String)"read from stdin");
        Option opt2 = OptionBuilder.create((char)'@');
        Assert.assertEquals((Object)"@", (Object)opt2.getOpt());
        try {
            OptionBuilder.create((char)' ');
            Assert.fail((String)"IllegalArgumentException not caught");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testOptionArgNumbers() {
        OptionBuilder.withDescription((String)"option description");
        OptionBuilder.hasArgs((int)2);
        Option opt = OptionBuilder.create((char)'o');
        Assert.assertEquals((long)2L, (long)opt.getArgs());
    }

    @Test
    public void testIllegalOptions() {
        try {
            OptionBuilder.withDescription((String)"option description");
            OptionBuilder.create((char)'\"');
            Assert.fail((String)"IllegalArgumentException not caught");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            OptionBuilder.create((String)"opt`");
            Assert.fail((String)"IllegalArgumentException not caught");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            OptionBuilder.create((String)"opt");
        }
        catch (IllegalArgumentException exp) {
            Assert.fail((String)"IllegalArgumentException caught");
        }
    }

    @Test
    public void testCreateIncompleteOption() {
        try {
            OptionBuilder.hasArg();
            OptionBuilder.create();
            Assert.fail((String)"Incomplete option should be rejected");
        }
        catch (IllegalArgumentException e) {
            OptionBuilder.create((String)"opt");
        }
    }

    @Test
    public void testBuilderIsResettedAlways() {
        try {
            OptionBuilder.withDescription((String)"JUnit");
            OptionBuilder.create((char)'\"');
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertNull((String)"we inherited a description", (Object)OptionBuilder.create((char)'x').getDescription());
        try {
            OptionBuilder.withDescription((String)"JUnit");
            OptionBuilder.create();
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertNull((String)"we inherited a description", (Object)OptionBuilder.create((char)'x').getDescription());
    }
}

