/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.bug;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.junit.Assert;
import org.junit.Test;

public class BugCLI266Test {
    private List<String> insertedOrder = Arrays.asList("h", "d", "f", "x", "s", "p", "t", "w", "o");
    private List<String> sortOrder = Arrays.asList("d", "f", "h", "o", "p", "s", "t", "w", "x");

    @Test
    public void testOptionComparatorDefaultOrder() throws ParseException {
        HelpFormatter formatter = new HelpFormatter();
        ArrayList options = new ArrayList(this.getOptions().getOptions());
        Collections.sort(options, formatter.getOptionComparator());
        int i = 0;
        for (Option o : options) {
            Assert.assertEquals((Object)o.getOpt(), (Object)this.sortOrder.get(i));
            ++i;
        }
    }

    @Test
    public void testOptionComparatorInsertedOrder() throws ParseException {
        Collection options = this.getOptions().getOptions();
        int i = 0;
        for (Option o : options) {
            Assert.assertEquals((Object)o.getOpt(), (Object)this.insertedOrder.get(i));
            ++i;
        }
    }

    private Options getOptions() {
        Options options = new Options();
        Option help = Option.builder((String)"h").longOpt("help").desc("Prints this help message").build();
        options.addOption(help);
        this.buildOptionsGroup(options);
        Option t = Option.builder((String)"t").required().hasArg().argName("file").build();
        Option w = Option.builder((String)"w").required().hasArg().argName("word").build();
        Option o = Option.builder((String)"o").hasArg().argName("directory").build();
        options.addOption(t);
        options.addOption(w);
        options.addOption(o);
        return options;
    }

    private void buildOptionsGroup(Options options) {
        OptionGroup firstGroup = new OptionGroup();
        OptionGroup secondGroup = new OptionGroup();
        firstGroup.setRequired(true);
        secondGroup.setRequired(true);
        firstGroup.addOption(Option.builder((String)"d").longOpt("db").hasArg().argName("table-name").build());
        firstGroup.addOption(Option.builder((String)"f").longOpt("flat-file").hasArg().argName("input.csv").build());
        options.addOptionGroup(firstGroup);
        secondGroup.addOption(Option.builder((String)"x").hasArg().argName("arg1").build());
        secondGroup.addOption(Option.builder((String)"s").build());
        secondGroup.addOption(Option.builder((String)"p").hasArg().argName("arg1").build());
        options.addOptionGroup(secondGroup);
    }
}

