/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import org.apache.commons.cli.Option;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionTest {
    @Test
    public void testClear() {
        TestOption option = new TestOption("x", true, "");
        Assert.assertEquals((long)0L, (long)option.getValuesList().size());
        option.addValue("a");
        Assert.assertEquals((long)1L, (long)option.getValuesList().size());
        option.clearValues();
        Assert.assertEquals((long)0L, (long)option.getValuesList().size());
    }

    @Test
    public void testClone() {
        TestOption a = new TestOption("a", true, "");
        TestOption b = (TestOption)((Object)a.clone());
        Assert.assertEquals((Object)((Object)a), (Object)((Object)b));
        Assert.assertNotSame((Object)((Object)a), (Object)((Object)b));
        a.setDescription("a");
        Assert.assertEquals((Object)"", (Object)b.getDescription());
        b.setArgs(2);
        b.addValue("b1");
        b.addValue("b2");
        Assert.assertEquals((long)1L, (long)a.getArgs());
        Assert.assertEquals((long)0L, (long)a.getValuesList().size());
        Assert.assertEquals((long)2L, (long)b.getValues().length);
    }

    @Test
    public void testSubclass() {
        DefaultOption option = new DefaultOption("f", "file", "myfile.txt");
        Option clone = (Option)option.clone();
        Assert.assertEquals((Object)"myfile.txt", (Object)clone.getValue());
        Assert.assertEquals(DefaultOption.class, clone.getClass());
    }

    @Test
    public void testHasArgName() {
        Option option = new Option("f", null);
        option.setArgName(null);
        Assert.assertFalse((boolean)option.hasArgName());
        option.setArgName("");
        Assert.assertFalse((boolean)option.hasArgName());
        option.setArgName("file");
        Assert.assertTrue((boolean)option.hasArgName());
    }

    @Test
    public void testHasArgs() {
        Option option = new Option("f", null);
        option.setArgs(0);
        Assert.assertFalse((boolean)option.hasArgs());
        option.setArgs(1);
        Assert.assertFalse((boolean)option.hasArgs());
        option.setArgs(10);
        Assert.assertTrue((boolean)option.hasArgs());
        option.setArgs(-2);
        Assert.assertTrue((boolean)option.hasArgs());
        option.setArgs(-1);
        Assert.assertFalse((boolean)option.hasArgs());
    }

    @Test
    public void testGetValue() {
        Option option = new Option("f", null);
        option.setArgs(-2);
        Assert.assertEquals((Object)"default", (Object)option.getValue("default"));
        Assert.assertEquals(null, (Object)option.getValue(0));
        option.addValueForProcessing("foo");
        Assert.assertEquals((Object)"foo", (Object)option.getValue());
        Assert.assertEquals((Object)"foo", (Object)option.getValue(0));
        Assert.assertEquals((Object)"foo", (Object)option.getValue("default"));
    }

    @Test
    public void testBuilderMethods() {
        char defaultSeparator = '\u0000';
        OptionTest.checkOption(Option.builder((String)"a").desc("desc").build(), "a", "desc", null, -1, null, false, false, defaultSeparator, String.class);
        OptionTest.checkOption(Option.builder((String)"a").desc("desc").build(), "a", "desc", null, -1, null, false, false, defaultSeparator, String.class);
        OptionTest.checkOption(Option.builder((String)"a").desc("desc").longOpt("aaa").build(), "a", "desc", "aaa", -1, null, false, false, defaultSeparator, String.class);
        OptionTest.checkOption(Option.builder((String)"a").desc("desc").hasArg(true).build(), "a", "desc", null, 1, null, false, false, defaultSeparator, String.class);
        OptionTest.checkOption(Option.builder((String)"a").desc("desc").hasArg(false).build(), "a", "desc", null, -1, null, false, false, defaultSeparator, String.class);
        OptionTest.checkOption(Option.builder((String)"a").desc("desc").hasArg(true).build(), "a", "desc", null, 1, null, false, false, defaultSeparator, String.class);
        OptionTest.checkOption(Option.builder((String)"a").desc("desc").numberOfArgs(3).build(), "a", "desc", null, 3, null, false, false, defaultSeparator, String.class);
        OptionTest.checkOption(Option.builder((String)"a").desc("desc").required(true).build(), "a", "desc", null, -1, null, true, false, defaultSeparator, String.class);
        OptionTest.checkOption(Option.builder((String)"a").desc("desc").required(false).build(), "a", "desc", null, -1, null, false, false, defaultSeparator, String.class);
        OptionTest.checkOption(Option.builder((String)"a").desc("desc").argName("arg1").build(), "a", "desc", null, -1, "arg1", false, false, defaultSeparator, String.class);
        OptionTest.checkOption(Option.builder((String)"a").desc("desc").optionalArg(false).build(), "a", "desc", null, -1, null, false, false, defaultSeparator, String.class);
        OptionTest.checkOption(Option.builder((String)"a").desc("desc").optionalArg(true).build(), "a", "desc", null, -1, null, false, true, defaultSeparator, String.class);
        OptionTest.checkOption(Option.builder((String)"a").desc("desc").valueSeparator(':').build(), "a", "desc", null, -1, null, false, false, ':', String.class);
        OptionTest.checkOption(Option.builder((String)"a").desc("desc").type(Integer.class).build(), "a", "desc", null, -1, null, false, false, defaultSeparator, Integer.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBuilderInsufficientParams1() {
        Option.builder().desc("desc").build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBuilderInsufficientParams2() {
        Option.builder(null).desc("desc").build();
    }

    private static void checkOption(Option option, String opt, String description, String longOpt, int numArgs, String argName, boolean required, boolean optionalArg, char valueSeparator, Class<?> cls) {
        Assert.assertEquals((Object)opt, (Object)option.getOpt());
        Assert.assertEquals((Object)description, (Object)option.getDescription());
        Assert.assertEquals((Object)longOpt, (Object)option.getLongOpt());
        Assert.assertEquals((long)numArgs, (long)option.getArgs());
        Assert.assertEquals((Object)argName, (Object)option.getArgName());
        Assert.assertEquals((Object)required, (Object)option.isRequired());
        Assert.assertEquals((Object)optionalArg, (Object)option.hasOptionalArg());
        Assert.assertEquals((long)valueSeparator, (long)option.getValueSeparator());
        Assert.assertEquals(cls, (Object)option.getType());
    }

    private static class DefaultOption
    extends Option {
        private static final long serialVersionUID = 1L;
        private final String defaultValue;

        public DefaultOption(String opt, String description, String defaultValue) throws IllegalArgumentException {
            super(opt, true, description);
            this.defaultValue = defaultValue;
        }

        public String getValue() {
            return super.getValue() != null ? super.getValue() : this.defaultValue;
        }
    }

    private static class TestOption
    extends Option {
        private static final long serialVersionUID = 1L;

        public TestOption(String opt, boolean hasArg, String description) throws IllegalArgumentException {
            super(opt, hasArg, description);
        }

        public boolean addValue(String value) {
            this.addValueForProcessing(value);
            return true;
        }
    }
}

