/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.bug;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BugCLI265Test {
    private DefaultParser parser;
    private Options options;

    @Before
    public void setUp() throws Exception {
        this.parser = new DefaultParser();
        Option optionT1 = Option.builder((String)"t1").hasArg().numberOfArgs(1).optionalArg(true).argName("t1_path").build();
        Option optionA = Option.builder((String)"a").hasArg(false).build();
        Option optionB = Option.builder((String)"b").hasArg(false).build();
        Option optionLast = Option.builder((String)"last").hasArg(false).build();
        this.options = new Options().addOption(optionT1).addOption(optionA).addOption(optionB).addOption(optionLast);
    }

    @Test
    public void shouldParseShortOptionWithValue() throws Exception {
        String[] shortOptionWithValue = new String[]{"-t1", "path/to/my/db"};
        CommandLine commandLine = this.parser.parse(this.options, shortOptionWithValue);
        Assert.assertEquals((Object)"path/to/my/db", (Object)commandLine.getOptionValue("t1"));
        Assert.assertFalse((boolean)commandLine.hasOption("last"));
    }

    @Test
    public void shouldParseShortOptionWithoutValue() throws Exception {
        String[] twoShortOptions = new String[]{"-t1", "-last"};
        CommandLine commandLine = this.parser.parse(this.options, twoShortOptions);
        Assert.assertTrue((boolean)commandLine.hasOption("t1"));
        Assert.assertNotEquals((String)"Second option has been used as value for first option", (Object)"-last", (Object)commandLine.getOptionValue("t1"));
        Assert.assertTrue((String)"Second option has not been detected", (boolean)commandLine.hasOption("last"));
    }

    @Test
    public void shouldParseConcatenatedShortOptions() throws Exception {
        String[] concatenatedShortOptions = new String[]{"-t1", "-ab"};
        CommandLine commandLine = this.parser.parse(this.options, concatenatedShortOptions);
        Assert.assertTrue((boolean)commandLine.hasOption("t1"));
        Assert.assertNull((Object)commandLine.getOptionValue("t1"));
        Assert.assertTrue((boolean)commandLine.hasOption("a"));
        Assert.assertTrue((boolean)commandLine.hasOption("b"));
        Assert.assertFalse((boolean)commandLine.hasOption("last"));
    }
}

