/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ValuesTest {
    private CommandLine cmd;

    @Before
    public void setUp() throws Exception {
        Options options = new Options();
        options.addOption("a", false, "toggle -a");
        options.addOption("b", true, "set -b");
        options.addOption("c", "c", false, "toggle -c");
        options.addOption("d", "d", true, "set -d");
        OptionBuilder.withLongOpt((String)"e");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"set -e ");
        options.addOption(OptionBuilder.create((char)'e'));
        options.addOption("f", "f", false, "jk");
        OptionBuilder.withLongOpt((String)"g");
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withDescription((String)"set -g");
        options.addOption(OptionBuilder.create((char)'g'));
        OptionBuilder.withLongOpt((String)"h");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"set -h");
        options.addOption(OptionBuilder.create((char)'h'));
        OptionBuilder.withLongOpt((String)"i");
        OptionBuilder.withDescription((String)"set -i");
        options.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.withLongOpt((String)"j");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"set -j");
        OptionBuilder.withValueSeparator((char)'=');
        options.addOption(OptionBuilder.create((char)'j'));
        OptionBuilder.withLongOpt((String)"k");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"set -k");
        OptionBuilder.withValueSeparator((char)'=');
        options.addOption(OptionBuilder.create((char)'k'));
        OptionBuilder.withLongOpt((String)"m");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"set -m");
        OptionBuilder.withValueSeparator();
        options.addOption(OptionBuilder.create((char)'m'));
        String[] args = new String[]{"-a", "-b", "foo", "--c", "--d", "bar", "-e", "one", "two", "-f", "arg1", "arg2", "-g", "val1", "val2", "arg3", "-h", "val1", "-i", "-h", "val2", "-jkey=value", "-j", "key=value", "-kkey1=value1", "-kkey2=value2", "-mkey=value"};
        PosixParser parser = new PosixParser();
        this.cmd = parser.parse(options, args);
    }

    @Test
    public void testCharSeparator() {
        Assert.assertTrue((String)"Option j is not set", (boolean)this.cmd.hasOption("j"));
        Assert.assertTrue((String)"Option j is not set", (boolean)this.cmd.hasOption('j'));
        Assert.assertArrayEquals((Object[])new String[]{"key", "value", "key", "value"}, (Object[])this.cmd.getOptionValues("j"));
        Assert.assertArrayEquals((Object[])new String[]{"key", "value", "key", "value"}, (Object[])this.cmd.getOptionValues('j'));
        Assert.assertTrue((String)"Option k is not set", (boolean)this.cmd.hasOption("k"));
        Assert.assertTrue((String)"Option k is not set", (boolean)this.cmd.hasOption('k'));
        Assert.assertArrayEquals((Object[])new String[]{"key1", "value1", "key2", "value2"}, (Object[])this.cmd.getOptionValues("k"));
        Assert.assertArrayEquals((Object[])new String[]{"key1", "value1", "key2", "value2"}, (Object[])this.cmd.getOptionValues('k'));
        Assert.assertTrue((String)"Option m is not set", (boolean)this.cmd.hasOption("m"));
        Assert.assertTrue((String)"Option m is not set", (boolean)this.cmd.hasOption('m'));
        Assert.assertArrayEquals((Object[])new String[]{"key", "value"}, (Object[])this.cmd.getOptionValues("m"));
        Assert.assertArrayEquals((Object[])new String[]{"key", "value"}, (Object[])this.cmd.getOptionValues('m'));
    }

    @Test
    public void testComplexValues() {
        Assert.assertTrue((String)"Option i is not set", (boolean)this.cmd.hasOption("i"));
        Assert.assertTrue((String)"Option h is not set", (boolean)this.cmd.hasOption("h"));
        Assert.assertArrayEquals((Object[])new String[]{"val1", "val2"}, (Object[])this.cmd.getOptionValues("h"));
    }

    @Test
    public void testExtraArgs() {
        Assert.assertArrayEquals((String)"Extra args", (Object[])new String[]{"arg1", "arg2", "arg3"}, (Object[])this.cmd.getArgs());
    }

    @Test
    public void testMultipleArgValues() {
        Assert.assertTrue((String)"Option e is not set", (boolean)this.cmd.hasOption("e"));
        Assert.assertArrayEquals((Object[])new String[]{"one", "two"}, (Object[])this.cmd.getOptionValues("e"));
    }

    @Test
    public void testShortArgs() {
        Assert.assertTrue((String)"Option a is not set", (boolean)this.cmd.hasOption("a"));
        Assert.assertTrue((String)"Option c is not set", (boolean)this.cmd.hasOption("c"));
        Assert.assertNull((Object)this.cmd.getOptionValues("a"));
        Assert.assertNull((Object)this.cmd.getOptionValues("c"));
    }

    @Test
    public void testShortArgsWithValue() {
        Assert.assertTrue((String)"Option b is not set", (boolean)this.cmd.hasOption("b"));
        Assert.assertEquals((Object)"foo", (Object)this.cmd.getOptionValue("b"));
        Assert.assertEquals((long)1L, (long)this.cmd.getOptionValues("b").length);
        Assert.assertTrue((String)"Option d is not set", (boolean)this.cmd.hasOption("d"));
        Assert.assertEquals((Object)"bar", (Object)this.cmd.getOptionValue("d"));
        Assert.assertEquals((long)1L, (long)this.cmd.getOptionValues("d").length);
    }

    @Test
    public void testTwoArgValues() {
        Assert.assertTrue((String)"Option g is not set", (boolean)this.cmd.hasOption("g"));
        Assert.assertArrayEquals((Object[])new String[]{"val1", "val2"}, (Object[])this.cmd.getOptionValues("g"));
    }
}

