/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.AmbiguousOptionException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.Parser;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractParserTestCase {
    protected CommandLineParser parser;
    protected Options options;

    private CommandLine parse(CommandLineParser parser, Options opts, String[] args, Properties properties) throws ParseException {
        if (parser instanceof Parser) {
            return ((Parser)parser).parse(opts, args, properties);
        }
        if (parser instanceof DefaultParser) {
            return ((DefaultParser)parser).parse(opts, args, properties);
        }
        throw new UnsupportedOperationException("Default options not supported by this parser");
    }

    @Before
    public void setUp() {
        this.options = new Options().addOption("a", "enable-a", false, "turn [a] on or off").addOption("b", "bfile", true, "set the value of [b]").addOption("c", "copt", false, "turn [c] on or off");
    }

    @Test
    public void testAmbiguousLongWithoutEqualSingleDash() throws Exception {
        String[] args = new String[]{"-b", "-foobar"};
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"foo");
        OptionBuilder.hasOptionalArg();
        options.addOption(OptionBuilder.create((char)'f'));
        OptionBuilder.withLongOpt((String)"bar");
        OptionBuilder.hasOptionalArg();
        options.addOption(OptionBuilder.create((char)'b'));
        CommandLine cl = this.parser.parse(options, args);
        Assert.assertTrue((boolean)cl.hasOption("b"));
        Assert.assertTrue((boolean)cl.hasOption("f"));
        Assert.assertEquals((Object)"bar", (Object)cl.getOptionValue("foo"));
    }

    @Test
    public void testAmbiguousLongWithoutEqualSingleDash2() throws Exception {
        String[] args = new String[]{"-b", "-foobar"};
        Options options = new Options();
        options.addOption(Option.builder().longOpt("foo").option("f").optionalArg(true).build());
        options.addOption(Option.builder().longOpt("bar").option("b").optionalArg(false).build());
        CommandLine cl = this.parser.parse(options, args);
        Assert.assertTrue((boolean)cl.hasOption("b"));
        Assert.assertTrue((boolean)cl.hasOption("f"));
        Assert.assertEquals((Object)"bar", (Object)cl.getOptionValue("foo"));
    }

    @Test
    public void testAmbiguousPartialLongOption1() throws Exception {
        String[] args = new String[]{"--ver"};
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"version");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"verbose");
        options.addOption(OptionBuilder.create());
        boolean caught = false;
        try {
            this.parser.parse(options, args);
        }
        catch (AmbiguousOptionException e) {
            caught = true;
            Assert.assertEquals((String)"Partial option", (Object)"--ver", (Object)e.getOption());
            Assert.assertNotNull((String)"Matching options null", (Object)e.getMatchingOptions());
            Assert.assertEquals((String)"Matching options size", (long)2L, (long)e.getMatchingOptions().size());
        }
        Assert.assertTrue((String)"Confirm MissingArgumentException caught", (boolean)caught);
    }

    @Test
    public void testAmbiguousPartialLongOption2() throws Exception {
        String[] args = new String[]{"-ver"};
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"version");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"verbose");
        options.addOption(OptionBuilder.create());
        boolean caught = false;
        try {
            this.parser.parse(options, args);
        }
        catch (AmbiguousOptionException e) {
            caught = true;
            Assert.assertEquals((String)"Partial option", (Object)"-ver", (Object)e.getOption());
            Assert.assertNotNull((String)"Matching options null", (Object)e.getMatchingOptions());
            Assert.assertEquals((String)"Matching options size", (long)2L, (long)e.getMatchingOptions().size());
        }
        Assert.assertTrue((String)"Confirm MissingArgumentException caught", (boolean)caught);
    }

    @Test
    public void testAmbiguousPartialLongOption3() throws Exception {
        String[] args = new String[]{"--ver=1"};
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"version");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"verbose");
        OptionBuilder.hasOptionalArg();
        options.addOption(OptionBuilder.create());
        boolean caught = false;
        try {
            this.parser.parse(options, args);
        }
        catch (AmbiguousOptionException e) {
            caught = true;
            Assert.assertEquals((String)"Partial option", (Object)"--ver", (Object)e.getOption());
            Assert.assertNotNull((String)"Matching options null", (Object)e.getMatchingOptions());
            Assert.assertEquals((String)"Matching options size", (long)2L, (long)e.getMatchingOptions().size());
        }
        Assert.assertTrue((String)"Confirm MissingArgumentException caught", (boolean)caught);
    }

    @Test
    public void testAmbiguousPartialLongOption4() throws Exception {
        String[] args = new String[]{"-ver=1"};
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"version");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"verbose");
        OptionBuilder.hasOptionalArg();
        options.addOption(OptionBuilder.create());
        boolean caught = false;
        try {
            this.parser.parse(options, args);
        }
        catch (AmbiguousOptionException e) {
            caught = true;
            Assert.assertEquals((String)"Partial option", (Object)"-ver", (Object)e.getOption());
            Assert.assertNotNull((String)"Matching options null", (Object)e.getMatchingOptions());
            Assert.assertEquals((String)"Matching options size", (long)2L, (long)e.getMatchingOptions().size());
        }
        Assert.assertTrue((String)"Confirm MissingArgumentException caught", (boolean)caught);
    }

    @Test
    public void testArgumentStartingWithHyphen() throws Exception {
        String[] args = new String[]{"-b", "-foo"};
        CommandLine cl = this.parser.parse(this.options, args);
        Assert.assertEquals((Object)"-foo", (Object)cl.getOptionValue("b"));
    }

    @Test
    public void testBursting() throws Exception {
        String[] args = new String[]{"-acbtoast", "foo", "bar"};
        CommandLine cl = this.parser.parse(this.options, args);
        Assert.assertTrue((String)"Confirm -a is set", (boolean)cl.hasOption("a"));
        Assert.assertTrue((String)"Confirm -b is set", (boolean)cl.hasOption("b"));
        Assert.assertTrue((String)"Confirm -c is set", (boolean)cl.hasOption("c"));
        Assert.assertEquals((String)"Confirm arg of -b", (Object)"toast", (Object)cl.getOptionValue("b"));
        Assert.assertEquals((String)"Confirm size of extra args", (long)2L, (long)cl.getArgList().size());
    }

    @Test
    public void testDoubleDash1() throws Exception {
        String[] args = new String[]{"--copt", "--", "-b", "toast"};
        CommandLine cl = this.parser.parse(this.options, args);
        Assert.assertTrue((String)"Confirm -c is set", (boolean)cl.hasOption("c"));
        Assert.assertFalse((String)"Confirm -b is not set", (boolean)cl.hasOption("b"));
        Assert.assertEquals((String)("Confirm 2 extra args: " + cl.getArgList().size()), (long)2L, (long)cl.getArgList().size());
    }

    @Test
    public void testDoubleDash2() throws Exception {
        Options options = new Options();
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'n'));
        options.addOption(OptionBuilder.create((char)'m'));
        try {
            this.parser.parse(options, new String[]{"-n", "--", "-m"});
            Assert.fail((String)"MissingArgumentException not thrown for option -n");
        }
        catch (MissingArgumentException e) {
            Assert.assertNotNull((String)"option null", (Object)e.getOption());
            Assert.assertEquals((Object)"n", (Object)e.getOption().getOpt());
        }
    }

    @Test
    public void testLongOptionQuoteHandling() throws Exception {
        String[] args = new String[]{"--bfile", "\"quoted string\""};
        CommandLine cl = this.parser.parse(this.options, args);
        Assert.assertEquals((String)"Confirm --bfile \"arg\" strips quotes", (Object)"quoted string", (Object)cl.getOptionValue("b"));
    }

    @Test
    public void testLongOptionWithEqualsQuoteHandling() throws Exception {
        String[] args = new String[]{"--bfile=\"quoted string\""};
        CommandLine cl = this.parser.parse(this.options, args);
        Assert.assertEquals((String)"Confirm --bfile=\"arg\" strips quotes", (Object)"quoted string", (Object)cl.getOptionValue("b"));
    }

    @Test
    public void testLongWithEqualDoubleDash() throws Exception {
        String[] args = new String[]{"--foo=bar"};
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"foo");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'f'));
        CommandLine cl = this.parser.parse(options, args);
        Assert.assertEquals((Object)"bar", (Object)cl.getOptionValue("foo"));
    }

    @Test
    public void testLongWithEqualSingleDash() throws Exception {
        String[] args = new String[]{"-foo=bar"};
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"foo");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'f'));
        CommandLine cl = this.parser.parse(options, args);
        Assert.assertEquals((Object)"bar", (Object)cl.getOptionValue("foo"));
    }

    @Test
    public void testLongWithoutEqualDoubleDash() throws Exception {
        String[] args = new String[]{"--foobar"};
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"foo");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'f'));
        CommandLine cl = this.parser.parse(options, args, true);
        Assert.assertFalse((boolean)cl.hasOption("foo"));
    }

    @Test
    public void testLongWithoutEqualSingleDash() throws Exception {
        String[] args = new String[]{"-foobar"};
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"foo");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'f'));
        CommandLine cl = this.parser.parse(options, args);
        Assert.assertEquals((Object)"bar", (Object)cl.getOptionValue("foo"));
    }

    @Test
    public void testLongWithUnexpectedArgument1() throws Exception {
        String[] args = new String[]{"--foo=bar"};
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"foo");
        options.addOption(OptionBuilder.create((char)'f'));
        try {
            this.parser.parse(options, args);
        }
        catch (UnrecognizedOptionException e) {
            Assert.assertEquals((Object)"--foo=bar", (Object)e.getOption());
            return;
        }
        Assert.fail((String)"UnrecognizedOptionException not thrown");
    }

    @Test
    public void testLongWithUnexpectedArgument2() throws Exception {
        String[] args = new String[]{"-foobar"};
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"foo");
        options.addOption(OptionBuilder.create((char)'f'));
        try {
            this.parser.parse(options, args);
        }
        catch (UnrecognizedOptionException e) {
            Assert.assertEquals((Object)"-foobar", (Object)e.getOption());
            return;
        }
        Assert.fail((String)"UnrecognizedOptionException not thrown");
    }

    @Test
    public void testMissingArg() throws Exception {
        String[] args = new String[]{"-b"};
        boolean caught = false;
        try {
            this.parser.parse(this.options, args);
        }
        catch (MissingArgumentException e) {
            caught = true;
            Assert.assertEquals((String)"option missing an argument", (Object)"b", (Object)e.getOption().getOpt());
        }
        Assert.assertTrue((String)"Confirm MissingArgumentException caught", (boolean)caught);
    }

    @Test
    public void testMissingArgWithBursting() throws Exception {
        String[] args = new String[]{"-acb"};
        boolean caught = false;
        try {
            this.parser.parse(this.options, args);
        }
        catch (MissingArgumentException e) {
            caught = true;
            Assert.assertEquals((String)"option missing an argument", (Object)"b", (Object)e.getOption().getOpt());
        }
        Assert.assertTrue((String)"Confirm MissingArgumentException caught", (boolean)caught);
    }

    @Test
    public void testMissingRequiredGroup() throws Exception {
        OptionGroup group = new OptionGroup();
        group.addOption(OptionBuilder.create((String)"a"));
        group.addOption(OptionBuilder.create((String)"b"));
        group.setRequired(true);
        Options options = new Options();
        options.addOptionGroup(group);
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"c"));
        try {
            this.parser.parse(options, new String[]{"-c"});
            Assert.fail((String)"MissingOptionException not thrown");
        }
        catch (MissingOptionException e) {
            Assert.assertEquals((long)1L, (long)e.getMissingOptions().size());
            Assert.assertTrue((boolean)(e.getMissingOptions().get(0) instanceof OptionGroup));
        }
        catch (ParseException e) {
            Assert.fail((String)"Expected to catch MissingOptionException");
        }
    }

    @Test
    public void testMissingRequiredOption() {
        String[] args = new String[]{"-a"};
        Options options = new Options();
        options.addOption("a", "enable-a", false, null);
        OptionBuilder.withLongOpt((String)"bfile");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'b'));
        try {
            this.parser.parse(options, args);
            Assert.fail((String)"exception should have been thrown");
        }
        catch (MissingOptionException e) {
            Assert.assertEquals((String)"Incorrect exception message", (Object)"Missing required option: b", (Object)e.getMessage());
            Assert.assertTrue((boolean)e.getMissingOptions().contains("b"));
        }
        catch (ParseException e) {
            Assert.fail((String)"expected to catch MissingOptionException");
        }
    }

    @Test
    public void testMissingRequiredOptions() {
        String[] args = new String[]{"-a"};
        Options options = new Options();
        options.addOption("a", "enable-a", false, null);
        OptionBuilder.withLongOpt((String)"bfile");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'b'));
        OptionBuilder.withLongOpt((String)"cfile");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'c'));
        try {
            this.parser.parse(options, args);
            Assert.fail((String)"exception should have been thrown");
        }
        catch (MissingOptionException e) {
            Assert.assertEquals((String)"Incorrect exception message", (Object)"Missing required options: b, c", (Object)e.getMessage());
            Assert.assertTrue((boolean)e.getMissingOptions().contains("b"));
            Assert.assertTrue((boolean)e.getMissingOptions().contains("c"));
        }
        catch (ParseException e) {
            Assert.fail((String)"expected to catch MissingOptionException");
        }
    }

    @Test
    public void testMultiple() throws Exception {
        String[] args = new String[]{"-c", "foobar", "-b", "toast"};
        CommandLine cl = this.parser.parse(this.options, args, true);
        Assert.assertTrue((String)"Confirm -c is set", (boolean)cl.hasOption("c"));
        Assert.assertEquals((String)("Confirm  3 extra args: " + cl.getArgList().size()), (long)3L, (long)cl.getArgList().size());
        cl = this.parser.parse(this.options, cl.getArgs());
        Assert.assertFalse((String)"Confirm -c is not set", (boolean)cl.hasOption("c"));
        Assert.assertTrue((String)"Confirm -b is set", (boolean)cl.hasOption("b"));
        Assert.assertEquals((String)"Confirm arg of -b", (Object)"toast", (Object)cl.getOptionValue("b"));
        Assert.assertEquals((String)("Confirm  1 extra arg: " + cl.getArgList().size()), (long)1L, (long)cl.getArgList().size());
        Assert.assertEquals((String)("Confirm  value of extra arg: " + (String)cl.getArgList().get(0)), (Object)"foobar", cl.getArgList().get(0));
    }

    @Test
    public void testMultipleWithLong() throws Exception {
        String[] args = new String[]{"--copt", "foobar", "--bfile", "toast"};
        CommandLine cl = this.parser.parse(this.options, args, true);
        Assert.assertTrue((String)"Confirm -c is set", (boolean)cl.hasOption("c"));
        Assert.assertEquals((String)("Confirm  3 extra args: " + cl.getArgList().size()), (long)3L, (long)cl.getArgList().size());
        cl = this.parser.parse(this.options, cl.getArgs());
        Assert.assertFalse((String)"Confirm -c is not set", (boolean)cl.hasOption("c"));
        Assert.assertTrue((String)"Confirm -b is set", (boolean)cl.hasOption("b"));
        Assert.assertEquals((String)"Confirm arg of -b", (Object)"toast", (Object)cl.getOptionValue("b"));
        Assert.assertEquals((String)("Confirm  1 extra arg: " + cl.getArgList().size()), (long)1L, (long)cl.getArgList().size());
        Assert.assertEquals((String)("Confirm  value of extra arg: " + (String)cl.getArgList().get(0)), (Object)"foobar", cl.getArgList().get(0));
    }

    @Test
    public void testNegativeArgument() throws Exception {
        String[] args = new String[]{"-b", "-1"};
        CommandLine cl = this.parser.parse(this.options, args);
        Assert.assertEquals((Object)"-1", (Object)cl.getOptionValue("b"));
    }

    @Test
    public void testNegativeOption() throws Exception {
        String[] args = new String[]{"-b", "-1"};
        this.options.addOption("1", false, null);
        CommandLine cl = this.parser.parse(this.options, args);
        Assert.assertEquals((Object)"-1", (Object)cl.getOptionValue("b"));
    }

    @Test
    public void testOptionAndRequiredOption() throws Exception {
        String[] args = new String[]{"-a", "-b", "file"};
        Options options = new Options();
        options.addOption("a", "enable-a", false, null);
        OptionBuilder.withLongOpt((String)"bfile");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'b'));
        CommandLine cl = this.parser.parse(options, args);
        Assert.assertTrue((String)"Confirm -a is set", (boolean)cl.hasOption("a"));
        Assert.assertTrue((String)"Confirm -b is set", (boolean)cl.hasOption("b"));
        Assert.assertEquals((String)"Confirm arg of -b", (Object)"file", (Object)cl.getOptionValue("b"));
        Assert.assertTrue((String)"Confirm NO of extra args", (boolean)cl.getArgList().isEmpty());
    }

    @Test
    public void testOptionGroup() throws Exception {
        OptionGroup group = new OptionGroup();
        group.addOption(OptionBuilder.create((String)"a"));
        group.addOption(OptionBuilder.create((String)"b"));
        Options options = new Options();
        options.addOptionGroup(group);
        this.parser.parse(options, new String[]{"-b"});
        Assert.assertEquals((String)"selected option", (Object)"b", (Object)group.getSelected());
    }

    @Test
    public void testOptionGroupLong() throws Exception {
        OptionGroup group = new OptionGroup();
        OptionBuilder.withLongOpt((String)"foo");
        group.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"bar");
        group.addOption(OptionBuilder.create());
        Options options = new Options();
        options.addOptionGroup(group);
        CommandLine cl = this.parser.parse(options, new String[]{"--bar"});
        Assert.assertTrue((boolean)cl.hasOption("bar"));
        Assert.assertEquals((String)"selected option", (Object)"bar", (Object)group.getSelected());
    }

    @Test
    public void testPartialLongOptionSingleDash() throws Exception {
        String[] args = new String[]{"-ver"};
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"version");
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'v'));
        CommandLine cl = this.parser.parse(options, args);
        Assert.assertTrue((String)"Confirm --version is set", (boolean)cl.hasOption("version"));
        Assert.assertFalse((String)"Confirm -v is not set", (boolean)cl.hasOption("v"));
    }

    @Test
    public void testPropertiesOption1() throws Exception {
        String[] args = new String[]{"-Jsource=1.5", "-J", "target", "1.5", "foo"};
        Options options = new Options();
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        options.addOption(OptionBuilder.create((char)'J'));
        CommandLine cl = this.parser.parse(options, args);
        List<String> values = Arrays.asList(cl.getOptionValues("J"));
        Assert.assertNotNull((String)"null values", values);
        Assert.assertEquals((String)"number of values", (long)4L, (long)values.size());
        Assert.assertEquals((String)"value 1", (Object)"source", (Object)values.get(0));
        Assert.assertEquals((String)"value 2", (Object)"1.5", (Object)values.get(1));
        Assert.assertEquals((String)"value 3", (Object)"target", (Object)values.get(2));
        Assert.assertEquals((String)"value 4", (Object)"1.5", (Object)values.get(3));
        List argsleft = cl.getArgList();
        Assert.assertEquals((String)"Should be 1 arg left", (long)1L, (long)argsleft.size());
        Assert.assertEquals((String)"Expecting foo", (Object)"foo", argsleft.get(0));
    }

    @Test
    public void testPropertiesOption2() throws Exception {
        String[] args = new String[]{"-Dparam1", "-Dparam2=value2", "-D"};
        Options options = new Options();
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasOptionalArgs((int)2);
        options.addOption(OptionBuilder.create((char)'D'));
        CommandLine cl = this.parser.parse(options, args);
        Properties props = cl.getOptionProperties("D");
        Assert.assertNotNull((String)"null properties", (Object)props);
        Assert.assertEquals((String)("number of properties in " + props), (long)2L, (long)props.size());
        Assert.assertEquals((String)"property 1", (Object)"true", (Object)props.getProperty("param1"));
        Assert.assertEquals((String)"property 2", (Object)"value2", (Object)props.getProperty("param2"));
        List argsleft = cl.getArgList();
        Assert.assertEquals((String)"Should be no arg left", (long)0L, (long)argsleft.size());
    }

    @Test
    public void testPropertyOptionFlags() throws Exception {
        Options opts = new Options();
        opts.addOption("a", false, "toggle -a");
        opts.addOption("c", "c", false, "toggle -c");
        OptionBuilder.hasOptionalArg();
        opts.addOption(OptionBuilder.create((char)'e'));
        Properties properties = new Properties();
        properties.setProperty("a", "true");
        properties.setProperty("c", "yes");
        properties.setProperty("e", "1");
        CommandLine cmd = this.parse(this.parser, opts, null, properties);
        Assert.assertTrue((boolean)cmd.hasOption("a"));
        Assert.assertTrue((boolean)cmd.hasOption("c"));
        Assert.assertTrue((boolean)cmd.hasOption("e"));
        properties = new Properties();
        properties.setProperty("a", "false");
        properties.setProperty("c", "no");
        properties.setProperty("e", "0");
        cmd = this.parse(this.parser, opts, null, properties);
        Assert.assertFalse((boolean)cmd.hasOption("a"));
        Assert.assertFalse((boolean)cmd.hasOption("c"));
        Assert.assertTrue((boolean)cmd.hasOption("e"));
        properties = new Properties();
        properties.setProperty("a", "TRUE");
        properties.setProperty("c", "nO");
        properties.setProperty("e", "TrUe");
        cmd = this.parse(this.parser, opts, null, properties);
        Assert.assertTrue((boolean)cmd.hasOption("a"));
        Assert.assertFalse((boolean)cmd.hasOption("c"));
        Assert.assertTrue((boolean)cmd.hasOption("e"));
        properties = new Properties();
        properties.setProperty("a", "just a string");
        properties.setProperty("e", "");
        cmd = this.parse(this.parser, opts, null, properties);
        Assert.assertFalse((boolean)cmd.hasOption("a"));
        Assert.assertFalse((boolean)cmd.hasOption("c"));
        Assert.assertTrue((boolean)cmd.hasOption("e"));
        properties = new Properties();
        properties.setProperty("a", "0");
        properties.setProperty("c", "1");
        cmd = this.parse(this.parser, opts, null, properties);
        Assert.assertFalse((boolean)cmd.hasOption("a"));
        Assert.assertTrue((boolean)cmd.hasOption("c"));
    }

    @Test
    public void testPropertyOptionGroup() throws Exception {
        Options opts = new Options();
        OptionGroup group1 = new OptionGroup();
        group1.addOption(new Option("a", null));
        group1.addOption(new Option("b", null));
        opts.addOptionGroup(group1);
        OptionGroup group2 = new OptionGroup();
        group2.addOption(new Option("x", null));
        group2.addOption(new Option("y", null));
        opts.addOptionGroup(group2);
        String[] args = new String[]{"-a"};
        Properties properties = new Properties();
        properties.put("b", "true");
        properties.put("x", "true");
        CommandLine cmd = this.parse(this.parser, opts, args, properties);
        Assert.assertTrue((boolean)cmd.hasOption("a"));
        Assert.assertFalse((boolean)cmd.hasOption("b"));
        Assert.assertTrue((boolean)cmd.hasOption("x"));
        Assert.assertFalse((boolean)cmd.hasOption("y"));
    }

    @Test
    public void testPropertyOptionMultipleValues() throws Exception {
        Options opts = new Options();
        OptionBuilder.hasArgs();
        OptionBuilder.withValueSeparator((char)',');
        opts.addOption(OptionBuilder.create((char)'k'));
        Properties properties = new Properties();
        properties.setProperty("k", "one,two");
        Object[] values = new String[]{"one", "two"};
        CommandLine cmd = this.parse(this.parser, opts, null, properties);
        Assert.assertTrue((boolean)cmd.hasOption("k"));
        Assert.assertArrayEquals((Object[])values, (Object[])cmd.getOptionValues('k'));
    }

    @Test
    public void testPropertyOptionRequired() throws Exception {
        Options opts = new Options();
        OptionBuilder.isRequired();
        opts.addOption(OptionBuilder.create((String)"f"));
        Properties properties = new Properties();
        properties.setProperty("f", "true");
        CommandLine cmd = this.parse(this.parser, opts, null, properties);
        Assert.assertTrue((boolean)cmd.hasOption("f"));
    }

    @Test
    public void testPropertyOptionSingularValue() throws Exception {
        Options opts = new Options();
        OptionBuilder.hasOptionalArgs((int)2);
        OptionBuilder.withLongOpt((String)"hide");
        opts.addOption(OptionBuilder.create());
        Properties properties = new Properties();
        properties.setProperty("hide", "seek");
        CommandLine cmd = this.parse(this.parser, opts, null, properties);
        Assert.assertTrue((boolean)cmd.hasOption("hide"));
        Assert.assertEquals((Object)"seek", (Object)cmd.getOptionValue("hide"));
        Assert.assertFalse((boolean)cmd.hasOption("fake"));
    }

    @Test
    public void testPropertyOptionUnexpected() throws Exception {
        Options opts = new Options();
        Properties properties = new Properties();
        properties.setProperty("f", "true");
        try {
            this.parse(this.parser, opts, null, properties);
            Assert.fail((String)"UnrecognizedOptionException expected");
        }
        catch (UnrecognizedOptionException unrecognizedOptionException) {
            // empty catch block
        }
    }

    @Test
    public void testPropertyOverrideValues() throws Exception {
        Options opts = new Options();
        OptionBuilder.hasOptionalArgs((int)2);
        opts.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.hasOptionalArgs();
        opts.addOption(OptionBuilder.create((char)'j'));
        String[] args = new String[]{"-j", "found", "-i", "ink"};
        Properties properties = new Properties();
        properties.setProperty("j", "seek");
        CommandLine cmd = this.parse(this.parser, opts, args, properties);
        Assert.assertTrue((boolean)cmd.hasOption("j"));
        Assert.assertEquals((Object)"found", (Object)cmd.getOptionValue("j"));
        Assert.assertTrue((boolean)cmd.hasOption("i"));
        Assert.assertEquals((Object)"ink", (Object)cmd.getOptionValue("i"));
        Assert.assertFalse((boolean)cmd.hasOption("fake"));
    }

    @Test
    public void testReuseOptionsTwice() throws Exception {
        Options opts = new Options();
        OptionBuilder.isRequired();
        opts.addOption(OptionBuilder.create((char)'v'));
        this.parser.parse(opts, new String[]{"-v"});
        try {
            this.parser.parse(opts, new String[0]);
            Assert.fail((String)"MissingOptionException not thrown");
        }
        catch (MissingOptionException missingOptionException) {
            // empty catch block
        }
    }

    @Test
    public void testShortOptionConcatenatedQuoteHandling() throws Exception {
        String[] args = new String[]{"-b\"quoted string\""};
        CommandLine cl = this.parser.parse(this.options, args);
        Assert.assertEquals((String)"Confirm -b\"arg\" strips quotes", (Object)"quoted string", (Object)cl.getOptionValue("b"));
    }

    @Test
    public void testShortOptionQuoteHandling() throws Exception {
        String[] args = new String[]{"-b", "\"quoted string\""};
        CommandLine cl = this.parser.parse(this.options, args);
        Assert.assertEquals((String)"Confirm -b \"arg\" strips quotes", (Object)"quoted string", (Object)cl.getOptionValue("b"));
    }

    @Test
    public void testShortWithEqual() throws Exception {
        String[] args = new String[]{"-f=bar"};
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"foo");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'f'));
        CommandLine cl = this.parser.parse(options, args);
        Assert.assertEquals((Object)"bar", (Object)cl.getOptionValue("foo"));
    }

    @Test
    public void testShortWithoutEqual() throws Exception {
        String[] args = new String[]{"-fbar"};
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"foo");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'f'));
        CommandLine cl = this.parser.parse(options, args);
        Assert.assertEquals((Object)"bar", (Object)cl.getOptionValue("foo"));
    }

    @Test
    public void testShortWithUnexpectedArgument() throws Exception {
        String[] args = new String[]{"-f=bar"};
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"foo");
        options.addOption(OptionBuilder.create((char)'f'));
        try {
            this.parser.parse(options, args);
        }
        catch (UnrecognizedOptionException e) {
            Assert.assertEquals((Object)"-f=bar", (Object)e.getOption());
            return;
        }
        Assert.fail((String)"UnrecognizedOptionException not thrown");
    }

    @Test
    public void testSimpleLong() throws Exception {
        String[] args = new String[]{"--enable-a", "--bfile", "toast", "foo", "bar"};
        CommandLine cl = this.parser.parse(this.options, args);
        Assert.assertTrue((String)"Confirm -a is set", (boolean)cl.hasOption("a"));
        Assert.assertTrue((String)"Confirm -b is set", (boolean)cl.hasOption("b"));
        Assert.assertEquals((String)"Confirm arg of -b", (Object)"toast", (Object)cl.getOptionValue("b"));
        Assert.assertEquals((String)"Confirm arg of --bfile", (Object)"toast", (Object)cl.getOptionValue("bfile"));
        Assert.assertEquals((String)"Confirm size of extra args", (long)2L, (long)cl.getArgList().size());
    }

    @Test
    public void testSimpleShort() throws Exception {
        String[] args = new String[]{"-a", "-b", "toast", "foo", "bar"};
        CommandLine cl = this.parser.parse(this.options, args);
        Assert.assertTrue((String)"Confirm -a is set", (boolean)cl.hasOption("a"));
        Assert.assertTrue((String)"Confirm -b is set", (boolean)cl.hasOption("b"));
        Assert.assertEquals((String)"Confirm arg of -b", (Object)"toast", (Object)cl.getOptionValue("b"));
        Assert.assertEquals((String)"Confirm size of extra args", (long)2L, (long)cl.getArgList().size());
    }

    @Test
    public void testSingleDash() throws Exception {
        String[] args = new String[]{"--copt", "-b", "-", "-a", "-"};
        CommandLine cl = this.parser.parse(this.options, args);
        Assert.assertTrue((String)"Confirm -a is set", (boolean)cl.hasOption("a"));
        Assert.assertTrue((String)"Confirm -b is set", (boolean)cl.hasOption("b"));
        Assert.assertEquals((String)"Confirm arg of -b", (Object)"-", (Object)cl.getOptionValue("b"));
        Assert.assertEquals((String)("Confirm 1 extra arg: " + cl.getArgList().size()), (long)1L, (long)cl.getArgList().size());
        Assert.assertEquals((String)("Confirm value of extra arg: " + (String)cl.getArgList().get(0)), (Object)"-", cl.getArgList().get(0));
    }

    @Test
    public void testStopAtExpectedArg() throws Exception {
        String[] args = new String[]{"-b", "foo"};
        CommandLine cl = this.parser.parse(this.options, args, true);
        Assert.assertTrue((String)"Confirm -b is set", (boolean)cl.hasOption('b'));
        Assert.assertEquals((String)"Confirm -b is set", (Object)"foo", (Object)cl.getOptionValue('b'));
        Assert.assertTrue((String)("Confirm no extra args: " + cl.getArgList().size()), (boolean)cl.getArgList().isEmpty());
    }

    @Test
    public void testStopAtNonOptionLong() throws Exception {
        String[] args = new String[]{"--zop==1", "-abtoast", "--b=bar"};
        CommandLine cl = this.parser.parse(this.options, args, true);
        Assert.assertFalse((String)"Confirm -a is not set", (boolean)cl.hasOption("a"));
        Assert.assertFalse((String)"Confirm -b is not set", (boolean)cl.hasOption("b"));
        Assert.assertEquals((String)("Confirm  3 extra args: " + cl.getArgList().size()), (long)3L, (long)cl.getArgList().size());
    }

    @Test
    public void testStopAtNonOptionShort() throws Exception {
        String[] args = new String[]{"-z", "-a", "-btoast"};
        CommandLine cl = this.parser.parse(this.options, args, true);
        Assert.assertFalse((String)"Confirm -a is not set", (boolean)cl.hasOption("a"));
        Assert.assertEquals((String)("Confirm  3 extra args: " + cl.getArgList().size()), (long)3L, (long)cl.getArgList().size());
    }

    @Test
    public void testStopAtUnexpectedArg() throws Exception {
        String[] args = new String[]{"-c", "foober", "-b", "toast"};
        CommandLine cl = this.parser.parse(this.options, args, true);
        Assert.assertTrue((String)"Confirm -c is set", (boolean)cl.hasOption("c"));
        Assert.assertEquals((String)("Confirm  3 extra args: " + cl.getArgList().size()), (long)3L, (long)cl.getArgList().size());
    }

    @Test
    public void testStopBursting() throws Exception {
        String[] args = new String[]{"-azc"};
        CommandLine cl = this.parser.parse(this.options, args, true);
        Assert.assertTrue((String)"Confirm -a is set", (boolean)cl.hasOption("a"));
        Assert.assertFalse((String)"Confirm -c is not set", (boolean)cl.hasOption("c"));
        Assert.assertEquals((String)("Confirm  1 extra arg: " + cl.getArgList().size()), (long)1L, (long)cl.getArgList().size());
        Assert.assertTrue((boolean)cl.getArgList().contains("zc"));
    }

    @Test
    public void testStopBursting2() throws Exception {
        String[] args = new String[]{"-c", "foobar", "-btoast"};
        CommandLine cl = this.parser.parse(this.options, args, true);
        Assert.assertTrue((String)"Confirm -c is set", (boolean)cl.hasOption("c"));
        Assert.assertEquals((String)("Confirm  2 extra args: " + cl.getArgList().size()), (long)2L, (long)cl.getArgList().size());
        cl = this.parser.parse(this.options, cl.getArgs());
        Assert.assertFalse((String)"Confirm -c is not set", (boolean)cl.hasOption("c"));
        Assert.assertTrue((String)"Confirm -b is set", (boolean)cl.hasOption("b"));
        Assert.assertEquals((String)"Confirm arg of -b", (Object)"toast", (Object)cl.getOptionValue("b"));
        Assert.assertEquals((String)("Confirm  1 extra arg: " + cl.getArgList().size()), (long)1L, (long)cl.getArgList().size());
        Assert.assertEquals((String)("Confirm  value of extra arg: " + (String)cl.getArgList().get(0)), (Object)"foobar", cl.getArgList().get(0));
    }

    @Test
    public void testUnambiguousPartialLongOption1() throws Exception {
        String[] args = new String[]{"--ver"};
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"version");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"help");
        options.addOption(OptionBuilder.create());
        CommandLine cl = this.parser.parse(options, args);
        Assert.assertTrue((String)"Confirm --version is set", (boolean)cl.hasOption("version"));
    }

    @Test
    public void testUnambiguousPartialLongOption2() throws Exception {
        String[] args = new String[]{"-ver"};
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"version");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"help");
        options.addOption(OptionBuilder.create());
        CommandLine cl = this.parser.parse(options, args);
        Assert.assertTrue((String)"Confirm --version is set", (boolean)cl.hasOption("version"));
    }

    @Test
    public void testUnambiguousPartialLongOption3() throws Exception {
        String[] args = new String[]{"--ver=1"};
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"verbose");
        OptionBuilder.hasOptionalArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"help");
        options.addOption(OptionBuilder.create());
        CommandLine cl = this.parser.parse(options, args);
        Assert.assertTrue((String)"Confirm --verbose is set", (boolean)cl.hasOption("verbose"));
        Assert.assertEquals((Object)"1", (Object)cl.getOptionValue("verbose"));
    }

    @Test
    public void testUnambiguousPartialLongOption4() throws Exception {
        String[] args = new String[]{"-ver=1"};
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"verbose");
        OptionBuilder.hasOptionalArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"help");
        options.addOption(OptionBuilder.create());
        CommandLine cl = this.parser.parse(options, args);
        Assert.assertTrue((String)"Confirm --verbose is set", (boolean)cl.hasOption("verbose"));
        Assert.assertEquals((Object)"1", (Object)cl.getOptionValue("verbose"));
    }

    @Test
    public void testUnlimitedArgs() throws Exception {
        String[] args = new String[]{"-e", "one", "two", "-f", "alpha"};
        Options options = new Options();
        OptionBuilder.hasArgs();
        options.addOption(OptionBuilder.create((String)"e"));
        OptionBuilder.hasArgs();
        options.addOption(OptionBuilder.create((String)"f"));
        CommandLine cl = this.parser.parse(options, args);
        Assert.assertTrue((String)"Confirm -e is set", (boolean)cl.hasOption("e"));
        Assert.assertEquals((String)"number of arg for -e", (long)2L, (long)cl.getOptionValues("e").length);
        Assert.assertTrue((String)"Confirm -f is set", (boolean)cl.hasOption("f"));
        Assert.assertEquals((String)"number of arg for -f", (long)1L, (long)cl.getOptionValues("f").length);
    }

    @Test
    public void testUnrecognizedOption() throws Exception {
        String[] args = new String[]{"-a", "-d", "-b", "toast", "foo", "bar"};
        try {
            this.parser.parse(this.options, args);
            Assert.fail((String)"UnrecognizedOptionException wasn't thrown");
        }
        catch (UnrecognizedOptionException e) {
            Assert.assertEquals((Object)"-d", (Object)e.getOption());
        }
    }

    @Test
    public void testUnrecognizedOptionWithBursting() throws Exception {
        String[] args = new String[]{"-adbtoast", "foo", "bar"};
        try {
            this.parser.parse(this.options, args);
            Assert.fail((String)"UnrecognizedOptionException wasn't thrown");
        }
        catch (UnrecognizedOptionException e) {
            Assert.assertEquals((Object)"-adbtoast", (Object)e.getOption());
        }
    }

    @Test
    public void testWithRequiredOption() throws Exception {
        String[] args = new String[]{"-b", "file"};
        Options options = new Options();
        options.addOption("a", "enable-a", false, null);
        OptionBuilder.withLongOpt((String)"bfile");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'b'));
        CommandLine cl = this.parser.parse(options, args);
        Assert.assertFalse((String)"Confirm -a is NOT set", (boolean)cl.hasOption("a"));
        Assert.assertTrue((String)"Confirm -b is set", (boolean)cl.hasOption("b"));
        Assert.assertEquals((String)"Confirm arg of -b", (Object)"file", (Object)cl.getOptionValue("b"));
        Assert.assertTrue((String)"Confirm NO of extra args", (boolean)cl.getArgList().isEmpty());
    }

    @Test(expected=UnrecognizedOptionException.class)
    public void testAmbiguousArgParsing() throws Exception {
        String[] args = new String[]{"-=-"};
        Options options = new Options();
        CommandLine cl = this.parser.parse(options, args);
    }
}

