/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.bug;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BugCLI71Test {
    private Options options;
    private CommandLineParser parser;

    @BeforeEach
    public void setUp() {
        this.options = new Options();
        Option algorithm = new Option("a", "algo", true, "the algorithm which it to perform executing");
        algorithm.setArgName("algorithm name");
        this.options.addOption(algorithm);
        Option key = new Option("k", "key", true, "the key the setted algorithm uses to process");
        algorithm.setArgName("value");
        this.options.addOption(key);
        this.parser = new PosixParser();
    }

    @Test
    public void testBasic() throws Exception {
        String[] args = new String[]{"-a", "Caesar", "-k", "A"};
        CommandLine line = this.parser.parse(this.options, args);
        Assertions.assertEquals((Object)"Caesar", (Object)line.getOptionValue("a"));
        Assertions.assertEquals((Object)"A", (Object)line.getOptionValue("k"));
    }

    @Test
    public void testGetsDefaultIfOptional() throws Exception {
        String[] args = new String[]{"-k", "-a", "Caesar"};
        this.options.getOption("k").setOptionalArg(true);
        CommandLine line = this.parser.parse(this.options, args);
        Assertions.assertEquals((Object)"Caesar", (Object)line.getOptionValue("a"));
        Assertions.assertEquals((Object)"a", (Object)line.getOptionValue('k', "a"));
    }

    @Test
    public void testLackOfError() throws Exception {
        String[] args = new String[]{"-k", "-a", "Caesar"};
        try {
            this.parser.parse(this.options, args);
            Assertions.fail((String)"MissingArgumentException expected");
        }
        catch (MissingArgumentException e) {
            Assertions.assertEquals((Object)"k", (Object)e.getOption().getOpt(), (String)"option missing an argument");
        }
    }

    @Test
    public void testMistakenArgument() throws Exception {
        String[] args = new String[]{"-a", "Caesar", "-k", "A"};
        CommandLine line = this.parser.parse(this.options, args);
        args = new String[]{"-a", "Caesar", "-k", "a"};
        line = this.parser.parse(this.options, args);
        Assertions.assertEquals((Object)"Caesar", (Object)line.getOptionValue("a"));
        Assertions.assertEquals((Object)"a", (Object)line.getOptionValue("k"));
    }
}

