/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CommandLineTest {
    @Test
    public void testBuilder() {
        CommandLine.Builder builder = new CommandLine.Builder();
        builder.addArg("foo").addArg("bar");
        builder.addOption(Option.builder((String)"T").build());
        CommandLine cmd = builder.build();
        Assertions.assertEquals((Object)"foo", (Object)cmd.getArgs()[0]);
        Assertions.assertEquals((Object)"bar", cmd.getArgList().get(1));
        Assertions.assertEquals((Object)"T", (Object)cmd.getOptions()[0].getOpt());
    }

    @Test
    public void testBuilderNullArgs() {
        CommandLine.Builder builder = new CommandLine.Builder();
        builder.addArg(null).addArg(null);
        builder.addOption(Option.builder((String)"T").build());
        CommandLine cmd = builder.build();
        Assertions.assertEquals((int)0, (int)cmd.getArgs().length);
        Assertions.assertEquals((Object)"T", (Object)cmd.getOptions()[0].getOpt());
    }

    @Test
    public void testBuilderNullOption() {
        CommandLine.Builder builder = new CommandLine.Builder();
        builder.addArg("foo").addArg("bar");
        builder.addOption(null);
        builder.addOption(null);
        builder.addOption(null);
        CommandLine cmd = builder.build();
        Assertions.assertEquals((Object)"foo", (Object)cmd.getArgs()[0]);
        Assertions.assertEquals((Object)"bar", cmd.getArgList().get(1));
        Assertions.assertEquals((int)0, (int)cmd.getOptions().length);
    }

    @Test
    public void testDeprecatedDefaultOption() {
        CommandLine.Builder builder = new CommandLine.Builder();
        builder.addArg("foo").addArg("bar");
        Option opt = Option.builder().option("T").deprecated().build();
        builder.addOption(opt);
        AtomicReference handler = new AtomicReference();
        CommandLine cmd = builder.build();
        cmd.getOptionValue(opt.getOpt());
        handler.set(null);
        cmd.getOptionValue("Nope");
        Assertions.assertNull(handler.get());
    }

    @Test
    public void testDeprecatedOption() {
        CommandLine.Builder builder = new CommandLine.Builder();
        builder.addArg("foo").addArg("bar");
        Option opt = Option.builder().option("T").longOpt("tee").deprecated().build();
        builder.addOption(opt);
        ArrayList handler = new ArrayList();
        CommandLine cmd = builder.setDeprecatedHandler(handler::add).build();
        cmd.getOptionValue(opt.getOpt());
        Assertions.assertEquals((int)1, (int)handler.size());
        Assertions.assertSame((Object)opt, handler.get(0));
        handler.clear();
        cmd.getOptionValue(opt.getLongOpt());
        Assertions.assertEquals((int)1, (int)handler.size());
        Assertions.assertSame((Object)opt, handler.get(0));
        handler.clear();
        cmd.getOptionValue(opt);
        Assertions.assertEquals((int)1, (int)handler.size());
        Assertions.assertSame((Object)opt, handler.get(0));
        handler.clear();
        cmd.getOptionValue("Nope");
        Assertions.assertEquals((int)0, (int)handler.size());
    }

    @Test
    public void testDeprecatedParsedOptionValue() throws ParseException {
        CommandLine.Builder builder = new CommandLine.Builder();
        builder.addArg("foo").addArg("bar");
        Option opt = Option.builder().option("T").longOpt("tee").deprecated().build();
        builder.addOption(opt);
        ArrayList handler = new ArrayList();
        CommandLine cmd = builder.setDeprecatedHandler(handler::add).build();
        cmd.getParsedOptionValue(opt.getOpt());
        Assertions.assertEquals((int)1, (int)handler.size());
        Assertions.assertSame((Object)opt, handler.get(0));
        handler.clear();
        cmd.getParsedOptionValue(opt.getLongOpt());
        Assertions.assertEquals((int)1, (int)handler.size());
        Assertions.assertSame((Object)opt, handler.get(0));
        handler.clear();
        cmd.getParsedOptionValue(opt);
        Assertions.assertEquals((int)1, (int)handler.size());
        Assertions.assertSame((Object)opt, handler.get(0));
        handler.clear();
        cmd.getParsedOptionValue("Nope");
        Assertions.assertEquals((int)0, (int)handler.size());
    }

    @Test
    public void testGetOptionProperties() throws Exception {
        String[] args = new String[]{"-Dparam1=value1", "-Dparam2=value2", "-Dparam3", "-Dparam4=value4", "-D", "--property", "foo=bar"};
        Options options = new Options();
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasOptionalArgs((int)2);
        options.addOption(OptionBuilder.create((char)'D'));
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withLongOpt((String)"property");
        options.addOption(OptionBuilder.create());
        GnuParser parser = new GnuParser();
        CommandLine cl = parser.parse(options, args);
        Properties props = cl.getOptionProperties("D");
        Assertions.assertNotNull((Object)props, (String)"null properties");
        Assertions.assertEquals((int)4, (int)props.size(), (String)("number of properties in " + props));
        Assertions.assertEquals((Object)"value1", (Object)props.getProperty("param1"), (String)"property 1");
        Assertions.assertEquals((Object)"value2", (Object)props.getProperty("param2"), (String)"property 2");
        Assertions.assertEquals((Object)"true", (Object)props.getProperty("param3"), (String)"property 3");
        Assertions.assertEquals((Object)"value4", (Object)props.getProperty("param4"), (String)"property 4");
        Assertions.assertEquals((Object)"bar", (Object)cl.getOptionProperties("property").getProperty("foo"), (String)"property with long format");
    }

    @Test
    public void testGetOptionPropertiesWithOption() throws Exception {
        String[] args = new String[]{"-Dparam1=value1", "-Dparam2=value2", "-Dparam3", "-Dparam4=value4", "-D", "--property", "foo=bar"};
        Options options = new Options();
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasOptionalArgs((int)2);
        Option optionD = OptionBuilder.create((char)'D');
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withLongOpt((String)"property");
        Option optionProperty = OptionBuilder.create();
        options.addOption(optionD);
        options.addOption(optionProperty);
        GnuParser parser = new GnuParser();
        CommandLine cl = parser.parse(options, args);
        Properties props = cl.getOptionProperties(optionD);
        Assertions.assertNotNull((Object)props, (String)"null properties");
        Assertions.assertEquals((int)4, (int)props.size(), (String)("number of properties in " + props));
        Assertions.assertEquals((Object)"value1", (Object)props.getProperty("param1"), (String)"property 1");
        Assertions.assertEquals((Object)"value2", (Object)props.getProperty("param2"), (String)"property 2");
        Assertions.assertEquals((Object)"true", (Object)props.getProperty("param3"), (String)"property 3");
        Assertions.assertEquals((Object)"value4", (Object)props.getProperty("param4"), (String)"property 4");
        Assertions.assertEquals((Object)"bar", (Object)cl.getOptionProperties(optionProperty).getProperty("foo"), (String)"property with long format");
    }

    @Test
    public void testGetOptionsBuilder() {
        CommandLine cmd = CommandLine.builder().build();
        Assertions.assertNotNull((Object)cmd.getOptions());
        Assertions.assertEquals((int)0, (int)cmd.getOptions().length);
        cmd.addOption(null);
        cmd.addOption(new Option("a", null));
        cmd.addOption(new Option("b", null));
        cmd.addOption(new Option("c", null));
        Assertions.assertEquals((int)3, (int)cmd.getOptions().length);
    }

    @Test
    public void testGetOptionsCtor() {
        CommandLine cmd = new CommandLine();
        Assertions.assertNotNull((Object)cmd.getOptions());
        Assertions.assertEquals((int)0, (int)cmd.getOptions().length);
        cmd.addOption(new Option("a", null));
        cmd.addOption(new Option("b", null));
        cmd.addOption(new Option("c", null));
        cmd.addOption(null);
        Assertions.assertEquals((int)3, (int)cmd.getOptions().length);
    }

    @Test
    public void testGetParsedOptionValue() throws Exception {
        Options options = new Options();
        OptionBuilder.hasArg();
        OptionBuilder.withType(Number.class);
        options.addOption(OptionBuilder.create((String)"i"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"f"));
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, new String[]{"-i", "123", "-f", "foo"});
        Assertions.assertEquals((int)123, (int)((Number)cmd.getParsedOptionValue("i")).intValue());
        Assertions.assertEquals((Object)"foo", (Object)cmd.getParsedOptionValue("f"));
    }

    @Test
    public void testGetParsedOptionValueUsingDefault() throws Exception {
        Options options = new Options();
        Option optI = Option.builder((String)"i").hasArg().type(Number.class).build();
        Option optF = Option.builder((String)"f").hasArg().build();
        options.addOption(optI);
        options.addOption(optF);
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, new String[]{"-i", "123"});
        Supplier nullSupplier = null;
        Assertions.assertEquals((int)123, (int)((Number)cmd.getParsedOptionValue(optI)).intValue());
        Assertions.assertEquals((Object)"foo", (Object)cmd.getParsedOptionValue(optF, (Object)"foo"));
        Assertions.assertEquals((Object)"foo", (Object)cmd.getParsedOptionValue(optF, () -> "foo"));
        Assertions.assertNull((Object)cmd.getParsedOptionValue(optF, null));
        Assertions.assertNull((Object)cmd.getParsedOptionValue(optF, nullSupplier));
        Assertions.assertNull((Object)cmd.getParsedOptionValue(optF, () -> null));
        Assertions.assertEquals((Object)"foo", (Object)cmd.getParsedOptionValue("f", (Object)"foo"));
        Assertions.assertEquals((Object)"foo", (Object)cmd.getParsedOptionValue("f", () -> "foo"));
        Assertions.assertNull((Object)cmd.getParsedOptionValue("f", null));
        Assertions.assertNull((Object)cmd.getParsedOptionValue("f", nullSupplier));
        Assertions.assertNull((Object)cmd.getParsedOptionValue("f", () -> null));
        Assertions.assertEquals((Object)"foo", (Object)cmd.getParsedOptionValue('f', (Object)"foo"));
        Assertions.assertEquals((Object)"foo", (Object)cmd.getParsedOptionValue('f', () -> "foo"));
        Assertions.assertNull((Object)cmd.getParsedOptionValue('f', null));
        Assertions.assertNull((Object)cmd.getParsedOptionValue('f', nullSupplier));
        Assertions.assertNull((Object)cmd.getParsedOptionValue('f', () -> null));
    }

    @Test
    public void testGetParsedOptionValueWithChar() throws Exception {
        Options options = new Options();
        options.addOption(Option.builder((String)"i").hasArg().type(Number.class).build());
        options.addOption(Option.builder((String)"f").hasArg().build());
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, new String[]{"-i", "123", "-f", "foo"});
        Assertions.assertEquals((int)123, (int)((Number)cmd.getParsedOptionValue('i')).intValue());
        Assertions.assertEquals((Object)"foo", (Object)cmd.getParsedOptionValue('f'));
    }

    @Test
    public void testGetParsedOptionValueWithOption() throws Exception {
        Options options = new Options();
        Option optI = Option.builder((String)"i").hasArg().type(Number.class).build();
        Option optF = Option.builder((String)"f").hasArg().build();
        options.addOption(optI);
        options.addOption(optF);
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, new String[]{"-i", "123", "-f", "foo"});
        Assertions.assertEquals((int)123, (int)((Number)cmd.getParsedOptionValue(optI)).intValue());
        Assertions.assertEquals((Object)"foo", (Object)cmd.getParsedOptionValue(optF));
    }

    @Test
    public void testNullOption() throws Exception {
        Options options = new Options();
        Option optI = Option.builder((String)"i").hasArg().type(Number.class).build();
        Option optF = Option.builder((String)"f").hasArg().build();
        options.addOption(optI);
        options.addOption(optF);
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, new String[]{"-i", "123", "-f", "foo"});
        Assertions.assertNull((Object)cmd.getOptionValue((Option)null));
        Assertions.assertNull((Object)cmd.getParsedOptionValue((Option)null));
    }
}

