/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.cli.DeprecatedAttributes;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OptionsTest {
    private void assertToStrings(Option option) {
        Assertions.assertNotNull((Object)option.toString());
        Assertions.assertNotNull((Object)option.toDeprecatedString());
    }

    @Test
    public void testAddConflictingOptions() {
        Options options1 = new Options();
        OptionGroup group1 = new OptionGroup();
        group1.addOption(Option.builder((String)"a").build());
        group1.addOption(Option.builder((String)"b").build());
        options1.addOptionGroup(group1);
        options1.addOption(Option.builder((String)"x").build());
        options1.addOption(Option.builder((String)"y").build());
        Options options2 = new Options();
        OptionGroup group2 = new OptionGroup();
        group2.addOption(Option.builder((String)"x").type(Integer.class).build());
        group2.addOption(Option.builder((String)"b").type(Integer.class).build());
        options2.addOptionGroup(group2);
        options2.addOption(Option.builder((String)"c").build());
        Assertions.assertThrows(IllegalArgumentException.class, () -> options1.addOptions(options2));
    }

    @Test
    public void testAddNonConflictingOptions() {
        Options options1 = new Options();
        OptionGroup group1 = new OptionGroup();
        group1.addOption(Option.builder((String)"a").build());
        group1.addOption(Option.builder((String)"b").build());
        options1.addOptionGroup(group1);
        options1.addOption(Option.builder((String)"x").build());
        options1.addOption(Option.builder((String)"y").build());
        Options options2 = new Options();
        OptionGroup group2 = new OptionGroup();
        group2.addOption(Option.builder((String)"c").type(Integer.class).build());
        group2.addOption(Option.builder((String)"d").type(Integer.class).build());
        options2.addOptionGroup(group2);
        options1.addOption(Option.builder((String)"e").build());
        options1.addOption(Option.builder((String)"f").build());
        Options underTest = new Options();
        underTest.addOptions(options1);
        underTest.addOptions(options2);
        List<OptionGroup> expected = Arrays.asList(group1, group2);
        Assertions.assertTrue((expected.size() == underTest.getOptionGroups().size() && expected.containsAll(underTest.getOptionGroups()) ? 1 : 0) != 0);
        HashSet expectOpt = new HashSet(options1.getOptions());
        expectOpt.addAll(options2.getOptions());
        Assertions.assertEquals((int)8, (int)expectOpt.size());
        Assertions.assertTrue((expectOpt.size() == underTest.getOptions().size() && expectOpt.containsAll(underTest.getOptions()) ? 1 : 0) != 0);
    }

    @Test
    public void testAddOptions() {
        Options options = new Options();
        OptionGroup group1 = new OptionGroup();
        group1.addOption(Option.builder((String)"a").build());
        group1.addOption(Option.builder((String)"b").build());
        options.addOptionGroup(group1);
        options.addOption(Option.builder((String)"X").build());
        options.addOption(Option.builder((String)"y").build());
        Options underTest = new Options();
        underTest.addOptions(options);
        Assertions.assertEquals((Object)options.getOptionGroups(), (Object)underTest.getOptionGroups());
        Assertions.assertArrayEquals((Object[])options.getOptions().toArray(), (Object[])underTest.getOptions().toArray());
    }

    @Test
    public void testAddOptions2X() {
        Options options = new Options();
        OptionGroup group1 = new OptionGroup();
        group1.addOption(Option.builder((String)"a").build());
        group1.addOption(Option.builder((String)"b").build());
        options.addOptionGroup(group1);
        options.addOption(Option.builder((String)"X").build());
        options.addOption(Option.builder((String)"y").build());
        Assertions.assertThrows(IllegalArgumentException.class, () -> options.addOptions(options));
    }

    @Test
    public void testDeprecated() {
        Options options = new Options();
        options.addOption(Option.builder().option("a").build());
        options.addOption(Option.builder().option("b").deprecated().build());
        options.addOption(Option.builder().option("c").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("2.0").setDescription("Use X.").get()).build());
        options.addOption(Option.builder().option("d").deprecated().longOpt("longD").hasArgs().build());
        Assertions.assertTrue((boolean)options.getOption("a").toString().startsWith("[ Option a"));
        Assertions.assertTrue((boolean)options.getOption("b").toString().startsWith("[ Option b"));
        Assertions.assertTrue((boolean)options.getOption("c").toString().startsWith("[ Option c"));
        Assertions.assertFalse((boolean)options.getOption("a").toDeprecatedString().startsWith("Option a"));
        Assertions.assertEquals((Object)"Option 'b': Deprecated", (Object)options.getOption("b").toDeprecatedString());
        Assertions.assertEquals((Object)"Option 'c': Deprecated for removal since 2.0: Use X.", (Object)options.getOption("c").toDeprecatedString());
        this.assertToStrings(options.getOption("a"));
        this.assertToStrings(options.getOption("b"));
        this.assertToStrings(options.getOption("c"));
        this.assertToStrings(options.getOption("d"));
    }

    @Test
    public void testDuplicateLong() {
        Options options = new Options();
        options.addOption("a", "--a", false, "toggle -a");
        options.addOption("a", "--a", false, "toggle -a*");
        Assertions.assertEquals((Object)"toggle -a*", (Object)options.getOption("a").getDescription(), (String)"last one in wins");
        this.assertToStrings(options.getOption("a"));
    }

    @Test
    public void testDuplicateSimple() {
        Options options = new Options();
        options.addOption("a", false, "toggle -a");
        this.assertToStrings(options.getOption("a"));
        options.addOption("a", true, "toggle -a*");
        Assertions.assertEquals((Object)"toggle -a*", (Object)options.getOption("a").getDescription(), (String)"last one in wins");
        this.assertToStrings(options.getOption("a"));
    }

    @Test
    public void testGetMatchingOpts() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"version");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"verbose");
        options.addOption(OptionBuilder.create());
        Assertions.assertTrue((boolean)options.getMatchingOptions("foo").isEmpty());
        Assertions.assertEquals((int)1, (int)options.getMatchingOptions("version").size());
        Assertions.assertEquals((int)2, (int)options.getMatchingOptions("ver").size());
        this.assertToStrings(options.getOption("version"));
        this.assertToStrings(options.getOption("verbose"));
    }

    @Test
    public void testGetOptionsGroups() {
        Options options = new Options();
        OptionGroup group1 = new OptionGroup();
        group1.addOption(OptionBuilder.create((char)'a'));
        group1.addOption(OptionBuilder.create((char)'b'));
        OptionGroup group2 = new OptionGroup();
        group2.addOption(OptionBuilder.create((char)'x'));
        group2.addOption(OptionBuilder.create((char)'y'));
        options.addOptionGroup(group1);
        options.addOptionGroup(group2);
        Assertions.assertNotNull((Object)options.getOptionGroups());
        Assertions.assertEquals((int)2, (int)options.getOptionGroups().size());
    }

    @Test
    public void testHelpOptions() {
        OptionBuilder.withLongOpt((String)"long-only1");
        Option longOnly1 = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)"long-only2");
        Option longOnly2 = OptionBuilder.create();
        Option shortOnly1 = OptionBuilder.create((String)"1");
        Option shortOnly2 = OptionBuilder.create((String)"2");
        OptionBuilder.withLongOpt((String)"bothA");
        Option bothA = OptionBuilder.create((String)"a");
        OptionBuilder.withLongOpt((String)"bothB");
        Option bothB = OptionBuilder.create((String)"b");
        Options options = new Options();
        options.addOption(longOnly1);
        options.addOption(longOnly2);
        options.addOption(shortOnly1);
        options.addOption(shortOnly2);
        options.addOption(bothA);
        options.addOption(bothB);
        ArrayList<Option> allOptions = new ArrayList<Option>();
        allOptions.add(longOnly1);
        allOptions.add(longOnly2);
        allOptions.add(shortOnly1);
        allOptions.add(shortOnly2);
        allOptions.add(bothA);
        allOptions.add(bothB);
        List helpOptions = options.helpOptions();
        Assertions.assertTrue((boolean)helpOptions.containsAll(allOptions), (String)"Everything in all should be in help");
        Assertions.assertTrue((boolean)allOptions.containsAll(helpOptions), (String)"Everything in help should be in all");
    }

    @Test
    public void testLong() {
        Options options = new Options();
        options.addOption("a", "--a", false, "toggle -a");
        options.addOption("b", "--b", true, "set -b");
        Assertions.assertTrue((boolean)options.hasOption("a"));
        Assertions.assertTrue((boolean)options.hasOption("b"));
    }

    @Test
    public void testMissingOptionException() throws ParseException {
        Options options = new Options();
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"f"));
        try {
            new PosixParser().parse(options, new String[0]);
            Assertions.fail((String)"Expected MissingOptionException to be thrown");
        }
        catch (MissingOptionException e) {
            Assertions.assertEquals((Object)"Missing required option: f", (Object)e.getMessage());
        }
    }

    @Test
    public void testMissingOptionsException() throws ParseException {
        Options options = new Options();
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"x"));
        try {
            new PosixParser().parse(options, new String[0]);
            Assertions.fail((String)"Expected MissingOptionException to be thrown");
        }
        catch (MissingOptionException e) {
            Assertions.assertEquals((Object)"Missing required options: f, x", (Object)e.getMessage());
        }
    }

    @Test
    public void testSimple() {
        Options options = new Options();
        options.addOption("a", false, "toggle -a");
        options.addOption("b", true, "toggle -b");
        Assertions.assertTrue((boolean)options.hasOption("a"));
        Assertions.assertTrue((boolean)options.hasOption("b"));
    }

    @Test
    public void testToString() {
        Options options = new Options();
        options.addOption("f", "foo", true, "Foo");
        options.addOption("b", "bar", false, "Bar");
        String s = options.toString();
        Assertions.assertNotNull((Object)s, (String)"null string returned");
        Assertions.assertTrue((boolean)s.toLowerCase().contains("foo"), (String)"foo option missing");
        Assertions.assertTrue((boolean)s.toLowerCase().contains("bar"), (String)"bar option missing");
    }
}

