/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Base32InputStream;
import org.apache.commons.codec.binary.Base32OutputStream;
import org.apache.commons.codec.binary.Base32TestData;
import org.apache.commons.codec.binary.BaseNCodec;
import org.apache.commons.codec.binary.Codec105ErrorInputStream;
import org.apache.commons.codec.binary.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class Base32InputStreamTest {
    private static final String ENCODED_FOO = "MZXW6===";
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] LF = new byte[]{10};
    private static final String STRING_FIXTURE = "Hello World";

    @Test
    public void testCodec130() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Base32OutputStream base32os = new Base32OutputStream((OutputStream)bos);
        base32os.write(StringUtils.getBytesUtf8((String)STRING_FIXTURE));
        base32os.close();
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        Base32InputStream ins = new Base32InputStream((InputStream)bis);
        ins.skip(1L);
        byte[] decodedBytes = Base32TestData.streamToBytes((InputStream)ins, new byte[64]);
        String str = StringUtils.newStringUtf8((byte[])decodedBytes);
        Assert.assertEquals((Object)STRING_FIXTURE.substring(1), (Object)str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCodec105() throws IOException {
        Base32InputStream in = new Base32InputStream((InputStream)new Codec105ErrorInputStream(), true, 0, null);
        try {
            for (int i = 0; i < 5; ++i) {
                in.read();
            }
        }
        finally {
            in.close();
        }
    }

    @Test
    public void testAvailable() throws Throwable {
        ByteArrayInputStream ins = new ByteArrayInputStream(StringUtils.getBytesIso8859_1((String)ENCODED_FOO));
        Base32InputStream b32stream = new Base32InputStream((InputStream)ins);
        Assert.assertEquals((long)1L, (long)b32stream.available());
        Assert.assertEquals((long)3L, (long)b32stream.skip(10L));
        Assert.assertEquals((long)0L, (long)b32stream.available());
        Assert.assertEquals((long)-1L, (long)b32stream.read());
        Assert.assertEquals((long)-1L, (long)b32stream.read());
        Assert.assertEquals((long)0L, (long)b32stream.available());
        b32stream.close();
    }

    @Test
    public void testBase32EmptyInputStreamMimeChuckSize() throws Exception {
        this.testBase32EmptyInputStream(76);
    }

    @Test
    public void testBase32EmptyInputStreamPemChuckSize() throws Exception {
        this.testBase32EmptyInputStream(64);
    }

    private void testBase32EmptyInputStream(int chuckSize) throws Exception {
        byte[] emptyEncoded = new byte[]{};
        byte[] emptyDecoded = new byte[]{};
        this.testByteByByte(emptyEncoded, emptyDecoded, chuckSize, CRLF);
        this.testByChunk(emptyEncoded, emptyDecoded, chuckSize, CRLF);
    }

    @Test
    public void testBase32InputStreamByChunk() throws Exception {
        byte[] encoded = StringUtils.getBytesUtf8((String)"JBSWY3DPEBLW64TMMQ======\r\n");
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        this.testByChunk(encoded, decoded, 76, CRLF);
        encoded = StringUtils.getBytesUtf8((String)"AA======\r\n");
        decoded = new byte[]{0};
        this.testByChunk(encoded, decoded, 76, CRLF);
        Base32 codec = new Base32();
        for (int i = 0; i <= 150; ++i) {
            byte[][] randomData = Base32TestData.randomData((BaseNCodec)codec, i);
            encoded = randomData[1];
            decoded = randomData[0];
            this.testByChunk(encoded, decoded, 0, LF);
        }
    }

    @Test
    public void testBase32InputStreamByteByByte() throws Exception {
        byte[] encoded = StringUtils.getBytesUtf8((String)"JBSWY3DPEBLW64TMMQ======\r\n");
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        this.testByteByByte(encoded, decoded, 76, CRLF);
        encoded = StringUtils.getBytesUtf8((String)"AA======\r\n");
        decoded = new byte[]{0};
        this.testByteByByte(encoded, decoded, 76, CRLF);
        Base32 codec = new Base32();
        for (int i = 0; i <= 150; ++i) {
            byte[][] randomData = Base32TestData.randomData((BaseNCodec)codec, i);
            encoded = randomData[1];
            decoded = randomData[0];
            this.testByteByByte(encoded, decoded, 0, LF);
        }
    }

    private void testByChunk(byte[] encoded, byte[] decoded, int chunkSize, byte[] separator) throws Exception {
        Object in = new Base32InputStream((InputStream)new ByteArrayInputStream(decoded), true, chunkSize, separator);
        byte[] output = Base32TestData.streamToBytes((InputStream)in);
        Assert.assertEquals((String)"EOF", (long)-1L, (long)((InputStream)in).read());
        Assert.assertEquals((String)"Still EOF", (long)-1L, (long)((InputStream)in).read());
        Assert.assertTrue((String)"Streaming base32 encode", (boolean)Arrays.equals(output, encoded));
        in = new Base32InputStream((InputStream)new ByteArrayInputStream(encoded));
        output = Base32TestData.streamToBytes((InputStream)in);
        Assert.assertEquals((String)"EOF", (long)-1L, (long)((InputStream)in).read());
        Assert.assertEquals((String)"Still EOF", (long)-1L, (long)((InputStream)in).read());
        Assert.assertTrue((String)"Streaming base32 decode", (boolean)Arrays.equals(output, decoded));
        in = new ByteArrayInputStream(decoded);
        for (int i = 0; i < 10; ++i) {
            in = new Base32InputStream((InputStream)in, true, chunkSize, separator);
            in = new Base32InputStream((InputStream)in, false);
        }
        output = Base32TestData.streamToBytes((InputStream)in);
        Assert.assertEquals((String)"EOF", (long)-1L, (long)((InputStream)in).read());
        Assert.assertEquals((String)"Still EOF", (long)-1L, (long)((InputStream)in).read());
        Assert.assertTrue((String)"Streaming base32 wrap-wrap-wrap!", (boolean)Arrays.equals(output, decoded));
        ((InputStream)in).close();
    }

    private void testByteByByte(byte[] encoded, byte[] decoded, int chunkSize, byte[] separator) throws Exception {
        int i;
        Object in = new Base32InputStream((InputStream)new ByteArrayInputStream(decoded), true, chunkSize, separator);
        byte[] output = new byte[encoded.length];
        for (i = 0; i < output.length; ++i) {
            output[i] = (byte)((InputStream)in).read();
        }
        Assert.assertEquals((String)"EOF", (long)-1L, (long)((InputStream)in).read());
        Assert.assertEquals((String)"Still EOF", (long)-1L, (long)((InputStream)in).read());
        Assert.assertTrue((String)"Streaming base32 encode", (boolean)Arrays.equals(output, encoded));
        ((InputStream)in).close();
        in = new Base32InputStream((InputStream)new ByteArrayInputStream(encoded));
        output = new byte[decoded.length];
        for (i = 0; i < output.length; ++i) {
            output[i] = (byte)((InputStream)in).read();
        }
        Assert.assertEquals((String)"EOF", (long)-1L, (long)((InputStream)in).read());
        Assert.assertEquals((String)"Still EOF", (long)-1L, (long)((InputStream)in).read());
        Assert.assertTrue((String)"Streaming base32 decode", (boolean)Arrays.equals(output, decoded));
        ((InputStream)in).close();
        in = new ByteArrayInputStream(decoded);
        for (i = 0; i < 10; ++i) {
            in = new Base32InputStream((InputStream)in, true, chunkSize, separator);
            in = new Base32InputStream((InputStream)in, false);
        }
        output = new byte[decoded.length];
        for (i = 0; i < output.length; ++i) {
            output[i] = (byte)((InputStream)in).read();
        }
        Assert.assertEquals((String)"EOF", (long)-1L, (long)((InputStream)in).read());
        Assert.assertEquals((String)"Still EOF", (long)-1L, (long)((InputStream)in).read());
        Assert.assertTrue((String)"Streaming base32 wrap-wrap-wrap!", (boolean)Arrays.equals(output, decoded));
    }

    @Test
    public void testMarkSupported() throws Exception {
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        ByteArrayInputStream bin = new ByteArrayInputStream(decoded);
        Base32InputStream in = new Base32InputStream((InputStream)bin, true, 4, new byte[]{0, 0, 0});
        Assert.assertFalse((String)"Base32InputStream.markSupported() is false", (boolean)in.markSupported());
        in.close();
    }

    @Test
    public void testRead0() throws Exception {
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        byte[] buf = new byte[1024];
        int bytesRead = 0;
        ByteArrayInputStream bin = new ByteArrayInputStream(decoded);
        Base32InputStream in = new Base32InputStream((InputStream)bin, true, 4, new byte[]{0, 0, 0});
        bytesRead = in.read(buf, 0, 0);
        Assert.assertEquals((String)"Base32InputStream.read(buf, 0, 0) returns 0", (long)0L, (long)bytesRead);
        in.close();
    }

    @Test
    public void testReadNull() throws Exception {
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        ByteArrayInputStream bin = new ByteArrayInputStream(decoded);
        Base32InputStream in = new Base32InputStream((InputStream)bin, true, 4, new byte[]{0, 0, 0});
        try {
            in.read(null, 0, 0);
            Assert.fail((String)"Base32InputStream.read(null, 0, 0) to throw a NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        in.close();
    }

    @Test
    public void testReadOutOfBounds() throws Exception {
        byte[] decoded = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        byte[] buf = new byte[1024];
        ByteArrayInputStream bin = new ByteArrayInputStream(decoded);
        Base32InputStream in = new Base32InputStream((InputStream)bin, true, 4, new byte[]{0, 0, 0});
        try {
            in.read(buf, -1, 0);
            Assert.fail((String)"Expected Base32InputStream.read(buf, -1, 0) to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            in.read(buf, 0, -1);
            Assert.fail((String)"Expected Base32InputStream.read(buf, 0, -1) to throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            in.read(buf, buf.length + 1, 0);
            Assert.fail((String)"Base32InputStream.read(buf, buf.length + 1, 0) throws IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            in.read(buf, buf.length - 1, 2);
            Assert.fail((String)"Base32InputStream.read(buf, buf.length - 1, 2) throws IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        in.close();
    }

    @Test
    public void testSkipNone() throws Throwable {
        ByteArrayInputStream ins = new ByteArrayInputStream(StringUtils.getBytesIso8859_1((String)ENCODED_FOO));
        Base32InputStream b32stream = new Base32InputStream((InputStream)ins);
        byte[] actualBytes = new byte[6];
        Assert.assertEquals((long)0L, (long)b32stream.skip(0L));
        b32stream.read(actualBytes, 0, actualBytes.length);
        Assert.assertArrayEquals((byte[])actualBytes, (byte[])new byte[]{102, 111, 111, 0, 0, 0});
        Assert.assertEquals((long)-1L, (long)b32stream.read());
        b32stream.close();
    }

    @Test
    public void testSkipBig() throws Throwable {
        ByteArrayInputStream ins = new ByteArrayInputStream(StringUtils.getBytesIso8859_1((String)ENCODED_FOO));
        Base32InputStream b32stream = new Base32InputStream((InputStream)ins);
        Assert.assertEquals((long)3L, (long)b32stream.skip(1024L));
        Assert.assertEquals((long)-1L, (long)b32stream.read());
        Assert.assertEquals((long)-1L, (long)b32stream.read());
        b32stream.close();
    }

    @Test
    public void testSkipPastEnd() throws Throwable {
        ByteArrayInputStream ins = new ByteArrayInputStream(StringUtils.getBytesIso8859_1((String)ENCODED_FOO));
        Base32InputStream b32stream = new Base32InputStream((InputStream)ins);
        Assert.assertEquals((long)3L, (long)b32stream.skip(10L));
        Assert.assertEquals((long)-1L, (long)b32stream.read());
        Assert.assertEquals((long)-1L, (long)b32stream.read());
        b32stream.close();
    }

    @Test
    public void testSkipToEnd() throws Throwable {
        ByteArrayInputStream ins = new ByteArrayInputStream(StringUtils.getBytesIso8859_1((String)ENCODED_FOO));
        Base32InputStream b32stream = new Base32InputStream((InputStream)ins);
        Assert.assertEquals((long)3L, (long)b32stream.skip(3L));
        Assert.assertEquals((long)-1L, (long)b32stream.read());
        Assert.assertEquals((long)-1L, (long)b32stream.read());
        b32stream.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSkipWrongArgument() throws Throwable {
        ByteArrayInputStream ins = new ByteArrayInputStream(StringUtils.getBytesIso8859_1((String)ENCODED_FOO));
        Base32InputStream b32stream = new Base32InputStream((InputStream)ins);
        b32stream.skip(-10L);
        b32stream.close();
    }
}

