/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Base32OutputStream;
import org.apache.commons.codec.binary.Base32TestData;
import org.apache.commons.codec.binary.BaseNCodec;
import org.apache.commons.codec.binary.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class Base32OutputStreamTest {
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] LF = new byte[]{10};

    @Test
    public void testBase32EmptyOutputStreamMimeChunkSize() throws Exception {
        this.testBase32EmptyOutputStream(76);
    }

    @Test
    public void testBase32EmptyOutputStreamPemChunkSize() throws Exception {
        this.testBase32EmptyOutputStream(64);
    }

    private void testBase32EmptyOutputStream(int chunkSize) throws Exception {
        byte[] emptyEncoded = new byte[]{};
        byte[] emptyDecoded = new byte[]{};
        this.testByteByByte(emptyEncoded, emptyDecoded, chunkSize, CRLF);
        this.testByChunk(emptyEncoded, emptyDecoded, chunkSize, CRLF);
    }

    @Test
    public void testBase32OutputStreamByChunk() throws Exception {
        byte[] encoded = StringUtils.getBytesUtf8((String)"JBSWY3DPEBLW64TMMQ======\r\n");
        byte[] decoded = StringUtils.getBytesUtf8((String)"Hello World");
        this.testByChunk(encoded, decoded, 76, CRLF);
        Base32 codec = new Base32();
        for (int i = 0; i <= 150; ++i) {
            byte[][] randomData = Base32TestData.randomData((BaseNCodec)codec, i);
            encoded = randomData[1];
            decoded = randomData[0];
            this.testByChunk(encoded, decoded, 0, LF);
        }
    }

    @Test
    public void testBase32OutputStreamByteByByte() throws Exception {
        byte[] encoded = StringUtils.getBytesUtf8((String)"JBSWY3DPEBLW64TMMQ======\r\n");
        byte[] decoded = StringUtils.getBytesUtf8((String)"Hello World");
        this.testByteByByte(encoded, decoded, 76, CRLF);
        Base32 codec = new Base32();
        for (int i = 0; i <= 150; ++i) {
            byte[][] randomData = Base32TestData.randomData((BaseNCodec)codec, i);
            encoded = randomData[1];
            decoded = randomData[0];
            this.testByteByByte(encoded, decoded, 0, LF);
        }
    }

    private void testByChunk(byte[] encoded, byte[] decoded, int chunkSize, byte[] separator) throws Exception {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        Object out = new Base32OutputStream((OutputStream)byteOut, true, chunkSize, separator);
        ((OutputStream)out).write(decoded);
        ((OutputStream)out).close();
        byte[] output = byteOut.toByteArray();
        Assert.assertTrue((String)"Streaming chunked Base32 encode", (boolean)Arrays.equals(output, encoded));
        byteOut = new ByteArrayOutputStream();
        out = new Base32OutputStream((OutputStream)byteOut, false);
        ((OutputStream)out).write(encoded);
        ((OutputStream)out).close();
        output = byteOut.toByteArray();
        Assert.assertTrue((String)"Streaming chunked Base32 decode", (boolean)Arrays.equals(output, decoded));
        byteOut = new ByteArrayOutputStream();
        out = byteOut;
        for (int i = 0; i < 10; ++i) {
            out = new Base32OutputStream((OutputStream)out, false);
            out = new Base32OutputStream((OutputStream)out, true, chunkSize, separator);
        }
        ((OutputStream)out).write(decoded);
        ((OutputStream)out).close();
        output = byteOut.toByteArray();
        Assert.assertTrue((String)"Streaming chunked Base32 wrap-wrap-wrap!", (boolean)Arrays.equals(output, decoded));
    }

    private void testByteByByte(byte[] encoded, byte[] decoded, int chunkSize, byte[] separator) throws Exception {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        Object out = new Base32OutputStream((OutputStream)byteOut, true, chunkSize, separator);
        for (byte element : decoded) {
            ((OutputStream)out).write(element);
        }
        ((OutputStream)out).close();
        byte[] output = byteOut.toByteArray();
        Assert.assertTrue((String)"Streaming byte-by-byte Base32 encode", (boolean)Arrays.equals(output, encoded));
        byteOut = new ByteArrayOutputStream();
        out = new Base32OutputStream((OutputStream)byteOut, false);
        for (byte element : encoded) {
            ((OutputStream)out).write(element);
        }
        ((OutputStream)out).close();
        output = byteOut.toByteArray();
        Assert.assertTrue((String)"Streaming byte-by-byte Base32 decode", (boolean)Arrays.equals(output, decoded));
        byteOut = new ByteArrayOutputStream();
        out = new Base32OutputStream((OutputStream)byteOut, false);
        for (byte element : encoded) {
            ((OutputStream)out).write(element);
            ((OutputStream)out).flush();
        }
        ((OutputStream)out).close();
        output = byteOut.toByteArray();
        Assert.assertTrue((String)"Streaming byte-by-byte flush() Base32 decode", (boolean)Arrays.equals(output, decoded));
        byteOut = new ByteArrayOutputStream();
        out = byteOut;
        for (int i = 0; i < 10; ++i) {
            out = new Base32OutputStream((OutputStream)out, false);
            out = new Base32OutputStream((OutputStream)out, true, chunkSize, separator);
        }
        for (byte element : decoded) {
            ((OutputStream)out).write(element);
        }
        ((OutputStream)out).close();
        output = byteOut.toByteArray();
        Assert.assertTrue((String)"Streaming byte-by-byte Base32 wrap-wrap-wrap!", (boolean)Arrays.equals(output, decoded));
    }

    @Test
    public void testWriteOutOfBounds() throws Exception {
        byte[] buf = new byte[1024];
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Base32OutputStream out = new Base32OutputStream((OutputStream)bout);
        try {
            out.write(buf, -1, 1);
            Assert.fail((String)"Expected Base32OutputStream.write(buf, -1, 1) to throw a IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ioobe) {
            // empty catch block
        }
        try {
            out.write(buf, 1, -1);
            Assert.fail((String)"Expected Base32OutputStream.write(buf, 1, -1) to throw a IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ioobe) {
            // empty catch block
        }
        try {
            out.write(buf, buf.length + 1, 0);
            Assert.fail((String)"Expected Base32OutputStream.write(buf, buf.length + 1, 0) to throw a IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ioobe) {
            // empty catch block
        }
        try {
            out.write(buf, buf.length - 1, 2);
            Assert.fail((String)"Expected Base32OutputStream.write(buf, buf.length - 1, 2) to throw a IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ioobe) {
            // empty catch block
        }
        out.close();
    }

    @Test
    public void testWriteToNullCoverage() throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Base32OutputStream out = new Base32OutputStream((OutputStream)bout);
        try {
            out.write(null, 0, 0);
            Assert.fail((String)"Expcted Base32OutputStream.write(null) to throw a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        out.close();
    }
}

