/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.net;

import java.nio.charset.UnsupportedCharsetException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.BCodec;
import org.junit.Assert;
import org.junit.Test;

public class BCodecTest {
    static final int[] SWISS_GERMAN_STUFF_UNICODE = new int[]{71, 114, 252, 101, 122, 105, 95, 122, 228, 109, 228};
    static final int[] RUSSIAN_STUFF_UNICODE = new int[]{1042, 1089, 1077, 1084, 95, 1087, 1088, 1080, 1074, 1077, 1090};

    private String constructString(int[] unicodeChars) {
        StringBuilder buffer = new StringBuilder();
        if (unicodeChars != null) {
            for (int unicodeChar : unicodeChars) {
                buffer.append((char)unicodeChar);
            }
        }
        return buffer.toString();
    }

    @Test
    public void testNullInput() throws Exception {
        BCodec bcodec = new BCodec();
        Assert.assertNull((Object)bcodec.doDecoding(null));
        Assert.assertNull((Object)bcodec.doEncoding(null));
    }

    @Test
    public void testUTF8RoundTrip() throws Exception {
        String ru_msg = this.constructString(RUSSIAN_STUFF_UNICODE);
        String ch_msg = this.constructString(SWISS_GERMAN_STUFF_UNICODE);
        BCodec bcodec = new BCodec("UTF-8");
        Assert.assertEquals((Object)"=?UTF-8?B?0JLRgdC10Lxf0L/RgNC40LLQtdGC?=", (Object)bcodec.encode(ru_msg));
        Assert.assertEquals((Object)"=?UTF-8?B?R3LDvGV6aV96w6Rtw6Q=?=", (Object)bcodec.encode(ch_msg));
        Assert.assertEquals((Object)ru_msg, (Object)bcodec.decode(bcodec.encode(ru_msg)));
        Assert.assertEquals((Object)ch_msg, (Object)bcodec.decode(bcodec.encode(ch_msg)));
    }

    @Test
    public void testBasicEncodeDecode() throws Exception {
        BCodec bcodec = new BCodec();
        String plain = "Hello there";
        String encoded = bcodec.encode("Hello there");
        Assert.assertEquals((String)"Basic B encoding test", (Object)"=?UTF-8?B?SGVsbG8gdGhlcmU=?=", (Object)encoded);
        Assert.assertEquals((String)"Basic B decoding test", (Object)"Hello there", (Object)bcodec.decode(encoded));
    }

    @Test
    public void testEncodeDecodeNull() throws Exception {
        BCodec bcodec = new BCodec();
        Assert.assertNull((String)"Null string B encoding test", (Object)bcodec.encode((String)null));
        Assert.assertNull((String)"Null string B decoding test", (Object)bcodec.decode((String)null));
    }

    @Test
    public void testEncodeStringWithNull() throws Exception {
        BCodec bcodec = new BCodec();
        String test = null;
        String result = bcodec.encode(test, "charset");
        Assert.assertEquals((String)"Result should be null", null, (Object)result);
    }

    @Test
    public void testDecodeStringWithNull() throws Exception {
        BCodec bcodec = new BCodec();
        String test = null;
        String result = bcodec.decode(test);
        Assert.assertEquals((String)"Result should be null", null, (Object)result);
    }

    @Test
    public void testEncodeObjects() throws Exception {
        BCodec bcodec = new BCodec();
        String plain = "what not";
        String encoded = (String)bcodec.encode((Object)"what not");
        Assert.assertEquals((String)"Basic B encoding test", (Object)"=?UTF-8?B?d2hhdCBub3Q=?=", (Object)encoded);
        Object result = bcodec.encode(null);
        Assert.assertEquals((String)"Encoding a null Object should return null", null, (Object)result);
        try {
            Double dObj = new Double(3.0);
            bcodec.encode((Object)dObj);
            Assert.fail((String)"Trying to url encode a Double object should cause an exception.");
        }
        catch (EncoderException encoderException) {
            // empty catch block
        }
    }

    @Test(expected=UnsupportedCharsetException.class)
    public void testInvalidEncoding() {
        new BCodec("NONSENSE");
    }

    @Test
    public void testDecodeObjects() throws Exception {
        BCodec bcodec = new BCodec();
        String decoded = "=?UTF-8?B?d2hhdCBub3Q=?=";
        String plain = (String)bcodec.decode((Object)"=?UTF-8?B?d2hhdCBub3Q=?=");
        Assert.assertEquals((String)"Basic B decoding test", (Object)"what not", (Object)plain);
        Object result = bcodec.decode(null);
        Assert.assertEquals((String)"Decoding a null Object should return null", null, (Object)result);
        try {
            Double dObj = new Double(3.0);
            bcodec.decode((Object)dObj);
            Assert.fail((String)"Trying to url encode a Double object should cause an exception.");
        }
        catch (DecoderException decoderException) {
            // empty catch block
        }
    }
}

