/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.codec.digest.DigestUtilsTest;
import org.apache.commons.codec.digest.MessageDigestAlgorithms;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MessageDigestAlgorithmsTest {
    private DigestUtilsTest digestUtilsTest;
    private final String messageDigestAlgorithm;

    @Parameterized.Parameters(name="{0}")
    public static Object[] data() {
        return MessageDigestAlgorithms.values();
    }

    private static boolean contains(String key) {
        for (String s : MessageDigestAlgorithms.values()) {
            if (!s.equals(key)) continue;
            return true;
        }
        return false;
    }

    @BeforeClass
    public static void checkValues() throws Exception {
        Field[] fields = MessageDigestAlgorithms.class.getDeclaredFields();
        boolean ok = true;
        int psf = 0;
        for (Field f : fields) {
            int modifiers = f.getModifiers();
            if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) continue;
            ++psf;
            if (MessageDigestAlgorithmsTest.contains((String)f.get(null))) continue;
            System.out.println("Not found in MessageDigestAlgorithms.values(): " + f.getName());
            ok = false;
        }
        if (!ok) {
            Assert.fail((String)"One or more entries are missing from the MessageDigestAlgorithms.values() array");
        }
        if (psf != MessageDigestAlgorithms.values().length) {
            Assert.fail((String)"One or more unexpected entries found in the MessageDigestAlgorithms.values() array");
        }
    }

    public MessageDigestAlgorithmsTest(String messageDigestAlgorithm) {
        this.messageDigestAlgorithm = messageDigestAlgorithm;
    }

    private byte[] digestTestData() throws IOException {
        return DigestUtils.digest((MessageDigest)DigestUtils.getDigest((String)this.messageDigestAlgorithm), (byte[])this.getTestData());
    }

    private byte[] getTestData() {
        return this.digestUtilsTest.getTestData();
    }

    private File getTestFile() {
        return this.digestUtilsTest.getTestFile();
    }

    @Before
    public void setUp() throws Exception {
        this.digestUtilsTest = new DigestUtilsTest();
        this.digestUtilsTest.setUp();
    }

    @After
    public void tearDown() throws Exception {
        this.digestUtilsTest.tearDown();
        this.digestUtilsTest = null;
    }

    @Test
    public void testAlgorithm() throws IOException, NoSuchAlgorithmException {
        String algorithm = this.messageDigestAlgorithm;
        Assert.assertNotNull((Object)algorithm);
        Assert.assertFalse((boolean)algorithm.isEmpty());
        Assume.assumeTrue((boolean)DigestUtils.isAvailable((String)this.messageDigestAlgorithm));
        MessageDigest.getInstance(algorithm);
    }

    @Test
    public void testDigestByteArray() throws IOException {
        Assume.assumeTrue((boolean)DigestUtils.isAvailable((String)this.messageDigestAlgorithm));
        Assert.assertArrayEquals((byte[])this.digestTestData(), (byte[])DigestUtils.digest((MessageDigest)DigestUtils.getDigest((String)this.messageDigestAlgorithm), (byte[])this.getTestData()));
        Assert.assertArrayEquals((byte[])this.digestTestData(), (byte[])DigestUtils.digest((MessageDigest)DigestUtils.getDigest((String)this.messageDigestAlgorithm), (byte[])this.getTestData()));
    }

    @Test
    public void testDigestByteBuffer() throws IOException {
        Assume.assumeTrue((boolean)DigestUtils.isAvailable((String)this.messageDigestAlgorithm));
        Assert.assertArrayEquals((byte[])this.digestTestData(), (byte[])DigestUtils.digest((MessageDigest)DigestUtils.getDigest((String)this.messageDigestAlgorithm), (ByteBuffer)ByteBuffer.wrap(this.getTestData())));
        Assert.assertArrayEquals((byte[])this.digestTestData(), (byte[])DigestUtils.digest((MessageDigest)DigestUtils.getDigest((String)this.messageDigestAlgorithm), (ByteBuffer)ByteBuffer.wrap(this.getTestData())));
    }

    @Test
    public void testDigestFile() throws IOException {
        Assume.assumeTrue((boolean)DigestUtils.isAvailable((String)this.messageDigestAlgorithm));
        Assert.assertArrayEquals((byte[])this.digestTestData(), (byte[])DigestUtils.digest((MessageDigest)DigestUtils.getDigest((String)this.messageDigestAlgorithm), (File)this.getTestFile()));
        Assert.assertArrayEquals((byte[])this.digestTestData(), (byte[])DigestUtils.digest((MessageDigest)DigestUtils.getDigest((String)this.messageDigestAlgorithm), (File)this.getTestFile()));
    }

    @Test
    public void testDigestInputStream() throws IOException {
        Assume.assumeTrue((boolean)DigestUtils.isAvailable((String)this.messageDigestAlgorithm));
        Assert.assertArrayEquals((byte[])this.digestTestData(), (byte[])DigestUtils.digest((MessageDigest)DigestUtils.getDigest((String)this.messageDigestAlgorithm), (InputStream)new ByteArrayInputStream(this.getTestData())));
        Assert.assertArrayEquals((byte[])this.digestTestData(), (byte[])DigestUtils.digest((MessageDigest)DigestUtils.getDigest((String)this.messageDigestAlgorithm), (InputStream)new ByteArrayInputStream(this.getTestData())));
    }

    @Test
    public void testGetMessageDigest() throws IOException, NoSuchAlgorithmException {
        Assume.assumeTrue((boolean)DigestUtils.isAvailable((String)this.messageDigestAlgorithm));
        MessageDigest messageDigest = DigestUtils.getDigest((String)this.messageDigestAlgorithm);
        Assert.assertEquals((Object)this.messageDigestAlgorithm, (Object)messageDigest.getAlgorithm());
    }
}

