/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.codec.digest.XXHash32;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class XXHash32Test {
    private final File file;
    private final String expectedChecksum;

    public XXHash32Test(String path, String c) throws IOException {
        URL url = XXHash32Test.class.getClassLoader().getResource(path);
        if (url == null) {
            throw new FileNotFoundException("couldn't find " + path);
        }
        URI uri = null;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
        this.file = new File(uri);
        this.expectedChecksum = c;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> factory() {
        return Arrays.asList({"bla.tar", "fbb5c8d1"}, {"bla.tar.xz", "4106a208"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void verifyChecksum() throws IOException {
        XXHash32 h = new XXHash32();
        FileInputStream s = new FileInputStream(this.file);
        try {
            byte[] b = XXHash32Test.toByteArray(s);
            h.update(b, 0, b.length);
        }
        finally {
            s.close();
        }
        Assert.assertEquals((String)("checksum for " + this.file.getName()), (Object)this.expectedChecksum, (Object)Long.toHexString(h.getValue()));
    }

    private static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        XXHash32Test.copy(input, output, 10240);
        return output.toByteArray();
    }

    private static long copy(InputStream input, OutputStream output, int buffersize) throws IOException {
        byte[] buffer = new byte[buffersize];
        int n = 0;
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

