/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Random;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class DigestUtilsTest {
    private final byte[] testData = new byte[0x100000];
    private File testFile;

    private void assumeJava8() {
        Assume.assumeTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8));
    }

    private void assumeJava9() {
        Assume.assumeTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9));
    }

    byte[] getTestData() {
        return this.testData;
    }

    File getTestFile() {
        return this.testFile;
    }

    @Before
    public void setUp() throws Exception {
        new Random().nextBytes(this.testData);
        this.testFile = File.createTempFile(DigestUtilsTest.class.getName(), ".dat");
        try (FileOutputStream fos = new FileOutputStream(this.testFile);){
            fos.write(this.testData);
        }
    }

    @After
    public void tearDown() {
        if (!this.testFile.delete()) {
            this.testFile.deleteOnExit();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInternalNoSuchAlgorithmException() {
        DigestUtils.getDigest((String)"Bogus Bogus");
    }

    @Test
    public void testMd2Hex() throws IOException {
        Assert.assertEquals((Object)"8350e5a3e24c153df2275c9f80692773", (Object)DigestUtils.md2Hex((String)""));
        Assert.assertEquals((Object)"32ec01ec4a6dac72c0ab96fb34c0b5d1", (Object)DigestUtils.md2Hex((String)"a"));
        Assert.assertEquals((Object)"da853b0d3f88d99b30283a69e6ded6bb", (Object)DigestUtils.md2Hex((String)"abc"));
        Assert.assertEquals((Object)"ab4f496bfb2a530b219ff33031fe06b0", (Object)DigestUtils.md2Hex((String)"message digest"));
        Assert.assertEquals((Object)"4e8ddff3650292ab5a4108c3aa47940b", (Object)DigestUtils.md2Hex((String)"abcdefghijklmnopqrstuvwxyz"));
        Assert.assertEquals((Object)"da33def2a42df13975352846c30338cd", (Object)DigestUtils.md2Hex((String)"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789"));
        Assert.assertEquals((Object)"d5976f79d83d3a0dc9806c3c66f3efd8", (Object)DigestUtils.md2Hex((String)"12345678901234567890123456789012345678901234567890123456789012345678901234567890"));
        Assert.assertEquals((Object)DigestUtils.md2Hex((byte[])this.testData), (Object)DigestUtils.md2Hex((InputStream)new ByteArrayInputStream(this.testData)));
    }

    @Test
    public void testMd2HexLength() {
        String hashMe = "this is some string that is longer than 32 characters";
        String hash = DigestUtils.md2Hex((byte[])StringUtils.getBytesUtf8((String)hashMe));
        Assert.assertEquals((long)32L, (long)hash.length());
        hashMe = "length < 32";
        hash = DigestUtils.md2Hex((byte[])StringUtils.getBytesUtf8((String)hashMe));
        Assert.assertEquals((long)32L, (long)hash.length());
    }

    @Test
    public void testMd2Length() {
        String hashMe = "this is some string that is longer than 16 characters";
        byte[] hash = DigestUtils.md2((byte[])StringUtils.getBytesUtf8((String)hashMe));
        Assert.assertEquals((long)16L, (long)hash.length);
        hashMe = "length < 16";
        hash = DigestUtils.md2((byte[])StringUtils.getBytesUtf8((String)hashMe));
        Assert.assertEquals((long)16L, (long)hash.length);
    }

    @Test
    public void testMd5Hex() throws IOException {
        Assert.assertEquals((Object)"d41d8cd98f00b204e9800998ecf8427e", (Object)DigestUtils.md5Hex((String)""));
        Assert.assertEquals((Object)"0cc175b9c0f1b6a831c399e269772661", (Object)DigestUtils.md5Hex((String)"a"));
        Assert.assertEquals((Object)"900150983cd24fb0d6963f7d28e17f72", (Object)DigestUtils.md5Hex((String)"abc"));
        Assert.assertEquals((Object)"f96b697d7cb7938d525a2f31aaf161d0", (Object)DigestUtils.md5Hex((String)"message digest"));
        Assert.assertEquals((Object)"c3fcd3d76192e4007dfb496cca67e13b", (Object)DigestUtils.md5Hex((String)"abcdefghijklmnopqrstuvwxyz"));
        Assert.assertEquals((Object)"d174ab98d277d9f5a5611c2c9f419d9f", (Object)DigestUtils.md5Hex((String)"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789"));
        Assert.assertEquals((Object)"57edf4a22be3c955ac49da2e2107b67a", (Object)DigestUtils.md5Hex((String)"12345678901234567890123456789012345678901234567890123456789012345678901234567890"));
        Assert.assertEquals((Object)DigestUtils.md5Hex((byte[])this.testData), (Object)DigestUtils.md5Hex((InputStream)new ByteArrayInputStream(this.testData)));
    }

    @Test
    public void testMd5HexLengthForBytes() {
        String hashMe = "this is some string that is longer than 32 characters";
        String hash = DigestUtils.md5Hex((byte[])StringUtils.getBytesUtf8((String)hashMe));
        Assert.assertEquals((long)32L, (long)hash.length());
        hashMe = "length < 32";
        hash = DigestUtils.md5Hex((byte[])StringUtils.getBytesUtf8((String)hashMe));
        Assert.assertEquals((long)32L, (long)hash.length());
    }

    @Test
    public void testMd5LengthForBytes() {
        String hashMe = "this is some string that is longer than 16 characters";
        byte[] hash = DigestUtils.md5((byte[])StringUtils.getBytesUtf8((String)hashMe));
        Assert.assertEquals((long)16L, (long)hash.length);
        hashMe = "length < 16";
        hash = DigestUtils.md5((byte[])StringUtils.getBytesUtf8((String)hashMe));
        Assert.assertEquals((long)16L, (long)hash.length);
    }

    @Test
    public void testSha1Hex() throws IOException {
        Assert.assertEquals((Object)"a9993e364706816aba3e25717850c26c9cd0d89d", (Object)DigestUtils.sha1Hex((String)"abc"));
        Assert.assertEquals((Object)"a9993e364706816aba3e25717850c26c9cd0d89d", (Object)DigestUtils.sha1Hex((byte[])StringUtils.getBytesUtf8((String)"abc")));
        Assert.assertEquals((Object)"84983e441c3bd26ebaae4aa1f95129e5e54670f1", (Object)DigestUtils.sha1Hex((String)"abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq"));
        Assert.assertEquals((Object)DigestUtils.sha1Hex((byte[])this.testData), (Object)DigestUtils.sha1Hex((InputStream)new ByteArrayInputStream(this.testData)));
    }

    @Test
    public void testSha1UpdateWithByteArray() {
        String d1 = "C'est un homme qui rentre dans un caf\u00e9, et plouf";
        String d2 = "C'est un homme, c'est qu'une t\u00eate, on lui offre un cadeau: 'oh... encore un chapeau!'";
        MessageDigest messageDigest = DigestUtils.getSha1Digest();
        messageDigest.update("C'est un homme qui rentre dans un caf\u00e9, et plouf".getBytes());
        messageDigest.update("C'est un homme, c'est qu'une t\u00eate, on lui offre un cadeau: 'oh... encore un chapeau!'".getBytes());
        String expectedResult = Hex.encodeHexString((byte[])messageDigest.digest());
        messageDigest = DigestUtils.getSha1Digest();
        DigestUtils.updateDigest((MessageDigest)messageDigest, (byte[])"C'est un homme qui rentre dans un caf\u00e9, et plouf".getBytes());
        DigestUtils.updateDigest((MessageDigest)messageDigest, (byte[])"C'est un homme, c'est qu'une t\u00eate, on lui offre un cadeau: 'oh... encore un chapeau!'".getBytes());
        String actualResult = Hex.encodeHexString((byte[])messageDigest.digest());
        Assert.assertEquals((Object)expectedResult, (Object)actualResult);
    }

    @Test
    public void testSha1UpdateWithByteBuffer() {
        String d1 = "C'est un homme qui rentre dans un caf\u00e9, et plouf";
        String d2 = "C'est un homme, c'est qu'une t\u00eate, on lui offre un cadeau: 'oh... encore un chapeau!'";
        MessageDigest messageDigest = DigestUtils.getSha1Digest();
        messageDigest.update("C'est un homme qui rentre dans un caf\u00e9, et plouf".getBytes());
        messageDigest.update("C'est un homme, c'est qu'une t\u00eate, on lui offre un cadeau: 'oh... encore un chapeau!'".getBytes());
        String expectedResult = Hex.encodeHexString((byte[])messageDigest.digest());
        messageDigest = DigestUtils.getSha1Digest();
        DigestUtils.updateDigest((MessageDigest)messageDigest, (ByteBuffer)ByteBuffer.wrap("C'est un homme qui rentre dans un caf\u00e9, et plouf".getBytes()));
        DigestUtils.updateDigest((MessageDigest)messageDigest, (ByteBuffer)ByteBuffer.wrap("C'est un homme, c'est qu'une t\u00eate, on lui offre un cadeau: 'oh... encore un chapeau!'".getBytes()));
        String actualResult = Hex.encodeHexString((byte[])messageDigest.digest());
        Assert.assertEquals((Object)expectedResult, (Object)actualResult);
    }

    @Test
    public void testSha1UpdateWithString() {
        String d1 = "C'est un homme qui rentre dans un caf\u00e9, et plouf";
        String d2 = "C'est un homme, c'est qu'une t\u00eate, on lui offre un cadeau: 'oh... encore un chapeau!'";
        MessageDigest messageDigest = DigestUtils.getSha1Digest();
        messageDigest.update(StringUtils.getBytesUtf8((String)"C'est un homme qui rentre dans un caf\u00e9, et plouf"));
        messageDigest.update(StringUtils.getBytesUtf8((String)"C'est un homme, c'est qu'une t\u00eate, on lui offre un cadeau: 'oh... encore un chapeau!'"));
        String expectedResult = Hex.encodeHexString((byte[])messageDigest.digest());
        messageDigest = DigestUtils.getSha1Digest();
        DigestUtils.updateDigest((MessageDigest)messageDigest, (String)"C'est un homme qui rentre dans un caf\u00e9, et plouf");
        DigestUtils.updateDigest((MessageDigest)messageDigest, (String)"C'est un homme, c'est qu'une t\u00eate, on lui offre un cadeau: 'oh... encore un chapeau!'");
        String actualResult = Hex.encodeHexString((byte[])messageDigest.digest());
        Assert.assertEquals((Object)expectedResult, (Object)actualResult);
    }

    @Test
    public void testSha224() {
        this.assumeJava8();
        Assert.assertEquals((Object)"d14a028c2a3a2bc9476102bb288234c415a2b01f828ea62ac5b3e42f", (Object)new DigestUtils("SHA-224").digestAsHex(""));
        Assert.assertEquals((Object)"730e109bd7a8a32b1cb9d9a09aa2325d2430587ddbc0c38bad911525", (Object)new DigestUtils("SHA-224").digestAsHex("The quick brown fox jumps over the lazy dog"));
    }

    @Test
    public void testSha256() throws IOException {
        Assert.assertEquals((Object)"ba7816bf8f01cfea414140de5dae2223b00361a396177a9cb410ff61f20015ad", (Object)DigestUtils.sha256Hex((String)"abc"));
        Assert.assertEquals((Object)"ba7816bf8f01cfea414140de5dae2223b00361a396177a9cb410ff61f20015ad", (Object)DigestUtils.sha256Hex((byte[])StringUtils.getBytesUtf8((String)"abc")));
        Assert.assertEquals((Object)"248d6a61d20638b8e5c026930c3e6039a33ce45964ff2167f6ecedd419db06c1", (Object)DigestUtils.sha256Hex((String)"abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq"));
        Assert.assertEquals((Object)DigestUtils.sha256Hex((byte[])this.testData), (Object)DigestUtils.sha256Hex((InputStream)new ByteArrayInputStream(this.testData)));
    }

    @Test
    public void testSha384() throws IOException {
        Assert.assertEquals((Object)"cb00753f45a35e8bb5a03d699ac65007272c32ab0eded1631a8b605a43ff5bed8086072ba1e7cc2358baeca134c825a7", (Object)DigestUtils.sha384Hex((String)"abc"));
        Assert.assertEquals((Object)"cb00753f45a35e8bb5a03d699ac65007272c32ab0eded1631a8b605a43ff5bed8086072ba1e7cc2358baeca134c825a7", (Object)DigestUtils.sha384Hex((byte[])StringUtils.getBytesUtf8((String)"abc")));
        Assert.assertEquals((Object)"09330c33f71147e83d192fc782cd1b4753111b173b3b05d22fa08086e3b0f712fcc7c71a557e2db966c3e9fa91746039", (Object)DigestUtils.sha384Hex((String)"abcdefghbcdefghicdefghijdefghijkefghijklfghijklmghijklmnhijklmnoijklmnopjklmnopqklmnopqrlmnopqrsmnopqrstnopqrstu"));
        Assert.assertEquals((Object)DigestUtils.sha384Hex((byte[])this.testData), (Object)DigestUtils.sha384Hex((InputStream)new ByteArrayInputStream(this.testData)));
    }

    @Test
    public void testSha512() {
        Assert.assertEquals((Object)"ddaf35a193617abacc417349ae20413112e6fa4e89a97ea20a9eeee64b55d39a2192992a274fc1a836ba3c23a3feebbd454d4423643ce80e2a9ac94fa54ca49f", (Object)DigestUtils.sha512Hex((String)"abc"));
        Assert.assertEquals((Object)"ddaf35a193617abacc417349ae20413112e6fa4e89a97ea20a9eeee64b55d39a2192992a274fc1a836ba3c23a3feebbd454d4423643ce80e2a9ac94fa54ca49f", (Object)DigestUtils.sha512Hex((byte[])StringUtils.getBytesUtf8((String)"abc")));
        Assert.assertEquals((Object)"8e959b75dae313da8cf4f72814fc143f8f7779c6eb9f7fa17299aeadb6889018501d289e4900f7e4331b99dec4b5433ac7d329eeb6dd26545e96e55b874be909", (Object)DigestUtils.sha512Hex((String)"abcdefghbcdefghicdefghijdefghijkefghijklfghijklmghijklmnhijklmnoijklmnopjklmnopqklmnopqrlmnopqrsmnopqrstnopqrstu"));
    }

    @Test
    public void testSha3_224() {
        this.assumeJava9();
        Assert.assertEquals((Object)"6b4e03423667dbb73b6e15454f0eb1abd4597f9a1b078e3f5b5a6bc7", (Object)DigestUtils.sha3_224Hex((String)""));
    }

    @Test
    public void testSha3_256() {
        this.assumeJava9();
        Assert.assertEquals((Object)"a7ffc6f8bf1ed76651c14756a061d662f580ff4de43b49fa82d80a4b80f8434a", (Object)DigestUtils.sha3_256Hex((String)""));
    }

    @Test
    public void testSha3_384() {
        this.assumeJava9();
        Assert.assertEquals((Object)"0c63a75b845e4f7d01107d852e4c2485c51a50aaaa94fc61995e71bbee983a2ac3713831264adb47fb6bd1e058d5f004", (Object)DigestUtils.sha3_384Hex((String)""));
    }

    @Test
    public void testSha3_512() {
        this.assumeJava9();
        Assert.assertEquals((Object)"a69f73cca23a9ac5c8b567dc185a756e97c982164fe25859e0d1dcc1475c80a615b2123af1f5f94c11e3e9402c3ac558f500199d95b6d3e301758586281dcd26", (Object)DigestUtils.sha3_512Hex((String)""));
    }

    @Test
    public void testSha256HexInputStream() throws IOException {
        Assert.assertEquals((Object)DigestUtils.sha256Hex((byte[])this.testData), (Object)DigestUtils.sha256Hex((InputStream)new ByteArrayInputStream(this.testData)));
    }

    @Test
    public void testSha384HexInputStream() throws IOException {
        Assert.assertEquals((Object)DigestUtils.sha384Hex((byte[])this.testData), (Object)DigestUtils.sha384Hex((InputStream)new ByteArrayInputStream(this.testData)));
    }

    @Test
    public void testSha512HexInputStream() throws IOException {
        Assert.assertEquals((Object)DigestUtils.sha512Hex((byte[])this.testData), (Object)DigestUtils.sha512Hex((InputStream)new ByteArrayInputStream(this.testData)));
    }

    @Test
    public void testSha3_224HexInputStream() throws IOException {
        this.assumeJava9();
        Assert.assertEquals((Object)DigestUtils.sha3_224Hex((byte[])this.testData), (Object)DigestUtils.sha3_224Hex((InputStream)new ByteArrayInputStream(this.testData)));
    }

    @Test
    public void testSha3_256HexInputStream() throws IOException {
        this.assumeJava9();
        Assert.assertEquals((Object)DigestUtils.sha3_256Hex((byte[])this.testData), (Object)DigestUtils.sha3_256Hex((InputStream)new ByteArrayInputStream(this.testData)));
    }

    @Test
    public void testSha3_384HexInputStream() throws IOException {
        this.assumeJava9();
        Assert.assertEquals((Object)DigestUtils.sha3_384Hex((byte[])this.testData), (Object)DigestUtils.sha3_384Hex((InputStream)new ByteArrayInputStream(this.testData)));
    }

    @Test
    public void testSha3_512HexInputStream() throws IOException {
        this.assumeJava9();
        Assert.assertEquals((Object)DigestUtils.sha3_512Hex((byte[])this.testData), (Object)DigestUtils.sha3_512Hex((InputStream)new ByteArrayInputStream(this.testData)));
    }

    @Test
    public void testShaHex() throws IOException {
        Assert.assertEquals((Object)"a9993e364706816aba3e25717850c26c9cd0d89d", (Object)DigestUtils.shaHex((String)"abc"));
        Assert.assertEquals((Object)"a9993e364706816aba3e25717850c26c9cd0d89d", (Object)DigestUtils.shaHex((byte[])StringUtils.getBytesUtf8((String)"abc")));
        Assert.assertEquals((Object)"84983e441c3bd26ebaae4aa1f95129e5e54670f1", (Object)DigestUtils.shaHex((String)"abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq"));
        Assert.assertEquals((Object)DigestUtils.shaHex((byte[])this.testData), (Object)DigestUtils.shaHex((InputStream)new ByteArrayInputStream(this.testData)));
    }

    @Test
    public void testShaUpdateWithByteArray() {
        String d1 = "C'est un homme qui rentre dans un caf\u00e9, et plouf";
        String d2 = "C'est un homme, c'est qu'une t\u00eate, on lui offre un cadeau: 'oh... encore un chapeau!'";
        MessageDigest messageDigest = DigestUtils.getShaDigest();
        messageDigest.update("C'est un homme qui rentre dans un caf\u00e9, et plouf".getBytes());
        messageDigest.update("C'est un homme, c'est qu'une t\u00eate, on lui offre un cadeau: 'oh... encore un chapeau!'".getBytes());
        String expectedResult = Hex.encodeHexString((byte[])messageDigest.digest());
        messageDigest = DigestUtils.getShaDigest();
        DigestUtils.updateDigest((MessageDigest)messageDigest, (byte[])"C'est un homme qui rentre dans un caf\u00e9, et plouf".getBytes());
        DigestUtils.updateDigest((MessageDigest)messageDigest, (byte[])"C'est un homme, c'est qu'une t\u00eate, on lui offre un cadeau: 'oh... encore un chapeau!'".getBytes());
        String actualResult = Hex.encodeHexString((byte[])messageDigest.digest());
        Assert.assertEquals((Object)expectedResult, (Object)actualResult);
    }

    @Test
    public void testShaUpdateWithString() {
        String d1 = "C'est un homme qui rentre dans un caf\u00e9, et plouf";
        String d2 = "C'est un homme, c'est qu'une t\u00eate, on lui offre un cadeau: 'oh... encore un chapeau!'";
        MessageDigest messageDigest = DigestUtils.getShaDigest();
        messageDigest.update(StringUtils.getBytesUtf8((String)"C'est un homme qui rentre dans un caf\u00e9, et plouf"));
        messageDigest.update(StringUtils.getBytesUtf8((String)"C'est un homme, c'est qu'une t\u00eate, on lui offre un cadeau: 'oh... encore un chapeau!'"));
        String expectedResult = Hex.encodeHexString((byte[])messageDigest.digest());
        messageDigest = DigestUtils.getShaDigest();
        DigestUtils.updateDigest((MessageDigest)messageDigest, (String)"C'est un homme qui rentre dans un caf\u00e9, et plouf");
        DigestUtils.updateDigest((MessageDigest)messageDigest, (String)"C'est un homme, c'est qu'une t\u00eate, on lui offre un cadeau: 'oh... encore un chapeau!'");
        String actualResult = Hex.encodeHexString((byte[])messageDigest.digest());
        Assert.assertEquals((Object)expectedResult, (Object)actualResult);
    }
}

