/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.binary.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class HexTest {
    private static final String BAD_ENCODING_NAME = "UNKNOWN";
    private static final boolean LOG = false;

    private boolean charsetSanityCheck(String name) {
        String source = "the quick brown dog jumped over the lazy fox";
        try {
            byte[] bytes = "the quick brown dog jumped over the lazy fox".getBytes(name);
            String str = new String(bytes, name);
            boolean equals = "the quick brown dog jumped over the lazy fox".equals(str);
            if (!equals) {
                this.log("FAILED charsetSanityCheck=Interesting Java charset oddity: Roundtrip failed for " + name);
            }
            return equals;
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    private void checkDecodeHexCharArrayOddCharacters(char[] data) {
        try {
            Hex.decodeHex((char[])data);
            Assert.fail((String)"An exception wasn't thrown when trying to decode an odd number of characters");
        }
        catch (DecoderException decoderException) {
            // empty catch block
        }
    }

    private void checkDecodeHexCharArrayOddCharacters(String data) {
        try {
            Hex.decodeHex((String)data);
            Assert.fail((String)"An exception wasn't thrown when trying to decode an odd number of characters");
        }
        catch (DecoderException decoderException) {
            // empty catch block
        }
    }

    private void log(String s) {
    }

    private void log(Throwable t) {
    }

    @Test
    public void testCustomCharset() throws UnsupportedEncodingException, DecoderException {
        for (String name : Charset.availableCharsets().keySet()) {
            this.testCustomCharset(name, "testCustomCharset");
        }
    }

    private void testCustomCharset(String name, String parent) throws UnsupportedEncodingException, DecoderException {
        if (!this.charsetSanityCheck(name)) {
            return;
        }
        this.log(parent + "=" + name);
        Hex customCodec = new Hex(name);
        String sourceString = "Hello World";
        byte[] sourceBytes = "Hello World".getBytes(name);
        byte[] actualEncodedBytes = customCodec.encode(sourceBytes);
        String expectedHexString = Hex.encodeHexString((byte[])sourceBytes);
        byte[] expectedHexStringBytes = expectedHexString.getBytes(name);
        Assert.assertTrue((boolean)Arrays.equals(expectedHexStringBytes, actualEncodedBytes));
        String actualStringFromBytes = new String(actualEncodedBytes, name);
        Assert.assertEquals((String)(name + ", expectedHexString=" + expectedHexString + ", actualStringFromBytes=" + actualStringFromBytes), (Object)expectedHexString, (Object)actualStringFromBytes);
        Hex utf8Codec = new Hex();
        expectedHexString = "48656c6c6f20576f726c64";
        byte[] decodedUtf8Bytes = (byte[])utf8Codec.decode((Object)expectedHexString);
        actualStringFromBytes = new String(decodedUtf8Bytes, utf8Codec.getCharset());
        Assert.assertEquals((String)name, (Object)"Hello World", (Object)actualStringFromBytes);
        byte[] decodedCustomBytes = customCodec.decode(actualEncodedBytes);
        actualStringFromBytes = new String(decodedCustomBytes, name);
        Assert.assertEquals((String)name, (Object)"Hello World", (Object)actualStringFromBytes);
    }

    @Test(expected=UnsupportedCharsetException.class)
    public void testCustomCharsetBadName() {
        new Hex(BAD_ENCODING_NAME);
    }

    @Test
    public void testCustomCharsetToString() {
        Assert.assertTrue((new Hex().toString().indexOf("UTF-8") >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDecodeBadCharacterPos0() {
        try {
            new Hex().decode((Object)"q0");
            Assert.fail((String)"An exception wasn't thrown when trying to decode an illegal character");
        }
        catch (DecoderException decoderException) {
            // empty catch block
        }
    }

    @Test
    public void testDecodeBadCharacterPos1() {
        try {
            new Hex().decode((Object)"0q");
            Assert.fail((String)"An exception wasn't thrown when trying to decode an illegal character");
        }
        catch (DecoderException decoderException) {
            // empty catch block
        }
    }

    @Test
    public void testDecodeByteArrayEmpty() throws DecoderException {
        Assert.assertTrue((boolean)Arrays.equals(new byte[0], new Hex().decode(new byte[0])));
    }

    @Test
    public void testDecodeByteArrayObjectEmpty() throws DecoderException {
        Assert.assertTrue((boolean)Arrays.equals(new byte[0], (byte[])new Hex().decode((Object)new byte[0])));
    }

    @Test
    public void testDecodeByteArrayOddCharacters() {
        try {
            new Hex().decode(new byte[]{65});
            Assert.fail((String)"An exception wasn't thrown when trying to decode an odd number of characters");
        }
        catch (DecoderException decoderException) {
            // empty catch block
        }
    }

    @Test
    public void testDecodeByteBufferEmpty() throws DecoderException {
        Assert.assertTrue((boolean)Arrays.equals(new byte[0], new Hex().decode(ByteBuffer.allocate(0))));
    }

    @Test
    public void testDecodeByteBufferObjectEmpty() throws DecoderException {
        Assert.assertTrue((boolean)Arrays.equals(new byte[0], (byte[])new Hex().decode((Object)ByteBuffer.allocate(0))));
    }

    @Test
    public void testDecodeByteBufferOddCharacters() {
        ByteBuffer buffer = ByteBuffer.allocate(1);
        buffer.put((byte)65);
        try {
            new Hex().decode(buffer);
            Assert.fail((String)"An exception wasn't thrown when trying to decode an odd number of characters");
        }
        catch (DecoderException decoderException) {
            // empty catch block
        }
    }

    @Test
    public void testDecodeHexCharArrayEmpty() throws DecoderException {
        Assert.assertTrue((boolean)Arrays.equals(new byte[0], Hex.decodeHex((char[])new char[0])));
    }

    @Test
    public void testDecodeHexStringEmpty() throws DecoderException {
        Assert.assertTrue((boolean)Arrays.equals(new byte[0], Hex.decodeHex((String)"")));
    }

    @Test
    public void testDecodeClassCastException() {
        try {
            new Hex().decode((Object)new int[]{65});
            Assert.fail((String)"An exception wasn't thrown when trying to decode.");
        }
        catch (DecoderException decoderException) {
            // empty catch block
        }
    }

    @Test
    public void testDecodeHexCharArrayOddCharacters1() {
        this.checkDecodeHexCharArrayOddCharacters(new char[]{'A'});
    }

    @Test
    public void testDecodeHexStringOddCharacters1() {
        this.checkDecodeHexCharArrayOddCharacters("A");
    }

    @Test
    public void testDecodeHexCharArrayOddCharacters3() {
        this.checkDecodeHexCharArrayOddCharacters(new char[]{'A', 'B', 'C'});
    }

    @Test
    public void testDecodeHexCharArrayOddCharacters5() {
        this.checkDecodeHexCharArrayOddCharacters(new char[]{'A', 'B', 'C', 'D', 'E'});
    }

    @Test
    public void testDecodeHexStringOddCharacters() {
        try {
            new Hex().decode((Object)"6");
            Assert.fail((String)"An exception wasn't thrown when trying to decode an odd number of characters");
        }
        catch (DecoderException decoderException) {
            // empty catch block
        }
    }

    @Test
    public void testDecodeStringEmpty() throws DecoderException {
        Assert.assertTrue((boolean)Arrays.equals(new byte[0], (byte[])new Hex().decode((Object)"")));
    }

    @Test
    public void testEncodeByteArrayEmpty() {
        Assert.assertTrue((boolean)Arrays.equals(new byte[0], new Hex().encode(new byte[0])));
    }

    @Test
    public void testEncodeByteArrayObjectEmpty() throws EncoderException {
        Assert.assertTrue((boolean)Arrays.equals(new char[0], (char[])new Hex().encode((Object)new byte[0])));
    }

    @Test
    public void testEncodeByteBufferEmpty() {
        Assert.assertTrue((boolean)Arrays.equals(new byte[0], new Hex().encode(ByteBuffer.allocate(0))));
    }

    @Test
    public void testEncodeByteBufferObjectEmpty() throws EncoderException {
        Assert.assertTrue((boolean)Arrays.equals(new char[0], (char[])new Hex().encode((Object)ByteBuffer.allocate(0))));
    }

    @Test
    public void testEncodeClassCastException() {
        try {
            new Hex().encode((Object)new int[]{65});
            Assert.fail((String)"An exception wasn't thrown when trying to encode.");
        }
        catch (EncoderException encoderException) {
            // empty catch block
        }
    }

    @Test
    public void testEncodeDecodeHexCharArrayRandom() throws DecoderException, EncoderException {
        Random random = new Random();
        Hex hex = new Hex();
        for (int i = 5; i > 0; --i) {
            byte[] data = new byte[random.nextInt(10000) + 1];
            random.nextBytes(data);
            char[] encodedChars = Hex.encodeHex((byte[])data);
            byte[] decodedBytes = Hex.decodeHex((char[])encodedChars);
            Assert.assertTrue((boolean)Arrays.equals(data, decodedBytes));
            byte[] encodedStringBytes = hex.encode(data);
            decodedBytes = hex.decode(encodedStringBytes);
            Assert.assertTrue((boolean)Arrays.equals(data, decodedBytes));
            String dataString = new String(encodedChars);
            char[] encodedStringChars = (char[])hex.encode((Object)dataString);
            decodedBytes = (byte[])hex.decode((Object)encodedStringChars);
            Assert.assertTrue((boolean)Arrays.equals(StringUtils.getBytesUtf8((String)dataString), decodedBytes));
            dataString = new String(encodedChars);
            encodedStringChars = (char[])hex.encode((Object)dataString);
            decodedBytes = (byte[])hex.decode((Object)new String(encodedStringChars));
            Assert.assertTrue((boolean)Arrays.equals(StringUtils.getBytesUtf8((String)dataString), decodedBytes));
        }
    }

    @Test
    public void testEncodeHexByteArrayEmpty() {
        Assert.assertTrue((boolean)Arrays.equals(new char[0], Hex.encodeHex((byte[])new byte[0])));
        Assert.assertTrue((boolean)Arrays.equals(new byte[0], new Hex().encode(new byte[0])));
    }

    @Test
    public void testEncodeHexByteArrayHelloWorldLowerCaseHex() {
        byte[] b = StringUtils.getBytesUtf8((String)"Hello World");
        String expected = "48656c6c6f20576f726c64";
        char[] actual = Hex.encodeHex((byte[])b);
        Assert.assertEquals((Object)"48656c6c6f20576f726c64", (Object)new String(actual));
        actual = Hex.encodeHex((byte[])b, (boolean)true);
        Assert.assertEquals((Object)"48656c6c6f20576f726c64", (Object)new String(actual));
        actual = Hex.encodeHex((byte[])b, (boolean)false);
        Assert.assertFalse((boolean)"48656c6c6f20576f726c64".equals(new String(actual)));
    }

    @Test
    public void testEncodeHexByteArrayHelloWorldUpperCaseHex() {
        byte[] b = StringUtils.getBytesUtf8((String)"Hello World");
        String expected = "48656C6C6F20576F726C64";
        char[] actual = Hex.encodeHex((byte[])b);
        Assert.assertFalse((boolean)"48656C6C6F20576F726C64".equals(new String(actual)));
        actual = Hex.encodeHex((byte[])b, (boolean)true);
        Assert.assertFalse((boolean)"48656C6C6F20576F726C64".equals(new String(actual)));
        actual = Hex.encodeHex((byte[])b, (boolean)false);
        Assert.assertTrue((boolean)"48656C6C6F20576F726C64".equals(new String(actual)));
    }

    @Test
    public void testEncodeHexByteArrayZeroes() {
        char[] c = Hex.encodeHex((byte[])new byte[36]);
        Assert.assertEquals((Object)"000000000000000000000000000000000000000000000000000000000000000000000000", (Object)new String(c));
    }

    @Test
    public void testEncodeHexByteBufferEmpty() {
        Assert.assertTrue((boolean)Arrays.equals(new char[0], Hex.encodeHex((ByteBuffer)ByteBuffer.allocate(0))));
        Assert.assertTrue((boolean)Arrays.equals(new byte[0], new Hex().encode(ByteBuffer.allocate(0))));
    }

    @Test
    public void testEncodeHexByteBufferHelloWorldLowerCaseHex() {
        ByteBuffer b = StringUtils.getByteBufferUtf8((String)"Hello World");
        String expected = "48656c6c6f20576f726c64";
        char[] actual = Hex.encodeHex((ByteBuffer)b);
        Assert.assertEquals((Object)"48656c6c6f20576f726c64", (Object)new String(actual));
        actual = Hex.encodeHex((ByteBuffer)b, (boolean)true);
        Assert.assertEquals((Object)"48656c6c6f20576f726c64", (Object)new String(actual));
        actual = Hex.encodeHex((ByteBuffer)b, (boolean)false);
        Assert.assertFalse((boolean)"48656c6c6f20576f726c64".equals(new String(actual)));
    }

    @Test
    public void testEncodeHexByteBufferHelloWorldUpperCaseHex() {
        ByteBuffer b = StringUtils.getByteBufferUtf8((String)"Hello World");
        String expected = "48656C6C6F20576F726C64";
        char[] actual = Hex.encodeHex((ByteBuffer)b);
        Assert.assertFalse((boolean)"48656C6C6F20576F726C64".equals(new String(actual)));
        actual = Hex.encodeHex((ByteBuffer)b, (boolean)true);
        Assert.assertFalse((boolean)"48656C6C6F20576F726C64".equals(new String(actual)));
        actual = Hex.encodeHex((ByteBuffer)b, (boolean)false);
        Assert.assertTrue((boolean)"48656C6C6F20576F726C64".equals(new String(actual)));
    }

    @Test
    public void testEncodeHex_ByteBufferOfZeroes() {
        char[] c = Hex.encodeHex((ByteBuffer)ByteBuffer.allocate(36));
        Assert.assertEquals((Object)"000000000000000000000000000000000000000000000000000000000000000000000000", (Object)new String(c));
    }

    @Test
    public void testEncodeHexByteString_ByteBufferOfZeroes() {
        String c = Hex.encodeHexString((ByteBuffer)ByteBuffer.allocate(36));
        Assert.assertEquals((Object)"000000000000000000000000000000000000000000000000000000000000000000000000", (Object)c);
    }

    @Test
    public void testEncodeHexByteString_ByteArrayOfZeroes() {
        String c = Hex.encodeHexString((byte[])new byte[36]);
        Assert.assertEquals((Object)"000000000000000000000000000000000000000000000000000000000000000000000000", (Object)c);
    }

    @Test
    public void testEncodeHexByteString_ByteArrayBoolean_ToLowerCase() {
        Assert.assertEquals((Object)"0a", (Object)Hex.encodeHexString((byte[])new byte[]{10}, (boolean)true));
    }

    @Test
    public void testEncodeHexByteString_ByteArrayBoolean_ToUpperCase() {
        Assert.assertEquals((Object)"0A", (Object)Hex.encodeHexString((byte[])new byte[]{10}, (boolean)false));
    }

    @Test
    public void testEncodeHexByteString_ByteBufferBoolean_ToLowerCase() {
        Assert.assertEquals((Object)"0a", (Object)Hex.encodeHexString((ByteBuffer)ByteBuffer.wrap(new byte[]{10}), (boolean)true));
    }

    @Test
    public void testEncodeHexByteString_ByteBufferBoolean_ToUpperCase() {
        Assert.assertEquals((Object)"0A", (Object)Hex.encodeHexString((ByteBuffer)ByteBuffer.wrap(new byte[]{10}), (boolean)false));
    }

    @Test
    public void testEncodeStringEmpty() throws EncoderException {
        Assert.assertTrue((boolean)Arrays.equals(new char[0], (char[])new Hex().encode((Object)"")));
    }

    @Test
    public void testGetCharset() {
        Assert.assertEquals((Object)Charsets.UTF_8, (Object)new Hex(Charsets.UTF_8).getCharset());
    }

    @Test
    public void testGetCharsetName() {
        Assert.assertEquals((Object)Charsets.UTF_8.name(), (Object)new Hex(Charsets.UTF_8).getCharsetName());
    }

    @Test
    public void testRequiredCharset() throws UnsupportedEncodingException, DecoderException {
        this.testCustomCharset("UTF-8", "testRequiredCharset");
        this.testCustomCharset("UTF-16", "testRequiredCharset");
        this.testCustomCharset("UTF-16BE", "testRequiredCharset");
        this.testCustomCharset("UTF-16LE", "testRequiredCharset");
        this.testCustomCharset("US-ASCII", "testRequiredCharset");
        this.testCustomCharset("ISO8859_1", "testRequiredCharset");
    }
}

