/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoderAbstractTest;
import org.apache.commons.codec.language.DaitchMokotoffSoundex;
import org.junit.Assert;
import org.junit.Test;

public class DaitchMokotoffSoundexTest
extends StringEncoderAbstractTest<DaitchMokotoffSoundex> {
    @Override
    protected DaitchMokotoffSoundex createStringEncoder() {
        return new DaitchMokotoffSoundex();
    }

    private String soundex(String source) {
        return ((DaitchMokotoffSoundex)this.getStringEncoder()).soundex(source);
    }

    private String encode(String source) {
        return ((DaitchMokotoffSoundex)this.getStringEncoder()).encode(source);
    }

    @Test
    public void testAccentedCharacterFolding() {
        Assert.assertEquals((Object)"294795", (Object)this.soundex("Stra\u00dfburg"));
        Assert.assertEquals((Object)"294795", (Object)this.soundex("Strasburg"));
        Assert.assertEquals((Object)"095600", (Object)this.soundex("\u00c9regon"));
        Assert.assertEquals((Object)"095600", (Object)this.soundex("Eregon"));
    }

    @Test
    public void testAdjacentCodes() {
        Assert.assertEquals((Object)"054800", (Object)this.soundex("AKSSOL"));
        Assert.assertEquals((Object)"547830|545783|594783|594578", (Object)this.soundex("GERSCHFELD"));
    }

    public void testEncodeBasic() {
        Assert.assertEquals((Object)"097400", (Object)this.encode("AUERBACH"));
        Assert.assertEquals((Object)"097400", (Object)this.encode("OHRBACH"));
        Assert.assertEquals((Object)"874400", (Object)this.encode("LIPSHITZ"));
        Assert.assertEquals((Object)"874400", (Object)this.encode("LIPPSZYC"));
        Assert.assertEquals((Object)"876450", (Object)this.encode("LEWINSKY"));
        Assert.assertEquals((Object)"876450", (Object)this.encode("LEVINSKI"));
        Assert.assertEquals((Object)"486740", (Object)this.encode("SZLAMAWICZ"));
        Assert.assertEquals((Object)"486740", (Object)this.encode("SHLAMOVITZ"));
    }

    @Test
    public void testEncodeIgnoreApostrophes() throws EncoderException {
        this.checkEncodingVariations("079600", new String[]{"OBrien", "'OBrien", "O'Brien", "OB'rien", "OBr'ien", "OBri'en", "OBrie'n", "OBrien'"});
    }

    @Test
    public void testEncodeIgnoreHyphens() throws EncoderException {
        this.checkEncodingVariations("565463", new String[]{"KINGSMITH", "-KINGSMITH", "K-INGSMITH", "KI-NGSMITH", "KIN-GSMITH", "KING-SMITH", "KINGS-MITH", "KINGSM-ITH", "KINGSMI-TH", "KINGSMIT-H", "KINGSMITH-"});
    }

    @Test
    public void testEncodeIgnoreTrimmable() {
        Assert.assertEquals((Object)"746536", (Object)this.encode(" \t\n\r Washington \t\n\r "));
        Assert.assertEquals((Object)"746536", (Object)this.encode("Washington"));
    }

    @Test
    public void testSoundexBasic() {
        Assert.assertEquals((Object)"583600", (Object)this.soundex("GOLDEN"));
        Assert.assertEquals((Object)"087930", (Object)this.soundex("Alpert"));
        Assert.assertEquals((Object)"791900", (Object)this.soundex("Breuer"));
        Assert.assertEquals((Object)"579000", (Object)this.soundex("Haber"));
        Assert.assertEquals((Object)"665600", (Object)this.soundex("Mannheim"));
        Assert.assertEquals((Object)"664000", (Object)this.soundex("Mintz"));
        Assert.assertEquals((Object)"370000", (Object)this.soundex("Topf"));
        Assert.assertEquals((Object)"586660", (Object)this.soundex("Kleinmann"));
        Assert.assertEquals((Object)"769600", (Object)this.soundex("Ben Aron"));
        Assert.assertEquals((Object)"097400|097500", (Object)this.soundex("AUERBACH"));
        Assert.assertEquals((Object)"097400|097500", (Object)this.soundex("OHRBACH"));
        Assert.assertEquals((Object)"874400", (Object)this.soundex("LIPSHITZ"));
        Assert.assertEquals((Object)"874400|874500", (Object)this.soundex("LIPPSZYC"));
        Assert.assertEquals((Object)"876450", (Object)this.soundex("LEWINSKY"));
        Assert.assertEquals((Object)"876450", (Object)this.soundex("LEVINSKI"));
        Assert.assertEquals((Object)"486740", (Object)this.soundex("SZLAMAWICZ"));
        Assert.assertEquals((Object)"486740", (Object)this.soundex("SHLAMOVITZ"));
    }

    @Test
    public void testSoundexBasic2() {
        Assert.assertEquals((Object)"467000|567000", (Object)this.soundex("Ceniow"));
        Assert.assertEquals((Object)"467000", (Object)this.soundex("Tsenyuv"));
        Assert.assertEquals((Object)"587400|587500", (Object)this.soundex("Holubica"));
        Assert.assertEquals((Object)"587400", (Object)this.soundex("Golubitsa"));
        Assert.assertEquals((Object)"746480|794648", (Object)this.soundex("Przemysl"));
        Assert.assertEquals((Object)"746480", (Object)this.soundex("Pshemeshil"));
        Assert.assertEquals((Object)"944744|944745|944754|944755|945744|945745|945754|945755", (Object)this.soundex("Rosochowaciec"));
        Assert.assertEquals((Object)"945744", (Object)this.soundex("Rosokhovatsets"));
    }

    @Test
    public void testSoundexBasic3() {
        Assert.assertEquals((Object)"734000|739400", (Object)this.soundex("Peters"));
        Assert.assertEquals((Object)"734600|739460", (Object)this.soundex("Peterson"));
        Assert.assertEquals((Object)"645740", (Object)this.soundex("Moskowitz"));
        Assert.assertEquals((Object)"645740", (Object)this.soundex("Moskovitz"));
        Assert.assertEquals((Object)"154600|145460|454600|445460", (Object)this.soundex("Jackson"));
        Assert.assertEquals((Object)"154654|154645|154644|145465|145464|454654|454645|454644|445465|445464", (Object)this.soundex("Jackson-Jackson"));
    }

    @Test
    public void testSpecialRomanianCharacters() {
        Assert.assertEquals((Object)"364000|464000", (Object)this.soundex("\u0163amas"));
        Assert.assertEquals((Object)"364000|464000", (Object)this.soundex("\u021bamas"));
    }
}

