/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.digest.Md5Crypt;
import org.junit.Assert;
import org.junit.Test;

public class Apr1CryptTest {
    @Test
    public void testApr1CryptStrings() {
        Assert.assertEquals((Object)"$apr1$TqI9WECO$LHZB2DqRlk9nObiB6vJG9.", (Object)Md5Crypt.apr1Crypt((String)"secret", (String)"$apr1$TqI9WECO"));
        Assert.assertEquals((Object)"$apr1$foo$P27KyD1htb4EllIPEYhqi0", (Object)Md5Crypt.apr1Crypt((String)"", (String)"$apr1$foo"));
        Assert.assertEquals((Object)"$apr1$1234$mAlH7FRST6FiRZ.kcYL.j1", (Object)Md5Crypt.apr1Crypt((String)"secret", (String)"$apr1$1234"));
        Assert.assertEquals((Object)"$apr1$1234$mAlH7FRST6FiRZ.kcYL.j1", (Object)Md5Crypt.apr1Crypt((String)"secret", (String)"$apr1$1234$567"));
        Assert.assertEquals((Object)"$apr1$1234$mAlH7FRST6FiRZ.kcYL.j1", (Object)Md5Crypt.apr1Crypt((String)"secret", (String)"$apr1$1234$567$890"));
        Assert.assertEquals((Object)"$apr1$12345678$0lqb/6VUFP8JY/s/jTrIk0", (Object)Md5Crypt.apr1Crypt((String)"secret", (String)"$apr1$1234567890123456"));
        Assert.assertEquals((Object)"$apr1$12345678$0lqb/6VUFP8JY/s/jTrIk0", (Object)Md5Crypt.apr1Crypt((String)"secret", (String)"$apr1$123456789012345678"));
    }

    @Test
    public void testApr1CryptBytes() {
        byte[] keyBytes = new byte[]{33, 98, 99, 46};
        String hash = Md5Crypt.apr1Crypt((byte[])keyBytes);
        Assert.assertEquals((Object)hash, (Object)Md5Crypt.apr1Crypt((String)"!bc.", (String)hash));
        Assert.assertEquals((Object)"$apr1$foo$P27KyD1htb4EllIPEYhqi0", (Object)Md5Crypt.apr1Crypt((byte[])new byte[0], (String)"$apr1$foo"));
        Assert.assertEquals((Object)"$apr1$./$EeFrYzWWbmTyGdf4xULYc.", (Object)Md5Crypt.apr1Crypt((String)"t\u00e4st", (String)"$apr1$./$"));
        Assert.assertEquals((Object)"$apr1$./$kCwT1pY9qXAJElYG9q1QE1", (Object)Md5Crypt.apr1Crypt((byte[])"t\u00e4st".getBytes(Charsets.ISO_8859_1), (String)"$apr1$./$"));
    }

    @Test
    public void testApr1CryptBytesWithThreadLocalRandom() {
        byte[] keyBytes = new byte[]{33, 98, 99, 46};
        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
        String hash = Md5Crypt.apr1Crypt((byte[])keyBytes, (Random)threadLocalRandom);
        Assert.assertEquals((Object)hash, (Object)Md5Crypt.apr1Crypt((String)"!bc.", (String)hash));
        Assert.assertEquals((Object)"$apr1$foo$P27KyD1htb4EllIPEYhqi0", (Object)Md5Crypt.apr1Crypt((byte[])new byte[0], (String)"$apr1$foo"));
        Assert.assertEquals((Object)"$apr1$./$EeFrYzWWbmTyGdf4xULYc.", (Object)Md5Crypt.apr1Crypt((String)"t\u00e4st", (String)"$apr1$./$"));
        Assert.assertEquals((Object)"$apr1$./$kCwT1pY9qXAJElYG9q1QE1", (Object)Md5Crypt.apr1Crypt((byte[])"t\u00e4st".getBytes(Charsets.ISO_8859_1), (String)"$apr1$./$"));
    }

    @Test
    public void testApr1CryptExplicitCall() {
        Assert.assertEquals((Object)"$apr1$1234$mAlH7FRST6FiRZ.kcYL.j1", (Object)Md5Crypt.apr1Crypt((String)"secret", (String)"1234"));
        Assert.assertTrue((boolean)Md5Crypt.apr1Crypt((byte[])"secret".getBytes()).matches("^\\$apr1\\$[a-zA-Z0-9./]{0,8}\\$.{1,}$"));
        Assert.assertTrue((boolean)Md5Crypt.apr1Crypt((byte[])"secret".getBytes(), (String)null).matches("^\\$apr1\\$[a-zA-Z0-9./]{0,8}\\$.{1,}$"));
    }

    @Test
    public void testApr1LongSalt() {
        Assert.assertEquals((Object)"$apr1$12345678$0lqb/6VUFP8JY/s/jTrIk0", (Object)Md5Crypt.apr1Crypt((String)"secret", (String)"12345678901234567890"));
    }

    @Test(expected=NullPointerException.class)
    public void testApr1CryptNullData() {
        Md5Crypt.apr1Crypt((byte[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testApr1CryptWithEmptySalt() {
        Md5Crypt.apr1Crypt((byte[])"secret".getBytes(), (String)"");
    }

    @Test
    public void testApr1CryptWithoutSalt() {
        String hash = Md5Crypt.apr1Crypt((String)"secret");
        Assert.assertTrue((boolean)hash.matches("^\\$apr1\\$[a-zA-Z0-9\\./]{8}\\$[a-zA-Z0-9\\./]{22}$"));
        String hash2 = Md5Crypt.apr1Crypt((String)"secret");
        Assert.assertNotSame((Object)hash, (Object)hash2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testApr1CryptWithInvalidSalt() {
        Md5Crypt.apr1Crypt((byte[])new byte[0], (String)"!");
    }
}

