/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import org.apache.commons.codec.binary.BaseNCodec;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class BaseNCodecTest {
    BaseNCodec codec;

    @Before
    public void setUp() {
        this.codec = new BaseNCodec(0, 0, 0, 0){

            protected boolean isInAlphabet(byte b) {
                return b == 79 || b == 75;
            }

            void encode(byte[] pArray, int i, int length, BaseNCodec.Context context) {
            }

            void decode(byte[] pArray, int i, int length, BaseNCodec.Context context) {
            }
        };
    }

    @Test
    public void testBaseNCodec() {
        Assert.assertNotNull((Object)this.codec);
    }

    @Test
    public void testIsWhiteSpace() {
        Assert.assertTrue((boolean)BaseNCodec.isWhiteSpace((byte)32));
        Assert.assertTrue((boolean)BaseNCodec.isWhiteSpace((byte)10));
        Assert.assertTrue((boolean)BaseNCodec.isWhiteSpace((byte)13));
        Assert.assertTrue((boolean)BaseNCodec.isWhiteSpace((byte)9));
    }

    @Test
    public void testIsInAlphabetByte() {
        Assert.assertFalse((boolean)this.codec.isInAlphabet((byte)0));
        Assert.assertFalse((boolean)this.codec.isInAlphabet((byte)97));
        Assert.assertTrue((boolean)this.codec.isInAlphabet((byte)79));
        Assert.assertTrue((boolean)this.codec.isInAlphabet((byte)75));
    }

    @Test
    public void testIsInAlphabetByteArrayBoolean() {
        Assert.assertTrue((boolean)this.codec.isInAlphabet(new byte[0], false));
        Assert.assertTrue((boolean)this.codec.isInAlphabet(new byte[]{79}, false));
        Assert.assertFalse((boolean)this.codec.isInAlphabet(new byte[]{79, 32}, false));
        Assert.assertFalse((boolean)this.codec.isInAlphabet(new byte[]{32}, false));
        Assert.assertTrue((boolean)this.codec.isInAlphabet(new byte[0], true));
        Assert.assertTrue((boolean)this.codec.isInAlphabet(new byte[]{79}, true));
        Assert.assertTrue((boolean)this.codec.isInAlphabet(new byte[]{79, 32}, true));
        Assert.assertTrue((boolean)this.codec.isInAlphabet(new byte[]{32}, true));
    }

    @Test
    public void testIsInAlphabetString() {
        Assert.assertTrue((boolean)this.codec.isInAlphabet("OK"));
        Assert.assertTrue((boolean)this.codec.isInAlphabet("O=K= \t\n\r"));
    }

    @Test
    public void testContainsAlphabetOrPad() {
        Assert.assertFalse((boolean)this.codec.containsAlphabetOrPad(null));
        Assert.assertFalse((boolean)this.codec.containsAlphabetOrPad(new byte[0]));
        Assert.assertTrue((boolean)this.codec.containsAlphabetOrPad("OK".getBytes()));
        Assert.assertTrue((boolean)this.codec.containsAlphabetOrPad("OK ".getBytes()));
        Assert.assertFalse((boolean)this.codec.containsAlphabetOrPad("ok ".getBytes()));
        Assert.assertTrue((boolean)this.codec.containsAlphabetOrPad(new byte[]{this.codec.pad}));
    }

    @Test
    public void testProvidePaddingByte() {
        this.codec = new BaseNCodec(0, 0, 0, 0, 37){

            protected boolean isInAlphabet(byte b) {
                return b == 79 || b == 75;
            }

            void encode(byte[] pArray, int i, int length, BaseNCodec.Context context) {
            }

            void decode(byte[] pArray, int i, int length, BaseNCodec.Context context) {
            }
        };
        byte actualPaddingByte = this.codec.pad;
        Assert.assertEquals((long)37L, (long)actualPaddingByte);
    }

    @Test
    public void testEnsureBufferSize() {
        int length;
        NoOpBaseNCodec ncodec = new NoOpBaseNCodec();
        BaseNCodec.Context context = new BaseNCodec.Context();
        Assert.assertNull((String)"Initial buffer should be null", (Object)context.buffer);
        context.pos = 76979;
        context.readPos = 273;
        ncodec.ensureBufferSize(0, context);
        Assert.assertNotNull((String)"buffer should be initialised", (Object)context.buffer);
        Assert.assertEquals((String)"buffer should be initialised to default size", (long)ncodec.getDefaultBufferSize(), (long)context.buffer.length);
        Assert.assertEquals((String)"context position", (long)0L, (long)context.pos);
        Assert.assertEquals((String)"context read position", (long)0L, (long)context.readPos);
        ncodec.ensureBufferSize(1, context);
        Assert.assertEquals((String)"buffer should not expand unless required", (long)ncodec.getDefaultBufferSize(), (long)context.buffer.length);
        context.pos = length = context.buffer.length;
        int extra = 1;
        ncodec.ensureBufferSize(extra, context);
        Assert.assertTrue((String)"buffer should expand", (context.buffer.length >= length + extra ? 1 : 0) != 0);
        context.pos = length = context.buffer.length;
        extra = length * 10;
        ncodec.ensureBufferSize(extra, context);
        Assert.assertTrue((String)"buffer should expand beyond double capacity", (context.buffer.length >= length + extra ? 1 : 0) != 0);
    }

    @Test
    public void testEnsureBufferSizeExpandsToMaxBufferSize() {
        BaseNCodecTest.assertEnsureBufferSizeExpandsToMaxBufferSize(false);
    }

    @Test
    public void testEnsureBufferSizeExpandsToBeyondMaxBufferSize() {
        BaseNCodecTest.assertEnsureBufferSizeExpandsToMaxBufferSize(true);
    }

    private static void assertEnsureBufferSizeExpandsToMaxBufferSize(boolean exceedMaxBufferSize) {
        boolean length = false;
        long presumableFreeMemory = BaseNCodecTest.getPresumableFreeMemory();
        long estimatedMemory = 0x80008000L;
        Assume.assumeTrue((String)"Not enough free memory for the test", (presumableFreeMemory > 0x80008000L ? 1 : 0) != 0);
        int max = 0x7FFFFFF7;
        if (exceedMaxBufferSize) {
            BaseNCodecTest.assumeCanAllocateBufferSize(0x7FFFFFF8);
            System.gc();
        }
        NoOpBaseNCodec ncodec = new NoOpBaseNCodec();
        BaseNCodec.Context context = new BaseNCodec.Context();
        context.buffer = new byte[0];
        context.pos = 0;
        int extra = 0x7FFFFFF7;
        if (exceedMaxBufferSize) {
            ++extra;
        }
        ncodec.ensureBufferSize(extra, context);
        Assert.assertTrue((context.buffer.length >= 0 + extra ? 1 : 0) != 0);
    }

    private static void assumeCanAllocateBufferSize(int size) {
        byte[] bytes = null;
        try {
            bytes = new byte[size];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        Assume.assumeTrue((String)("Cannot allocate array of size: " + size), (bytes != null ? 1 : 0) != 0);
    }

    static long getPresumableFreeMemory() {
        System.gc();
        long allocatedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        return Runtime.getRuntime().maxMemory() - allocatedMemory;
    }

    @Test(expected=OutOfMemoryError.class)
    public void testEnsureBufferSizeThrowsOnOverflow() {
        NoOpBaseNCodec ncodec = new NoOpBaseNCodec();
        BaseNCodec.Context context = new BaseNCodec.Context();
        int length = 10;
        context.buffer = new byte[10];
        context.pos = 10;
        int extra = Integer.MAX_VALUE;
        ncodec.ensureBufferSize(Integer.MAX_VALUE, context);
    }

    private static class NoOpBaseNCodec
    extends BaseNCodec {
        NoOpBaseNCodec() {
            super(0, 0, 0, 0);
        }

        void encode(byte[] pArray, int i, int length, BaseNCodec.Context context) {
        }

        void decode(byte[] pArray, int i, int length, BaseNCodec.Context context) {
        }

        protected boolean isInAlphabet(byte value) {
            return false;
        }
    }
}

