/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.net;

import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.QuotedPrintableCodec;
import org.junit.Assert;
import org.junit.Test;

public class QuotedPrintableCodecTest {
    static final int[] SWISS_GERMAN_STUFF_UNICODE = new int[]{71, 114, 252, 101, 122, 105, 95, 122, 228, 109, 228};
    static final int[] RUSSIAN_STUFF_UNICODE = new int[]{1042, 1089, 1077, 1084, 95, 1087, 1088, 1080, 1074, 1077, 1090};

    private String constructString(int[] unicodeChars) {
        StringBuilder buffer = new StringBuilder();
        if (unicodeChars != null) {
            for (int unicodeChar : unicodeChars) {
                buffer.append((char)unicodeChar);
            }
        }
        return buffer.toString();
    }

    @Test
    public void testUTF8RoundTrip() throws Exception {
        String ru_msg = this.constructString(RUSSIAN_STUFF_UNICODE);
        String ch_msg = this.constructString(SWISS_GERMAN_STUFF_UNICODE);
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec();
        Assert.assertEquals((Object)"=D0=92=D1=81=D0=B5=D0=BC_=D0=BF=D1=80=D0=B8=D0=B2=D0=B5=D1=82", (Object)qpcodec.encode(ru_msg, "UTF-8"));
        Assert.assertEquals((Object)"Gr=C3=BCezi_z=C3=A4m=C3=A4", (Object)qpcodec.encode(ch_msg, "UTF-8"));
        Assert.assertEquals((Object)ru_msg, (Object)qpcodec.decode(qpcodec.encode(ru_msg, "UTF-8"), "UTF-8"));
        Assert.assertEquals((Object)ch_msg, (Object)qpcodec.decode(qpcodec.encode(ch_msg, "UTF-8"), "UTF-8"));
    }

    @Test
    public void testBasicEncodeDecode() throws Exception {
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec();
        String plain = "= Hello there =\r\n";
        String encoded = qpcodec.encode("= Hello there =\r\n");
        Assert.assertEquals((String)"Basic quoted-printable encoding test", (Object)"=3D Hello there =3D=0D=0A", (Object)encoded);
        Assert.assertEquals((String)"Basic quoted-printable decoding test", (Object)"= Hello there =\r\n", (Object)qpcodec.decode(encoded));
    }

    @Test
    public void testSafeCharEncodeDecode() throws Exception {
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec();
        String plain = "abc123_-.*~!@#$%^&()+{}\"\\;:`,/[]";
        String encoded = qpcodec.encode("abc123_-.*~!@#$%^&()+{}\"\\;:`,/[]");
        Assert.assertEquals((String)"Safe chars quoted-printable encoding test", (Object)"abc123_-.*~!@#$%^&()+{}\"\\;:`,/[]", (Object)encoded);
        Assert.assertEquals((String)"Safe chars quoted-printable decoding test", (Object)"abc123_-.*~!@#$%^&()+{}\"\\;:`,/[]", (Object)qpcodec.decode(encoded));
    }

    @Test
    public void testUnsafeEncodeDecode() throws Exception {
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec();
        String plain = "=\r\n";
        String encoded = qpcodec.encode("=\r\n");
        Assert.assertEquals((String)"Unsafe chars quoted-printable encoding test", (Object)"=3D=0D=0A", (Object)encoded);
        Assert.assertEquals((String)"Unsafe chars quoted-printable decoding test", (Object)"=\r\n", (Object)qpcodec.decode(encoded));
    }

    @Test
    public void testEncodeDecodeNull() throws Exception {
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec();
        Assert.assertNull((String)"Null string quoted-printable encoding test", (Object)qpcodec.encode((String)null));
        Assert.assertNull((String)"Null string quoted-printable decoding test", (Object)qpcodec.decode((String)null));
    }

    @Test
    public void testDecodeInvalid() throws Exception {
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec();
        try {
            qpcodec.decode("=");
            Assert.fail((String)"DecoderException should have been thrown");
        }
        catch (DecoderException decoderException) {
            // empty catch block
        }
        try {
            qpcodec.decode("=A");
            Assert.fail((String)"DecoderException should have been thrown");
        }
        catch (DecoderException decoderException) {
            // empty catch block
        }
        try {
            qpcodec.decode("=WW");
            Assert.fail((String)"DecoderException should have been thrown");
        }
        catch (DecoderException decoderException) {
            // empty catch block
        }
    }

    @Test
    public void testEncodeNull() throws Exception {
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec();
        byte[] plain = null;
        byte[] encoded = qpcodec.encode(plain);
        Assert.assertEquals((String)"Encoding a null string should return null", null, (Object)encoded);
    }

    @Test
    public void testEncodeUrlWithNullBitSet() throws Exception {
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec();
        String plain = "1+1 = 2";
        String encoded = new String(QuotedPrintableCodec.encodeQuotedPrintable(null, (byte[])"1+1 = 2".getBytes(StandardCharsets.UTF_8)));
        Assert.assertEquals((String)"Basic quoted-printable encoding test", (Object)"1+1 =3D 2", (Object)encoded);
        Assert.assertEquals((String)"Basic quoted-printable decoding test", (Object)"1+1 = 2", (Object)qpcodec.decode(encoded));
    }

    @Test
    public void testDecodeWithNullArray() throws Exception {
        byte[] plain = null;
        byte[] result = QuotedPrintableCodec.decodeQuotedPrintable(plain);
        Assert.assertEquals((String)"Result should be null", null, (Object)result);
    }

    @Test
    public void testEncodeStringWithNull() throws Exception {
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec();
        String test = null;
        String result = qpcodec.encode(test, "charset");
        Assert.assertEquals((String)"Result should be null", null, (Object)result);
    }

    @Test
    public void testDecodeStringWithNull() throws Exception {
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec();
        String test = null;
        String result = qpcodec.decode(test, "charset");
        Assert.assertEquals((String)"Result should be null", null, (Object)result);
    }

    @Test
    public void testEncodeObjects() throws Exception {
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec();
        String plain = "1+1 = 2";
        String encoded = (String)qpcodec.encode((Object)"1+1 = 2");
        Assert.assertEquals((String)"Basic quoted-printable encoding test", (Object)"1+1 =3D 2", (Object)encoded);
        byte[] plainBA = "1+1 = 2".getBytes(StandardCharsets.UTF_8);
        byte[] encodedBA = (byte[])qpcodec.encode((Object)plainBA);
        encoded = new String(encodedBA);
        Assert.assertEquals((String)"Basic quoted-printable encoding test", (Object)"1+1 =3D 2", (Object)encoded);
        Object result = qpcodec.encode(null);
        Assert.assertEquals((String)"Encoding a null Object should return null", null, (Object)result);
        try {
            Double dObj = 3.0;
            qpcodec.encode((Object)dObj);
            Assert.fail((String)"Trying to url encode a Double object should cause an exception.");
        }
        catch (EncoderException encoderException) {
            // empty catch block
        }
    }

    @Test(expected=UnsupportedCharsetException.class)
    public void testInvalidEncoding() {
        new QuotedPrintableCodec("NONSENSE");
    }

    @Test
    public void testDecodeObjects() throws Exception {
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec();
        String plain = "1+1 =3D 2";
        String decoded = (String)qpcodec.decode((Object)"1+1 =3D 2");
        Assert.assertEquals((String)"Basic quoted-printable decoding test", (Object)"1+1 = 2", (Object)decoded);
        byte[] plainBA = "1+1 =3D 2".getBytes(StandardCharsets.UTF_8);
        byte[] decodedBA = (byte[])qpcodec.decode((Object)plainBA);
        decoded = new String(decodedBA);
        Assert.assertEquals((String)"Basic quoted-printable decoding test", (Object)"1+1 = 2", (Object)decoded);
        Object result = qpcodec.decode(null);
        Assert.assertEquals((String)"Decoding a null Object should return null", null, (Object)result);
        try {
            Double dObj = 3.0;
            qpcodec.decode((Object)dObj);
            Assert.fail((String)"Trying to url encode a Double object should cause an exception.");
        }
        catch (DecoderException decoderException) {
            // empty catch block
        }
    }

    @Test
    public void testDefaultEncoding() throws Exception {
        String plain = "Hello there!";
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec("UnicodeBig");
        qpcodec.encode("Hello there!");
        String encoded1 = qpcodec.encode("Hello there!", "UnicodeBig");
        String encoded2 = qpcodec.encode("Hello there!");
        Assert.assertEquals((Object)encoded1, (Object)encoded2);
    }

    @Test
    public void testSoftLineBreakDecode() throws Exception {
        String qpdata = "If you believe that truth=3Dbeauty, then surely=20=\r\nmathematics is the most beautiful branch of philosophy.";
        String expected = "If you believe that truth=beauty, then surely mathematics is the most beautiful branch of philosophy.";
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec();
        Assert.assertEquals((Object)"If you believe that truth=beauty, then surely mathematics is the most beautiful branch of philosophy.", (Object)qpcodec.decode("If you believe that truth=3Dbeauty, then surely=20=\r\nmathematics is the most beautiful branch of philosophy."));
        String encoded = qpcodec.encode("If you believe that truth=beauty, then surely mathematics is the most beautiful branch of philosophy.");
        Assert.assertEquals((Object)"If you believe that truth=beauty, then surely mathematics is the most beautiful branch of philosophy.", (Object)qpcodec.decode(encoded));
    }

    @Test
    public void testSoftLineBreakEncode() throws Exception {
        String qpdata = "If you believe that truth=3Dbeauty, then surely mathematics is the most b=\r\neautiful branch of philosophy.";
        String expected = "If you believe that truth=beauty, then surely mathematics is the most beautiful branch of philosophy.";
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec(true);
        Assert.assertEquals((Object)"If you believe that truth=3Dbeauty, then surely mathematics is the most b=\r\neautiful branch of philosophy.", (Object)qpcodec.encode("If you believe that truth=beauty, then surely mathematics is the most beautiful branch of philosophy."));
        String decoded = qpcodec.decode("If you believe that truth=3Dbeauty, then surely mathematics is the most b=\r\neautiful branch of philosophy.");
        Assert.assertEquals((Object)"If you believe that truth=3Dbeauty, then surely mathematics is the most b=\r\neautiful branch of philosophy.", (Object)qpcodec.encode(decoded));
    }

    @Test
    public void testSkipNotEncodedCRLF() throws Exception {
        String qpdata = "CRLF in an\n encoded text should be=20=\r\n\rskipped in the\r decoding.";
        String expected = "CRLF in an encoded text should be skipped in the decoding.";
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec(true);
        Assert.assertEquals((Object)"CRLF in an encoded text should be skipped in the decoding.", (Object)qpcodec.decode("CRLF in an\n encoded text should be=20=\r\n\rskipped in the\r decoding."));
        String encoded = qpcodec.encode("CRLF in an encoded text should be skipped in the decoding.");
        Assert.assertEquals((Object)"CRLF in an encoded text should be skipped in the decoding.", (Object)qpcodec.decode(encoded));
    }

    @Test
    public void testTrailingSpecial() throws Exception {
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec(true);
        String plain = "This is a example of a quoted-printable text file. This might contain sp=cial chars.";
        String expected = "This is a example of a quoted-printable text file. This might contain sp=3D=\r\ncial chars.";
        Assert.assertEquals((Object)expected, (Object)qpcodec.encode(plain));
        plain = "This is a example of a quoted-printable text file. This might contain ta\tbs as well.";
        expected = "This is a example of a quoted-printable text file. This might contain ta=09=\r\nbs as well.";
        Assert.assertEquals((Object)expected, (Object)qpcodec.encode(plain));
    }

    @Test
    public void testUltimateSoftBreak() throws Exception {
        QuotedPrintableCodec qpcodec = new QuotedPrintableCodec(true);
        String plain = "This is a example of a quoted-printable text file. There is no end to it\t";
        String expected = "This is a example of a quoted-printable text file. There is no end to i=\r\nt=09";
        Assert.assertEquals((Object)expected, (Object)qpcodec.encode(plain));
        plain = "This is a example of a quoted-printable text file. There is no end to it ";
        expected = "This is a example of a quoted-printable text file. There is no end to i=\r\nt=20";
        Assert.assertEquals((Object)expected, (Object)qpcodec.encode(plain));
        plain = "This is a example of a quoted-printable text file. There is no end to   ";
        expected = "This is a example of a quoted-printable text file. There is no end to=20=\r\n =20";
        Assert.assertEquals((Object)expected, (Object)qpcodec.encode(plain));
        plain = "This is a example of a quoted-printable text file. There is no end to=  ";
        expected = "This is a example of a quoted-printable text file. There is no end to=3D=\r\n =20";
        Assert.assertEquals((Object)expected, (Object)qpcodec.encode(plain));
    }

    @Test
    public void testFinalBytes() throws Exception {
        String plain = "This is a example of a quoted=printable text file. There is no tt";
        String expected = "This is a example of a quoted=3Dprintable text file. There is no tt";
        Assert.assertEquals((Object)"This is a example of a quoted=3Dprintable text file. There is no tt", (Object)new QuotedPrintableCodec(true).encode("This is a example of a quoted=printable text file. There is no tt"));
    }
}

