/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Base32TestData;
import org.apache.commons.codec.binary.BaseNCodec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;

public class Base32Test {
    private static final Charset CHARSET_UTF8 = StandardCharsets.UTF_8;
    private static final String[][] BASE32_TEST_CASES = new String[][]{{"", ""}, {"f", "MY======"}, {"fo", "MZXQ===="}, {"foo", "MZXW6==="}, {"foob", "MZXW6YQ="}, {"fooba", "MZXW6YTB"}, {"foobar", "MZXW6YTBOI======"}};
    private static final String[] BASE32_IMPOSSIBLE_CASES = new String[]{"MC======", "MZXE====", "MZXWB===", "MZXW6YB=", "MZXW6YTBOC======", "AB======"};
    private static final String[] BASE32_IMPOSSIBLE_CASES_CHUNKED = new String[]{"M2======\r\n", "MZX0====\r\n", "MZXW0===\r\n", "MZXW6Y2=\r\n", "MZXW6YTBO2======\r\n"};
    private static final String[] BASE32HEX_IMPOSSIBLE_CASES = new String[]{"C2======", "CPN4====", "CPNM1===", "CPNMUO1=", "CPNMUOJ1E2======"};
    private static final byte[] ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 50, 51, 52, 53, 54, 55};
    private static final Object[][] BASE32_BINARY_TEST_CASES;
    private static final String[][] BASE32HEX_TEST_CASES;
    private static final String[][] BASE32_TEST_CASES_CHUNKED;
    private static final String[][] BASE32_PAD_TEST_CASES;

    @Test
    public void testBase64AtBufferStart() {
        this.testBase64InBuffer(0, 100);
    }

    @Test
    public void testBase64AtBufferEnd() {
        this.testBase64InBuffer(100, 0);
    }

    @Test
    public void testBase64AtBufferMiddle() {
        this.testBase64InBuffer(100, 100);
    }

    private void testBase64InBuffer(int startPasSize, int endPadSize) {
        Base32 codec = new Base32();
        for (String[] element : BASE32_TEST_CASES) {
            byte[] bytes = element[0].getBytes(CHARSET_UTF8);
            byte[] buffer = ArrayUtils.addAll((byte[])bytes, (byte[])new byte[endPadSize]);
            buffer = ArrayUtils.addAll((byte[])new byte[startPasSize], (byte[])buffer);
            Assert.assertEquals((Object)element[1], (Object)StringUtils.newStringUtf8((byte[])codec.encode(buffer, startPasSize, bytes.length)));
        }
    }

    @Test
    public void testBase32Chunked() throws Exception {
        Base32 codec = new Base32(20);
        for (String[] element : BASE32_TEST_CASES_CHUNKED) {
            Assert.assertEquals((Object)element[1], (Object)codec.encodeAsString(element[0].getBytes(CHARSET_UTF8)));
        }
    }

    @Test
    public void testBase32HexSamples() throws Exception {
        Base32 codec = new Base32(true);
        for (String[] element : BASE32HEX_TEST_CASES) {
            Assert.assertEquals((Object)element[1], (Object)codec.encodeAsString(element[0].getBytes(CHARSET_UTF8)));
        }
    }

    @Test
    public void testBase32HexSamplesReverse() throws Exception {
        Base32 codec = new Base32(true);
        for (String[] element : BASE32HEX_TEST_CASES) {
            Assert.assertEquals((Object)element[0], (Object)new String(codec.decode(element[1]), CHARSET_UTF8));
        }
    }

    @Test
    public void testBase32HexSamplesReverseLowercase() throws Exception {
        Base32 codec = new Base32(true);
        for (String[] element : BASE32HEX_TEST_CASES) {
            Assert.assertEquals((Object)element[0], (Object)new String(codec.decode(element[1].toLowerCase()), CHARSET_UTF8));
        }
    }

    @Test
    public void testBase32Samples() throws Exception {
        Base32 codec = new Base32();
        for (String[] element : BASE32_TEST_CASES) {
            Assert.assertEquals((Object)element[1], (Object)codec.encodeAsString(element[0].getBytes(CHARSET_UTF8)));
        }
    }

    @Test
    public void testBase32BinarySamples() throws Exception {
        Base32 codec = new Base32();
        for (Object[] element : BASE32_BINARY_TEST_CASES) {
            String expected = element.length > 2 ? (String)element[2] : (String)element[1];
            Assert.assertEquals((Object)expected.toUpperCase(), (Object)codec.encodeAsString((byte[])element[0]));
        }
    }

    @Test
    public void testBase32BinarySamplesReverse() throws Exception {
        Base32 codec = new Base32();
        for (Object[] element : BASE32_BINARY_TEST_CASES) {
            Assert.assertArrayEquals((byte[])((byte[])element[0]), (byte[])codec.decode((String)element[1]));
        }
    }

    @Test
    public void testBase32SamplesNonDefaultPadding() throws Exception {
        Base32 codec = new Base32(37);
        for (String[] element : BASE32_PAD_TEST_CASES) {
            Assert.assertEquals((Object)element[1], (Object)codec.encodeAsString(element[0].getBytes(CHARSET_UTF8)));
        }
    }

    @Test
    public void testCodec200() {
        Base32 codec = new Base32(true, 87);
        Assert.assertNotNull((Object)codec);
    }

    @Test
    public void testRandomBytes() {
        for (int i = 0; i < 20; ++i) {
            Base32 codec = new Base32();
            byte[][] b = Base32TestData.randomData((BaseNCodec)codec, i);
            Assert.assertEquals((String)("" + i + " " + codec.lineLength), (long)b[1].length, (long)codec.getEncodedLength(b[0]));
        }
    }

    @Test
    public void testRandomBytesChunked() {
        for (int i = 0; i < 20; ++i) {
            Base32 codec = new Base32(10);
            byte[][] b = Base32TestData.randomData((BaseNCodec)codec, i);
            Assert.assertEquals((String)("" + i + " " + codec.lineLength), (long)b[1].length, (long)codec.getEncodedLength(b[0]));
        }
    }

    @Test
    public void testRandomBytesHex() {
        for (int i = 0; i < 20; ++i) {
            Base32 codec = new Base32(true);
            byte[][] b = Base32TestData.randomData((BaseNCodec)codec, i);
            Assert.assertEquals((String)("" + i + " " + codec.lineLength), (long)b[1].length, (long)codec.getEncodedLength(b[0]));
        }
    }

    @Test
    public void testSingleCharEncoding() {
        for (int i = 0; i < 20; ++i) {
            Base32 codec = new Base32();
            BaseNCodec.Context context = new BaseNCodec.Context();
            byte[] unencoded = new byte[i];
            byte[] allInOne = codec.encode(unencoded);
            codec = new Base32();
            for (int j = 0; j < unencoded.length; ++j) {
                codec.encode(unencoded, j, 1, context);
            }
            codec.encode(unencoded, 0, -1, context);
            byte[] singly = new byte[allInOne.length];
            codec.readResults(singly, 0, 100, context);
            if (Arrays.equals(allInOne, singly)) continue;
            Assert.fail();
        }
    }

    @Test
    public void testBase32ImpossibleSamples() {
        this.testImpossibleCases(new Base32(), BASE32_IMPOSSIBLE_CASES);
    }

    @Test
    public void testBase32ImpossibleChunked() {
        this.testImpossibleCases(new Base32(20), BASE32_IMPOSSIBLE_CASES_CHUNKED);
    }

    @Test
    public void testBase32HexImpossibleSamples() {
        this.testImpossibleCases(new Base32(true), BASE32HEX_IMPOSSIBLE_CASES);
    }

    private void testImpossibleCases(Base32 codec, String[] impossible_cases) {
        for (String impossible : impossible_cases) {
            try {
                codec.decode(impossible);
                Assert.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testBase32DecodingOfTrailing10Bits() {
        Base32Test.assertBase32DecodingOfTrailingBits(10);
    }

    @Test
    public void testBase32DecodingOfTrailing15Bits() {
        Base32Test.assertBase32DecodingOfTrailingBits(15);
    }

    @Test
    public void testBase32DecodingOfTrailing20Bits() {
        Base32Test.assertBase32DecodingOfTrailingBits(20);
    }

    @Test
    public void testBase32DecodingOfTrailing25Bits() {
        Base32Test.assertBase32DecodingOfTrailingBits(25);
    }

    @Test
    public void testBase32DecodingOfTrailing30Bits() {
        Base32Test.assertBase32DecodingOfTrailingBits(30);
    }

    @Test
    public void testBase32DecodingOfTrailing35Bits() {
        Base32Test.assertBase32DecodingOfTrailingBits(35);
    }

    private static void assertBase32DecodingOfTrailingBits(int nbits) {
        Base32 codec = new Base32();
        byte[] encoded = new byte[nbits / 5];
        Arrays.fill(encoded, ENCODE_TABLE[0]);
        int discard = nbits % 8;
        int emptyBitsMask = (1 << discard) - 1;
        int last = encoded.length - 1;
        for (int i = 0; i < 32; ++i) {
            encoded[last] = ENCODE_TABLE[i];
            if ((i & emptyBitsMask) != 0) {
                try {
                    codec.decode(encoded);
                    Assert.fail((String)"Final base-32 digit should not be allowed");
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                continue;
            }
            byte[] decoded = codec.decode(encoded);
            int bitsEncoded = i >> discard;
            Assert.assertEquals((String)"Invalid decoding of last character", (long)bitsEncoded, (long)decoded[decoded.length - 1]);
        }
    }

    static {
        Hex hex = new Hex();
        try {
            BASE32_BINARY_TEST_CASES = new Object[][]{{hex.decode((Object)"623a01735836e9a126e12fbf95e013ee6892997c"), "MI5AC42YG3U2CJXBF67ZLYAT5ZUJFGL4"}, {hex.decode((Object)"623a01735836e9a126e12fbf95e013ee6892997c"), "mi5ac42yg3u2cjxbf67zlyat5zujfgl4"}, {hex.decode((Object)"739ce42108"), "OOOOIIII"}};
        }
        catch (DecoderException de) {
            throw new Error(":(", de);
        }
        BASE32HEX_TEST_CASES = new String[][]{{"", ""}, {"f", "CO======"}, {"fo", "CPNG===="}, {"foo", "CPNMU==="}, {"foob", "CPNMUOG="}, {"fooba", "CPNMUOJ1"}, {"foobar", "CPNMUOJ1E8======"}};
        BASE32_TEST_CASES_CHUNKED = new String[][]{{"", ""}, {"f", "MY======\r\n"}, {"fo", "MZXQ====\r\n"}, {"foo", "MZXW6===\r\n"}, {"foob", "MZXW6YQ=\r\n"}, {"fooba", "MZXW6YTB\r\n"}, {"foobar", "MZXW6YTBOI======\r\n"}};
        BASE32_PAD_TEST_CASES = new String[][]{{"", ""}, {"f", "MY%%%%%%"}, {"fo", "MZXQ%%%%"}, {"foo", "MZXW6%%%"}, {"foob", "MZXW6YQ%"}, {"fooba", "MZXW6YTB"}, {"foobar", "MZXW6YTBOI%%%%%%"}};
    }
}

