/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language.bm;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.language.bm.Languages;
import org.apache.commons.codec.language.bm.NameType;
import org.apache.commons.codec.language.bm.PhoneticEngine;
import org.apache.commons.codec.language.bm.RuleType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PhoneticEngineRegressionTest {
    @Test
    public void testSolrGENERIC() {
        TreeMap<String, String> args = new TreeMap<String, String>();
        args.put("nameType", "GENERIC");
        Assertions.assertEquals((Object)"YngYlo|Yngilo|agilo|angYlo|angilo|aniilo|anilo|anxilo|anzilo|ogilo|ongYlo|ongilo|oniilo|onilo|onxilo|onzilo", (Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"));
        args.put("ruleType", "EXACT");
        Assertions.assertEquals((Object)"anZelo|andZelo|angelo|anhelo|anjelo|anxelo", (Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"));
        Assertions.assertEquals((Object)"(anZelo|andZelo|angelo|anhelo|anjelo|anxelo)-(danZelo|dandZelo|dangelo|danhelo|danjelo|danxelo)", (Object)PhoneticEngineRegressionTest.encode(args, true, "D'Angelo"));
        args.put("languageSet", "italian,greek,spanish");
        Assertions.assertEquals((Object)"andZelo|angelo|anxelo", (Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"));
        Assertions.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "1234"), (Object)"");
        args = new TreeMap();
        Assertions.assertEquals((Object)"YngYlo|Yngilo|agilo|angYlo|angilo|aniilo|anilo|anxilo|anzilo|ogilo|ongYlo|ongilo|oniilo|onilo|onxilo|onzilo", (Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"));
        args.put("ruleType", "EXACT");
        Assertions.assertEquals((Object)"anZelo|andZelo|angelo|anhelo|anjelo|anxelo", (Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"));
        Assertions.assertEquals((Object)"(anZelo|andZelo|angelo|anhelo|anjelo|anxelo)-(danZelo|dandZelo|dangelo|danhelo|danjelo|danxelo)", (Object)PhoneticEngineRegressionTest.encode(args, false, "D'Angelo"));
        args.put("languageSet", "italian,greek,spanish");
        Assertions.assertEquals((Object)"andZelo|angelo|anxelo", (Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"));
        Assertions.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "1234"), (Object)"");
        args = new TreeMap();
        Assertions.assertEquals((Object)"YngYlo|Yngilo|agilo|angYlo|angilo|aniilo|anilo|anxilo|anzilo|ogilo|ongYlo|ongilo|oniilo|onilo|onxilo|onzilo", (Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"));
        args.put("ruleType", "APPROX");
        Assertions.assertEquals((Object)"YngYlo|Yngilo|agilo|angYlo|angilo|aniilo|anilo|anxilo|anzilo|ogilo|ongYlo|ongilo|oniilo|onilo|onxilo|onzilo", (Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"));
        Assertions.assertEquals((Object)"(YngYlo|Yngilo|agilo|angYlo|angilo|aniilo|anilo|anxilo|anzilo|ogilo|ongYlo|ongilo|oniilo|onilo|onxilo|onzilo)-(dYngYlo|dYngilo|dagilo|dangYlo|dangilo|daniilo|danilo|danxilo|danzilo|dogilo|dongYlo|dongilo|doniilo|donilo|donxilo|donzilo)", (Object)PhoneticEngineRegressionTest.encode(args, true, "D'Angelo"));
        args.put("languageSet", "italian,greek,spanish");
        Assertions.assertEquals((Object)"angilo|anxilo|anzilo|ongilo|onxilo|onzilo", (Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"));
        Assertions.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "1234"), (Object)"");
        args = new TreeMap();
        Assertions.assertEquals((Object)"YngYlo|Yngilo|agilo|angYlo|angilo|aniilo|anilo|anxilo|anzilo|ogilo|ongYlo|ongilo|oniilo|onilo|onxilo|onzilo", (Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"));
        args.put("ruleType", "APPROX");
        Assertions.assertEquals((Object)"YngYlo|Yngilo|agilo|angYlo|angilo|aniilo|anilo|anxilo|anzilo|ogilo|ongYlo|ongilo|oniilo|onilo|onxilo|onzilo", (Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"));
        Assertions.assertEquals((Object)"(YngYlo|Yngilo|agilo|angYlo|angilo|aniilo|anilo|anxilo|anzilo|ogilo|ongYlo|ongilo|oniilo|onilo|onxilo|onzilo)-(dYngYlo|dYngilo|dagilo|dangYlo|dangilo|daniilo|danilo|danxilo|danzilo|dogilo|dongYlo|dongilo|doniilo|donilo|donxilo|donzilo)", (Object)PhoneticEngineRegressionTest.encode(args, false, "D'Angelo"));
        args.put("languageSet", "italian,greek,spanish");
        Assertions.assertEquals((Object)"angilo|anxilo|anzilo|ongilo|onxilo|onzilo", (Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"));
        Assertions.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "1234"), (Object)"");
    }

    @Test
    public void testSolrASHKENAZI() {
        TreeMap<String, String> args = new TreeMap<String, String>();
        args.put("nameType", "ASHKENAZI");
        Assertions.assertEquals((Object)"YngYlo|Yngilo|angYlo|angilo|anilo|anxilo|anzilo|ongYlo|ongilo|onilo|onxilo|onzilo", (Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"));
        args.put("ruleType", "EXACT");
        Assertions.assertEquals((Object)"andZelo|angelo|anhelo|anxelo", (Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"));
        Assertions.assertEquals((Object)"dandZelo|dangelo|danhelo|danxelo", (Object)PhoneticEngineRegressionTest.encode(args, true, "D'Angelo"));
        args.put("languageSet", "italian,greek,spanish");
        Assertions.assertEquals((Object)"angelo|anxelo", (Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"));
        Assertions.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "1234"), (Object)"");
        args = new TreeMap();
        args.put("nameType", "ASHKENAZI");
        Assertions.assertEquals((Object)"YngYlo|Yngilo|angYlo|angilo|anilo|anxilo|anzilo|ongYlo|ongilo|onilo|onxilo|onzilo", (Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"));
        args.put("ruleType", "EXACT");
        Assertions.assertEquals((Object)"andZelo|angelo|anhelo|anxelo", (Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"));
        Assertions.assertEquals((Object)"dandZelo|dangelo|danhelo|danxelo", (Object)PhoneticEngineRegressionTest.encode(args, false, "D'Angelo"));
        args.put("languageSet", "italian,greek,spanish");
        Assertions.assertEquals((Object)"angelo|anxelo", (Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"));
        Assertions.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "1234"), (Object)"");
        args = new TreeMap();
        args.put("nameType", "ASHKENAZI");
        Assertions.assertEquals((Object)"YngYlo|Yngilo|angYlo|angilo|anilo|anxilo|anzilo|ongYlo|ongilo|onilo|onxilo|onzilo", (Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"));
        args.put("ruleType", "APPROX");
        Assertions.assertEquals((Object)"YngYlo|Yngilo|angYlo|angilo|anilo|anxilo|anzilo|ongYlo|ongilo|onilo|onxilo|onzilo", (Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"));
        Assertions.assertEquals((Object)"dYngYlo|dYngilo|dangYlo|dangilo|danilo|danxilo|danzilo|dongYlo|dongilo|donilo|donxilo|donzilo", (Object)PhoneticEngineRegressionTest.encode(args, true, "D'Angelo"));
        args.put("languageSet", "italian,greek,spanish");
        Assertions.assertEquals((Object)"angilo|anxilo|ongilo|onxilo", (Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"));
        Assertions.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "1234"), (Object)"");
        args = new TreeMap();
        args.put("nameType", "ASHKENAZI");
        Assertions.assertEquals((Object)"YngYlo|Yngilo|angYlo|angilo|anilo|anxilo|anzilo|ongYlo|ongilo|onilo|onxilo|onzilo", (Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"));
        args.put("ruleType", "APPROX");
        Assertions.assertEquals((Object)"YngYlo|Yngilo|angYlo|angilo|anilo|anxilo|anzilo|ongYlo|ongilo|onilo|onxilo|onzilo", (Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"));
        Assertions.assertEquals((Object)"dYngYlo|dYngilo|dangYlo|dangilo|danilo|danxilo|danzilo|dongYlo|dongilo|donilo|donxilo|donzilo", (Object)PhoneticEngineRegressionTest.encode(args, false, "D'Angelo"));
        args.put("languageSet", "italian,greek,spanish");
        Assertions.assertEquals((Object)"angilo|anxilo|ongilo|onxilo", (Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"));
        Assertions.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "1234"), (Object)"");
    }

    @Test
    public void testSolrSEPHARDIC() {
        TreeMap<String, String> args = new TreeMap<String, String>();
        args.put("nameType", "SEPHARDIC");
        Assertions.assertEquals((Object)"anhila|anhilu|anzila|anzilu|nhila|nhilu|nzila|nzilu", (Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"));
        args.put("ruleType", "EXACT");
        Assertions.assertEquals((Object)"anZelo|andZelo|anxelo", (Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"));
        Assertions.assertEquals((Object)"anZelo|andZelo|anxelo", (Object)PhoneticEngineRegressionTest.encode(args, true, "D'Angelo"));
        args.put("languageSet", "italian,greek,spanish");
        Assertions.assertEquals((Object)"andZelo|anxelo", (Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"));
        Assertions.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "1234"), (Object)"");
        args = new TreeMap();
        args.put("nameType", "SEPHARDIC");
        Assertions.assertEquals((Object)"anhila|anhilu|anzila|anzilu|nhila|nhilu|nzila|nzilu", (Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"));
        args.put("ruleType", "EXACT");
        Assertions.assertEquals((Object)"anZelo|andZelo|anxelo", (Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"));
        Assertions.assertEquals((Object)"danZelo|dandZelo|danxelo", (Object)PhoneticEngineRegressionTest.encode(args, false, "D'Angelo"));
        args.put("languageSet", "italian,greek,spanish");
        Assertions.assertEquals((Object)"andZelo|anxelo", (Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"));
        Assertions.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "1234"), (Object)"");
        args = new TreeMap();
        args.put("nameType", "SEPHARDIC");
        Assertions.assertEquals((Object)"anhila|anhilu|anzila|anzilu|nhila|nhilu|nzila|nzilu", (Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"));
        args.put("ruleType", "APPROX");
        Assertions.assertEquals((Object)"anhila|anhilu|anzila|anzilu|nhila|nhilu|nzila|nzilu", (Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"));
        Assertions.assertEquals((Object)"anhila|anhilu|anzila|anzilu|nhila|nhilu|nzila|nzilu", (Object)PhoneticEngineRegressionTest.encode(args, true, "D'Angelo"));
        args.put("languageSet", "italian,greek,spanish");
        Assertions.assertEquals((Object)"anhila|anhilu|anzila|anzilu|nhila|nhilu|nzila|nzilu", (Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"));
        Assertions.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "1234"), (Object)"");
        args = new TreeMap();
        args.put("nameType", "SEPHARDIC");
        Assertions.assertEquals((Object)"anhila|anhilu|anzila|anzilu|nhila|nhilu|nzila|nzilu", (Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"));
        args.put("ruleType", "APPROX");
        Assertions.assertEquals((Object)"anhila|anhilu|anzila|anzilu|nhila|nhilu|nzila|nzilu", (Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"));
        Assertions.assertEquals((Object)"danhila|danhilu|danzila|danzilu|nhila|nhilu|nzila|nzilu", (Object)PhoneticEngineRegressionTest.encode(args, false, "D'Angelo"));
        args.put("languageSet", "italian,greek,spanish");
        Assertions.assertEquals((Object)"anhila|anhilu|anzila|anzilu|nhila|nhilu|nzila|nzilu", (Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"));
        Assertions.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "1234"), (Object)"");
    }

    @Test
    public void testCompatibilityWithOriginalVersion() {
        TreeMap<String, String> args = new TreeMap<String, String>();
        args.put("nameType", "GENERIC");
        args.put("ruleType", "APPROX");
        Assertions.assertEquals((Object)"Ybram|Ybrom|abram|abran|abrom|abron|avram|avrom|obram|obran|obrom|obron|ovram|ovrom", (Object)PhoneticEngineRegressionTest.encode(args, true, "abram"));
        Assertions.assertEquals((Object)"bndzn|bntsn|bnzn|vndzn|vntsn", (Object)PhoneticEngineRegressionTest.encode(args, true, "Bendzin"));
        args.put("nameType", "ASHKENAZI");
        args.put("ruleType", "APPROX");
        Assertions.assertEquals((Object)"Ybram|Ybrom|abram|abrom|avram|avrom|imbram|imbrom|obram|obrom|ombram|ombrom|ovram|ovrom", (Object)PhoneticEngineRegressionTest.encode(args, true, "abram"));
        Assertions.assertEquals((Object)"YlpYrn|Ylpirn|alpYrn|alpirn|olpYrn|olpirn|xalpirn|xolpirn", (Object)PhoneticEngineRegressionTest.encode(args, true, "Halpern"));
    }

    private static String encode(Map<String, String> args, boolean concat, String input) {
        String nameTypeArg = args.get("nameType");
        NameType nameType = nameTypeArg == null ? NameType.GENERIC : NameType.valueOf((String)nameTypeArg);
        String ruleTypeArg = args.get("ruleType");
        RuleType ruleType = ruleTypeArg == null ? RuleType.APPROX : RuleType.valueOf((String)ruleTypeArg);
        PhoneticEngine engine = new PhoneticEngine(nameType, ruleType, concat);
        String languageSetArg = args.get("languageSet");
        Languages.LanguageSet languageSet = languageSetArg == null || languageSetArg.equals("auto") ? null : Languages.LanguageSet.from(new HashSet<String>(Arrays.asList(languageSetArg.split(","))));
        if (languageSet == null) {
            return engine.encode(input);
        }
        return engine.encode(input, languageSet);
    }
}

