/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language.bm;

import org.apache.commons.codec.language.bm.Languages;
import org.apache.commons.codec.language.bm.Rule;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RuleTest {
    private Rule.Phoneme[][] makePhonemes() {
        String[][] words = new String[][]{{"rinD", "rinDlt", "rina", "rinalt", "rino", "rinolt", "rinu", "rinult"}, {"dortlaj", "dortlej", "ortlaj", "ortlej", "ortlej-dortlaj"}};
        Rule.Phoneme[][] phonemes = new Rule.Phoneme[words.length][];
        for (int i = 0; i < words.length; ++i) {
            String[] words_i = words[i];
            phonemes[i] = new Rule.Phoneme[words_i.length];
            Rule.Phoneme[] phonemes_i = phonemes[i];
            for (int j = 0; j < words_i.length; ++j) {
                phonemes_i[j] = new Rule.Phoneme((CharSequence)words_i[j], Languages.NO_LANGUAGES);
            }
        }
        return phonemes;
    }

    @Test
    public void testPhonemeComparedToLaterIsNegative() {
        for (Rule.Phoneme[] phs : this.makePhonemes()) {
            for (int i = 0; i < phs.length; ++i) {
                for (int j = i + 1; j < phs.length; ++j) {
                    int c = Rule.Phoneme.COMPARATOR.compare(phs[i], phs[j]);
                    Assertions.assertTrue((Integer.valueOf(c) < 0 ? 1 : 0) != 0, (String)("Comparing " + phs[i].getPhonemeText() + " to " + phs[j].getPhonemeText() + " should be negative"));
                }
            }
        }
    }

    @Test
    public void testPhonemeComparedToSelfIsZero() {
        Rule.Phoneme[][] phonemeArray = this.makePhonemes();
        int n = phonemeArray.length;
        for (int i = 0; i < n; ++i) {
            Rule.Phoneme[] phs;
            for (Rule.Phoneme ph : phs = phonemeArray[i]) {
                Assertions.assertEquals((int)0, (int)Rule.Phoneme.COMPARATOR.compare(ph, ph), (String)("Phoneme compared to itself should be zero: " + ph.getPhonemeText()));
            }
        }
    }

    @Test
    public void testSubSequenceWorks() {
        Rule.Phoneme a = new Rule.Phoneme((CharSequence)"a", null);
        Rule.Phoneme b = new Rule.Phoneme((CharSequence)"b", null);
        Rule.Phoneme cd = new Rule.Phoneme((CharSequence)"cd", null);
        Rule.Phoneme ef = new Rule.Phoneme((CharSequence)"ef", null);
        Rule.Phoneme ghi = new Rule.Phoneme((CharSequence)"ghi", null);
        Rule.Phoneme jkl = new Rule.Phoneme((CharSequence)"jkl", null);
        Assertions.assertEquals((char)'a', (char)a.getPhonemeText().charAt(0));
        Assertions.assertEquals((char)'b', (char)b.getPhonemeText().charAt(0));
        Assertions.assertEquals((char)'c', (char)cd.getPhonemeText().charAt(0));
        Assertions.assertEquals((char)'d', (char)cd.getPhonemeText().charAt(1));
        Assertions.assertEquals((char)'e', (char)ef.getPhonemeText().charAt(0));
        Assertions.assertEquals((char)'f', (char)ef.getPhonemeText().charAt(1));
        Assertions.assertEquals((char)'g', (char)ghi.getPhonemeText().charAt(0));
        Assertions.assertEquals((char)'h', (char)ghi.getPhonemeText().charAt(1));
        Assertions.assertEquals((char)'i', (char)ghi.getPhonemeText().charAt(2));
        Assertions.assertEquals((char)'j', (char)jkl.getPhonemeText().charAt(0));
        Assertions.assertEquals((char)'k', (char)jkl.getPhonemeText().charAt(1));
        Assertions.assertEquals((char)'l', (char)jkl.getPhonemeText().charAt(2));
        Rule.Phoneme a_b = new Rule.Phoneme(a, b);
        Assertions.assertEquals((char)'a', (char)a_b.getPhonemeText().charAt(0));
        Assertions.assertEquals((char)'b', (char)a_b.getPhonemeText().charAt(1));
        Assertions.assertEquals((Object)"ab", (Object)a_b.getPhonemeText().subSequence(0, 2).toString());
        Assertions.assertEquals((Object)"a", (Object)a_b.getPhonemeText().subSequence(0, 1).toString());
        Assertions.assertEquals((Object)"b", (Object)a_b.getPhonemeText().subSequence(1, 2).toString());
        Rule.Phoneme cd_ef = new Rule.Phoneme(cd, ef);
        Assertions.assertEquals((char)'c', (char)cd_ef.getPhonemeText().charAt(0));
        Assertions.assertEquals((char)'d', (char)cd_ef.getPhonemeText().charAt(1));
        Assertions.assertEquals((char)'e', (char)cd_ef.getPhonemeText().charAt(2));
        Assertions.assertEquals((char)'f', (char)cd_ef.getPhonemeText().charAt(3));
        Assertions.assertEquals((Object)"c", (Object)cd_ef.getPhonemeText().subSequence(0, 1).toString());
        Assertions.assertEquals((Object)"d", (Object)cd_ef.getPhonemeText().subSequence(1, 2).toString());
        Assertions.assertEquals((Object)"e", (Object)cd_ef.getPhonemeText().subSequence(2, 3).toString());
        Assertions.assertEquals((Object)"f", (Object)cd_ef.getPhonemeText().subSequence(3, 4).toString());
        Assertions.assertEquals((Object)"cd", (Object)cd_ef.getPhonemeText().subSequence(0, 2).toString());
        Assertions.assertEquals((Object)"de", (Object)cd_ef.getPhonemeText().subSequence(1, 3).toString());
        Assertions.assertEquals((Object)"ef", (Object)cd_ef.getPhonemeText().subSequence(2, 4).toString());
        Assertions.assertEquals((Object)"cde", (Object)cd_ef.getPhonemeText().subSequence(0, 3).toString());
        Assertions.assertEquals((Object)"def", (Object)cd_ef.getPhonemeText().subSequence(1, 4).toString());
        Assertions.assertEquals((Object)"cdef", (Object)cd_ef.getPhonemeText().subSequence(0, 4).toString());
        Rule.Phoneme a_b_cd = new Rule.Phoneme(new Rule.Phoneme(a, b), cd);
        Assertions.assertEquals((char)'a', (char)a_b_cd.getPhonemeText().charAt(0));
        Assertions.assertEquals((char)'b', (char)a_b_cd.getPhonemeText().charAt(1));
        Assertions.assertEquals((char)'c', (char)a_b_cd.getPhonemeText().charAt(2));
        Assertions.assertEquals((char)'d', (char)a_b_cd.getPhonemeText().charAt(3));
        Assertions.assertEquals((Object)"a", (Object)a_b_cd.getPhonemeText().subSequence(0, 1).toString());
        Assertions.assertEquals((Object)"b", (Object)a_b_cd.getPhonemeText().subSequence(1, 2).toString());
        Assertions.assertEquals((Object)"c", (Object)a_b_cd.getPhonemeText().subSequence(2, 3).toString());
        Assertions.assertEquals((Object)"d", (Object)a_b_cd.getPhonemeText().subSequence(3, 4).toString());
        Assertions.assertEquals((Object)"ab", (Object)a_b_cd.getPhonemeText().subSequence(0, 2).toString());
        Assertions.assertEquals((Object)"bc", (Object)a_b_cd.getPhonemeText().subSequence(1, 3).toString());
        Assertions.assertEquals((Object)"cd", (Object)a_b_cd.getPhonemeText().subSequence(2, 4).toString());
        Assertions.assertEquals((Object)"abc", (Object)a_b_cd.getPhonemeText().subSequence(0, 3).toString());
        Assertions.assertEquals((Object)"bcd", (Object)a_b_cd.getPhonemeText().subSequence(1, 4).toString());
        Assertions.assertEquals((Object)"abcd", (Object)a_b_cd.getPhonemeText().subSequence(0, 4).toString());
    }
}

