/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.net;

import java.nio.charset.UnsupportedCharsetException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.QCodec;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class QCodecTest {
    static final int[] SWISS_GERMAN_STUFF_UNICODE = new int[]{71, 114, 252, 101, 122, 105, 95, 122, 228, 109, 228};
    static final int[] RUSSIAN_STUFF_UNICODE = new int[]{1042, 1089, 1077, 1084, 95, 1087, 1088, 1080, 1074, 1077, 1090};

    private String constructString(int[] unicodeChars) {
        StringBuilder buffer = new StringBuilder();
        if (unicodeChars != null) {
            for (int unicodeChar : unicodeChars) {
                buffer.append((char)unicodeChar);
            }
        }
        return buffer.toString();
    }

    @Test
    public void testNullInput() throws Exception {
        QCodec qcodec = new QCodec();
        Assertions.assertNull((Object)qcodec.doDecoding(null));
        Assertions.assertNull((Object)qcodec.doEncoding(null));
    }

    @Test
    public void testUTF8RoundTrip() throws Exception {
        String ru_msg = this.constructString(RUSSIAN_STUFF_UNICODE);
        String ch_msg = this.constructString(SWISS_GERMAN_STUFF_UNICODE);
        QCodec qcodec = new QCodec("UTF-8");
        Assertions.assertEquals((Object)"=?UTF-8?Q?=D0=92=D1=81=D0=B5=D0=BC=5F=D0=BF=D1=80=D0=B8=D0=B2=D0=B5=D1=82?=", (Object)qcodec.encode(ru_msg));
        Assertions.assertEquals((Object)"=?UTF-8?Q?Gr=C3=BCezi=5Fz=C3=A4m=C3=A4?=", (Object)qcodec.encode(ch_msg));
        Assertions.assertEquals((Object)ru_msg, (Object)qcodec.decode(qcodec.encode(ru_msg)));
        Assertions.assertEquals((Object)ch_msg, (Object)qcodec.decode(qcodec.encode(ch_msg)));
    }

    @Test
    public void testBasicEncodeDecode() throws Exception {
        QCodec qcodec = new QCodec();
        String plain = "= Hello there =\r\n";
        String encoded = qcodec.encode("= Hello there =\r\n");
        Assertions.assertEquals((Object)"=?UTF-8?Q?=3D Hello there =3D=0D=0A?=", (Object)encoded, (String)"Basic Q encoding test");
        Assertions.assertEquals((Object)"= Hello there =\r\n", (Object)qcodec.decode(encoded), (String)"Basic Q decoding test");
    }

    @Test
    public void testUnsafeEncodeDecode() throws Exception {
        QCodec qcodec = new QCodec();
        String plain = "?_=\r\n";
        String encoded = qcodec.encode("?_=\r\n");
        Assertions.assertEquals((Object)"=?UTF-8?Q?=3F=5F=3D=0D=0A?=", (Object)encoded, (String)"Unsafe chars Q encoding test");
        Assertions.assertEquals((Object)"?_=\r\n", (Object)qcodec.decode(encoded), (String)"Unsafe chars Q decoding test");
    }

    @Test
    public void testEncodeDecodeNull() throws Exception {
        QCodec qcodec = new QCodec();
        Assertions.assertNull((Object)qcodec.encode((String)null), (String)"Null string Q encoding test");
        Assertions.assertNull((Object)qcodec.decode((String)null), (String)"Null string Q decoding test");
    }

    @Test
    public void testEncodeStringWithNull() throws Exception {
        QCodec qcodec = new QCodec();
        String test = null;
        String result = qcodec.encode(test, "charset");
        Assertions.assertNull((Object)result, (String)"Result should be null");
    }

    @Test
    public void testDecodeStringWithNull() throws Exception {
        QCodec qcodec = new QCodec();
        String test = null;
        String result = qcodec.decode(test);
        Assertions.assertNull((Object)result, (String)"Result should be null");
    }

    @Test
    public void testEncodeObjects() throws Exception {
        QCodec qcodec = new QCodec();
        String plain = "1+1 = 2";
        String encoded = (String)qcodec.encode((Object)"1+1 = 2");
        Assertions.assertEquals((Object)"=?UTF-8?Q?1+1 =3D 2?=", (Object)encoded, (String)"Basic Q encoding test");
        Object result = qcodec.encode(null);
        Assertions.assertNull((Object)result, (String)"Encoding a null Object should return null");
        Assertions.assertThrows(EncoderException.class, () -> qcodec.encode((Object)3.0), (String)"Trying to url encode a Double object should cause an exception.");
    }

    @Test
    public void testInvalidEncoding() {
        Assertions.assertThrows(UnsupportedCharsetException.class, () -> new QCodec("NONSENSE"));
    }

    @Test
    public void testDecodeObjects() throws Exception {
        QCodec qcodec = new QCodec();
        String decoded = "=?UTF-8?Q?1+1 =3D 2?=";
        String plain = (String)qcodec.decode((Object)"=?UTF-8?Q?1+1 =3D 2?=");
        Assertions.assertEquals((Object)"1+1 = 2", (Object)plain, (String)"Basic Q decoding test");
        Object result = qcodec.decode(null);
        Assertions.assertNull((Object)result, (String)"Decoding a null Object should return null");
        Assertions.assertThrows(DecoderException.class, () -> qcodec.decode((Object)3.0), (String)"Trying to url encode a Double object should cause an exception.");
    }

    @Test
    public void testEncodeDecodeBlanks() throws Exception {
        String plain = "Mind those pesky blanks";
        String encoded1 = "=?UTF-8?Q?Mind those pesky blanks?=";
        String encoded2 = "=?UTF-8?Q?Mind_those_pesky_blanks?=";
        QCodec qcodec = new QCodec();
        qcodec.setEncodeBlanks(false);
        String s = qcodec.encode("Mind those pesky blanks");
        Assertions.assertEquals((Object)"=?UTF-8?Q?Mind those pesky blanks?=", (Object)s, (String)"Blanks encoding with the Q codec test");
        qcodec.setEncodeBlanks(true);
        s = qcodec.encode("Mind those pesky blanks");
        Assertions.assertEquals((Object)"=?UTF-8?Q?Mind_those_pesky_blanks?=", (Object)s, (String)"Blanks encoding with the Q codec test");
        s = qcodec.decode("=?UTF-8?Q?Mind those pesky blanks?=");
        Assertions.assertEquals((Object)"Mind those pesky blanks", (Object)s, (String)"Blanks decoding with the Q codec test");
        s = qcodec.decode("=?UTF-8?Q?Mind_those_pesky_blanks?=");
        Assertions.assertEquals((Object)"Mind those pesky blanks", (Object)s, (String)"Blanks decoding with the Q codec test");
    }

    @Test
    public void testLetUsMakeCloverHappy() throws Exception {
        QCodec qcodec = new QCodec();
        qcodec.setEncodeBlanks(true);
        Assertions.assertTrue((boolean)qcodec.isEncodeBlanks());
        qcodec.setEncodeBlanks(false);
        Assertions.assertFalse((boolean)qcodec.isEncodeBlanks());
    }
}

