/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.binary.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class HexTest {
    private static final String BAD_ENCODING_NAME = "UNKNOWN";
    private static final boolean LOG = false;

    protected ByteBuffer allocate(int capacity) {
        return ByteBuffer.allocate(capacity);
    }

    private boolean charsetSanityCheck(String name) {
        String source = "the quick brown dog jumped over the lazy fox";
        try {
            byte[] bytes = "the quick brown dog jumped over the lazy fox".getBytes(name);
            String str = new String(bytes, name);
            boolean equals = "the quick brown dog jumped over the lazy fox".equals(str);
            if (!equals) {
                this.log("FAILED charsetSanityCheck=Interesting Java charset oddity: Roundtrip failed for " + name);
            }
            return equals;
        }
        catch (UnsupportedEncodingException | UnsupportedOperationException e) {
            return false;
        }
    }

    private void checkDecodeHexByteBufferOddCharacters(ByteBuffer data) {
        Assertions.assertThrows(DecoderException.class, () -> new Hex().decode(data));
    }

    private void checkDecodeHexCharArrayOddCharacters(char[] data) {
        Assertions.assertThrows(DecoderException.class, () -> Hex.decodeHex((char[])data));
    }

    private void checkDecodeHexCharArrayOddCharacters(String data) {
        Assertions.assertThrows(DecoderException.class, () -> Hex.decodeHex((String)data));
    }

    private ByteBuffer getByteBufferUtf8(String string) {
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        ByteBuffer bb = this.allocate(bytes.length);
        bb.put(bytes);
        bb.flip();
        return bb;
    }

    private void log(String s) {
    }

    private void log(Throwable t) {
    }

    private void testCharset(String name, String parent) throws UnsupportedEncodingException, DecoderException {
        if (!this.charsetSanityCheck(name)) {
            return;
        }
        this.log(parent + "=" + name);
        Hex customCodec = new Hex(name);
        String sourceString = "Hello World";
        byte[] sourceBytes = "Hello World".getBytes(name);
        byte[] actualEncodedBytes = customCodec.encode(sourceBytes);
        String expectedHexString = Hex.encodeHexString((byte[])sourceBytes);
        byte[] expectedHexStringBytes = expectedHexString.getBytes(name);
        Assertions.assertArrayEquals((byte[])expectedHexStringBytes, (byte[])actualEncodedBytes);
        String actualStringFromBytes = new String(actualEncodedBytes, name);
        Assertions.assertEquals((Object)expectedHexString, (Object)actualStringFromBytes, (String)name);
        Hex utf8Codec = new Hex();
        expectedHexString = "48656c6c6f20576f726c64";
        byte[] decodedUtf8Bytes = (byte[])utf8Codec.decode((Object)expectedHexString);
        actualStringFromBytes = new String(decodedUtf8Bytes, utf8Codec.getCharset());
        Assertions.assertEquals((Object)"Hello World", (Object)actualStringFromBytes, (String)name);
        byte[] decodedCustomBytes = customCodec.decode(actualEncodedBytes);
        actualStringFromBytes = new String(decodedCustomBytes, name);
        Assertions.assertEquals((Object)"Hello World", (Object)actualStringFromBytes, (String)name);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.codec.CharsetsTest#getAvailableCharsetNames()"})
    public void testCustomCharset(String name) throws UnsupportedEncodingException, DecoderException {
        this.testCharset(name, "testCustomCharset");
    }

    @Test
    public void testCustomCharsetBadName() {
        Assertions.assertThrows(UnsupportedCharsetException.class, () -> new Hex(BAD_ENCODING_NAME));
    }

    @Test
    public void testCustomCharsetToString() {
        Assertions.assertTrue((new Hex().toString().indexOf(Hex.DEFAULT_CHARSET_NAME) >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDecodeBadCharacterPos0() {
        Assertions.assertThrows(DecoderException.class, () -> new Hex().decode((Object)"q0"));
    }

    @Test
    public void testDecodeBadCharacterPos1() {
        Assertions.assertThrows(DecoderException.class, () -> new Hex().decode((Object)"0q"));
    }

    @Test
    public void testDecodeByteArrayEmpty() throws DecoderException {
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])new Hex().decode(new byte[0]));
    }

    @Test
    public void testDecodeByteArrayObjectEmpty() throws DecoderException {
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])new Hex().decode((Object)new byte[0])));
    }

    @Test
    public void testDecodeByteArrayOddCharacters() {
        Assertions.assertThrows(DecoderException.class, () -> new Hex().decode(new byte[]{65}), (String)"odd number of characters");
    }

    @Test
    public void testDecodeByteBufferAllocatedButEmpty() throws DecoderException {
        ByteBuffer bb = this.allocate(10);
        bb.flip();
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])new Hex().decode(bb));
        Assertions.assertEquals((int)0, (int)bb.remaining());
    }

    @Test
    public void testDecodeByteBufferEmpty() throws DecoderException {
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])new Hex().decode(this.allocate(0)));
    }

    @Test
    public void testDecodeByteBufferObjectEmpty() throws DecoderException {
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])new Hex().decode((Object)this.allocate(0))));
    }

    @Test
    public void testDecodeByteBufferOddCharacters() {
        ByteBuffer bb = this.allocate(1);
        bb.put((byte)65);
        bb.flip();
        this.checkDecodeHexByteBufferOddCharacters(bb);
    }

    @Test
    public void testDecodeByteBufferWithLimit() throws DecoderException {
        ByteBuffer bb = this.getByteBufferUtf8("000102030405060708090a0b0c0d0e0f");
        byte[] expected = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        for (int i = 0; i < 15; ++i) {
            bb.position(i * 2);
            bb.limit(i * 2 + 4);
            Assertions.assertEquals((Object)new String(Arrays.copyOfRange(expected, i, i + 2)), (Object)new String(new Hex().decode(bb)));
            Assertions.assertEquals((int)0, (int)bb.remaining());
        }
    }

    @Test
    public void testDecodeByteBufferWithLimitOddCharacters() {
        ByteBuffer bb = this.allocate(10);
        bb.put(1, (byte)65);
        bb.position(1);
        bb.limit(2);
        this.checkDecodeHexByteBufferOddCharacters(bb);
    }

    @Test
    public void testDecodeClassCastException() {
        Assertions.assertThrows(DecoderException.class, () -> new Hex().decode((Object)new int[]{65}), (String)"odd number of characters");
    }

    @Test
    public void testDecodeHexCharArrayEmpty() throws DecoderException {
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])Hex.decodeHex((char[])new char[0]));
    }

    @Test
    public void testDecodeHexCharArrayOddCharacters1() {
        this.checkDecodeHexCharArrayOddCharacters(new char[]{'A'});
    }

    @Test
    public void testDecodeHexCharArrayOddCharacters3() {
        this.checkDecodeHexCharArrayOddCharacters(new char[]{'A', 'B', 'C'});
    }

    @Test
    public void testDecodeHexCharArrayOddCharacters5() {
        this.checkDecodeHexCharArrayOddCharacters(new char[]{'A', 'B', 'C', 'D', 'E'});
    }

    @Test
    public void testDecodeHexCharArrayOutBufferUnderSized() {
        byte[] out = new byte[4];
        Assertions.assertThrows(DecoderException.class, () -> Hex.decodeHex((char[])"aabbccddeeff".toCharArray(), (byte[])out, (int)0));
    }

    @Test
    public void testDecodeHexCharArrayOutBufferUnderSizedByOffset() {
        byte[] out = new byte[6];
        Assertions.assertThrows(DecoderException.class, () -> Hex.decodeHex((char[])"aabbccddeeff".toCharArray(), (byte[])out, (int)1));
    }

    @Test
    public void testDecodeHexStringEmpty() throws DecoderException {
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])Hex.decodeHex((String)""));
    }

    @Test
    public void testDecodeHexStringOddCharacters() {
        Assertions.assertThrows(DecoderException.class, () -> new Hex().decode((Object)"6"), (String)"odd number of characters");
    }

    @Test
    public void testDecodeHexStringOddCharacters1() {
        this.checkDecodeHexCharArrayOddCharacters("A");
    }

    @Test
    public void testDecodeStringEmpty() throws DecoderException {
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])new Hex().decode((Object)"")));
    }

    @Test
    public void testEncodeByteArrayEmpty() {
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])new Hex().encode(new byte[0]));
    }

    @Test
    public void testEncodeByteArrayObjectEmpty() throws EncoderException {
        Assertions.assertArrayEquals((char[])new char[0], (char[])((char[])new Hex().encode((Object)new byte[0])));
    }

    @Test
    public void testEncodeByteBufferAllocatedButEmpty() {
        ByteBuffer bb = this.allocate(10);
        bb.flip();
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])new Hex().encode(bb));
        Assertions.assertEquals((int)0, (int)bb.remaining());
    }

    @Test
    public void testEncodeByteBufferEmpty() {
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])new Hex().encode(this.allocate(0)));
    }

    @Test
    public void testEncodeByteBufferObjectEmpty() throws EncoderException {
        Assertions.assertArrayEquals((char[])new char[0], (char[])((char[])new Hex().encode((Object)this.allocate(0))));
    }

    @Test
    public void testEncodeClassCastException() {
        Assertions.assertThrows(EncoderException.class, () -> new Hex().encode((Object)new int[]{65}));
    }

    @Test
    public void testEncodeDecodeHexCharArrayRandom() throws DecoderException, EncoderException {
        Hex hex = new Hex();
        for (int i = 5; i > 0; --i) {
            byte[] data = new byte[ThreadLocalRandom.current().nextInt(10000) + 1];
            ThreadLocalRandom.current().nextBytes(data);
            char[] encodedChars = Hex.encodeHex((byte[])data);
            byte[] decodedBytes = Hex.decodeHex((char[])encodedChars);
            Assertions.assertArrayEquals((byte[])data, (byte[])decodedBytes);
            byte[] encodedStringBytes = hex.encode(data);
            decodedBytes = hex.decode(encodedStringBytes);
            Assertions.assertArrayEquals((byte[])data, (byte[])decodedBytes);
            String dataString = new String(encodedChars);
            char[] encodedStringChars = (char[])hex.encode((Object)dataString);
            decodedBytes = (byte[])hex.decode((Object)encodedStringChars);
            Assertions.assertArrayEquals((byte[])StringUtils.getBytesUtf8((String)dataString), (byte[])decodedBytes);
            dataString = new String(encodedChars);
            encodedStringChars = (char[])hex.encode((Object)dataString);
            decodedBytes = (byte[])hex.decode((Object)new String(encodedStringChars));
            Assertions.assertArrayEquals((byte[])StringUtils.getBytesUtf8((String)dataString), (byte[])decodedBytes);
        }
    }

    @Test
    public void testEncodeDecodeHexCharArrayRandomToOutput() throws DecoderException {
        for (int i = 5; i > 0; --i) {
            byte[] data = new byte[ThreadLocalRandom.current().nextInt(10000) + 1];
            ThreadLocalRandom.current().nextBytes(data);
            char[] lowerEncodedChars = new char[data.length * 2];
            Hex.encodeHex((byte[])data, (int)0, (int)data.length, (boolean)true, (char[])lowerEncodedChars, (int)0);
            byte[] decodedLowerCaseBytes = Hex.decodeHex((char[])lowerEncodedChars);
            Assertions.assertArrayEquals((byte[])data, (byte[])decodedLowerCaseBytes);
            char[] upperEncodedChars = new char[data.length * 2];
            Hex.encodeHex((byte[])data, (int)0, (int)data.length, (boolean)false, (char[])upperEncodedChars, (int)0);
            byte[] decodedUpperCaseBytes = Hex.decodeHex((char[])upperEncodedChars);
            Assertions.assertArrayEquals((byte[])data, (byte[])decodedUpperCaseBytes);
        }
    }

    @Test
    public void testEncodeHex_ByteBufferOfZeroes() {
        char[] c = Hex.encodeHex((ByteBuffer)this.allocate(36));
        Assertions.assertEquals((Object)"000000000000000000000000000000000000000000000000000000000000000000000000", (Object)new String(c));
    }

    @Test
    public void testEncodeHex_ByteBufferWithLimit() {
        ByteBuffer bb = this.allocate(16);
        for (int i = 0; i < 16; ++i) {
            bb.put((byte)i);
        }
        bb.flip();
        String expected = "000102030405060708090a0b0c0d0e0f";
        for (int i = 0; i < 15; ++i) {
            bb.position(i);
            bb.limit(i + 2);
            Assertions.assertEquals((Object)"000102030405060708090a0b0c0d0e0f".substring(i * 2, i * 2 + 4), (Object)new String(Hex.encodeHex((ByteBuffer)bb)));
            Assertions.assertEquals((int)0, (int)bb.remaining());
        }
    }

    @Test
    public void testEncodeHexByteArrayEmpty() {
        Assertions.assertArrayEquals((char[])new char[0], (char[])Hex.encodeHex((byte[])new byte[0]));
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])new Hex().encode(new byte[0]));
    }

    @Test
    public void testEncodeHexByteArrayHelloWorldLowerCaseHex() {
        byte[] b = StringUtils.getBytesUtf8((String)"Hello World");
        String expected = "48656c6c6f20576f726c64";
        char[] actual = Hex.encodeHex((byte[])b);
        Assertions.assertEquals((Object)"48656c6c6f20576f726c64", (Object)new String(actual));
        actual = Hex.encodeHex((byte[])b, (boolean)true);
        Assertions.assertEquals((Object)"48656c6c6f20576f726c64", (Object)new String(actual));
        actual = Hex.encodeHex((byte[])b, (boolean)false);
        Assertions.assertNotEquals((Object)"48656c6c6f20576f726c64", (Object)new String(actual));
    }

    @Test
    public void testEncodeHexByteArrayHelloWorldUpperCaseHex() {
        byte[] b = StringUtils.getBytesUtf8((String)"Hello World");
        String expected = "48656C6C6F20576F726C64";
        char[] actual = Hex.encodeHex((byte[])b);
        Assertions.assertNotEquals((Object)"48656C6C6F20576F726C64", (Object)new String(actual));
        actual = Hex.encodeHex((byte[])b, (boolean)true);
        Assertions.assertNotEquals((Object)"48656C6C6F20576F726C64", (Object)new String(actual));
        actual = Hex.encodeHex((byte[])b, (boolean)false);
        Assertions.assertEquals((Object)"48656C6C6F20576F726C64", (Object)new String(actual));
    }

    @Test
    public void testEncodeHexByteArrayZeroes() {
        char[] c = Hex.encodeHex((byte[])new byte[36]);
        Assertions.assertEquals((Object)"000000000000000000000000000000000000000000000000000000000000000000000000", (Object)new String(c));
    }

    @Test
    public void testEncodeHexByteBufferEmpty() {
        Assertions.assertArrayEquals((char[])new char[0], (char[])Hex.encodeHex((ByteBuffer)this.allocate(0)));
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])new Hex().encode(this.allocate(0)));
    }

    @Test
    public void testEncodeHexByteBufferHelloWorldLowerCaseHex() {
        ByteBuffer b = this.getByteBufferUtf8("Hello World");
        String expected = "48656c6c6f20576f726c64";
        char[] actual = Hex.encodeHex((ByteBuffer)b);
        Assertions.assertEquals((Object)"48656c6c6f20576f726c64", (Object)new String(actual));
        Assertions.assertEquals((int)0, (int)b.remaining());
        b.flip();
        actual = Hex.encodeHex((ByteBuffer)b, (boolean)true);
        Assertions.assertEquals((Object)"48656c6c6f20576f726c64", (Object)new String(actual));
        Assertions.assertEquals((int)0, (int)b.remaining());
        b.flip();
        actual = Hex.encodeHex((ByteBuffer)b, (boolean)false);
        Assertions.assertEquals((Object)"48656c6c6f20576f726c64".toUpperCase(), (Object)new String(actual));
        Assertions.assertEquals((int)0, (int)b.remaining());
    }

    @Test
    public void testEncodeHexByteBufferHelloWorldUpperCaseHex() {
        ByteBuffer b = this.getByteBufferUtf8("Hello World");
        String expected = "48656C6C6F20576F726C64";
        char[] actual = Hex.encodeHex((ByteBuffer)b);
        Assertions.assertEquals((Object)"48656C6C6F20576F726C64".toLowerCase(), (Object)new String(actual));
        Assertions.assertEquals((int)0, (int)b.remaining());
        b.flip();
        actual = Hex.encodeHex((ByteBuffer)b, (boolean)true);
        Assertions.assertEquals((Object)"48656C6C6F20576F726C64".toLowerCase(), (Object)new String(actual));
        Assertions.assertEquals((int)0, (int)b.remaining());
        b.flip();
        actual = Hex.encodeHex((ByteBuffer)b, (boolean)false);
        Assertions.assertEquals((Object)"48656C6C6F20576F726C64", (Object)new String(actual));
        Assertions.assertEquals((int)0, (int)b.remaining());
    }

    @Test
    public void testEncodeHexByteString_ByteArrayBoolean_ToLowerCase() {
        Assertions.assertEquals((Object)"0a", (Object)Hex.encodeHexString((byte[])new byte[]{10}, (boolean)true));
    }

    @Test
    public void testEncodeHexByteString_ByteArrayBoolean_ToUpperCase() {
        Assertions.assertEquals((Object)"0A", (Object)Hex.encodeHexString((byte[])new byte[]{10}, (boolean)false));
    }

    @Test
    public void testEncodeHexByteString_ByteArrayOfZeroes() {
        String c = Hex.encodeHexString((byte[])new byte[36]);
        Assertions.assertEquals((Object)"000000000000000000000000000000000000000000000000000000000000000000000000", (Object)c);
    }

    @Test
    public void testEncodeHexByteString_ByteBufferBoolean_ToLowerCase() {
        ByteBuffer bb = this.allocate(1);
        bb.put((byte)10);
        bb.flip();
        Assertions.assertEquals((Object)"0a", (Object)Hex.encodeHexString((ByteBuffer)bb, (boolean)true));
    }

    @Test
    public void testEncodeHexByteString_ByteBufferBoolean_ToUpperCase() {
        ByteBuffer bb = this.allocate(1);
        bb.put((byte)10);
        bb.flip();
        Assertions.assertEquals((Object)"0A", (Object)Hex.encodeHexString((ByteBuffer)bb, (boolean)false));
    }

    @Test
    public void testEncodeHexByteString_ByteBufferOfZeroes() {
        String c = Hex.encodeHexString((ByteBuffer)this.allocate(36));
        Assertions.assertEquals((Object)"000000000000000000000000000000000000000000000000000000000000000000000000", (Object)c);
    }

    @Test
    public void testEncodeHexByteString_ByteBufferOfZeroesWithLimit() {
        ByteBuffer bb = this.allocate(36);
        bb.limit(3);
        Assertions.assertEquals((Object)"000000", (Object)Hex.encodeHexString((ByteBuffer)bb));
        Assertions.assertEquals((int)0, (int)bb.remaining());
        bb.position(1);
        bb.limit(3);
        Assertions.assertEquals((Object)"0000", (Object)Hex.encodeHexString((ByteBuffer)bb));
        Assertions.assertEquals((int)0, (int)bb.remaining());
    }

    @Test
    public void testEncodeHexByteString_ByteBufferWithLimitBoolean_ToLowerCase() {
        ByteBuffer bb = this.allocate(4);
        bb.put(1, (byte)10);
        bb.position(1);
        bb.limit(2);
        Assertions.assertEquals((Object)"0a", (Object)Hex.encodeHexString((ByteBuffer)bb, (boolean)true));
        Assertions.assertEquals((int)0, (int)bb.remaining());
    }

    @Test
    public void testEncodeHexByteString_ByteBufferWithLimitBoolean_ToUpperCase() {
        ByteBuffer bb = this.allocate(4);
        bb.put(1, (byte)10);
        bb.position(1);
        bb.limit(2);
        Assertions.assertEquals((Object)"0A", (Object)Hex.encodeHexString((ByteBuffer)bb, (boolean)false));
        Assertions.assertEquals((int)0, (int)bb.remaining());
    }

    @Test
    public void testEncodeHexPartialInput() {
        byte[] data = "hello world".getBytes(StandardCharsets.UTF_8);
        char[] hex = Hex.encodeHex((byte[])data, (int)0, (int)0, (boolean)true);
        Assertions.assertArrayEquals((char[])new char[0], (char[])hex);
        hex = Hex.encodeHex((byte[])data, (int)0, (int)1, (boolean)true);
        Assertions.assertArrayEquals((char[])"68".toCharArray(), (char[])hex);
        hex = Hex.encodeHex((byte[])data, (int)0, (int)1, (boolean)false);
        Assertions.assertArrayEquals((char[])"68".toCharArray(), (char[])hex);
        hex = Hex.encodeHex((byte[])data, (int)2, (int)4, (boolean)true);
        Assertions.assertArrayEquals((char[])"6c6c6f20".toCharArray(), (char[])hex);
        hex = Hex.encodeHex((byte[])data, (int)2, (int)4, (boolean)false);
        Assertions.assertArrayEquals((char[])"6C6C6F20".toCharArray(), (char[])hex);
        hex = Hex.encodeHex((byte[])data, (int)10, (int)1, (boolean)true);
        Assertions.assertArrayEquals((char[])"64".toCharArray(), (char[])hex);
        hex = Hex.encodeHex((byte[])data, (int)10, (int)1, (boolean)false);
        Assertions.assertArrayEquals((char[])"64".toCharArray(), (char[])hex);
    }

    @Test
    public void testEncodeHexPartialInputOverbounds() {
        byte[] data = "hello world".getBytes(StandardCharsets.UTF_8);
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> Hex.encodeHex((byte[])data, (int)9, (int)10, (boolean)true));
    }

    @Test
    public void testEncodeHexPartialInputUnderbounds() {
        byte[] data = "hello world".getBytes(StandardCharsets.UTF_8);
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> Hex.encodeHex((byte[])data, (int)-2, (int)10, (boolean)true));
    }

    @Test
    public void testEncodeHexReadOnlyByteBuffer() {
        char[] chars = Hex.encodeHex((ByteBuffer)ByteBuffer.wrap(new byte[]{10}).asReadOnlyBuffer());
        Assertions.assertEquals((Object)"0a", (Object)String.valueOf(chars));
    }

    @Test
    public void testEncodeStringEmpty() throws EncoderException {
        Assertions.assertArrayEquals((char[])new char[0], (char[])((char[])new Hex().encode((Object)"")));
    }

    @Test
    public void testGetCharset() {
        Assertions.assertEquals((Object)StandardCharsets.UTF_8, (Object)new Hex(StandardCharsets.UTF_8).getCharset());
    }

    @Test
    public void testGetCharsetName() {
        Assertions.assertEquals((Object)StandardCharsets.UTF_8.name(), (Object)new Hex(StandardCharsets.UTF_8).getCharsetName());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.codec.CharsetsTest#getRequiredCharsets()"})
    public void testRequiredCharset(Charset charset) throws UnsupportedEncodingException, DecoderException {
        this.testCharset(charset.name(), "testRequiredCharset");
    }
}

