/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.codec.digest.Crypt;
import org.apache.commons.codec.digest.Md5Crypt;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Md5CryptTest {
    @Test
    public void testCtor() {
        Assertions.assertNotNull((Object)new Md5Crypt());
    }

    @Test
    public void testInvalidPrefix() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Md5Crypt.md5Crypt((byte[])new byte[]{1, 2, 3, 4, 5}, (String)"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa!", (String)"(.*a){10000}"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Md5Crypt.md5Crypt((byte[])new byte[]{1, 2, 3, 4, 5}, (String)"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa!", (String)"$(.*a){10000}$"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Md5Crypt.md5Crypt((byte[])new byte[]{1, 2, 3, 4, 5}, (String)"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", (String)"$(.*a){10000}$"));
    }

    @Test
    public void testMd5CryptBytes() {
        Assertions.assertEquals((Object)"$1$foo$9mS5ExwgIECGE5YKlD5o91", (Object)Crypt.crypt((byte[])new byte[0], (String)"$1$foo"));
        Assertions.assertEquals((Object)"$1$./$52agTEQZs877L9jyJnCNZ1", (Object)Crypt.crypt((String)"t\u00e4st", (String)"$1$./$"));
        Assertions.assertEquals((Object)"$1$./$J2UbKzGe0Cpe63WZAt6p//", (Object)Crypt.crypt((byte[])"t\u00e4st".getBytes(StandardCharsets.ISO_8859_1), (String)"$1$./$"));
    }

    @Test
    public void testMd5CryptExplicitCall() {
        Assertions.assertTrue((boolean)Md5Crypt.md5Crypt((byte[])"secret".getBytes()).matches("^\\$1\\$[a-zA-Z0-9./]{0,8}\\$.{1,}$"));
        Assertions.assertTrue((boolean)Md5Crypt.md5Crypt((byte[])"secret".getBytes(), (String)null).matches("^\\$1\\$[a-zA-Z0-9./]{0,8}\\$.{1,}$"));
    }

    @Test
    public void testMd5CryptExplicitCallWithThreadLocalRandom() {
        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
        Assertions.assertTrue((boolean)Md5Crypt.md5Crypt((byte[])"secret".getBytes(), (Random)threadLocalRandom).matches("^\\$1\\$[a-zA-Z0-9./]{0,8}\\$.{1,}$"));
        Assertions.assertTrue((boolean)Md5Crypt.md5Crypt((byte[])"secret".getBytes(), (String)null).matches("^\\$1\\$[a-zA-Z0-9./]{0,8}\\$.{1,}$"));
    }

    @Test
    public void testMd5CryptLongInput() {
        Assertions.assertEquals((Object)"$1$1234$MoxekaNNUgfPRVqoeYjCD/", (Object)Crypt.crypt((String)"12345678901234567890", (String)"$1$1234"));
    }

    @Test
    public void testMd5CryptNullData() {
        Assertions.assertThrows(NullPointerException.class, () -> Md5Crypt.md5Crypt((byte[])null));
    }

    @Test
    public void testMd5CryptStrings() {
        Assertions.assertEquals((Object)"$1$foo$9mS5ExwgIECGE5YKlD5o91", (Object)Crypt.crypt((String)"", (String)"$1$foo"));
        Assertions.assertEquals((Object)"$1$1234$ImZYBLmYC.rbBKg9ERxX70", (Object)Crypt.crypt((String)"secret", (String)"$1$1234"));
        Assertions.assertEquals((Object)"$1$1234$ImZYBLmYC.rbBKg9ERxX70", (Object)Crypt.crypt((String)"secret", (String)"$1$1234$567"));
        Assertions.assertEquals((Object)"$1$1234$ImZYBLmYC.rbBKg9ERxX70", (Object)Crypt.crypt((String)"secret", (String)"$1$1234$567$890"));
        Assertions.assertEquals((Object)"$1$12345678$hj0uLpdidjPhbMMZeno8X/", (Object)Crypt.crypt((String)"secret", (String)"$1$1234567890123456"));
        Assertions.assertEquals((Object)"$1$12345678$hj0uLpdidjPhbMMZeno8X/", (Object)Crypt.crypt((String)"secret", (String)"$1$123456789012345678"));
    }

    @Test
    public void testMd5CryptWithEmptySalt() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Md5Crypt.md5Crypt((byte[])"secret".getBytes(), (String)""));
    }

    @Test
    public void testZeroOutInput() {
        byte[] buffer = new byte[200];
        Arrays.fill(buffer, (byte)65);
        Md5Crypt.md5Crypt((byte[])buffer);
        Assertions.assertArrayEquals((byte[])new byte[buffer.length], (byte[])buffer);
    }
}

