/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.codec.AbstractStringEncoderTest;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.language.ColognePhonetic;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;

public class ColognePhoneticTest
extends AbstractStringEncoderTest<ColognePhonetic> {
    private static final Set<String> TESTSET = new HashSet<String>();
    private static final String[] MATCHES = new String[]{".*[AEIOUJY].*", ".*H.*", ".*B.*", ".*P[^H].*", ".*[DT][^CSZ].*", ".*[FVW].*", ".*PH.*", ".*[GKQ].*", "C[AHKLOQRUX].*", ".*[^SZ]C[AHKLOQRUX].*", ".*[^CKQ]X.*", ".*L.*", ".*[MN].*", ".*R.*", ".*[SZ].*", ".*[SZ]C.*", "C[^AHKLOQRUX].*", ".+C[^AHKLOQRUX].*", ".*[DT][CSZ].*", ".*[CKQ]X.*"};

    @AfterAll
    public static void finishTests() {
        int errors = 0;
        for (String m : MATCHES) {
            if (ColognePhoneticTest.hasTestCase(m)) continue;
            System.out.println(m + " has no test case");
            ++errors;
        }
        Assertions.assertEquals((int)0, (int)errors, (String)"Not expecting any missing test cases");
    }

    private static boolean hasTestCase(String re) {
        for (String s : TESTSET) {
            if (!s.matches(re)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        ColognePhonetic coder = new ColognePhonetic();
        for (String arg : args) {
            String code = coder.encode(arg);
            System.out.println("'" + arg + "' = '" + code + "'");
        }
    }

    @Override
    public void checkEncoding(String expected, String source) throws EncoderException {
        TESTSET.add(source.toUpperCase(Locale.GERMAN).replace('\u00c4', 'A').replace('\u00d6', 'O').replace('\u00dc', 'U'));
        super.checkEncoding(expected, source);
    }

    @Override
    protected ColognePhonetic createStringEncoder() {
        return new ColognePhonetic();
    }

    @Test
    public void testAabjoe() throws EncoderException {
        this.checkEncoding("01", "Aabjoe");
    }

    @Test
    public void testAaclan() throws EncoderException {
        this.checkEncoding("0856", "Aaclan");
    }

    @Test
    public void testAychlmajrForCodec122() throws EncoderException {
        this.checkEncoding("04567", "Aychlmajr");
    }

    @Test
    public void testCanFail() {
        Assertions.assertThrows(AssertionFailedError.class, () -> this.checkEncoding("/", "Fehler"));
    }

    @Test
    public void testEdgeCases() throws EncoderException {
        String[][] data = new String[][]{{"a", "0"}, {"e", "0"}, {"i", "0"}, {"o", "0"}, {"u", "0"}, {"\u00e4", "0"}, {"\u00f6", "0"}, {"\u00fc", "0"}, {"\u00df", "8"}, {"aa", "0"}, {"ha", "0"}, {"h", ""}, {"aha", "0"}, {"b", "1"}, {"p", "1"}, {"ph", "3"}, {"f", "3"}, {"v", "3"}, {"w", "3"}, {"g", "4"}, {"k", "4"}, {"q", "4"}, {"x", "48"}, {"ax", "048"}, {"cx", "48"}, {"l", "5"}, {"cl", "45"}, {"acl", "085"}, {"mn", "6"}, {"{mn}", "6"}, {"r", "7"}};
        this.checkEncodings(data);
    }

    @Test
    public void testExamples() throws EncoderException {
        String[][] data = new String[][]{{"m\u00dcller", "657"}, {"m\u00fcller", "657"}, {"schmidt", "862"}, {"schneider", "8627"}, {"fischer", "387"}, {"weber", "317"}, {"wagner", "3467"}, {"becker", "147"}, {"hoffmann", "0366"}, {"sch\u00c4fer", "837"}, {"sch\u00e4fer", "837"}, {"Breschnew", "17863"}, {"Wikipedia", "3412"}, {"peter", "127"}, {"pharma", "376"}, {"m\u00f6nchengladbach", "664645214"}, {"deutsch", "28"}, {"deutz", "28"}, {"hamburg", "06174"}, {"hannover", "0637"}, {"christstollen", "478256"}, {"Xanthippe", "48621"}, {"Zacharias", "8478"}, {"Holzbau", "0581"}, {"matsch", "68"}, {"matz", "68"}, {"Arbeitsamt", "071862"}, {"Eberhard", "01772"}, {"Eberhardt", "01772"}, {"Celsius", "8588"}, {"Ace", "08"}, {"shch", "84"}, {"xch", "484"}, {"heithabu", "021"}};
        this.checkEncodings(data);
    }

    @Test
    public void testHyphen() throws EncoderException {
        String[][] data = new String[][]{{"bergisch-gladbach", "174845214"}, {"M\u00fcller-L\u00fcdenscheidt", "65752682"}};
        this.checkEncodings(data);
    }

    @Test
    public void testIsEncodeEquals() {
        String[][] data;
        for (String[] element : data = new String[][]{{"Muller", "M\u00fcller"}, {"Meyer", "Mayr"}, {"house", "house"}, {"House", "house"}, {"Haus", "house"}, {"ganz", "Gans"}, {"ganz", "G\u00e4nse"}, {"Miyagi", "Miyako"}}) {
            boolean encodeEqual = ((ColognePhonetic)this.getStringEncoder()).isEncodeEqual(element[1], element[0]);
            Assertions.assertTrue((boolean)encodeEqual, (String)(element[1] + " != " + element[0]));
        }
    }

    @Test
    public void testSpecialCharsBetweenSameLetters() throws EncoderException {
        String[] data = new String[]{"Test test", "Testtest", "Test-test", "TesT#Test", "TesT?test"};
        this.checkEncodingVariations("28282", data);
    }

    @Test
    public void testVariationsMella() throws EncoderException {
        String[] data = new String[]{"mella", "milah", "moulla", "mellah", "muehle", "mule"};
        this.checkEncodingVariations("65", data);
    }

    @Test
    public void testVariationsMeyer() throws EncoderException {
        String[] data = new String[]{"Meier", "Maier", "Mair", "Meyer", "Meyr", "Mejer", "Major"};
        this.checkEncodingVariations("67", data);
    }
}

