/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import junit.framework.Assert;
import org.apache.commons.codec.binary.StringUtils;
import org.junit.Test;

public class StringUtilsTest {
    private static final byte[] BYTES_FIXTURE = new byte[]{97, 98, 99};
    private static final String STRING_FIXTURE = "ABC";

    @Test
    public void testConstructor() {
        new StringUtils();
    }

    @Test
    public void testGetBytesIso8859_1() throws UnsupportedEncodingException {
        String charsetName = "ISO-8859-1";
        this.testGetBytesUnchecked(charsetName);
        byte[] expected = STRING_FIXTURE.getBytes(charsetName);
        byte[] actual = StringUtils.getBytesIso8859_1((String)STRING_FIXTURE);
        Assert.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    private void testGetBytesUnchecked(String charsetName) throws UnsupportedEncodingException {
        byte[] expected = STRING_FIXTURE.getBytes(charsetName);
        byte[] actual = StringUtils.getBytesUnchecked((String)STRING_FIXTURE, (String)charsetName);
        Assert.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testGetBytesUsAscii() throws UnsupportedEncodingException {
        String charsetName = "US-ASCII";
        this.testGetBytesUnchecked(charsetName);
        byte[] expected = STRING_FIXTURE.getBytes(charsetName);
        byte[] actual = StringUtils.getBytesUsAscii((String)STRING_FIXTURE);
        Assert.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testGetBytesUtf16() throws UnsupportedEncodingException {
        String charsetName = "UTF-16";
        this.testGetBytesUnchecked(charsetName);
        byte[] expected = STRING_FIXTURE.getBytes(charsetName);
        byte[] actual = StringUtils.getBytesUtf16((String)STRING_FIXTURE);
        Assert.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testGetBytesUtf16Be() throws UnsupportedEncodingException {
        String charsetName = "UTF-16BE";
        this.testGetBytesUnchecked(charsetName);
        byte[] expected = STRING_FIXTURE.getBytes(charsetName);
        byte[] actual = StringUtils.getBytesUtf16Be((String)STRING_FIXTURE);
        Assert.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testGetBytesUtf16Le() throws UnsupportedEncodingException {
        String charsetName = "UTF-16LE";
        this.testGetBytesUnchecked(charsetName);
        byte[] expected = STRING_FIXTURE.getBytes(charsetName);
        byte[] actual = StringUtils.getBytesUtf16Le((String)STRING_FIXTURE);
        Assert.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testGetBytesUtf8() throws UnsupportedEncodingException {
        String charsetName = "UTF-8";
        this.testGetBytesUnchecked(charsetName);
        byte[] expected = STRING_FIXTURE.getBytes(charsetName);
        byte[] actual = StringUtils.getBytesUtf8((String)STRING_FIXTURE);
        Assert.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    @Test
    public void testGetBytesUncheckedBadName() {
        try {
            StringUtils.getBytesUnchecked((String)STRING_FIXTURE, (String)"UNKNOWN");
            Assert.fail((String)("Expected " + IllegalStateException.class.getName()));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void testNewString(String charsetName) throws UnsupportedEncodingException {
        String expected = new String(BYTES_FIXTURE, charsetName);
        String actual = StringUtils.newString((byte[])BYTES_FIXTURE, (String)charsetName);
        Assert.assertEquals((String)expected, (String)actual);
    }

    @Test
    public void testNewStringBadEnc() {
        try {
            StringUtils.newString((byte[])BYTES_FIXTURE, (String)"UNKNOWN");
            Assert.fail((String)("Expected " + IllegalStateException.class.getName()));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testNewStringIso8859_1() throws UnsupportedEncodingException {
        String charsetName = "ISO-8859-1";
        this.testNewString(charsetName);
        String expected = new String(BYTES_FIXTURE, charsetName);
        String actual = StringUtils.newStringIso8859_1((byte[])BYTES_FIXTURE);
        Assert.assertEquals((String)expected, (String)actual);
    }

    @Test
    public void testNewStringUsAscii() throws UnsupportedEncodingException {
        String charsetName = "US-ASCII";
        this.testNewString(charsetName);
        String expected = new String(BYTES_FIXTURE, charsetName);
        String actual = StringUtils.newStringUsAscii((byte[])BYTES_FIXTURE);
        Assert.assertEquals((String)expected, (String)actual);
    }

    @Test
    public void testNewStringUtf16() throws UnsupportedEncodingException {
        String charsetName = "UTF-16";
        this.testNewString(charsetName);
        String expected = new String(BYTES_FIXTURE, charsetName);
        String actual = StringUtils.newStringUtf16((byte[])BYTES_FIXTURE);
        Assert.assertEquals((String)expected, (String)actual);
    }

    @Test
    public void testNewStringUtf16Be() throws UnsupportedEncodingException {
        String charsetName = "UTF-16BE";
        this.testNewString(charsetName);
        String expected = new String(BYTES_FIXTURE, charsetName);
        String actual = StringUtils.newStringUtf16Be((byte[])BYTES_FIXTURE);
        Assert.assertEquals((String)expected, (String)actual);
    }

    @Test
    public void testNewStringUtf16Le() throws UnsupportedEncodingException {
        String charsetName = "UTF-16LE";
        this.testNewString(charsetName);
        String expected = new String(BYTES_FIXTURE, charsetName);
        String actual = StringUtils.newStringUtf16Le((byte[])BYTES_FIXTURE);
        Assert.assertEquals((String)expected, (String)actual);
    }

    @Test
    public void testNewStringUtf8() throws UnsupportedEncodingException {
        String charsetName = "UTF-8";
        this.testNewString(charsetName);
        String expected = new String(BYTES_FIXTURE, charsetName);
        String actual = StringUtils.newStringUtf8((byte[])BYTES_FIXTURE);
        Assert.assertEquals((String)expected, (String)actual);
    }
}

