/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.StringEncoderAbstractTest;
import org.apache.commons.codec.language.Metaphone;
import org.junit.Assert;
import org.junit.Test;

public class MetaphoneTest
extends StringEncoderAbstractTest {
    public void assertIsMetaphoneEqual(String source, String[] matches) {
        for (String matche : matches) {
            Assert.assertTrue((String)("Source: " + source + ", should have same Metaphone as: " + matche), (boolean)this.getMetaphone().isMetaphoneEqual(source, matche));
        }
        for (String matche : matches) {
            for (String matche2 : matches) {
                Assert.assertTrue((boolean)this.getMetaphone().isMetaphoneEqual(matche, matche2));
            }
        }
    }

    public void assertMetaphoneEqual(String[][] pairs) {
        this.validateFixture(pairs);
        for (String[] pair : pairs) {
            String name0 = pair[0];
            String name1 = pair[1];
            String failMsg = "Expected match between " + name0 + " and " + name1;
            Assert.assertTrue((String)failMsg, (boolean)this.getMetaphone().isMetaphoneEqual(name0, name1));
            Assert.assertTrue((String)failMsg, (boolean)this.getMetaphone().isMetaphoneEqual(name1, name0));
        }
    }

    private Metaphone getMetaphone() {
        return (Metaphone)this.getStringEncoder();
    }

    protected StringEncoder createStringEncoder() {
        return new Metaphone();
    }

    @Test
    public void testIsMetaphoneEqual1() {
        this.assertMetaphoneEqual(new String[][]{{"Case", "case"}, {"CASE", "Case"}, {"caSe", "cAsE"}, {"quick", "cookie"}});
    }

    @Test
    public void testIsMetaphoneEqual2() {
        this.assertMetaphoneEqual(new String[][]{{"Lawrence", "Lorenza"}, {"Gary", "Cahra"}});
    }

    @Test
    public void testIsMetaphoneEqualAero() {
        this.assertIsMetaphoneEqual("Aero", new String[]{"Eure"});
    }

    @Test
    public void testIsMetaphoneEqualWhite() {
        this.assertIsMetaphoneEqual("White", new String[]{"Wade", "Wait", "Waite", "Wat", "Whit", "Wiatt", "Wit", "Wittie", "Witty", "Wood", "Woodie", "Woody"});
    }

    @Test
    public void testIsMetaphoneEqualAlbert() {
        this.assertIsMetaphoneEqual("Albert", new String[]{"Ailbert", "Alberik", "Albert", "Alberto", "Albrecht"});
    }

    @Test
    public void testIsMetaphoneEqualGary() {
        this.assertIsMetaphoneEqual("Gary", new String[]{"Cahra", "Cara", "Carey", "Cari", "Caria", "Carie", "Caro", "Carree", "Carri", "Carrie", "Carry", "Cary", "Cora", "Corey", "Cori", "Corie", "Correy", "Corri", "Corrie", "Corry", "Cory", "Gray", "Kara", "Kare", "Karee", "Kari", "Karia", "Karie", "Karrah", "Karrie", "Karry", "Kary", "Keri", "Kerri", "Kerrie", "Kerry", "Kira", "Kiri", "Kora", "Kore", "Kori", "Korie", "Korrie", "Korry"});
    }

    @Test
    public void testIsMetaphoneEqualJohn() {
        this.assertIsMetaphoneEqual("John", new String[]{"Gena", "Gene", "Genia", "Genna", "Genni", "Gennie", "Genny", "Giana", "Gianna", "Gina", "Ginni", "Ginnie", "Ginny", "Jaine", "Jan", "Jana", "Jane", "Janey", "Jania", "Janie", "Janna", "Jany", "Jayne", "Jean", "Jeana", "Jeane", "Jeanie", "Jeanna", "Jeanne", "Jeannie", "Jen", "Jena", "Jeni", "Jenn", "Jenna", "Jennee", "Jenni", "Jennie", "Jenny", "Jinny", "Jo Ann", "Jo-Ann", "Jo-Anne", "Joan", "Joana", "Joane", "Joanie", "Joann", "Joanna", "Joanne", "Joeann", "Johna", "Johnna", "Joni", "Jonie", "Juana", "June", "Junia", "Junie"});
    }

    @Test
    public void testIsMetaphoneEqualKnight() {
        this.assertIsMetaphoneEqual("Knight", new String[]{"Hynda", "Nada", "Nadia", "Nady", "Nat", "Nata", "Natty", "Neda", "Nedda", "Nedi", "Netta", "Netti", "Nettie", "Netty", "Nita", "Nydia"});
    }

    @Test
    public void testIsMetaphoneEqualMary() {
        this.assertIsMetaphoneEqual("Mary", new String[]{"Mair", "Maire", "Mara", "Mareah", "Mari", "Maria", "Marie", "Mary", "Maura", "Maure", "Meara", "Merrie", "Merry", "Mira", "Moira", "Mora", "Moria", "Moyra", "Muire", "Myra", "Myrah"});
    }

    @Test
    public void testIsMetaphoneEqualParis() {
        this.assertIsMetaphoneEqual("Paris", new String[]{"Pearcy", "Perris", "Piercy", "Pierz", "Pryse"});
    }

    @Test
    public void testIsMetaphoneEqualPeter() {
        this.assertIsMetaphoneEqual("Peter", new String[]{"Peadar", "Peder", "Pedro", "Peter", "Petr", "Peyter", "Pieter", "Pietro", "Piotr"});
    }

    @Test
    public void testIsMetaphoneEqualRay() {
        this.assertIsMetaphoneEqual("Ray", new String[]{"Ray", "Rey", "Roi", "Roy", "Ruy"});
    }

    @Test
    public void testIsMetaphoneEqualSusan() {
        this.assertIsMetaphoneEqual("Susan", new String[]{"Siusan", "Sosanna", "Susan", "Susana", "Susann", "Susanna", "Susannah", "Susanne", "Suzann", "Suzanna", "Suzanne", "Zuzana"});
    }

    @Test
    public void testIsMetaphoneEqualWright() {
        this.assertIsMetaphoneEqual("Wright", new String[]{"Rota", "Rudd", "Ryde"});
    }

    @Test
    public void testIsMetaphoneEqualXalan() {
        this.assertIsMetaphoneEqual("Xalan", new String[]{"Celene", "Celina", "Celine", "Selena", "Selene", "Selina", "Seline", "Suellen", "Xylina"});
    }

    @Test
    public void testMetaphone() {
        Assert.assertEquals((Object)"HL", (Object)this.getMetaphone().metaphone("howl"));
        Assert.assertEquals((Object)"TSTN", (Object)this.getMetaphone().metaphone("testing"));
        Assert.assertEquals((Object)"0", (Object)this.getMetaphone().metaphone("The"));
        Assert.assertEquals((Object)"KK", (Object)this.getMetaphone().metaphone("quick"));
        Assert.assertEquals((Object)"BRN", (Object)this.getMetaphone().metaphone("brown"));
        Assert.assertEquals((Object)"FKS", (Object)this.getMetaphone().metaphone("fox"));
        Assert.assertEquals((Object)"JMPT", (Object)this.getMetaphone().metaphone("jumped"));
        Assert.assertEquals((Object)"OFR", (Object)this.getMetaphone().metaphone("over"));
        Assert.assertEquals((Object)"0", (Object)this.getMetaphone().metaphone("the"));
        Assert.assertEquals((Object)"LS", (Object)this.getMetaphone().metaphone("lazy"));
        Assert.assertEquals((Object)"TKS", (Object)this.getMetaphone().metaphone("dogs"));
    }

    @Test
    public void testWordEndingInMB() {
        Assert.assertEquals((Object)"KM", (Object)this.getMetaphone().metaphone("COMB"));
        Assert.assertEquals((Object)"TM", (Object)this.getMetaphone().metaphone("TOMB"));
        Assert.assertEquals((Object)"WM", (Object)this.getMetaphone().metaphone("WOMB"));
    }

    @Test
    public void testDiscardOfSCEOrSCIOrSCY() {
        Assert.assertEquals((Object)"SNS", (Object)this.getMetaphone().metaphone("SCIENCE"));
        Assert.assertEquals((Object)"SN", (Object)this.getMetaphone().metaphone("SCENE"));
        Assert.assertEquals((Object)"S", (Object)this.getMetaphone().metaphone("SCY"));
    }

    @Test
    public void testWhy() {
        Assert.assertEquals((Object)"", (Object)this.getMetaphone().metaphone("WHY"));
    }

    @Test
    public void testWordsWithCIA() {
        Assert.assertEquals((Object)"XP", (Object)this.getMetaphone().metaphone("CIAPO"));
    }

    @Test
    public void testTranslateOfSCHAndCH() {
        Assert.assertEquals((Object)"SKTL", (Object)this.getMetaphone().metaphone("SCHEDULE"));
        Assert.assertEquals((Object)"SKMT", (Object)this.getMetaphone().metaphone("SCHEMATIC"));
        Assert.assertEquals((Object)"KRKT", (Object)this.getMetaphone().metaphone("CHARACTER"));
        Assert.assertEquals((Object)"TX", (Object)this.getMetaphone().metaphone("TEACH"));
    }

    @Test
    public void testTranslateToJOfDGEOrDGIOrDGY() {
        Assert.assertEquals((Object)"TJ", (Object)this.getMetaphone().metaphone("DODGY"));
        Assert.assertEquals((Object)"TJ", (Object)this.getMetaphone().metaphone("DODGE"));
        Assert.assertEquals((Object)"AJMT", (Object)this.getMetaphone().metaphone("ADGIEMTI"));
    }

    @Test
    public void testDiscardOfSilentHAfterG() {
        Assert.assertEquals((Object)"KNT", (Object)this.getMetaphone().metaphone("GHENT"));
        Assert.assertEquals((Object)"B", (Object)this.getMetaphone().metaphone("BAUGH"));
    }

    @Test
    public void testDiscardOfSilentGN() {
        Assert.assertEquals((Object)"N", (Object)this.getMetaphone().metaphone("GNU"));
        Assert.assertEquals((Object)"SNT", (Object)this.getMetaphone().metaphone("SIGNED"));
    }

    @Test
    public void testPHTOF() {
        Assert.assertEquals((Object)"FX", (Object)this.getMetaphone().metaphone("PHISH"));
    }

    @Test
    public void testSHAndSIOAndSIAToX() {
        Assert.assertEquals((Object)"XT", (Object)this.getMetaphone().metaphone("SHOT"));
        Assert.assertEquals((Object)"OTXN", (Object)this.getMetaphone().metaphone("ODSIAN"));
        Assert.assertEquals((Object)"PLXN", (Object)this.getMetaphone().metaphone("PULSION"));
    }

    @Test
    public void testTIOAndTIAToX() {
        Assert.assertEquals((Object)"OX", (Object)this.getMetaphone().metaphone("OTIA"));
        Assert.assertEquals((Object)"PRXN", (Object)this.getMetaphone().metaphone("PORTION"));
    }

    @Test
    public void testTCH() {
        Assert.assertEquals((Object)"RX", (Object)this.getMetaphone().metaphone("RETCH"));
        Assert.assertEquals((Object)"WX", (Object)this.getMetaphone().metaphone("WATCH"));
    }

    @Test
    public void testExceedLength() {
        Assert.assertEquals((Object)"AKSK", (Object)this.getMetaphone().metaphone("AXEAXE"));
    }

    @Test
    public void testSetMaxLengthWithTruncation() {
        this.getMetaphone().setMaxCodeLen(6);
        Assert.assertEquals((Object)"AKSKSK", (Object)this.getMetaphone().metaphone("AXEAXEAXE"));
    }

    public void validateFixture(String[][] pairs) {
        if (pairs.length == 0) {
            Assert.fail((String)"Test fixture is empty");
        }
        for (int i = 0; i < pairs.length; ++i) {
            if (pairs[i].length == 2) continue;
            Assert.fail((String)("Error in test fixture in the data array at index " + i));
        }
    }
}

