/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language.bm;

import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.StringEncoderAbstractTest;
import org.apache.commons.codec.language.bm.BeiderMorseEncoder;
import org.apache.commons.codec.language.bm.Lang;
import org.apache.commons.codec.language.bm.Languages;
import org.apache.commons.codec.language.bm.NameType;
import org.apache.commons.codec.language.bm.Rule;
import org.apache.commons.codec.language.bm.RuleType;
import org.junit.Assert;
import org.junit.Test;

public class BeiderMorseEncoderTest
extends StringEncoderAbstractTest {
    private static final char[] TEST_CHARS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'o', 'u'};

    private void assertNotEmpty(BeiderMorseEncoder bmpm, String value) throws EncoderException {
        Assert.assertFalse((String)value, (boolean)bmpm.encode(value).equals(""));
    }

    private BeiderMorseEncoder createGenericApproxEncoder() {
        BeiderMorseEncoder encoder = new BeiderMorseEncoder();
        encoder.setNameType(NameType.GENERIC);
        encoder.setRuleType(RuleType.APPROX);
        return encoder;
    }

    protected StringEncoder createStringEncoder() {
        return new BeiderMorseEncoder();
    }

    @Test
    public void testAllChars() throws EncoderException {
        BeiderMorseEncoder bmpm = this.createGenericApproxEncoder();
        for (char c = '\u0000'; c < '\uffff'; c = (char)(c + '\u0001')) {
            bmpm.encode("" + c);
        }
    }

    @Test
    public void testAsciiEncodeNotEmpty1Letter() throws EncoderException {
        BeiderMorseEncoder bmpm = this.createGenericApproxEncoder();
        for (char c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
            String value = "" + c;
            String valueU = value.toUpperCase();
            this.assertNotEmpty(bmpm, value);
            this.assertNotEmpty(bmpm, valueU);
        }
    }

    @Test
    public void testAsciiEncodeNotEmpty2Letters() throws EncoderException {
        BeiderMorseEncoder bmpm = this.createGenericApproxEncoder();
        for (char c1 = 'a'; c1 <= 'z'; c1 = (char)((char)(c1 + 1))) {
            for (char c2 = 'a'; c2 <= 'z'; c2 = (char)((char)(c2 + 1))) {
                String value = new String(new char[]{c1, c2});
                String valueU = value.toUpperCase();
                this.assertNotEmpty(bmpm, value);
                this.assertNotEmpty(bmpm, valueU);
            }
        }
    }

    @Test
    public void testEncodeAtzNotEmpty() throws EncoderException {
        String[] names;
        BeiderMorseEncoder bmpm = this.createGenericApproxEncoder();
        for (String name : names = new String[]{"\u00e1cz", "\u00e1tz", "Ign\u00e1cz", "Ign\u00e1tz", "Ign\u00e1c"}) {
            this.assertNotEmpty(bmpm, name);
        }
    }

    @Test
    public void testEncodeGna() throws EncoderException {
        BeiderMorseEncoder bmpm = this.createGenericApproxEncoder();
        bmpm.encode("gna");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidLangIllegalArgumentException() {
        Rule.getInstance((NameType)NameType.GENERIC, (RuleType)RuleType.APPROX, (String)"noSuchLanguage");
    }

    @Test(expected=IllegalStateException.class)
    public void testInvalidLangIllegalStateException() {
        Lang.loadFromResource((String)"thisIsAMadeUpResourceName", (Languages)Languages.getInstance((NameType)NameType.GENERIC));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidLanguageIllegalArgumentException() {
        Languages.getInstance((String)"thereIsNoSuchLanguage");
    }

    @Test(timeout=10000L)
    public void testLongestEnglishSurname() throws EncoderException {
        BeiderMorseEncoder bmpm = this.createGenericApproxEncoder();
        bmpm.encode("MacGhilleseatheanaich");
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testNegativeIndexForRuleMatchIndexOutOfBoundsException() {
        Rule r = new Rule("a", "", "", (Rule.PhonemeExpr)new Rule.Phoneme((CharSequence)"", Languages.ANY_LANGUAGE));
        r.patternAndContextMatches((CharSequence)"bob", -1);
    }

    @Test
    public void testSetConcat() {
        BeiderMorseEncoder bmpm = new BeiderMorseEncoder();
        bmpm.setConcat(false);
        Assert.assertFalse((String)"Should be able to set concat to false", (boolean)bmpm.isConcat());
    }

    @Test
    public void testSetNameTypeAsh() {
        BeiderMorseEncoder bmpm = new BeiderMorseEncoder();
        bmpm.setNameType(NameType.ASHKENAZI);
        Assert.assertEquals((String)"Name type should have been set to ash", (Object)NameType.ASHKENAZI, (Object)bmpm.getNameType());
    }

    @Test
    public void testSetRuleTypeExact() {
        BeiderMorseEncoder bmpm = new BeiderMorseEncoder();
        bmpm.setRuleType(RuleType.EXACT);
        Assert.assertEquals((String)"Rule type should have been set to exact", (Object)RuleType.EXACT, (Object)bmpm.getRuleType());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetRuleTypeToRulesIllegalArgumentException() {
        BeiderMorseEncoder bmpm = new BeiderMorseEncoder();
        bmpm.setRuleType(RuleType.RULES);
    }

    @Test
    public void testSpeedCheck() throws EncoderException {
        BeiderMorseEncoder bmpm = this.createGenericApproxEncoder();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TEST_CHARS[0]);
        int i = 0;
        int j = 1;
        while (i < 40) {
            if (j == TEST_CHARS.length) {
                j = 0;
            }
            bmpm.encode(stringBuffer.toString());
            stringBuffer.append(TEST_CHARS[j]);
            ++i;
            ++j;
        }
    }

    @Test
    public void testSpeedCheck2() throws EncoderException {
        BeiderMorseEncoder bmpm = this.createGenericApproxEncoder();
        String phrase = "ItstheendoftheworldasweknowitandIfeelfine";
        for (int i = 1; i <= phrase.length(); ++i) {
            bmpm.encode((Object)phrase.subSequence(0, i));
        }
    }

    @Test
    public void testSpeedCheck3() throws EncoderException {
        BeiderMorseEncoder bmpm = this.createGenericApproxEncoder();
        String phrase = "abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz";
        for (int i = 1; i <= phrase.length(); ++i) {
            bmpm.encode((Object)phrase.subSequence(0, i));
        }
    }
}

