/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language.bm;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.language.bm.NameType;
import org.apache.commons.codec.language.bm.PhoneticEngine;
import org.apache.commons.codec.language.bm.RuleType;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class PhoneticEngineTest {
    private final boolean concat;
    private final String name;
    private final NameType nameType;
    private final String phoneticExpected;
    private final RuleType ruleType;

    @Parameterized.Parameters
    public static List<Object[]> data() {
        return Arrays.asList({"Renault", "rinD|rinDlt|rina|rinalt|rino|rinolt|rinu|rinult", NameType.GENERIC, RuleType.APPROX, true}, {"Renault", "rYnDlt|rYnalt|rYnult|rinDlt|rinalt|rinult", NameType.ASHKENAZI, RuleType.APPROX, true}, {"Renault", "rinDlt", NameType.SEPHARDIC, RuleType.APPROX, true}, {"SntJohn-Smith", "sntjonsmit", NameType.GENERIC, RuleType.EXACT, true}, {"d'ortley", "(ortlaj|ortlej)-(dortlaj|dortlej)", NameType.GENERIC, RuleType.EXACT, true}, {"van helsing", "(elSink|elsink|helSink|helsink|helzink|xelsink)-(banhelsink|fanhelsink|fanhelzink|vanhelsink|vanhelzink|vanjelsink)", NameType.GENERIC, RuleType.EXACT, false});
    }

    public PhoneticEngineTest(String name, String phoneticExpected, NameType nameType, RuleType ruleType, boolean concat) {
        this.name = name;
        this.phoneticExpected = phoneticExpected;
        this.nameType = nameType;
        this.ruleType = ruleType;
        this.concat = concat;
    }

    @Test(timeout=10000L)
    public void testEncode() {
        PhoneticEngine engine = new PhoneticEngine(this.nameType, this.ruleType, this.concat);
        String phoneticActual = engine.encode(this.name);
        Assert.assertEquals((String)"phoneme incorrect", (Object)this.phoneticExpected, (Object)phoneticActual);
    }
}

