/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec;

import java.util.Locale;
import junit.framework.Assert;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;
import org.junit.Test;

public abstract class StringEncoderAbstractTest {
    protected StringEncoder stringEncoder = this.createStringEncoder();

    public void checkEncoding(String expected, String source) throws EncoderException {
        Assert.assertEquals((String)("Source: " + source), (String)expected, (String)this.getStringEncoder().encode(source));
    }

    protected void checkEncodings(String[][] data) throws EncoderException {
        for (String[] element : data) {
            this.checkEncoding(element[1], element[0]);
        }
    }

    protected void checkEncodingVariations(String expected, String[] data) throws EncoderException {
        for (String element : data) {
            this.checkEncoding(expected, element);
        }
    }

    protected abstract StringEncoder createStringEncoder();

    public StringEncoder getStringEncoder() {
        return this.stringEncoder;
    }

    @Test
    public void testEncodeEmpty() throws Exception {
        StringEncoder encoder = this.getStringEncoder();
        encoder.encode((Object)"");
        encoder.encode((Object)" ");
        encoder.encode((Object)"\t");
    }

    @Test
    public void testEncodeNull() throws Exception {
        StringEncoder encoder = this.getStringEncoder();
        try {
            encoder.encode(null);
        }
        catch (EncoderException encoderException) {
            // empty catch block
        }
    }

    @Test
    public void testEncodeWithInvalidObject() throws Exception {
        boolean exceptionThrown = false;
        try {
            StringEncoder encoder = this.getStringEncoder();
            encoder.encode((Object)new Float(3.4));
        }
        catch (Exception e) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"An exception was not thrown when we tried to encode a Float object", (boolean)exceptionThrown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocaleIndependence() throws Exception {
        StringEncoder encoder = this.getStringEncoder();
        String[] data = new String[]{"I", "i"};
        Locale orig = Locale.getDefault();
        Locale[] locales = new Locale[]{Locale.ENGLISH, new Locale("tr"), Locale.getDefault()};
        try {
            for (String element : data) {
                String ref = null;
                for (int j = 0; j < locales.length; ++j) {
                    Locale.setDefault(locales[j]);
                    if (j <= 0) {
                        ref = encoder.encode(element);
                        continue;
                    }
                    String cur = null;
                    try {
                        cur = encoder.encode(element);
                    }
                    catch (Exception e) {
                        Assert.fail((String)(Locale.getDefault().toString() + ": " + e.getMessage()));
                    }
                    Assert.assertEquals((String)(Locale.getDefault().toString() + ": "), (String)ref, (String)cur);
                }
            }
        }
        finally {
            Locale.setDefault(orig);
        }
    }
}

