/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.junit.Assert;
import org.junit.Test;

public class DigestUtilsTest {
    private final byte[] testData = new byte[0x100000];

    private byte[] getBytesUtf8(String hashMe) {
        return StringUtils.getBytesUtf8((String)hashMe);
    }

    protected void setUp() throws Exception {
        new Random().nextBytes(this.testData);
    }

    @Test
    public void testConstructable() {
        new DigestUtils();
    }

    @Test
    public void testInternalNoSuchAlgorithmException() {
        try {
            DigestUtils.getDigest((String)"Bogus Bogus");
            Assert.fail((String)"A RuntimeException should have been thrown.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testMd5Hex() throws IOException {
        Assert.assertEquals((Object)"d41d8cd98f00b204e9800998ecf8427e", (Object)DigestUtils.md5Hex((String)""));
        Assert.assertEquals((Object)"0cc175b9c0f1b6a831c399e269772661", (Object)DigestUtils.md5Hex((String)"a"));
        Assert.assertEquals((Object)"900150983cd24fb0d6963f7d28e17f72", (Object)DigestUtils.md5Hex((String)"abc"));
        Assert.assertEquals((Object)"f96b697d7cb7938d525a2f31aaf161d0", (Object)DigestUtils.md5Hex((String)"message digest"));
        Assert.assertEquals((Object)"c3fcd3d76192e4007dfb496cca67e13b", (Object)DigestUtils.md5Hex((String)"abcdefghijklmnopqrstuvwxyz"));
        Assert.assertEquals((Object)"d174ab98d277d9f5a5611c2c9f419d9f", (Object)DigestUtils.md5Hex((String)"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789"));
        Assert.assertEquals((Object)"57edf4a22be3c955ac49da2e2107b67a", (Object)DigestUtils.md5Hex((String)"12345678901234567890123456789012345678901234567890123456789012345678901234567890"));
        Assert.assertEquals((Object)DigestUtils.md5Hex((byte[])this.testData), (Object)DigestUtils.md5Hex((InputStream)new ByteArrayInputStream(this.testData)));
    }

    @Test
    public void testMD5HexLength() {
        String hashMe = "this is some string that is longer than 32 characters";
        String hash = DigestUtils.md5Hex((byte[])this.getBytesUtf8(hashMe));
        Assert.assertEquals((long)32L, (long)hash.length());
        hashMe = "length < 32";
        hash = DigestUtils.md5Hex((byte[])this.getBytesUtf8(hashMe));
        Assert.assertEquals((long)32L, (long)hash.length());
    }

    @Test
    public void testMD5Length() {
        String hashMe = "this is some string that is longer than 16 characters";
        byte[] hash = DigestUtils.md5((byte[])this.getBytesUtf8(hashMe));
        Assert.assertEquals((long)16L, (long)hash.length);
        hashMe = "length < 16";
        hash = DigestUtils.md5((byte[])this.getBytesUtf8(hashMe));
        Assert.assertEquals((long)16L, (long)hash.length);
    }

    @Test
    public void testSha256() throws IOException {
        Assert.assertEquals((Object)"ba7816bf8f01cfea414140de5dae2223b00361a396177a9cb410ff61f20015ad", (Object)DigestUtils.sha256Hex((String)"abc"));
        Assert.assertEquals((Object)"ba7816bf8f01cfea414140de5dae2223b00361a396177a9cb410ff61f20015ad", (Object)DigestUtils.sha256Hex((byte[])this.getBytesUtf8("abc")));
        Assert.assertEquals((Object)"248d6a61d20638b8e5c026930c3e6039a33ce45964ff2167f6ecedd419db06c1", (Object)DigestUtils.sha256Hex((String)"abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq"));
        Assert.assertEquals((Object)DigestUtils.sha256Hex((byte[])this.testData), (Object)DigestUtils.sha256Hex((InputStream)new ByteArrayInputStream(this.testData)));
    }

    @Test
    public void testSha384() throws IOException {
        Assert.assertEquals((Object)"cb00753f45a35e8bb5a03d699ac65007272c32ab0eded1631a8b605a43ff5bed8086072ba1e7cc2358baeca134c825a7", (Object)DigestUtils.sha384Hex((String)"abc"));
        Assert.assertEquals((Object)"cb00753f45a35e8bb5a03d699ac65007272c32ab0eded1631a8b605a43ff5bed8086072ba1e7cc2358baeca134c825a7", (Object)DigestUtils.sha384Hex((byte[])this.getBytesUtf8("abc")));
        Assert.assertEquals((Object)"09330c33f71147e83d192fc782cd1b4753111b173b3b05d22fa08086e3b0f712fcc7c71a557e2db966c3e9fa91746039", (Object)DigestUtils.sha384Hex((String)"abcdefghbcdefghicdefghijdefghijkefghijklfghijklmghijklmnhijklmnoijklmnopjklmnopqklmnopqrlmnopqrsmnopqrstnopqrstu"));
        Assert.assertEquals((Object)DigestUtils.sha384Hex((byte[])this.testData), (Object)DigestUtils.sha384Hex((InputStream)new ByteArrayInputStream(this.testData)));
    }

    @Test
    public void testSha512() throws IOException {
        Assert.assertEquals((Object)"ddaf35a193617abacc417349ae20413112e6fa4e89a97ea20a9eeee64b55d39a2192992a274fc1a836ba3c23a3feebbd454d4423643ce80e2a9ac94fa54ca49f", (Object)DigestUtils.sha512Hex((String)"abc"));
        Assert.assertEquals((Object)"ddaf35a193617abacc417349ae20413112e6fa4e89a97ea20a9eeee64b55d39a2192992a274fc1a836ba3c23a3feebbd454d4423643ce80e2a9ac94fa54ca49f", (Object)DigestUtils.sha512Hex((byte[])this.getBytesUtf8("abc")));
        Assert.assertEquals((Object)"8e959b75dae313da8cf4f72814fc143f8f7779c6eb9f7fa17299aeadb6889018501d289e4900f7e4331b99dec4b5433ac7d329eeb6dd26545e96e55b874be909", (Object)DigestUtils.sha512Hex((String)"abcdefghbcdefghicdefghijdefghijkefghijklfghijklmghijklmnhijklmnoijklmnopjklmnopqklmnopqrlmnopqrsmnopqrstnopqrstu"));
        Assert.assertEquals((Object)DigestUtils.sha512Hex((byte[])this.testData), (Object)DigestUtils.sha512Hex((InputStream)new ByteArrayInputStream(this.testData)));
    }

    @Test
    public void testShaHex() throws IOException {
        Assert.assertEquals((Object)"a9993e364706816aba3e25717850c26c9cd0d89d", (Object)DigestUtils.shaHex((String)"abc"));
        Assert.assertEquals((Object)"a9993e364706816aba3e25717850c26c9cd0d89d", (Object)DigestUtils.shaHex((byte[])this.getBytesUtf8("abc")));
        Assert.assertEquals((Object)"84983e441c3bd26ebaae4aa1f95129e5e54670f1", (Object)DigestUtils.shaHex((String)"abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq"));
        Assert.assertEquals((Object)DigestUtils.shaHex((byte[])this.testData), (Object)DigestUtils.shaHex((InputStream)new ByteArrayInputStream(this.testData)));
    }
}

