/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.StringEncoderAbstractTest;
import org.apache.commons.codec.language.ColognePhonetic;
import org.junit.Test;

public class ColognePhoneticTest
extends StringEncoderAbstractTest {
    @Override
    protected StringEncoder createStringEncoder() {
        return new ColognePhonetic();
    }

    @Test
    public void testAabjoe() throws EncoderException {
        this.checkEncoding("01", "Aabjoe");
    }

    @Test
    public void testAaclan() throws EncoderException {
        this.checkEncoding("0856", "Aaclan");
    }

    @Test
    public void testAychlmajrForCodec122() throws EncoderException {
        this.checkEncoding("04567", "Aychlmajr");
    }

    @Test
    public void testEdgeCases() throws EncoderException {
        String[][] data = new String[][]{{"a", "0"}, {"e", "0"}, {"i", "0"}, {"o", "0"}, {"u", "0"}, {"\u00e4", "0"}, {"\u00f6", "0"}, {"\u00fc", "0"}, {"aa", "0"}, {"ha", "0"}, {"h", ""}, {"aha", "0"}, {"b", "1"}, {"p", "1"}, {"ph", "3"}, {"f", "3"}, {"v", "3"}, {"w", "3"}, {"g", "4"}, {"k", "4"}, {"q", "4"}, {"x", "48"}, {"ax", "048"}, {"cx", "48"}, {"l", "5"}, {"cl", "45"}, {"acl", "085"}, {"mn", "6"}, {"r", "7"}};
        this.checkEncodings(data);
    }

    @Test
    public void testExamples() throws EncoderException {
        String[][] data = new String[][]{{"m\u00dcller", "657"}, {"schmidt", "862"}, {"schneider", "8627"}, {"fischer", "387"}, {"weber", "317"}, {"wagner", "3467"}, {"becker", "147"}, {"hoffmann", "0366"}, {"sch\u00c4fer", "837"}, {"Breschnew", "17863"}, {"Wikipedia", "3412"}, {"peter", "127"}, {"pharma", "376"}, {"m\u00f6nchengladbach", "664645214"}, {"deutsch", "28"}, {"deutz", "28"}, {"hamburg", "06174"}, {"hannover", "0637"}, {"christstollen", "478256"}, {"Xanthippe", "48621"}, {"Zacharias", "8478"}, {"Holzbau", "0581"}, {"matsch", "68"}, {"matz", "68"}, {"Arbeitsamt", "071862"}, {"Eberhard", "01772"}, {"Eberhardt", "01772"}, {"heithabu", "021"}};
        this.checkEncodings(data);
    }

    @Test
    public void testHyphen() throws EncoderException {
        String[][] data = new String[][]{{"bergisch-gladbach", "174845214"}, {"M\u00fcller-L\u00fcdenscheidt", "65752682"}};
        this.checkEncodings(data);
    }

    @Test
    public void testIsEncodeEquals() {
        String[][] data;
        for (String[] element : data = new String[][]{{"Meyer", "M\u00fcller"}, {"Meyer", "Mayr"}, {"house", "house"}, {"House", "house"}, {"Haus", "house"}, {"ganz", "Gans"}, {"ganz", "G\u00e4nse"}, {"Miyagi", "Miyako"}}) {
            ((ColognePhonetic)this.getStringEncoder()).isEncodeEqual(element[1], element[0]);
        }
    }

    @Test
    public void testVariationsMella() throws EncoderException {
        String[] data = new String[]{"mella", "milah", "moulla", "mellah", "muehle", "mule"};
        this.checkEncodingVariations("65", data);
    }

    @Test
    public void testVariationsMeyer() throws EncoderException {
        String[] data = new String[]{"Meier", "Maier", "Mair", "Meyer", "Meyr", "Mejer", "Major"};
        this.checkEncodingVariations("67", data);
    }
}

