/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.StringEncoderAbstractTest;
import org.apache.commons.codec.language.RefinedSoundex;
import org.junit.Assert;
import org.junit.Test;

public class RefinedSoundexTest
extends StringEncoderAbstractTest {
    @Override
    protected StringEncoder createStringEncoder() {
        return new RefinedSoundex();
    }

    private RefinedSoundex getRefinedSoundex() {
        return (RefinedSoundex)this.getStringEncoder();
    }

    @Test
    public void testDifference() throws EncoderException {
        Assert.assertEquals((long)0L, (long)this.getRefinedSoundex().difference(null, null));
        Assert.assertEquals((long)0L, (long)this.getRefinedSoundex().difference("", ""));
        Assert.assertEquals((long)0L, (long)this.getRefinedSoundex().difference(" ", " "));
        Assert.assertEquals((long)6L, (long)this.getRefinedSoundex().difference("Smith", "Smythe"));
        Assert.assertEquals((long)3L, (long)this.getRefinedSoundex().difference("Ann", "Andrew"));
        Assert.assertEquals((long)1L, (long)this.getRefinedSoundex().difference("Margaret", "Andrew"));
        Assert.assertEquals((long)1L, (long)this.getRefinedSoundex().difference("Janet", "Margaret"));
        Assert.assertEquals((long)5L, (long)this.getRefinedSoundex().difference("Green", "Greene"));
        Assert.assertEquals((long)1L, (long)this.getRefinedSoundex().difference("Blotchet-Halls", "Greene"));
        Assert.assertEquals((long)6L, (long)this.getRefinedSoundex().difference("Smith", "Smythe"));
        Assert.assertEquals((long)8L, (long)this.getRefinedSoundex().difference("Smithers", "Smythers"));
        Assert.assertEquals((long)5L, (long)this.getRefinedSoundex().difference("Anothers", "Brothers"));
    }

    @Test
    public void testEncode() {
        Assert.assertEquals((Object)"T6036084", (Object)this.getRefinedSoundex().encode("testing"));
        Assert.assertEquals((Object)"T6036084", (Object)this.getRefinedSoundex().encode("TESTING"));
        Assert.assertEquals((Object)"T60", (Object)this.getRefinedSoundex().encode("The"));
        Assert.assertEquals((Object)"Q503", (Object)this.getRefinedSoundex().encode("quick"));
        Assert.assertEquals((Object)"B1908", (Object)this.getRefinedSoundex().encode("brown"));
        Assert.assertEquals((Object)"F205", (Object)this.getRefinedSoundex().encode("fox"));
        Assert.assertEquals((Object)"J408106", (Object)this.getRefinedSoundex().encode("jumped"));
        Assert.assertEquals((Object)"O0209", (Object)this.getRefinedSoundex().encode("over"));
        Assert.assertEquals((Object)"T60", (Object)this.getRefinedSoundex().encode("the"));
        Assert.assertEquals((Object)"L7050", (Object)this.getRefinedSoundex().encode("lazy"));
        Assert.assertEquals((Object)"D6043", (Object)this.getRefinedSoundex().encode("dogs"));
        Assert.assertEquals((Object)"D6043", (Object)RefinedSoundex.US_ENGLISH.encode("dogs"));
    }

    @Test
    public void testGetMappingCodeNonLetter() {
        char code = this.getRefinedSoundex().getMappingCode('#');
        Assert.assertEquals((String)"Code does not equals zero", (long)0L, (long)code);
    }

    @Test
    public void testNewInstance() {
        Assert.assertEquals((Object)"D6043", (Object)new RefinedSoundex().soundex("dogs"));
    }

    @Test
    public void testNewInstance2() {
        Assert.assertEquals((Object)"D6043", (Object)new RefinedSoundex("01360240043788015936020505".toCharArray()).soundex("dogs"));
    }

    @Test
    public void testNewInstance3() {
        Assert.assertEquals((Object)"D6043", (Object)new RefinedSoundex("01360240043788015936020505").soundex("dogs"));
    }
}

