/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.BinaryCodec;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BinaryCodecTest {
    private static final int BIT_0 = 1;
    private static final int BIT_1 = 2;
    private static final int BIT_2 = 4;
    private static final int BIT_3 = 8;
    private static final int BIT_4 = 16;
    private static final int BIT_5 = 32;
    private static final int BIT_6 = 64;
    private static final int BIT_7 = 128;
    BinaryCodec instance = null;

    @Before
    public void setUp() throws Exception {
        this.instance = new BinaryCodec();
    }

    @After
    public void tearDown() throws Exception {
        this.instance = null;
    }

    @Test
    public void testDecodeObjectException() {
        try {
            this.instance.decode(new Object());
        }
        catch (DecoderException e) {
            return;
        }
        Assert.fail((String)"Expected DecoderException");
    }

    @Test
    public void testDecodeObject() throws Exception {
        byte[] bits = new byte[1];
        this.assertDecodeObject(bits, "00000000");
        bits = new byte[]{1};
        this.assertDecodeObject(bits, "00000001");
        bits = new byte[]{3};
        this.assertDecodeObject(bits, "00000011");
        bits = new byte[]{7};
        this.assertDecodeObject(bits, "00000111");
        bits = new byte[]{15};
        this.assertDecodeObject(bits, "00001111");
        bits = new byte[]{31};
        this.assertDecodeObject(bits, "00011111");
        bits = new byte[]{63};
        this.assertDecodeObject(bits, "00111111");
        bits = new byte[]{127};
        this.assertDecodeObject(bits, "01111111");
        bits = new byte[]{-1};
        this.assertDecodeObject(bits, "11111111");
        bits = new byte[2];
        bits[0] = -1;
        this.assertDecodeObject(bits, "0000000011111111");
        bits = new byte[2];
        bits[1] = 1;
        bits[0] = -1;
        this.assertDecodeObject(bits, "0000000111111111");
        bits = new byte[2];
        bits[1] = 3;
        bits[0] = -1;
        this.assertDecodeObject(bits, "0000001111111111");
        bits = new byte[2];
        bits[1] = 7;
        bits[0] = -1;
        this.assertDecodeObject(bits, "0000011111111111");
        bits = new byte[2];
        bits[1] = 15;
        bits[0] = -1;
        this.assertDecodeObject(bits, "0000111111111111");
        bits = new byte[2];
        bits[1] = 31;
        bits[0] = -1;
        this.assertDecodeObject(bits, "0001111111111111");
        bits = new byte[2];
        bits[1] = 63;
        bits[0] = -1;
        this.assertDecodeObject(bits, "0011111111111111");
        bits = new byte[2];
        bits[1] = 127;
        bits[0] = -1;
        this.assertDecodeObject(bits, "0111111111111111");
        bits = new byte[2];
        bits[1] = -1;
        bits[0] = -1;
        this.assertDecodeObject(bits, "1111111111111111");
        this.assertDecodeObject(new byte[0], null);
    }

    void assertDecodeObject(byte[] bits, String encodeMe) throws DecoderException {
        byte[] decoded = (byte[])this.instance.decode((Object)encodeMe);
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        decoded = encodeMe == null ? this.instance.decode((byte[])null) : (byte[])this.instance.decode((Object)encodeMe.getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        decoded = encodeMe == null ? (byte[])this.instance.decode((Object)null) : (byte[])this.instance.decode((Object)encodeMe.toCharArray());
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
    }

    @Test
    public void testDecodeByteArray() {
        byte[] bits = new byte[1];
        byte[] decoded = this.instance.decode("00000000".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{1};
        decoded = this.instance.decode("00000001".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{3};
        decoded = this.instance.decode("00000011".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{7};
        decoded = this.instance.decode("00000111".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{15};
        decoded = this.instance.decode("00001111".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{31};
        decoded = this.instance.decode("00011111".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{63};
        decoded = this.instance.decode("00111111".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{127};
        decoded = this.instance.decode("01111111".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{-1};
        decoded = this.instance.decode("11111111".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[0] = -1;
        decoded = this.instance.decode("0000000011111111".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 1;
        bits[0] = -1;
        decoded = this.instance.decode("0000000111111111".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 3;
        bits[0] = -1;
        decoded = this.instance.decode("0000001111111111".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 7;
        bits[0] = -1;
        decoded = this.instance.decode("0000011111111111".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 15;
        bits[0] = -1;
        decoded = this.instance.decode("0000111111111111".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 31;
        bits[0] = -1;
        decoded = this.instance.decode("0001111111111111".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 63;
        bits[0] = -1;
        decoded = this.instance.decode("0011111111111111".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 127;
        bits[0] = -1;
        decoded = this.instance.decode("0111111111111111".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = -1;
        bits[0] = -1;
        decoded = this.instance.decode("1111111111111111".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
    }

    @Test
    public void testToByteArrayFromString() {
        byte[] bits = new byte[1];
        byte[] decoded = this.instance.toByteArray("00000000");
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{1};
        decoded = this.instance.toByteArray("00000001");
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{3};
        decoded = this.instance.toByteArray("00000011");
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{7};
        decoded = this.instance.toByteArray("00000111");
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{15};
        decoded = this.instance.toByteArray("00001111");
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{31};
        decoded = this.instance.toByteArray("00011111");
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{63};
        decoded = this.instance.toByteArray("00111111");
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{127};
        decoded = this.instance.toByteArray("01111111");
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{-1};
        decoded = this.instance.toByteArray("11111111");
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[0] = -1;
        decoded = this.instance.toByteArray("0000000011111111");
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 1;
        bits[0] = -1;
        decoded = this.instance.toByteArray("0000000111111111");
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 3;
        bits[0] = -1;
        decoded = this.instance.toByteArray("0000001111111111");
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 7;
        bits[0] = -1;
        decoded = this.instance.toByteArray("0000011111111111");
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 15;
        bits[0] = -1;
        decoded = this.instance.toByteArray("0000111111111111");
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 31;
        bits[0] = -1;
        decoded = this.instance.toByteArray("0001111111111111");
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 63;
        bits[0] = -1;
        decoded = this.instance.toByteArray("0011111111111111");
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 127;
        bits[0] = -1;
        decoded = this.instance.toByteArray("0111111111111111");
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = -1;
        bits[0] = -1;
        decoded = this.instance.toByteArray("1111111111111111");
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        Assert.assertEquals((long)0L, (long)this.instance.toByteArray((String)null).length);
    }

    @Test
    public void testFromAsciiCharArray() {
        Assert.assertEquals((long)0L, (long)BinaryCodec.fromAscii((char[])null).length);
        Assert.assertEquals((long)0L, (long)BinaryCodec.fromAscii((char[])new char[0]).length);
        byte[] bits = new byte[1];
        byte[] decoded = BinaryCodec.fromAscii((char[])"00000000".toCharArray());
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{1};
        decoded = BinaryCodec.fromAscii((char[])"00000001".toCharArray());
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{3};
        decoded = BinaryCodec.fromAscii((char[])"00000011".toCharArray());
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{7};
        decoded = BinaryCodec.fromAscii((char[])"00000111".toCharArray());
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{15};
        decoded = BinaryCodec.fromAscii((char[])"00001111".toCharArray());
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{31};
        decoded = BinaryCodec.fromAscii((char[])"00011111".toCharArray());
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{63};
        decoded = BinaryCodec.fromAscii((char[])"00111111".toCharArray());
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{127};
        decoded = BinaryCodec.fromAscii((char[])"01111111".toCharArray());
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{-1};
        decoded = BinaryCodec.fromAscii((char[])"11111111".toCharArray());
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((char[])"0000000011111111".toCharArray());
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 1;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((char[])"0000000111111111".toCharArray());
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 3;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((char[])"0000001111111111".toCharArray());
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 7;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((char[])"0000011111111111".toCharArray());
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 15;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((char[])"0000111111111111".toCharArray());
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 31;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((char[])"0001111111111111".toCharArray());
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 63;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((char[])"0011111111111111".toCharArray());
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 127;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((char[])"0111111111111111".toCharArray());
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = -1;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((char[])"1111111111111111".toCharArray());
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        Assert.assertEquals((long)0L, (long)BinaryCodec.fromAscii((char[])null).length);
    }

    @Test
    public void testFromAsciiByteArray() {
        Assert.assertEquals((long)0L, (long)BinaryCodec.fromAscii((byte[])null).length);
        Assert.assertEquals((long)0L, (long)BinaryCodec.fromAscii((byte[])new byte[0]).length);
        byte[] bits = new byte[1];
        byte[] decoded = BinaryCodec.fromAscii((byte[])"00000000".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{1};
        decoded = BinaryCodec.fromAscii((byte[])"00000001".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{3};
        decoded = BinaryCodec.fromAscii((byte[])"00000011".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{7};
        decoded = BinaryCodec.fromAscii((byte[])"00000111".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{15};
        decoded = BinaryCodec.fromAscii((byte[])"00001111".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{31};
        decoded = BinaryCodec.fromAscii((byte[])"00011111".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{63};
        decoded = BinaryCodec.fromAscii((byte[])"00111111".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{127};
        decoded = BinaryCodec.fromAscii((byte[])"01111111".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[]{-1};
        decoded = BinaryCodec.fromAscii((byte[])"11111111".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((byte[])"0000000011111111".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 1;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((byte[])"0000000111111111".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 3;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((byte[])"0000001111111111".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 7;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((byte[])"0000011111111111".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 15;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((byte[])"0000111111111111".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 31;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((byte[])"0001111111111111".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 63;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((byte[])"0011111111111111".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = 127;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((byte[])"0111111111111111".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        bits = new byte[2];
        bits[1] = -1;
        bits[0] = -1;
        decoded = BinaryCodec.fromAscii((byte[])"1111111111111111".getBytes(Charsets.UTF_8));
        Assert.assertEquals((Object)new String(bits), (Object)new String(decoded));
        Assert.assertEquals((long)0L, (long)BinaryCodec.fromAscii((byte[])null).length);
    }

    @Test
    public void testEncodeByteArray() {
        byte[] bits = new byte[1];
        String l_encoded = new String(this.instance.encode(bits));
        Assert.assertEquals((Object)"00000000", (Object)l_encoded);
        bits = new byte[]{1};
        l_encoded = new String(this.instance.encode(bits));
        Assert.assertEquals((Object)"00000001", (Object)l_encoded);
        bits = new byte[]{3};
        l_encoded = new String(this.instance.encode(bits));
        Assert.assertEquals((Object)"00000011", (Object)l_encoded);
        bits = new byte[]{7};
        l_encoded = new String(this.instance.encode(bits));
        Assert.assertEquals((Object)"00000111", (Object)l_encoded);
        bits = new byte[]{15};
        l_encoded = new String(this.instance.encode(bits));
        Assert.assertEquals((Object)"00001111", (Object)l_encoded);
        bits = new byte[]{31};
        l_encoded = new String(this.instance.encode(bits));
        Assert.assertEquals((Object)"00011111", (Object)l_encoded);
        bits = new byte[]{63};
        l_encoded = new String(this.instance.encode(bits));
        Assert.assertEquals((Object)"00111111", (Object)l_encoded);
        bits = new byte[]{127};
        l_encoded = new String(this.instance.encode(bits));
        Assert.assertEquals((Object)"01111111", (Object)l_encoded);
        bits = new byte[]{-1};
        l_encoded = new String(this.instance.encode(bits));
        Assert.assertEquals((Object)"11111111", (Object)l_encoded);
        bits = new byte[2];
        l_encoded = new String(this.instance.encode(bits));
        Assert.assertEquals((Object)"0000000000000000", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 1;
        l_encoded = new String(this.instance.encode(bits));
        Assert.assertEquals((Object)"0000000000000001", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 3;
        l_encoded = new String(this.instance.encode(bits));
        Assert.assertEquals((Object)"0000000000000011", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 7;
        l_encoded = new String(this.instance.encode(bits));
        Assert.assertEquals((Object)"0000000000000111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 15;
        l_encoded = new String(this.instance.encode(bits));
        Assert.assertEquals((Object)"0000000000001111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 31;
        l_encoded = new String(this.instance.encode(bits));
        Assert.assertEquals((Object)"0000000000011111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 63;
        l_encoded = new String(this.instance.encode(bits));
        Assert.assertEquals((Object)"0000000000111111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 127;
        l_encoded = new String(this.instance.encode(bits));
        Assert.assertEquals((Object)"0000000001111111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = -1;
        l_encoded = new String(this.instance.encode(bits));
        Assert.assertEquals((Object)"0000000011111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 1;
        bits[0] = -1;
        l_encoded = new String(this.instance.encode(bits));
        Assert.assertEquals((Object)"0000000111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 3;
        bits[0] = -1;
        l_encoded = new String(this.instance.encode(bits));
        Assert.assertEquals((Object)"0000001111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 7;
        bits[0] = -1;
        l_encoded = new String(this.instance.encode(bits));
        Assert.assertEquals((Object)"0000011111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 15;
        bits[0] = -1;
        l_encoded = new String(this.instance.encode(bits));
        Assert.assertEquals((Object)"0000111111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 31;
        bits[0] = -1;
        l_encoded = new String(this.instance.encode(bits));
        Assert.assertEquals((Object)"0001111111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 63;
        bits[0] = -1;
        l_encoded = new String(this.instance.encode(bits));
        Assert.assertEquals((Object)"0011111111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 127;
        bits[0] = -1;
        l_encoded = new String(this.instance.encode(bits));
        Assert.assertEquals((Object)"0111111111111111", (Object)l_encoded);
        bits = new byte[]{-1, -1};
        l_encoded = new String(this.instance.encode(bits));
        Assert.assertEquals((Object)"1111111111111111", (Object)l_encoded);
        Assert.assertEquals((long)0L, (long)this.instance.encode((byte[])null).length);
    }

    @Test
    public void testToAsciiBytes() {
        byte[] bits = new byte[1];
        String l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assert.assertEquals((Object)"00000000", (Object)l_encoded);
        bits = new byte[]{1};
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assert.assertEquals((Object)"00000001", (Object)l_encoded);
        bits = new byte[]{3};
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assert.assertEquals((Object)"00000011", (Object)l_encoded);
        bits = new byte[]{7};
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assert.assertEquals((Object)"00000111", (Object)l_encoded);
        bits = new byte[]{15};
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assert.assertEquals((Object)"00001111", (Object)l_encoded);
        bits = new byte[]{31};
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assert.assertEquals((Object)"00011111", (Object)l_encoded);
        bits = new byte[]{63};
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assert.assertEquals((Object)"00111111", (Object)l_encoded);
        bits = new byte[]{127};
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assert.assertEquals((Object)"01111111", (Object)l_encoded);
        bits = new byte[]{-1};
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assert.assertEquals((Object)"11111111", (Object)l_encoded);
        bits = new byte[2];
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assert.assertEquals((Object)"0000000000000000", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 1;
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assert.assertEquals((Object)"0000000000000001", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 3;
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assert.assertEquals((Object)"0000000000000011", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 7;
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assert.assertEquals((Object)"0000000000000111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 15;
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assert.assertEquals((Object)"0000000000001111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 31;
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assert.assertEquals((Object)"0000000000011111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 63;
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assert.assertEquals((Object)"0000000000111111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 127;
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assert.assertEquals((Object)"0000000001111111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assert.assertEquals((Object)"0000000011111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 1;
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assert.assertEquals((Object)"0000000111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 3;
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assert.assertEquals((Object)"0000001111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 7;
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assert.assertEquals((Object)"0000011111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 15;
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assert.assertEquals((Object)"0000111111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 31;
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assert.assertEquals((Object)"0001111111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 63;
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assert.assertEquals((Object)"0011111111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 127;
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assert.assertEquals((Object)"0111111111111111", (Object)l_encoded);
        bits = new byte[]{-1, -1};
        l_encoded = new String(BinaryCodec.toAsciiBytes((byte[])bits));
        Assert.assertEquals((Object)"1111111111111111", (Object)l_encoded);
        Assert.assertEquals((long)0L, (long)BinaryCodec.toAsciiBytes((byte[])null).length);
    }

    @Test
    public void testToAsciiChars() {
        byte[] bits = new byte[1];
        String l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assert.assertEquals((Object)"00000000", (Object)l_encoded);
        bits = new byte[]{1};
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assert.assertEquals((Object)"00000001", (Object)l_encoded);
        bits = new byte[]{3};
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assert.assertEquals((Object)"00000011", (Object)l_encoded);
        bits = new byte[]{7};
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assert.assertEquals((Object)"00000111", (Object)l_encoded);
        bits = new byte[]{15};
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assert.assertEquals((Object)"00001111", (Object)l_encoded);
        bits = new byte[]{31};
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assert.assertEquals((Object)"00011111", (Object)l_encoded);
        bits = new byte[]{63};
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assert.assertEquals((Object)"00111111", (Object)l_encoded);
        bits = new byte[]{127};
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assert.assertEquals((Object)"01111111", (Object)l_encoded);
        bits = new byte[]{-1};
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assert.assertEquals((Object)"11111111", (Object)l_encoded);
        bits = new byte[2];
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assert.assertEquals((Object)"0000000000000000", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 1;
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assert.assertEquals((Object)"0000000000000001", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 3;
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assert.assertEquals((Object)"0000000000000011", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 7;
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assert.assertEquals((Object)"0000000000000111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 15;
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assert.assertEquals((Object)"0000000000001111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 31;
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assert.assertEquals((Object)"0000000000011111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 63;
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assert.assertEquals((Object)"0000000000111111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 127;
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assert.assertEquals((Object)"0000000001111111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assert.assertEquals((Object)"0000000011111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 1;
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assert.assertEquals((Object)"0000000111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 3;
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assert.assertEquals((Object)"0000001111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 7;
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assert.assertEquals((Object)"0000011111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 15;
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assert.assertEquals((Object)"0000111111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 31;
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assert.assertEquals((Object)"0001111111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 63;
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assert.assertEquals((Object)"0011111111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 127;
        bits[0] = -1;
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assert.assertEquals((Object)"0111111111111111", (Object)l_encoded);
        bits = new byte[]{-1, -1};
        l_encoded = new String(BinaryCodec.toAsciiChars((byte[])bits));
        Assert.assertEquals((Object)"1111111111111111", (Object)l_encoded);
        Assert.assertEquals((long)0L, (long)BinaryCodec.toAsciiChars((byte[])null).length);
    }

    @Test
    public void testToAsciiString() {
        byte[] bits = new byte[1];
        String l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assert.assertEquals((Object)"00000000", (Object)l_encoded);
        bits = new byte[]{1};
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assert.assertEquals((Object)"00000001", (Object)l_encoded);
        bits = new byte[]{3};
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assert.assertEquals((Object)"00000011", (Object)l_encoded);
        bits = new byte[]{7};
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assert.assertEquals((Object)"00000111", (Object)l_encoded);
        bits = new byte[]{15};
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assert.assertEquals((Object)"00001111", (Object)l_encoded);
        bits = new byte[]{31};
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assert.assertEquals((Object)"00011111", (Object)l_encoded);
        bits = new byte[]{63};
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assert.assertEquals((Object)"00111111", (Object)l_encoded);
        bits = new byte[]{127};
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assert.assertEquals((Object)"01111111", (Object)l_encoded);
        bits = new byte[]{-1};
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assert.assertEquals((Object)"11111111", (Object)l_encoded);
        bits = new byte[2];
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assert.assertEquals((Object)"0000000000000000", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 1;
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assert.assertEquals((Object)"0000000000000001", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 3;
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assert.assertEquals((Object)"0000000000000011", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 7;
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assert.assertEquals((Object)"0000000000000111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 15;
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assert.assertEquals((Object)"0000000000001111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 31;
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assert.assertEquals((Object)"0000000000011111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 63;
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assert.assertEquals((Object)"0000000000111111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 127;
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assert.assertEquals((Object)"0000000001111111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = -1;
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assert.assertEquals((Object)"0000000011111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 1;
        bits[0] = -1;
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assert.assertEquals((Object)"0000000111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 3;
        bits[0] = -1;
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assert.assertEquals((Object)"0000001111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 7;
        bits[0] = -1;
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assert.assertEquals((Object)"0000011111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 15;
        bits[0] = -1;
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assert.assertEquals((Object)"0000111111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 31;
        bits[0] = -1;
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assert.assertEquals((Object)"0001111111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 63;
        bits[0] = -1;
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assert.assertEquals((Object)"0011111111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 127;
        bits[0] = -1;
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assert.assertEquals((Object)"0111111111111111", (Object)l_encoded);
        bits = new byte[]{-1, -1};
        l_encoded = BinaryCodec.toAsciiString((byte[])bits);
        Assert.assertEquals((Object)"1111111111111111", (Object)l_encoded);
    }

    @Test
    public void testEncodeObjectNull() throws Exception {
        byte[] obj = new byte[]{};
        Assert.assertEquals((long)0L, (long)((char[])this.instance.encode((Object)obj)).length);
    }

    @Test
    public void testEncodeObjectException() {
        try {
            this.instance.encode((Object)"");
        }
        catch (EncoderException e) {
            return;
        }
        Assert.fail((String)"Expected EncoderException");
    }

    @Test
    public void testEncodeObject() throws Exception {
        byte[] bits = new byte[1];
        String l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assert.assertEquals((Object)"00000000", (Object)l_encoded);
        bits = new byte[]{1};
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assert.assertEquals((Object)"00000001", (Object)l_encoded);
        bits = new byte[]{3};
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assert.assertEquals((Object)"00000011", (Object)l_encoded);
        bits = new byte[]{7};
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assert.assertEquals((Object)"00000111", (Object)l_encoded);
        bits = new byte[]{15};
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assert.assertEquals((Object)"00001111", (Object)l_encoded);
        bits = new byte[]{31};
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assert.assertEquals((Object)"00011111", (Object)l_encoded);
        bits = new byte[]{63};
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assert.assertEquals((Object)"00111111", (Object)l_encoded);
        bits = new byte[]{127};
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assert.assertEquals((Object)"01111111", (Object)l_encoded);
        bits = new byte[]{-1};
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assert.assertEquals((Object)"11111111", (Object)l_encoded);
        bits = new byte[2];
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assert.assertEquals((Object)"0000000000000000", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 1;
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assert.assertEquals((Object)"0000000000000001", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 3;
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assert.assertEquals((Object)"0000000000000011", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 7;
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assert.assertEquals((Object)"0000000000000111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 15;
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assert.assertEquals((Object)"0000000000001111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 31;
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assert.assertEquals((Object)"0000000000011111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 63;
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assert.assertEquals((Object)"0000000000111111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = 127;
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assert.assertEquals((Object)"0000000001111111", (Object)l_encoded);
        bits = new byte[2];
        bits[0] = -1;
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assert.assertEquals((Object)"0000000011111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 1;
        bits[0] = -1;
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assert.assertEquals((Object)"0000000111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 3;
        bits[0] = -1;
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assert.assertEquals((Object)"0000001111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 7;
        bits[0] = -1;
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assert.assertEquals((Object)"0000011111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 15;
        bits[0] = -1;
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assert.assertEquals((Object)"0000111111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 31;
        bits[0] = -1;
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assert.assertEquals((Object)"0001111111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 63;
        bits[0] = -1;
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assert.assertEquals((Object)"0011111111111111", (Object)l_encoded);
        bits = new byte[2];
        bits[1] = 127;
        bits[0] = -1;
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assert.assertEquals((Object)"0111111111111111", (Object)l_encoded);
        bits = new byte[]{-1, -1};
        l_encoded = new String((char[])this.instance.encode((Object)bits));
        Assert.assertEquals((Object)"1111111111111111", (Object)l_encoded);
    }
}

