/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.EmptyStackException;
import junit.framework.Test;
import org.apache.commons.collections4.AbstractArrayListTest;
import org.apache.commons.collections4.ArrayStack;
import org.apache.commons.collections4.BulkTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayStackTest<E>
extends AbstractArrayListTest<E> {
    public ArrayStackTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(ArrayStackTest.class);
    }

    @Override
    public ArrayStack<E> makeObject() {
        return new ArrayStack();
    }

    public void testNewStack() {
        ArrayStack<E> stack = this.makeObject();
        ArrayStackTest.assertTrue((String)"New stack is empty", (boolean)stack.empty());
        ArrayStackTest.assertEquals((String)"New stack has size zero", (int)0, (int)stack.size());
        try {
            stack.peek();
            ArrayStackTest.fail((String)"peek() should have thrown EmptyStackException");
        }
        catch (EmptyStackException e) {
            // empty catch block
        }
        try {
            stack.pop();
            ArrayStackTest.fail((String)"pop() should have thrown EmptyStackException");
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    public void testPushPeekPop() {
        ArrayStack<E> stack = this.makeObject();
        stack.push((Object)"First Item");
        ArrayStackTest.assertTrue((String)"Stack is not empty", (!stack.empty() ? 1 : 0) != 0);
        ArrayStackTest.assertEquals((String)"Stack size is one", (int)1, (int)stack.size());
        ArrayStackTest.assertEquals((String)"Top item is 'First Item'", (String)"First Item", (String)((String)stack.peek()));
        ArrayStackTest.assertEquals((String)"Stack size is one", (int)1, (int)stack.size());
        stack.push((Object)"Second Item");
        ArrayStackTest.assertEquals((String)"Stack size is two", (int)2, (int)stack.size());
        ArrayStackTest.assertEquals((String)"Top item is 'Second Item'", (String)"Second Item", (String)((String)stack.peek()));
        ArrayStackTest.assertEquals((String)"Stack size is two", (int)2, (int)stack.size());
        ArrayStackTest.assertEquals((String)"Popped item is 'Second Item'", (String)"Second Item", (String)((String)stack.pop()));
        ArrayStackTest.assertEquals((String)"Top item is 'First Item'", (String)"First Item", (String)((String)stack.peek()));
        ArrayStackTest.assertEquals((String)"Stack size is one", (int)1, (int)stack.size());
        ArrayStackTest.assertEquals((String)"Popped item is 'First Item'", (String)"First Item", (String)((String)stack.pop()));
        ArrayStackTest.assertEquals((String)"Stack size is zero", (int)0, (int)stack.size());
    }

    @Override
    public void testSearch() {
        ArrayStack<E> stack = this.makeObject();
        stack.push((Object)"First Item");
        stack.push((Object)"Second Item");
        ArrayStackTest.assertEquals((String)"Top item is 'Second Item'", (int)1, (int)stack.search((Object)"Second Item"));
        ArrayStackTest.assertEquals((String)"Next Item is 'First Item'", (int)2, (int)stack.search((Object)"First Item"));
        ArrayStackTest.assertEquals((String)"Cannot find 'Missing Item'", (int)-1, (int)stack.search((Object)"Missing Item"));
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

