/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.OrderedIterator;
import org.apache.commons.collections4.OrderedMapIterator;
import org.apache.commons.collections4.ResettableIterator;
import org.apache.commons.collections4.ResettableListIterator;
import org.apache.commons.collections4.iterators.EmptyIterator;
import org.apache.commons.collections4.iterators.EmptyListIterator;
import org.apache.commons.collections4.iterators.EmptyMapIterator;
import org.apache.commons.collections4.iterators.EmptyOrderedIterator;
import org.apache.commons.collections4.iterators.EmptyOrderedMapIterator;
import org.apache.commons.collections4.iterators.NodeListIterator;
import org.easymock.EasyMock;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratorUtilsTest
extends BulkTest {
    public IteratorUtilsTest(String name) {
        super(name);
    }

    public static Test suite() {
        return BulkTest.makeSuite(IteratorUtilsTest.class);
    }

    public void testAsIterable() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(0);
        list.add(1);
        list.add(2);
        Iterator iterator = list.iterator();
        Iterable iterable = IteratorUtils.asIterable(iterator);
        int expected = 0;
        for (Integer actual : iterable) {
            IteratorUtilsTest.assertEquals((int)expected, (int)actual);
            ++expected;
        }
        IteratorUtilsTest.assertTrue((expected > 0 ? 1 : 0) != 0);
        IteratorUtilsTest.assertFalse((String)"should not be able to iterate twice", (boolean)IteratorUtils.asIterable(iterator).iterator().hasNext());
    }

    public void testAsIterableNull() {
        try {
            IteratorUtils.asIterable(null);
            IteratorUtilsTest.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAsMultipleIterable() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(0);
        list.add(1);
        list.add(2);
        Iterator iterator = list.iterator();
        Iterable iterable = IteratorUtils.asMultipleUseIterable(iterator);
        int expected = 0;
        for (Integer actual : iterable) {
            IteratorUtilsTest.assertEquals((int)expected, (int)actual);
            ++expected;
        }
        IteratorUtilsTest.assertTrue((expected > 0 ? 1 : 0) != 0);
        expected = 0;
        for (Integer actual : iterable) {
            IteratorUtilsTest.assertEquals((int)expected, (int)actual);
            ++expected;
        }
        IteratorUtilsTest.assertTrue((expected > 0 ? 1 : 0) != 0);
    }

    public void testAsMultipleIterableNull() {
        try {
            IteratorUtils.asMultipleUseIterable(null);
            IteratorUtilsTest.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToList() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(1);
        list.add("Two");
        list.add(null);
        List result = IteratorUtils.toList(list.iterator());
        IteratorUtilsTest.assertEquals(list, (Object)result);
    }

    public void testToArray() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(1);
        list.add("Two");
        list.add(null);
        Object[] result = IteratorUtils.toArray(list.iterator());
        IteratorUtilsTest.assertEquals(list, Arrays.asList(result));
    }

    public void testToArray2() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("One");
        list.add("Two");
        list.add(null);
        String[] result = (String[])IteratorUtils.toArray(list.iterator(), String.class);
        IteratorUtilsTest.assertEquals(list, Arrays.asList(result));
    }

    public void testArrayIterator() {
        Object[] objArray = new Object[]{"a", "b", "c"};
        ResettableIterator iterator = IteratorUtils.arrayIterator((Object[])objArray);
        IteratorUtilsTest.assertTrue((boolean)iterator.next().equals("a"));
        IteratorUtilsTest.assertTrue((boolean)iterator.next().equals("b"));
        iterator.reset();
        IteratorUtilsTest.assertTrue((boolean)iterator.next().equals("a"));
        try {
            iterator = IteratorUtils.arrayIterator((Object)0);
            IteratorUtilsTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            iterator = IteratorUtils.arrayIterator((Object[])null);
            IteratorUtilsTest.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        iterator = IteratorUtils.arrayIterator((Object[])objArray, (int)1);
        IteratorUtilsTest.assertTrue((boolean)iterator.next().equals("b"));
        try {
            iterator = IteratorUtils.arrayIterator((Object[])objArray, (int)-1);
            IteratorUtilsTest.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        iterator = IteratorUtils.arrayIterator((Object[])objArray, (int)3);
        IteratorUtilsTest.assertTrue((!iterator.hasNext() ? 1 : 0) != 0);
        iterator.reset();
        try {
            iterator = IteratorUtils.arrayIterator((Object[])objArray, (int)4);
            IteratorUtilsTest.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        iterator = IteratorUtils.arrayIterator((Object[])objArray, (int)2, (int)3);
        IteratorUtilsTest.assertTrue((boolean)iterator.next().equals("c"));
        try {
            iterator = IteratorUtils.arrayIterator((Object[])objArray, (int)2, (int)4);
            IteratorUtilsTest.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            iterator = IteratorUtils.arrayIterator((Object[])objArray, (int)-1, (int)1);
            IteratorUtilsTest.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            iterator = IteratorUtils.arrayIterator((Object[])objArray, (int)2, (int)1);
            IteratorUtilsTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        int[] intArray = new int[]{0, 1, 2};
        iterator = IteratorUtils.arrayIterator((Object)intArray);
        IteratorUtilsTest.assertTrue((boolean)iterator.next().equals(0));
        IteratorUtilsTest.assertTrue((boolean)iterator.next().equals(1));
        iterator.reset();
        IteratorUtilsTest.assertTrue((boolean)iterator.next().equals(0));
        iterator = IteratorUtils.arrayIterator((Object)intArray, (int)1);
        IteratorUtilsTest.assertTrue((boolean)iterator.next().equals(1));
        try {
            iterator = IteratorUtils.arrayIterator((Object)intArray, (int)-1);
            IteratorUtilsTest.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        iterator = IteratorUtils.arrayIterator((Object)intArray, (int)3);
        IteratorUtilsTest.assertTrue((!iterator.hasNext() ? 1 : 0) != 0);
        iterator.reset();
        try {
            iterator = IteratorUtils.arrayIterator((Object)intArray, (int)4);
            IteratorUtilsTest.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        iterator = IteratorUtils.arrayIterator((Object)intArray, (int)2, (int)3);
        IteratorUtilsTest.assertTrue((boolean)iterator.next().equals(2));
        try {
            iterator = IteratorUtils.arrayIterator((Object)intArray, (int)2, (int)4);
            IteratorUtilsTest.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            iterator = IteratorUtils.arrayIterator((Object)intArray, (int)-1, (int)1);
            IteratorUtilsTest.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            iterator = IteratorUtils.arrayIterator((Object)intArray, (int)2, (int)1);
            IteratorUtilsTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    public void testArrayListIterator() {
        Object[] objArray = new Object[]{"a", "b", "c", "d"};
        ResettableListIterator iterator = IteratorUtils.arrayListIterator((Object[])objArray);
        IteratorUtilsTest.assertTrue((!iterator.hasPrevious() ? 1 : 0) != 0);
        IteratorUtilsTest.assertTrue((iterator.previousIndex() == -1 ? 1 : 0) != 0);
        IteratorUtilsTest.assertTrue((iterator.nextIndex() == 0 ? 1 : 0) != 0);
        IteratorUtilsTest.assertTrue((boolean)iterator.next().equals("a"));
        IteratorUtilsTest.assertTrue((boolean)iterator.previous().equals("a"));
        IteratorUtilsTest.assertTrue((boolean)iterator.next().equals("a"));
        IteratorUtilsTest.assertTrue((iterator.previousIndex() == 0 ? 1 : 0) != 0);
        IteratorUtilsTest.assertTrue((iterator.nextIndex() == 1 ? 1 : 0) != 0);
        IteratorUtilsTest.assertTrue((boolean)iterator.next().equals("b"));
        IteratorUtilsTest.assertTrue((boolean)iterator.next().equals("c"));
        IteratorUtilsTest.assertTrue((boolean)iterator.next().equals("d"));
        IteratorUtilsTest.assertTrue((iterator.nextIndex() == 4 ? 1 : 0) != 0);
        IteratorUtilsTest.assertTrue((iterator.previousIndex() == 3 ? 1 : 0) != 0);
        try {
            iterator = IteratorUtils.arrayListIterator((Object)0);
            IteratorUtilsTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            iterator = IteratorUtils.arrayListIterator((Object[])null);
            IteratorUtilsTest.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        iterator = IteratorUtils.arrayListIterator((Object[])objArray, (int)1);
        IteratorUtilsTest.assertTrue((iterator.previousIndex() == -1 ? 1 : 0) != 0);
        IteratorUtilsTest.assertTrue((!iterator.hasPrevious() ? 1 : 0) != 0);
        IteratorUtilsTest.assertTrue((iterator.nextIndex() == 0 ? 1 : 0) != 0);
        IteratorUtilsTest.assertTrue((boolean)iterator.next().equals("b"));
        IteratorUtilsTest.assertTrue((iterator.previousIndex() == 0 ? 1 : 0) != 0);
        try {
            iterator = IteratorUtils.arrayListIterator((Object[])objArray, (int)-1);
            IteratorUtilsTest.fail((String)"Expecting IndexOutOfBoundsException.");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        iterator = IteratorUtils.arrayListIterator((Object[])objArray, (int)3);
        IteratorUtilsTest.assertTrue((boolean)iterator.hasNext());
        try {
            iterator.previous();
            IteratorUtilsTest.fail((String)"Expecting NoSuchElementException.");
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        try {
            iterator = IteratorUtils.arrayListIterator((Object[])objArray, (int)5);
            IteratorUtilsTest.fail((String)"Expecting IndexOutOfBoundsException.");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        iterator = IteratorUtils.arrayListIterator((Object[])objArray, (int)2, (int)3);
        IteratorUtilsTest.assertTrue((boolean)iterator.next().equals("c"));
        try {
            iterator = IteratorUtils.arrayListIterator((Object[])objArray, (int)2, (int)5);
            IteratorUtilsTest.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            iterator = IteratorUtils.arrayListIterator((Object[])objArray, (int)-1, (int)1);
            IteratorUtilsTest.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            iterator = IteratorUtils.arrayListIterator((Object[])objArray, (int)2, (int)1);
            IteratorUtilsTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        int[] intArray = new int[]{0, 1, 2};
        iterator = IteratorUtils.arrayListIterator((Object)intArray);
        IteratorUtilsTest.assertTrue((iterator.previousIndex() == -1 ? 1 : 0) != 0);
        IteratorUtilsTest.assertTrue((!iterator.hasPrevious() ? 1 : 0) != 0);
        IteratorUtilsTest.assertTrue((iterator.nextIndex() == 0 ? 1 : 0) != 0);
        IteratorUtilsTest.assertTrue((boolean)iterator.next().equals(0));
        IteratorUtilsTest.assertTrue((iterator.previousIndex() == 0 ? 1 : 0) != 0);
        IteratorUtilsTest.assertTrue((iterator.nextIndex() == 1 ? 1 : 0) != 0);
        IteratorUtilsTest.assertTrue((boolean)iterator.next().equals(1));
        IteratorUtilsTest.assertTrue((iterator.previousIndex() == 1 ? 1 : 0) != 0);
        IteratorUtilsTest.assertTrue((iterator.nextIndex() == 2 ? 1 : 0) != 0);
        IteratorUtilsTest.assertTrue((boolean)iterator.previous().equals(1));
        IteratorUtilsTest.assertTrue((boolean)iterator.next().equals(1));
        iterator = IteratorUtils.arrayListIterator((Object)intArray, (int)1);
        IteratorUtilsTest.assertTrue((iterator.previousIndex() == -1 ? 1 : 0) != 0);
        IteratorUtilsTest.assertTrue((!iterator.hasPrevious() ? 1 : 0) != 0);
        IteratorUtilsTest.assertTrue((iterator.nextIndex() == 0 ? 1 : 0) != 0);
        IteratorUtilsTest.assertTrue((boolean)iterator.next().equals(1));
        IteratorUtilsTest.assertTrue((boolean)iterator.previous().equals(1));
        IteratorUtilsTest.assertTrue((boolean)iterator.next().equals(1));
        IteratorUtilsTest.assertTrue((iterator.previousIndex() == 0 ? 1 : 0) != 0);
        IteratorUtilsTest.assertTrue((iterator.nextIndex() == 1 ? 1 : 0) != 0);
        IteratorUtilsTest.assertTrue((boolean)iterator.next().equals(2));
        IteratorUtilsTest.assertTrue((iterator.previousIndex() == 1 ? 1 : 0) != 0);
        IteratorUtilsTest.assertTrue((iterator.nextIndex() == 2 ? 1 : 0) != 0);
        IteratorUtilsTest.assertTrue((boolean)iterator.previous().equals(2));
        IteratorUtilsTest.assertTrue((iterator.previousIndex() == 0 ? 1 : 0) != 0);
        IteratorUtilsTest.assertTrue((iterator.nextIndex() == 1 ? 1 : 0) != 0);
        try {
            iterator = IteratorUtils.arrayListIterator((Object)intArray, (int)-1);
            IteratorUtilsTest.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        iterator = IteratorUtils.arrayListIterator((Object)intArray, (int)3);
        IteratorUtilsTest.assertTrue((!iterator.hasNext() ? 1 : 0) != 0);
        try {
            iterator = IteratorUtils.arrayListIterator((Object)intArray, (int)4);
            IteratorUtilsTest.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        iterator = IteratorUtils.arrayListIterator((Object)intArray, (int)2, (int)3);
        IteratorUtilsTest.assertTrue((!iterator.hasPrevious() ? 1 : 0) != 0);
        IteratorUtilsTest.assertTrue((iterator.previousIndex() == -1 ? 1 : 0) != 0);
        IteratorUtilsTest.assertTrue((boolean)iterator.next().equals(2));
        IteratorUtilsTest.assertTrue((boolean)iterator.hasPrevious());
        IteratorUtilsTest.assertTrue((!iterator.hasNext() ? 1 : 0) != 0);
        try {
            iterator = IteratorUtils.arrayListIterator((Object)intArray, (int)2, (int)4);
            IteratorUtilsTest.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            iterator = IteratorUtils.arrayListIterator((Object)intArray, (int)-1, (int)1);
            IteratorUtilsTest.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            iterator = IteratorUtils.arrayListIterator((Object)intArray, (int)2, (int)1);
            IteratorUtilsTest.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    private Iterator<String> getImmutableIterator() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("a");
        list.add("b");
        list.add("c");
        list.add("d");
        return IteratorUtils.unmodifiableIterator(list.iterator());
    }

    private ListIterator<String> getImmutableListIterator() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("a");
        list.add("b");
        list.add("c");
        list.add("d");
        return IteratorUtils.unmodifiableListIterator(list.listIterator());
    }

    public void testEmptyIterator() {
        IteratorUtilsTest.assertSame((Object)EmptyIterator.INSTANCE, (Object)IteratorUtils.EMPTY_ITERATOR);
        IteratorUtilsTest.assertSame((Object)EmptyIterator.RESETTABLE_INSTANCE, (Object)IteratorUtils.EMPTY_ITERATOR);
        IteratorUtilsTest.assertEquals((boolean)true, (boolean)(IteratorUtils.EMPTY_ITERATOR instanceof Iterator));
        IteratorUtilsTest.assertEquals((boolean)true, (boolean)(IteratorUtils.EMPTY_ITERATOR instanceof ResettableIterator));
        IteratorUtilsTest.assertEquals((boolean)false, (boolean)(IteratorUtils.EMPTY_ITERATOR instanceof OrderedIterator));
        IteratorUtilsTest.assertEquals((boolean)false, (boolean)(IteratorUtils.EMPTY_ITERATOR instanceof ListIterator));
        IteratorUtilsTest.assertEquals((boolean)false, (boolean)(IteratorUtils.EMPTY_ITERATOR instanceof MapIterator));
        IteratorUtilsTest.assertEquals((boolean)false, (boolean)IteratorUtils.EMPTY_ITERATOR.hasNext());
        IteratorUtils.EMPTY_ITERATOR.reset();
        IteratorUtilsTest.assertSame((Object)IteratorUtils.EMPTY_ITERATOR, (Object)IteratorUtils.EMPTY_ITERATOR);
        IteratorUtilsTest.assertSame((Object)IteratorUtils.EMPTY_ITERATOR, (Object)IteratorUtils.emptyIterator());
        try {
            IteratorUtils.EMPTY_ITERATOR.next();
            IteratorUtilsTest.fail();
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        try {
            IteratorUtils.EMPTY_ITERATOR.remove();
            IteratorUtilsTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testEmptyListIterator() {
        IteratorUtilsTest.assertSame((Object)EmptyListIterator.INSTANCE, (Object)IteratorUtils.EMPTY_LIST_ITERATOR);
        IteratorUtilsTest.assertSame((Object)EmptyListIterator.RESETTABLE_INSTANCE, (Object)IteratorUtils.EMPTY_LIST_ITERATOR);
        IteratorUtilsTest.assertEquals((boolean)true, (boolean)(IteratorUtils.EMPTY_LIST_ITERATOR instanceof Iterator));
        IteratorUtilsTest.assertEquals((boolean)true, (boolean)(IteratorUtils.EMPTY_LIST_ITERATOR instanceof ListIterator));
        IteratorUtilsTest.assertEquals((boolean)true, (boolean)(IteratorUtils.EMPTY_LIST_ITERATOR instanceof ResettableIterator));
        IteratorUtilsTest.assertEquals((boolean)true, (boolean)(IteratorUtils.EMPTY_LIST_ITERATOR instanceof ResettableListIterator));
        IteratorUtilsTest.assertEquals((boolean)false, (boolean)(IteratorUtils.EMPTY_LIST_ITERATOR instanceof MapIterator));
        IteratorUtilsTest.assertEquals((boolean)false, (boolean)IteratorUtils.EMPTY_LIST_ITERATOR.hasNext());
        IteratorUtilsTest.assertEquals((int)0, (int)IteratorUtils.EMPTY_LIST_ITERATOR.nextIndex());
        IteratorUtilsTest.assertEquals((int)-1, (int)IteratorUtils.EMPTY_LIST_ITERATOR.previousIndex());
        IteratorUtils.EMPTY_LIST_ITERATOR.reset();
        IteratorUtilsTest.assertSame((Object)IteratorUtils.EMPTY_LIST_ITERATOR, (Object)IteratorUtils.EMPTY_LIST_ITERATOR);
        IteratorUtilsTest.assertSame((Object)IteratorUtils.EMPTY_LIST_ITERATOR, (Object)IteratorUtils.emptyListIterator());
        try {
            IteratorUtils.EMPTY_LIST_ITERATOR.next();
            IteratorUtilsTest.fail();
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        try {
            IteratorUtils.EMPTY_LIST_ITERATOR.previous();
            IteratorUtilsTest.fail();
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        try {
            IteratorUtils.EMPTY_LIST_ITERATOR.remove();
            IteratorUtilsTest.fail();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        try {
            IteratorUtils.emptyListIterator().set(null);
            IteratorUtilsTest.fail();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        try {
            IteratorUtils.emptyListIterator().add(null);
            IteratorUtilsTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testEmptyMapIterator() {
        IteratorUtilsTest.assertSame((Object)EmptyMapIterator.INSTANCE, (Object)IteratorUtils.EMPTY_MAP_ITERATOR);
        IteratorUtilsTest.assertEquals((boolean)true, (boolean)(IteratorUtils.EMPTY_MAP_ITERATOR instanceof Iterator));
        IteratorUtilsTest.assertEquals((boolean)true, (boolean)(IteratorUtils.EMPTY_MAP_ITERATOR instanceof MapIterator));
        IteratorUtilsTest.assertEquals((boolean)true, (boolean)(IteratorUtils.EMPTY_MAP_ITERATOR instanceof ResettableIterator));
        IteratorUtilsTest.assertEquals((boolean)false, (boolean)(IteratorUtils.EMPTY_MAP_ITERATOR instanceof ListIterator));
        IteratorUtilsTest.assertEquals((boolean)false, (boolean)(IteratorUtils.EMPTY_MAP_ITERATOR instanceof OrderedIterator));
        IteratorUtilsTest.assertEquals((boolean)false, (boolean)(IteratorUtils.EMPTY_MAP_ITERATOR instanceof OrderedMapIterator));
        IteratorUtilsTest.assertEquals((boolean)false, (boolean)IteratorUtils.EMPTY_MAP_ITERATOR.hasNext());
        ((ResettableIterator)IteratorUtils.EMPTY_MAP_ITERATOR).reset();
        IteratorUtilsTest.assertSame((Object)IteratorUtils.EMPTY_MAP_ITERATOR, (Object)IteratorUtils.EMPTY_MAP_ITERATOR);
        IteratorUtilsTest.assertSame((Object)IteratorUtils.EMPTY_MAP_ITERATOR, (Object)IteratorUtils.emptyMapIterator());
        try {
            IteratorUtils.EMPTY_MAP_ITERATOR.next();
            IteratorUtilsTest.fail();
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        try {
            IteratorUtils.EMPTY_MAP_ITERATOR.remove();
            IteratorUtilsTest.fail();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        try {
            IteratorUtils.EMPTY_MAP_ITERATOR.getKey();
            IteratorUtilsTest.fail();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        try {
            IteratorUtils.EMPTY_MAP_ITERATOR.getValue();
            IteratorUtilsTest.fail();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        try {
            IteratorUtils.EMPTY_MAP_ITERATOR.setValue(null);
            IteratorUtilsTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testEmptyOrderedIterator() {
        IteratorUtilsTest.assertSame((Object)EmptyOrderedIterator.INSTANCE, (Object)IteratorUtils.EMPTY_ORDERED_ITERATOR);
        IteratorUtilsTest.assertEquals((boolean)true, (boolean)(IteratorUtils.EMPTY_ORDERED_ITERATOR instanceof Iterator));
        IteratorUtilsTest.assertEquals((boolean)true, (boolean)(IteratorUtils.EMPTY_ORDERED_ITERATOR instanceof OrderedIterator));
        IteratorUtilsTest.assertEquals((boolean)true, (boolean)(IteratorUtils.EMPTY_ORDERED_ITERATOR instanceof ResettableIterator));
        IteratorUtilsTest.assertEquals((boolean)false, (boolean)(IteratorUtils.EMPTY_ORDERED_ITERATOR instanceof ListIterator));
        IteratorUtilsTest.assertEquals((boolean)false, (boolean)(IteratorUtils.EMPTY_ORDERED_ITERATOR instanceof MapIterator));
        IteratorUtilsTest.assertEquals((boolean)false, (boolean)IteratorUtils.EMPTY_ORDERED_ITERATOR.hasNext());
        IteratorUtilsTest.assertEquals((boolean)false, (boolean)IteratorUtils.EMPTY_ORDERED_ITERATOR.hasPrevious());
        ((ResettableIterator)IteratorUtils.EMPTY_ORDERED_ITERATOR).reset();
        IteratorUtilsTest.assertSame((Object)IteratorUtils.EMPTY_ORDERED_ITERATOR, (Object)IteratorUtils.EMPTY_ORDERED_ITERATOR);
        IteratorUtilsTest.assertSame((Object)IteratorUtils.EMPTY_ORDERED_ITERATOR, (Object)IteratorUtils.emptyOrderedIterator());
        try {
            IteratorUtils.EMPTY_ORDERED_ITERATOR.next();
            IteratorUtilsTest.fail();
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        try {
            IteratorUtils.EMPTY_ORDERED_ITERATOR.previous();
            IteratorUtilsTest.fail();
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        try {
            IteratorUtils.EMPTY_ORDERED_ITERATOR.remove();
            IteratorUtilsTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testEmptyOrderedMapIterator() {
        IteratorUtilsTest.assertSame((Object)EmptyOrderedMapIterator.INSTANCE, (Object)IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR);
        IteratorUtilsTest.assertEquals((boolean)true, (boolean)(IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR instanceof Iterator));
        IteratorUtilsTest.assertEquals((boolean)true, (boolean)(IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR instanceof MapIterator));
        IteratorUtilsTest.assertEquals((boolean)true, (boolean)(IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR instanceof OrderedMapIterator));
        IteratorUtilsTest.assertEquals((boolean)true, (boolean)(IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR instanceof ResettableIterator));
        IteratorUtilsTest.assertEquals((boolean)false, (boolean)(IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR instanceof ListIterator));
        IteratorUtilsTest.assertEquals((boolean)false, (boolean)IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR.hasNext());
        IteratorUtilsTest.assertEquals((boolean)false, (boolean)IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR.hasPrevious());
        ((ResettableIterator)IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR).reset();
        IteratorUtilsTest.assertSame((Object)IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR, (Object)IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR);
        IteratorUtilsTest.assertSame((Object)IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR, (Object)IteratorUtils.emptyOrderedMapIterator());
        try {
            IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR.next();
            IteratorUtilsTest.fail();
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        try {
            IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR.previous();
            IteratorUtilsTest.fail();
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        try {
            IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR.remove();
            IteratorUtilsTest.fail();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        try {
            IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR.getKey();
            IteratorUtilsTest.fail();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        try {
            IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR.getValue();
            IteratorUtilsTest.fail();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        try {
            IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR.setValue(null);
            IteratorUtilsTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testUnmodifiableIteratorIteration() {
        Iterator<String> iterator = this.getImmutableIterator();
        IteratorUtilsTest.assertTrue((boolean)iterator.hasNext());
        IteratorUtilsTest.assertEquals((String)"a", (String)iterator.next());
        IteratorUtilsTest.assertTrue((boolean)iterator.hasNext());
        IteratorUtilsTest.assertEquals((String)"b", (String)iterator.next());
        IteratorUtilsTest.assertTrue((boolean)iterator.hasNext());
        IteratorUtilsTest.assertEquals((String)"c", (String)iterator.next());
        IteratorUtilsTest.assertTrue((boolean)iterator.hasNext());
        IteratorUtilsTest.assertEquals((String)"d", (String)iterator.next());
        IteratorUtilsTest.assertTrue((!iterator.hasNext() ? 1 : 0) != 0);
    }

    public void testUnmodifiableListIteratorIteration() {
        ListIterator<String> listIterator = this.getImmutableListIterator();
        IteratorUtilsTest.assertTrue((!listIterator.hasPrevious() ? 1 : 0) != 0);
        IteratorUtilsTest.assertTrue((boolean)listIterator.hasNext());
        IteratorUtilsTest.assertEquals((String)"a", (String)listIterator.next());
        IteratorUtilsTest.assertTrue((boolean)listIterator.hasPrevious());
        IteratorUtilsTest.assertTrue((boolean)listIterator.hasNext());
        IteratorUtilsTest.assertEquals((String)"b", (String)listIterator.next());
        IteratorUtilsTest.assertTrue((boolean)listIterator.hasPrevious());
        IteratorUtilsTest.assertTrue((boolean)listIterator.hasNext());
        IteratorUtilsTest.assertEquals((String)"c", (String)listIterator.next());
        IteratorUtilsTest.assertTrue((boolean)listIterator.hasPrevious());
        IteratorUtilsTest.assertTrue((boolean)listIterator.hasNext());
        IteratorUtilsTest.assertEquals((String)"d", (String)listIterator.next());
        IteratorUtilsTest.assertTrue((boolean)listIterator.hasPrevious());
        IteratorUtilsTest.assertTrue((!listIterator.hasNext() ? 1 : 0) != 0);
        IteratorUtilsTest.assertEquals((String)"d", (String)listIterator.previous());
        IteratorUtilsTest.assertTrue((boolean)listIterator.hasPrevious());
        IteratorUtilsTest.assertTrue((boolean)listIterator.hasNext());
        IteratorUtilsTest.assertEquals((String)"c", (String)listIterator.previous());
        IteratorUtilsTest.assertTrue((boolean)listIterator.hasPrevious());
        IteratorUtilsTest.assertTrue((boolean)listIterator.hasNext());
        IteratorUtilsTest.assertEquals((String)"b", (String)listIterator.previous());
        IteratorUtilsTest.assertTrue((boolean)listIterator.hasPrevious());
        IteratorUtilsTest.assertTrue((boolean)listIterator.hasNext());
        IteratorUtilsTest.assertEquals((String)"a", (String)listIterator.previous());
        IteratorUtilsTest.assertTrue((!listIterator.hasPrevious() ? 1 : 0) != 0);
        IteratorUtilsTest.assertTrue((boolean)listIterator.hasNext());
    }

    public void testUnmodifiableIteratorImmutability() {
        Iterator<String> iterator = this.getImmutableIterator();
        try {
            iterator.remove();
            IteratorUtilsTest.fail((String)"remove() should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        iterator.next();
        try {
            iterator.remove();
            IteratorUtilsTest.fail((String)"remove() should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testUnmodifiableListIteratorImmutability() {
        ListIterator<String> listIterator = this.getImmutableListIterator();
        try {
            listIterator.remove();
            IteratorUtilsTest.fail((String)"remove() should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            listIterator.set("a");
            IteratorUtilsTest.fail((String)"set(Object) should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            listIterator.add("a");
            IteratorUtilsTest.fail((String)"add(Object) should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        listIterator.next();
        try {
            listIterator.remove();
            IteratorUtilsTest.fail((String)"remove() should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            listIterator.set("a");
            IteratorUtilsTest.fail((String)"set(Object) should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            listIterator.add("a");
            IteratorUtilsTest.fail((String)"add(Object) should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testNodeListIterator() {
        Node[] nodes = this.createNodes();
        NodeList nodeList = this.createNodeList(nodes);
        NodeListIterator iterator = IteratorUtils.nodeListIterator((NodeList)nodeList);
        int expectedNodeIndex = 0;
        for (Node actual : IteratorUtils.asIterable((Iterator)iterator)) {
            IteratorUtilsTest.assertEquals((Object)nodes[expectedNodeIndex], (Object)actual);
            ++expectedNodeIndex;
        }
        IteratorUtilsTest.assertTrue((expectedNodeIndex > 0 ? 1 : 0) != 0);
        IteratorUtilsTest.assertFalse((String)"should not be able to iterate twice", (boolean)IteratorUtils.asIterable((Iterator)iterator).iterator().hasNext());
    }

    public void testNodeIterator() {
        Node[] nodes = this.createNodes();
        NodeList nodeList = this.createNodeList(nodes);
        Node parentNode = (Node)EasyMock.createMock(Node.class);
        EasyMock.expect((Object)parentNode.getChildNodes()).andStubReturn((Object)nodeList);
        EasyMock.replay((Object[])new Object[]{parentNode});
        NodeListIterator iterator = IteratorUtils.nodeListIterator((Node)parentNode);
        int expectedNodeIndex = 0;
        for (Node actual : IteratorUtils.asIterable((Iterator)iterator)) {
            IteratorUtilsTest.assertEquals((Object)nodes[expectedNodeIndex], (Object)actual);
            ++expectedNodeIndex;
        }
        IteratorUtilsTest.assertTrue((expectedNodeIndex > 0 ? 1 : 0) != 0);
        IteratorUtilsTest.assertFalse((String)"should not be able to iterate twice", (boolean)IteratorUtils.asIterable((Iterator)iterator).iterator().hasNext());
    }

    private Node[] createNodes() {
        Node node1 = (Node)EasyMock.createMock(Node.class);
        Node node2 = (Node)EasyMock.createMock(Node.class);
        Node node3 = (Node)EasyMock.createMock(Node.class);
        Node node4 = (Node)EasyMock.createMock(Node.class);
        EasyMock.replay((Object[])new Object[]{node1});
        EasyMock.replay((Object[])new Object[]{node2});
        EasyMock.replay((Object[])new Object[]{node3});
        EasyMock.replay((Object[])new Object[]{node4});
        return new Node[]{node1, node2, node3, node4};
    }

    private NodeList createNodeList(final Node[] nodes) {
        return new NodeList(){

            public Node item(int index) {
                return nodes[index];
            }

            public int getLength() {
                return nodes.length;
            }
        };
    }
}

