/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.functors.EqualPredicate;
import org.apache.commons.collections4.list.PredicatedList;

public class ListUtilsTest
extends BulkTest {
    private static final String a = "a";
    private static final String b = "b";
    private static final String c = "c";
    private static final String d = "d";
    private static final String e = "e";
    private static final String x = "x";
    private String[] fullArray;
    private List<String> fullList;
    private static Predicate<Number> EQUALS_TWO = new Predicate<Number>(){

        public boolean evaluate(Number input) {
            return input.intValue() == 2;
        }
    };

    public ListUtilsTest(String name) {
        super(name);
    }

    public static Test suite() {
        return BulkTest.makeSuite(ListUtilsTest.class);
    }

    public void setUp() {
        this.fullArray = new String[]{a, b, c, d, e};
        this.fullList = new ArrayList<String>(Arrays.asList(this.fullArray));
    }

    public void testNothing() {
    }

    public void testIntersectNonEmptyWithEmptyList() {
        List empty = Collections.emptyList();
        ListUtilsTest.assertTrue((String)"result not empty", (boolean)ListUtils.intersection(empty, this.fullList).isEmpty());
    }

    public void testIntersectEmptyWithEmptyList() {
        List empty = Collections.EMPTY_LIST;
        ListUtilsTest.assertTrue((String)"result not empty", (boolean)ListUtils.intersection((List)empty, (List)empty).isEmpty());
    }

    public void testIntersectNonEmptySubset() {
        ArrayList<String> other = new ArrayList<String>(this.fullList);
        ListUtilsTest.assertNotNull(other.remove(0));
        ListUtilsTest.assertNotNull(other.remove(1));
        ListUtilsTest.assertEquals(other, (Object)ListUtils.intersection(this.fullList, other));
    }

    public void testIntersectListWithNoOverlapAndDifferentTypes() {
        List<Integer> other = Arrays.asList(1, 23);
        ListUtilsTest.assertTrue((boolean)ListUtils.intersection(this.fullList, other).isEmpty());
    }

    public void testIntersectListWithSelf() {
        ListUtilsTest.assertEquals(this.fullList, (Object)ListUtils.intersection(this.fullList, this.fullList));
    }

    public void testIntersectionOrderInsensitivity() {
        ArrayList<String> one = new ArrayList<String>();
        ArrayList<String> two = new ArrayList<String>();
        one.add(a);
        one.add(b);
        two.add(a);
        two.add(a);
        two.add(b);
        two.add(b);
        ListUtilsTest.assertEquals((Object)ListUtils.intersection(one, two), (Object)ListUtils.intersection(two, one));
    }

    public void testPredicatedList() {
        Predicate<Object> predicate = new Predicate<Object>(){

            public boolean evaluate(Object o) {
                return o instanceof String;
            }
        };
        List list = ListUtils.predicatedList(new ArrayList(), (Predicate)predicate);
        ListUtilsTest.assertTrue((String)"returned object should be a PredicatedList", (boolean)(list instanceof PredicatedList));
        try {
            ListUtils.predicatedList(new ArrayList(), null);
            ListUtilsTest.fail((String)"Expecting IllegalArgumentException for null predicate.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            ListUtils.predicatedList(null, (Predicate)predicate);
            ListUtilsTest.fail((String)"Expecting IllegalArgumentException for null list.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testLazyList() {
        List list = ListUtils.lazyList(new ArrayList(), (Factory)new Factory<Integer>(){
            private int index;

            public Integer create() {
                ++this.index;
                return this.index;
            }
        });
        ListUtilsTest.assertNotNull(list.get(5));
        ListUtilsTest.assertEquals((int)6, (int)list.size());
        ListUtilsTest.assertNotNull(list.get(5));
        ListUtilsTest.assertEquals((int)6, (int)list.size());
    }

    public void testEmptyIfNull() {
        ListUtilsTest.assertTrue((boolean)ListUtils.emptyIfNull(null).isEmpty());
        ArrayList list = new ArrayList();
        ListUtilsTest.assertSame(list, (Object)ListUtils.emptyIfNull(list));
    }

    public void testDefaultIfNull() {
        ListUtilsTest.assertTrue((boolean)ListUtils.defaultIfNull(null, Collections.emptyList()).isEmpty());
        ArrayList list = new ArrayList();
        ListUtilsTest.assertSame(list, (Object)ListUtils.defaultIfNull(list, Collections.emptyList()));
    }

    public void testEquals() {
        List<String> data = Arrays.asList(a, b, c);
        ArrayList<String> a = new ArrayList<String>(data);
        ArrayList<String> b = new ArrayList<String>(data);
        ListUtilsTest.assertEquals((boolean)true, (boolean)a.equals(b));
        ListUtilsTest.assertEquals((boolean)true, (boolean)ListUtils.isEqualList(a, b));
        a.clear();
        ListUtilsTest.assertEquals((boolean)false, (boolean)ListUtils.isEqualList(a, b));
        ListUtilsTest.assertEquals((boolean)false, (boolean)ListUtils.isEqualList(a, null));
        ListUtilsTest.assertEquals((boolean)false, (boolean)ListUtils.isEqualList(null, b));
        ListUtilsTest.assertEquals((boolean)true, (boolean)ListUtils.isEqualList(null, null));
    }

    public void testHashCode() {
        List<String> data = Arrays.asList(a, b, c);
        ArrayList<String> a = new ArrayList<String>(data);
        ArrayList<String> b = new ArrayList<String>(data);
        ListUtilsTest.assertEquals((boolean)true, (a.hashCode() == b.hashCode() ? 1 : 0) != 0);
        ListUtilsTest.assertEquals((boolean)true, (a.hashCode() == ListUtils.hashCodeForList(a) ? 1 : 0) != 0);
        ListUtilsTest.assertEquals((boolean)true, (b.hashCode() == ListUtils.hashCodeForList(b) ? 1 : 0) != 0);
        ListUtilsTest.assertEquals((boolean)true, (ListUtils.hashCodeForList(a) == ListUtils.hashCodeForList(b) ? 1 : 0) != 0);
        a.clear();
        ListUtilsTest.assertEquals((boolean)false, (ListUtils.hashCodeForList(a) == ListUtils.hashCodeForList(b) ? 1 : 0) != 0);
        ListUtilsTest.assertEquals((int)0, (int)ListUtils.hashCodeForList(null));
    }

    public void testRetainAll() {
        ArrayList<String> sub = new ArrayList<String>();
        sub.add(a);
        sub.add(b);
        sub.add(x);
        List retained = ListUtils.retainAll(this.fullList, sub);
        ListUtilsTest.assertTrue((retained.size() == 2 ? 1 : 0) != 0);
        sub.remove(x);
        ListUtilsTest.assertTrue((boolean)retained.equals(sub));
        this.fullList.retainAll(sub);
        ListUtilsTest.assertTrue((boolean)retained.equals(this.fullList));
        try {
            ListUtils.retainAll(null, null);
            ListUtilsTest.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testRemoveAll() {
        ArrayList<String> sub = new ArrayList<String>();
        sub.add(a);
        sub.add(b);
        sub.add(x);
        List remainder = ListUtils.removeAll(this.fullList, sub);
        ListUtilsTest.assertTrue((remainder.size() == 3 ? 1 : 0) != 0);
        this.fullList.removeAll(sub);
        ListUtilsTest.assertTrue((boolean)remainder.equals(this.fullList));
        try {
            ListUtils.removeAll(null, null);
            ListUtilsTest.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testSubtract() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(a);
        list.add(b);
        list.add(a);
        list.add(x);
        ArrayList<String> sub = new ArrayList<String>();
        sub.add(a);
        List result = ListUtils.subtract(list, sub);
        ListUtilsTest.assertTrue((result.size() == 3 ? 1 : 0) != 0);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(b);
        expected.add(a);
        expected.add(x);
        ListUtilsTest.assertEquals(expected, (Object)result);
        try {
            ListUtils.subtract(list, null);
            ListUtilsTest.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
    }

    public void testSubtractNullElement() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(a);
        list.add(null);
        list.add(null);
        list.add(x);
        ArrayList<Object> sub = new ArrayList<Object>();
        sub.add(null);
        List result = ListUtils.subtract(list, sub);
        ListUtilsTest.assertTrue((result.size() == 3 ? 1 : 0) != 0);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(a);
        expected.add(null);
        expected.add(x);
        ListUtilsTest.assertEquals(expected, (Object)result);
    }

    public void testIndexOf() {
        Predicate testPredicate = EqualPredicate.equalPredicate((Object)d);
        int index = ListUtils.indexOf(this.fullList, (Predicate)testPredicate);
        ListUtilsTest.assertEquals((String)d, (String)this.fullList.get(index));
        testPredicate = EqualPredicate.equalPredicate((Object)"de");
        index = ListUtils.indexOf(this.fullList, (Predicate)testPredicate);
        ListUtilsTest.assertEquals((int)index, (int)-1);
        ListUtilsTest.assertEquals((int)ListUtils.indexOf(null, (Predicate)testPredicate), (int)-1);
        ListUtilsTest.assertEquals((int)ListUtils.indexOf(this.fullList, null), (int)-1);
    }

    public void testLongestCommonSubsequence() {
        try {
            ListUtils.longestCommonSubsequence((List)null, null);
            ListUtilsTest.fail((String)"failed to check for null argument");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            ListUtils.longestCommonSubsequence(Arrays.asList(Character.valueOf('A')), null);
            ListUtilsTest.fail((String)"failed to check for null argument");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            ListUtils.longestCommonSubsequence(null, Arrays.asList(Character.valueOf('A')));
            ListUtilsTest.fail((String)"failed to check for null argument");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        List lcs = ListUtils.longestCommonSubsequence((List)Collections.EMPTY_LIST, (List)Collections.EMPTY_LIST);
        ListUtilsTest.assertEquals((int)0, (int)lcs.size());
        List<Character> list1 = Arrays.asList(Character.valueOf('B'), Character.valueOf('A'), Character.valueOf('N'), Character.valueOf('A'), Character.valueOf('N'), Character.valueOf('A'));
        List<Character> list2 = Arrays.asList(Character.valueOf('A'), Character.valueOf('N'), Character.valueOf('A'), Character.valueOf('N'), Character.valueOf('A'), Character.valueOf('S'));
        lcs = ListUtils.longestCommonSubsequence(list1, list2);
        List<Character> expected = Arrays.asList(Character.valueOf('A'), Character.valueOf('N'), Character.valueOf('A'), Character.valueOf('N'), Character.valueOf('A'));
        ListUtilsTest.assertEquals(expected, (Object)lcs);
        List<Character> list3 = Arrays.asList(Character.valueOf('A'), Character.valueOf('T'), Character.valueOf('A'), Character.valueOf('N'), Character.valueOf('A'));
        lcs = ListUtils.longestCommonSubsequence(list1, list3);
        expected = Arrays.asList(Character.valueOf('A'), Character.valueOf('A'), Character.valueOf('N'), Character.valueOf('A'));
        ListUtilsTest.assertEquals(expected, (Object)lcs);
        List<Character> listZorro = Arrays.asList(Character.valueOf('Z'), Character.valueOf('O'), Character.valueOf('R'), Character.valueOf('R'), Character.valueOf('O'));
        lcs = ListUtils.longestCommonSubsequence(list1, listZorro);
        ListUtilsTest.assertTrue((boolean)lcs.isEmpty());
    }

    public void testLongestCommonSubsequenceWithString() {
        try {
            ListUtils.longestCommonSubsequence((CharSequence)null, null);
            ListUtilsTest.fail((String)"failed to check for null argument");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            ListUtils.longestCommonSubsequence((CharSequence)"A", null);
            ListUtilsTest.fail((String)"failed to check for null argument");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            ListUtils.longestCommonSubsequence(null, (CharSequence)"A");
            ListUtilsTest.fail((String)"failed to check for null argument");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        String lcs = ListUtils.longestCommonSubsequence((CharSequence)"", (CharSequence)"");
        ListUtilsTest.assertEquals((int)0, (int)lcs.length());
        String banana = "BANANA";
        String ananas = "ANANAS";
        lcs = ListUtils.longestCommonSubsequence((CharSequence)banana, (CharSequence)ananas);
        ListUtilsTest.assertEquals((String)"ANANA", (String)lcs);
        String atana = "ATANA";
        lcs = ListUtils.longestCommonSubsequence((CharSequence)banana, (CharSequence)atana);
        ListUtilsTest.assertEquals((String)"AANA", (String)lcs);
        String zorro = "ZORRO";
        lcs = ListUtils.longestCommonSubsequence((CharSequence)banana, (CharSequence)zorro);
        ListUtilsTest.assertEquals((int)0, (int)lcs.length());
    }

    public void testPartition() {
        ArrayList<Integer> strings = new ArrayList<Integer>();
        for (int i = 0; i <= 6; ++i) {
            strings.add(i);
        }
        List partition = ListUtils.partition(strings, (int)3);
        ListUtilsTest.assertNotNull((Object)partition);
        ListUtilsTest.assertEquals((int)3, (int)partition.size());
        ListUtilsTest.assertEquals((int)1, (int)((List)partition.get(2)).size());
        try {
            ListUtils.partition(null, (int)3);
            ListUtilsTest.fail((String)"failed to check for null argument");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            ListUtils.partition(strings, (int)0);
            ListUtilsTest.fail((String)"failed to check for size argument");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            ListUtils.partition(strings, (int)-10);
            ListUtilsTest.fail((String)"failed to check for size argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSelect() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        List output1 = ListUtils.select(list, EQUALS_TWO);
        List output2 = ListUtils.select(list, EQUALS_TWO);
        HashSet output3 = (HashSet)CollectionUtils.select(list, EQUALS_TWO, new HashSet());
        ListUtilsTest.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)output1, (Collection)output3));
        ListUtilsTest.assertEquals((int)4, (int)list.size());
        ListUtilsTest.assertEquals((int)1, (int)output1.size());
        ListUtilsTest.assertEquals((Object)2, output2.iterator().next());
    }

    public void testSelectRejected() {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(1L);
        list.add(2L);
        list.add(3L);
        list.add(4L);
        List output1 = ListUtils.selectRejected(list, EQUALS_TWO);
        List output2 = ListUtils.selectRejected(list, EQUALS_TWO);
        HashSet output3 = (HashSet)CollectionUtils.selectRejected(list, EQUALS_TWO, new HashSet());
        ListUtilsTest.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)output1, (Collection)output2));
        ListUtilsTest.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)output1, (Collection)output3));
        ListUtilsTest.assertEquals((int)4, (int)list.size());
        ListUtilsTest.assertEquals((int)3, (int)output1.size());
        ListUtilsTest.assertTrue((boolean)output1.contains(1L));
        ListUtilsTest.assertTrue((boolean)output1.contains(3L));
        ListUtilsTest.assertTrue((boolean)output1.contains(4L));
    }
}

