/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListResourceBundle;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.FactoryUtils;
import org.apache.commons.collections4.IterableMap;
import org.apache.commons.collections4.IterableSortedMap;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.MultiMap;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import org.apache.commons.collections4.collection.TransformedCollectionTest;
import org.apache.commons.collections4.keyvalue.DefaultKeyValue;
import org.apache.commons.collections4.keyvalue.DefaultMapEntry;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.collections4.map.LazyMap;
import org.apache.commons.collections4.map.MultiValueMap;
import org.apache.commons.collections4.map.PredicatedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapUtilsTest
extends BulkTest {
    public MapUtilsTest(String name) {
        super(name);
    }

    public static Test suite() {
        return BulkTest.makeSuite(MapUtilsTest.class);
    }

    public Predicate<Object> getPredicate() {
        return new Predicate<Object>(){

            public boolean evaluate(Object o) {
                return o instanceof String;
            }
        };
    }

    public void testPredicatedMap() {
        Predicate<Object> p = this.getPredicate();
        IterableMap map = MapUtils.predicatedMap(new HashMap(), p, p);
        MapUtilsTest.assertTrue((String)"returned object should be a PredicatedMap", (boolean)(map instanceof PredicatedMap));
        try {
            MapUtils.predicatedMap(null, p, p);
            MapUtilsTest.fail((String)"Expecting IllegalArgumentException for null map.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testLazyMapFactory() {
        Factory factory = FactoryUtils.constantFactory((Object)5);
        IterableMap map = MapUtils.lazyMap(new HashMap(), (Factory)factory);
        MapUtilsTest.assertTrue((boolean)(map instanceof LazyMap));
        try {
            map = MapUtils.lazyMap(new HashMap(), (Factory)null);
            MapUtilsTest.fail((String)"Expecting IllegalArgumentException for null factory");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            map = MapUtils.lazyMap((Map)null, (Factory)factory);
            MapUtilsTest.fail((String)"Expecting IllegalArgumentException for null map");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        Transformer transformer = TransformerUtils.asTransformer((Factory)factory);
        map = MapUtils.lazyMap(new HashMap(), (Transformer)transformer);
        MapUtilsTest.assertTrue((boolean)(map instanceof LazyMap));
        try {
            map = MapUtils.lazyMap(new HashMap(), (Transformer)null);
            MapUtilsTest.fail((String)"Expecting IllegalArgumentException for null transformer");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            map = MapUtils.lazyMap((Map)null, (Transformer)transformer);
            MapUtilsTest.fail((String)"Expecting IllegalArgumentException for null map");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void testLazyMapTransformer() {
        IterableMap map = MapUtils.lazyMap(new HashMap(), (Transformer)new Transformer<Object, Object>(){

            public Object transform(Object mapKey) {
                if (mapKey instanceof String) {
                    return Integer.valueOf((String)mapKey);
                }
                return null;
            }
        });
        MapUtilsTest.assertEquals((int)0, (int)map.size());
        Integer i1 = (Integer)map.get("5");
        MapUtilsTest.assertEquals((Object)5, (Object)i1);
        MapUtilsTest.assertEquals((int)1, (int)map.size());
        Integer i2 = (Integer)map.get(new String(new char[]{'5'}));
        MapUtilsTest.assertEquals((Object)5, (Object)i2);
        MapUtilsTest.assertEquals((int)1, (int)map.size());
        MapUtilsTest.assertSame((Object)i1, (Object)i2);
    }

    public void testInvertMap() {
        HashMap<String, String> in = new HashMap<String, String>(5, 1.0f);
        in.put("1", "A");
        in.put("2", "B");
        in.put("3", "C");
        in.put("4", "D");
        in.put("5", "E");
        HashSet inKeySet = new HashSet(in.keySet());
        HashSet inValSet = new HashSet(in.values());
        Map out = MapUtils.invertMap(in);
        HashSet outKeySet = new HashSet(out.keySet());
        HashSet outValSet = new HashSet(out.values());
        MapUtilsTest.assertTrue((boolean)inKeySet.equals(outValSet));
        MapUtilsTest.assertTrue((boolean)inValSet.equals(outKeySet));
        MapUtilsTest.assertEquals((String)"1", (String)((String)out.get("A")));
        MapUtilsTest.assertEquals((String)"2", (String)((String)out.get("B")));
        MapUtilsTest.assertEquals((String)"3", (String)((String)out.get("C")));
        MapUtilsTest.assertEquals((String)"4", (String)((String)out.get("D")));
        MapUtilsTest.assertEquals((String)"5", (String)((String)out.get("E")));
    }

    public void testPutAll_Map_array() {
        try {
            MapUtils.putAll(null, null);
            MapUtilsTest.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            MapUtils.putAll(null, (Object[])new Object[0]);
            MapUtilsTest.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        Map test = MapUtils.putAll(new HashMap(), (Object[])new String[0]);
        MapUtilsTest.assertEquals((int)0, (int)test.size());
        test = MapUtils.putAll(new HashMap(), (Object[])new String[][]{{"RED", "#FF0000"}, {"GREEN", "#00FF00"}, {"BLUE", "#0000FF"}});
        MapUtilsTest.assertEquals((boolean)true, (boolean)test.containsKey("RED"));
        MapUtilsTest.assertEquals((String)"#FF0000", (String)((String)test.get("RED")));
        MapUtilsTest.assertEquals((boolean)true, (boolean)test.containsKey("GREEN"));
        MapUtilsTest.assertEquals((String)"#00FF00", (String)((String)test.get("GREEN")));
        MapUtilsTest.assertEquals((boolean)true, (boolean)test.containsKey("BLUE"));
        MapUtilsTest.assertEquals((String)"#0000FF", (String)((String)test.get("BLUE")));
        MapUtilsTest.assertEquals((int)3, (int)test.size());
        try {
            MapUtils.putAll(new HashMap(), (Object[])new String[][]{{"RED", "#FF0000"}, null, {"BLUE", "#0000FF"}});
            MapUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            MapUtils.putAll(new HashMap(), (Object[])new String[][]{{"RED", "#FF0000"}, {"GREEN"}, {"BLUE", "#0000FF"}});
            MapUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            MapUtils.putAll(new HashMap(), (Object[])new String[][]{{"RED", "#FF0000"}, new String[0], {"BLUE", "#0000FF"}});
            MapUtilsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        test = MapUtils.putAll(new HashMap(), (Object[])new String[]{"RED", "#FF0000", "GREEN", "#00FF00", "BLUE", "#0000FF"});
        MapUtilsTest.assertEquals((boolean)true, (boolean)test.containsKey("RED"));
        MapUtilsTest.assertEquals((String)"#FF0000", (String)((String)test.get("RED")));
        MapUtilsTest.assertEquals((boolean)true, (boolean)test.containsKey("GREEN"));
        MapUtilsTest.assertEquals((String)"#00FF00", (String)((String)test.get("GREEN")));
        MapUtilsTest.assertEquals((boolean)true, (boolean)test.containsKey("BLUE"));
        MapUtilsTest.assertEquals((String)"#0000FF", (String)((String)test.get("BLUE")));
        MapUtilsTest.assertEquals((int)3, (int)test.size());
        test = MapUtils.putAll(new HashMap(), (Object[])new String[]{"RED", "#FF0000", "GREEN", "#00FF00", "BLUE", "#0000FF", "PURPLE"});
        MapUtilsTest.assertEquals((boolean)true, (boolean)test.containsKey("RED"));
        MapUtilsTest.assertEquals((String)"#FF0000", (String)((String)test.get("RED")));
        MapUtilsTest.assertEquals((boolean)true, (boolean)test.containsKey("GREEN"));
        MapUtilsTest.assertEquals((String)"#00FF00", (String)((String)test.get("GREEN")));
        MapUtilsTest.assertEquals((boolean)true, (boolean)test.containsKey("BLUE"));
        MapUtilsTest.assertEquals((String)"#0000FF", (String)((String)test.get("BLUE")));
        MapUtilsTest.assertEquals((int)3, (int)test.size());
        test = MapUtils.putAll(new HashMap(), (Object[])new Object[]{new DefaultMapEntry((Object)"RED", (Object)"#FF0000"), new DefaultMapEntry((Object)"GREEN", (Object)"#00FF00"), new DefaultMapEntry((Object)"BLUE", (Object)"#0000FF")});
        MapUtilsTest.assertEquals((boolean)true, (boolean)test.containsKey("RED"));
        MapUtilsTest.assertEquals((String)"#FF0000", (String)((String)test.get("RED")));
        MapUtilsTest.assertEquals((boolean)true, (boolean)test.containsKey("GREEN"));
        MapUtilsTest.assertEquals((String)"#00FF00", (String)((String)test.get("GREEN")));
        MapUtilsTest.assertEquals((boolean)true, (boolean)test.containsKey("BLUE"));
        MapUtilsTest.assertEquals((String)"#0000FF", (String)((String)test.get("BLUE")));
        MapUtilsTest.assertEquals((int)3, (int)test.size());
        test = MapUtils.putAll(new HashMap(), (Object[])new Object[]{new DefaultKeyValue((Object)"RED", (Object)"#FF0000"), new DefaultKeyValue((Object)"GREEN", (Object)"#00FF00"), new DefaultKeyValue((Object)"BLUE", (Object)"#0000FF")});
        MapUtilsTest.assertEquals((boolean)true, (boolean)test.containsKey("RED"));
        MapUtilsTest.assertEquals((String)"#FF0000", (String)((String)test.get("RED")));
        MapUtilsTest.assertEquals((boolean)true, (boolean)test.containsKey("GREEN"));
        MapUtilsTest.assertEquals((String)"#00FF00", (String)((String)test.get("GREEN")));
        MapUtilsTest.assertEquals((boolean)true, (boolean)test.containsKey("BLUE"));
        MapUtilsTest.assertEquals((String)"#0000FF", (String)((String)test.get("BLUE")));
        MapUtilsTest.assertEquals((int)3, (int)test.size());
    }

    public void testConvertResourceBundle() {
        final HashMap<String, String> in = new HashMap<String, String>(5, 1.0f);
        in.put("1", "A");
        in.put("2", "B");
        in.put("3", "C");
        in.put("4", "D");
        in.put("5", "E");
        ListResourceBundle b = new ListResourceBundle(){

            public Object[][] getContents() {
                Object[][] contents = new Object[in.size()][2];
                Iterator i = in.keySet().iterator();
                int n = 0;
                while (i.hasNext()) {
                    Object key = i.next();
                    Object val = in.get(key);
                    contents[n][0] = key;
                    contents[n][1] = val;
                    ++n;
                }
                return contents;
            }
        };
        Map out = MapUtils.toMap((ResourceBundle)b);
        MapUtilsTest.assertTrue((boolean)in.equals(out));
    }

    public void testDebugAndVerbosePrintCasting() {
        HashMap<Integer, String> inner = new HashMap<Integer, String>(2, 1.0f);
        inner.put(2, "B");
        inner.put(3, "C");
        HashMap<Integer, Object> outer = new HashMap<Integer, Object>(2, 1.0f);
        outer.put(0, inner);
        outer.put(1, "A");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        try {
            MapUtils.debugPrint((PrintStream)outPrint, (Object)"Print Map", outer);
        }
        catch (ClassCastException e) {
            MapUtilsTest.fail((String)"No Casting should be occurring!");
        }
    }

    public void testDebugAndVerbosePrintNullMap() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String LABEL = "Print Map";
        outPrint.println("Print Map = " + String.valueOf((Object)null));
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.debugPrint((PrintStream)outPrint, (Object)"Print Map", null);
        MapUtilsTest.assertEquals((String)EXPECTED_OUT, (String)out.toString());
        out.reset();
        MapUtils.verbosePrint((PrintStream)outPrint, (Object)"Print Map", null);
        MapUtilsTest.assertEquals((String)EXPECTED_OUT, (String)out.toString());
    }

    public void testVerbosePrintNullLabel() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String INDENT = "    ";
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        map.put(2, "B");
        map.put(3, "C");
        map.put(4, null);
        outPrint.println("{");
        outPrint.println("    2 = B");
        outPrint.println("    3 = C");
        outPrint.println("    4 = null");
        outPrint.println("}");
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.verbosePrint((PrintStream)outPrint, null, map);
        MapUtilsTest.assertEquals((String)EXPECTED_OUT, (String)out.toString());
    }

    public void testDebugPrintNullLabel() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String INDENT = "    ";
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        map.put(2, "B");
        map.put(3, "C");
        map.put(4, null);
        outPrint.println("{");
        outPrint.println("    2 = B " + String.class.getName());
        outPrint.println("    3 = C " + String.class.getName());
        outPrint.println("    4 = null");
        outPrint.println("} " + TreeMap.class.getName());
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.debugPrint((PrintStream)outPrint, null, map);
        MapUtilsTest.assertEquals((String)EXPECTED_OUT, (String)out.toString());
    }

    public void testVerbosePrintNullLabelAndMap() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        outPrint.println("null");
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.verbosePrint((PrintStream)outPrint, null, null);
        MapUtilsTest.assertEquals((String)EXPECTED_OUT, (String)out.toString());
    }

    public void testDebugPrintNullLabelAndMap() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        outPrint.println("null");
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.debugPrint((PrintStream)outPrint, null, null);
        MapUtilsTest.assertEquals((String)EXPECTED_OUT, (String)out.toString());
    }

    public void testVerbosePrintNullStream() {
        try {
            MapUtils.verbosePrint(null, (Object)"Map", new HashMap());
            MapUtilsTest.fail((String)"Should generate NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDebugPrintNullStream() {
        try {
            MapUtils.debugPrint(null, (Object)"Map", new HashMap());
            MapUtilsTest.fail((String)"Should generate NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDebugPrintNullKey() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String INDENT = "    ";
        HashMap<Object, String> map = new HashMap<Object, String>();
        map.put(null, "A");
        outPrint.println("{");
        outPrint.println("    null = A " + String.class.getName());
        outPrint.println("} " + HashMap.class.getName());
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.debugPrint((PrintStream)outPrint, null, map);
        MapUtilsTest.assertEquals((String)EXPECTED_OUT, (String)out.toString());
    }

    public void testVerbosePrintNullKey() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String INDENT = "    ";
        HashMap<Object, String> map = new HashMap<Object, String>();
        map.put(null, "A");
        outPrint.println("{");
        outPrint.println("    null = A");
        outPrint.println("}");
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.verbosePrint((PrintStream)outPrint, null, map);
        MapUtilsTest.assertEquals((String)EXPECTED_OUT, (String)out.toString());
    }

    public void testDebugPrintNullKeyToMap1() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String INDENT = "    ";
        HashMap map = new HashMap();
        map.put(null, map);
        outPrint.println("{");
        outPrint.println("    null = (this Map) " + HashMap.class.getName());
        outPrint.println("} " + HashMap.class.getName());
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.debugPrint((PrintStream)outPrint, null, map);
        MapUtilsTest.assertEquals((String)EXPECTED_OUT, (String)out.toString());
    }

    public void testVerbosePrintNullKeyToMap1() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String INDENT = "    ";
        HashMap map = new HashMap();
        map.put(null, map);
        outPrint.println("{");
        outPrint.println("    null = (this Map)");
        outPrint.println("}");
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.verbosePrint((PrintStream)outPrint, null, map);
        MapUtilsTest.assertEquals((String)EXPECTED_OUT, (String)out.toString());
    }

    public void testDebugPrintNullKeyToMap2() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String INDENT = "    ";
        HashMap map = new HashMap();
        HashMap<String, String> map2 = new HashMap<String, String>();
        map.put(null, map2);
        map2.put("2", "B");
        outPrint.println("{");
        outPrint.println("    null = ");
        outPrint.println("    {");
        outPrint.println("        2 = B " + String.class.getName());
        outPrint.println("    } " + HashMap.class.getName());
        outPrint.println("} " + HashMap.class.getName());
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.debugPrint((PrintStream)outPrint, null, map);
        MapUtilsTest.assertEquals((String)EXPECTED_OUT, (String)out.toString());
    }

    public void testVerbosePrintNullKeyToMap2() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String INDENT = "    ";
        HashMap map = new HashMap();
        HashMap<String, String> map2 = new HashMap<String, String>();
        map.put(null, map2);
        map2.put("2", "B");
        outPrint.println("{");
        outPrint.println("    null = ");
        outPrint.println("    {");
        outPrint.println("        2 = B");
        outPrint.println("    }");
        outPrint.println("}");
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.verbosePrint((PrintStream)outPrint, null, map);
        MapUtilsTest.assertEquals((String)EXPECTED_OUT, (String)out.toString());
    }

    public void testVerbosePrint() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String LABEL = "Print Map";
        String INDENT = "    ";
        outPrint.println("Print Map = ");
        outPrint.println("{");
        outPrint.println("    0 = A");
        outPrint.println("    1 = ");
        outPrint.println("    {");
        outPrint.println("        2 = B");
        outPrint.println("        3 = C");
        outPrint.println("    }");
        outPrint.println("    7 = (this Map)");
        outPrint.println("}");
        String EXPECTED_OUT = out.toString();
        out.reset();
        TreeMap<Integer, String> inner = new TreeMap<Integer, String>();
        inner.put(2, "B");
        inner.put(3, "C");
        TreeMap<Integer, Object> outer = new TreeMap<Integer, Object>();
        outer.put(1, inner);
        outer.put(0, "A");
        outer.put(7, outer);
        MapUtils.verbosePrint((PrintStream)outPrint, (Object)"Print Map", outer);
        MapUtilsTest.assertEquals((String)EXPECTED_OUT, (String)out.toString());
    }

    public void testDebugPrint() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String LABEL = "Print Map";
        String INDENT = "    ";
        outPrint.println("Print Map = ");
        outPrint.println("{");
        outPrint.println("    0 = A " + String.class.getName());
        outPrint.println("    1 = ");
        outPrint.println("    {");
        outPrint.println("        2 = B " + String.class.getName());
        outPrint.println("        3 = C " + String.class.getName());
        outPrint.println("    } " + TreeMap.class.getName());
        outPrint.println("    7 = (this Map) " + TreeMap.class.getName());
        outPrint.println("} " + TreeMap.class.getName());
        String EXPECTED_OUT = out.toString();
        out.reset();
        TreeMap<Integer, String> inner = new TreeMap<Integer, String>();
        inner.put(2, "B");
        inner.put(3, "C");
        TreeMap<Integer, Object> outer = new TreeMap<Integer, Object>();
        outer.put(1, inner);
        outer.put(0, "A");
        outer.put(7, outer);
        MapUtils.debugPrint((PrintStream)outPrint, (Object)"Print Map", outer);
        MapUtilsTest.assertEquals((String)EXPECTED_OUT, (String)out.toString());
    }

    public void testVerbosePrintSelfReference() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String LABEL = "Print Map";
        String INDENT = "    ";
        TreeMap<Integer, Object> grandfather = new TreeMap<Integer, Object>();
        TreeMap<Integer, Object> father = new TreeMap<Integer, Object>();
        TreeMap<Integer, Object> son = new TreeMap<Integer, Object>();
        grandfather.put(0, "A");
        grandfather.put(1, father);
        father.put(2, "B");
        father.put(3, grandfather);
        father.put(4, son);
        son.put(5, "C");
        son.put(6, grandfather);
        son.put(7, father);
        outPrint.println("Print Map = ");
        outPrint.println("{");
        outPrint.println("    0 = A");
        outPrint.println("    1 = ");
        outPrint.println("    {");
        outPrint.println("        2 = B");
        outPrint.println("        3 = (ancestor[0] Map)");
        outPrint.println("        4 = ");
        outPrint.println("        {");
        outPrint.println("            5 = C");
        outPrint.println("            6 = (ancestor[1] Map)");
        outPrint.println("            7 = (ancestor[0] Map)");
        outPrint.println("        }");
        outPrint.println("    }");
        outPrint.println("}");
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.verbosePrint((PrintStream)outPrint, (Object)"Print Map", grandfather);
        MapUtilsTest.assertEquals((String)EXPECTED_OUT, (String)out.toString());
    }

    public void testDebugPrintSelfReference() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String LABEL = "Print Map";
        String INDENT = "    ";
        TreeMap<Integer, Object> grandfather = new TreeMap<Integer, Object>();
        TreeMap<Integer, Object> father = new TreeMap<Integer, Object>();
        TreeMap<Integer, Object> son = new TreeMap<Integer, Object>();
        grandfather.put(0, "A");
        grandfather.put(1, father);
        father.put(2, "B");
        father.put(3, grandfather);
        father.put(4, son);
        son.put(5, "C");
        son.put(6, grandfather);
        son.put(7, father);
        outPrint.println("Print Map = ");
        outPrint.println("{");
        outPrint.println("    0 = A " + String.class.getName());
        outPrint.println("    1 = ");
        outPrint.println("    {");
        outPrint.println("        2 = B " + String.class.getName());
        outPrint.println("        3 = (ancestor[0] Map) " + TreeMap.class.getName());
        outPrint.println("        4 = ");
        outPrint.println("        {");
        outPrint.println("            5 = C " + String.class.getName());
        outPrint.println("            6 = (ancestor[1] Map) " + TreeMap.class.getName());
        outPrint.println("            7 = (ancestor[0] Map) " + TreeMap.class.getName());
        outPrint.println("        } " + TreeMap.class.getName());
        outPrint.println("    } " + TreeMap.class.getName());
        outPrint.println("} " + TreeMap.class.getName());
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.debugPrint((PrintStream)outPrint, (Object)"Print Map", grandfather);
        MapUtilsTest.assertEquals((String)EXPECTED_OUT, (String)out.toString());
    }

    public void testEmptyIfNull() {
        MapUtilsTest.assertTrue((boolean)MapUtils.emptyIfNull(null).isEmpty());
        HashMap map = new HashMap();
        MapUtilsTest.assertSame(map, (Object)MapUtils.emptyIfNull(map));
    }

    public void testIsEmptyWithEmptyMap() {
        HashMap map = new HashMap();
        MapUtilsTest.assertEquals((boolean)true, (boolean)MapUtils.isEmpty(map));
    }

    public void testIsEmptyWithNonEmptyMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("item", "value");
        MapUtilsTest.assertEquals((boolean)false, (boolean)MapUtils.isEmpty(map));
    }

    public void testIsEmptyWithNull() {
        Map map = null;
        MapUtilsTest.assertEquals((boolean)true, (boolean)MapUtils.isEmpty(map));
    }

    public void testIsNotEmptyWithEmptyMap() {
        HashMap map = new HashMap();
        MapUtilsTest.assertEquals((boolean)false, (boolean)MapUtils.isNotEmpty(map));
    }

    public void testIsNotEmptyWithNonEmptyMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("item", "value");
        MapUtilsTest.assertEquals((boolean)true, (boolean)MapUtils.isNotEmpty(map));
    }

    public void testIsNotEmptyWithNull() {
        Map map = null;
        MapUtilsTest.assertEquals((boolean)false, (boolean)MapUtils.isNotEmpty(map));
    }

    public void testPopulateMap() {
        int i;
        ArrayList<String> list = new ArrayList<String>();
        list.add("1");
        list.add("3");
        list.add("5");
        list.add("7");
        list.add("2");
        list.add("4");
        list.add("6");
        HashMap map = new HashMap();
        MapUtils.populateMap(map, list, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        MapUtilsTest.assertEquals((int)list.size(), (int)map.size());
        for (i = 0; i < list.size(); ++i) {
            MapUtilsTest.assertEquals((boolean)true, (boolean)map.containsKey(Integer.valueOf((String)list.get(i))));
            MapUtilsTest.assertEquals((boolean)false, (boolean)map.containsKey(list.get(i)));
            MapUtilsTest.assertEquals((boolean)true, (boolean)map.containsValue(list.get(i)));
            MapUtilsTest.assertEquals(list.get(i), map.get(Integer.valueOf((String)list.get(i))));
        }
        map = new HashMap();
        MapUtils.populateMap(map, list, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        MapUtilsTest.assertEquals((int)list.size(), (int)map.size());
        for (i = 0; i < list.size(); ++i) {
            MapUtilsTest.assertEquals((boolean)true, (boolean)map.containsKey(Integer.valueOf((String)list.get(i))));
            MapUtilsTest.assertEquals((boolean)false, (boolean)map.containsKey(list.get(i)));
            MapUtilsTest.assertEquals((boolean)true, (boolean)map.containsValue(Integer.valueOf((String)list.get(i))));
            MapUtilsTest.assertEquals((Object)Integer.valueOf((String)list.get(i)), map.get(Integer.valueOf((String)list.get(i))));
        }
    }

    public void testPopulateMultiMap() {
        ArrayList<X> list = new ArrayList<X>();
        list.add(new X(1, "x1"));
        list.add(new X(2, "x2"));
        list.add(new X(2, "x3"));
        list.add(new X(5, "x4"));
        list.add(new X(5, "x5"));
        MultiValueMap map = MultiValueMap.multiValueMap(new TreeMap());
        MapUtils.populateMap((MultiMap)map, list, (Transformer)new Transformer<X, Integer>(){

            public Integer transform(X input) {
                return input.key;
            }
        }, (Transformer)TransformerUtils.nopTransformer());
        MapUtilsTest.assertEquals((int)list.size(), (int)map.totalSize());
        for (int i = 0; i < list.size(); ++i) {
            MapUtilsTest.assertEquals((boolean)true, (boolean)map.containsKey((Object)((X)list.get((int)i)).key));
            MapUtilsTest.assertEquals((boolean)true, (boolean)map.containsValue(list.get(i)));
        }
    }

    public void testIterableMap() {
        try {
            MapUtils.iterableMap(null);
            MapUtilsTest.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "foov");
        map.put("bar", "barv");
        map.put("baz", "bazv");
        IterableMap iMap = MapUtils.iterableMap(map);
        MapUtilsTest.assertEquals(map, (Object)iMap);
        MapUtilsTest.assertNotSame(map, (Object)iMap);
        HashedMap hMap = new HashedMap(map);
        MapUtilsTest.assertSame((Object)hMap, (Object)MapUtils.iterableMap((Map)hMap));
    }

    public void testIterableSortedMap() {
        try {
            MapUtils.iterableSortedMap(null);
            MapUtilsTest.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("foo", "foov");
        map.put("bar", "barv");
        map.put("baz", "bazv");
        IterableSortedMap iMap = MapUtils.iterableSortedMap(map);
        MapUtilsTest.assertEquals(map, (Object)iMap);
        MapUtilsTest.assertNotSame(map, (Object)iMap);
        MapUtilsTest.assertSame((Object)iMap, (Object)MapUtils.iterableMap((Map)iMap));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class X
    implements Comparable<X> {
        int key;
        String name;

        public X(int key, String name) {
            this.key = key;
            this.name = name;
        }

        @Override
        public int compareTo(X o) {
            return this.key - o.key | this.name.compareTo(o.name);
        }
    }
}

