/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MockTestCase {
    private final List<Object> mockObjects = new ArrayList<Object>();

    protected <T> T createMock(Class<?> name) {
        Object mock = EasyMock.createMock(name);
        return (T)this.registerMock(mock);
    }

    private <T> T registerMock(T mock) {
        this.mockObjects.add(mock);
        return mock;
    }

    protected <T> IExpectationSetters<T> expect(T t) {
        return EasyMock.expect(t);
    }

    protected final void replay() {
        for (Object o : this.mockObjects) {
            EasyMock.replay((Object[])new Object[]{o});
        }
    }

    protected final void verify() {
        ListIterator<Object> i = this.mockObjects.listIterator();
        while (i.hasNext()) {
            try {
                EasyMock.verify((Object[])new Object[]{i.next()});
            }
            catch (AssertionError e) {
                throw new AssertionError((Object)(i.previousIndex() + 1 + "" + ((Throwable)((Object)e)).getMessage()));
            }
        }
    }
}

