/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.LinkedList;
import java.util.Queue;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.QueueUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import org.apache.commons.collections4.functors.TruePredicate;
import org.apache.commons.collections4.queue.PredicatedQueue;
import org.apache.commons.collections4.queue.TransformedQueue;
import org.apache.commons.collections4.queue.UnmodifiableQueue;

public class QueueUtilsTest
extends BulkTest {
    protected Class<?> stringClass = this.getName().getClass();
    protected Predicate<Object> truePredicate = TruePredicate.truePredicate();
    protected Transformer<Object, Object> nopTransformer = TransformerUtils.nopTransformer();

    public QueueUtilsTest(String name) {
        super(name);
    }

    public static Test suite() {
        return BulkTest.makeSuite(QueueUtilsTest.class);
    }

    public void testUnmodifiableQueue() {
        Queue queue = QueueUtils.unmodifiableQueue(new LinkedList());
        QueueUtilsTest.assertTrue((String)"Returned object should be an UnmodifiableQueue.", (boolean)(queue instanceof UnmodifiableQueue));
        try {
            QueueUtils.unmodifiableQueue(null);
            QueueUtilsTest.fail((String)"Expecting IllegalArgumentException for null queue.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        QueueUtilsTest.assertSame((String)"UnmodifiableQueue shall not be decorated", (Object)queue, (Object)QueueUtils.unmodifiableQueue((Queue)queue));
    }

    public void testPredicatedQueue() {
        Queue queue = QueueUtils.predicatedQueue(new LinkedList(), this.truePredicate);
        QueueUtilsTest.assertTrue((String)"Returned object should be a PredicatedQueue.", (boolean)(queue instanceof PredicatedQueue));
        try {
            QueueUtils.predicatedQueue(null, this.truePredicate);
            QueueUtilsTest.fail((String)"Expecting IllegalArgumentException for null queue.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            QueueUtils.predicatedQueue(new LinkedList(), null);
            QueueUtilsTest.fail((String)"Expecting IllegalArgumentException for null predicate.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testTransformedQueue() {
        Queue queue = QueueUtils.transformingQueue(new LinkedList(), this.nopTransformer);
        QueueUtilsTest.assertTrue((String)"Returned object should be an TransformedQueue.", (boolean)(queue instanceof TransformedQueue));
        try {
            QueueUtils.transformingQueue(null, this.nopTransformer);
            QueueUtilsTest.fail((String)"Expecting IllegalArgumentException for null queue.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            QueueUtils.transformingQueue(new LinkedList(), null);
            QueueUtilsTest.fail((String)"Expecting IllegalArgumentException for null transformer.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEmptyQueue() {
        Queue queue = QueueUtils.emptyQueue();
        QueueUtilsTest.assertTrue((String)"Returned object should be an UnmodifiableQueue.", (boolean)(queue instanceof UnmodifiableQueue));
        QueueUtilsTest.assertTrue((String)"Returned queue is not empty.", (boolean)queue.isEmpty());
        try {
            queue.add(new Object());
            QueueUtilsTest.fail((String)"Expecting UnsupportedOperationException for empty queue.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

