/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.collections4.set.PredicatedSet;

public class SetUtilsTest
extends BulkTest {
    public SetUtilsTest(String name) {
        super(name);
    }

    public static Test suite() {
        return BulkTest.makeSuite(SetUtilsTest.class);
    }

    public void testNothing() {
    }

    public void testpredicatedSet() {
        Predicate<Object> predicate = new Predicate<Object>(){

            public boolean evaluate(Object o) {
                return o instanceof String;
            }
        };
        Set set = SetUtils.predicatedSet(new HashSet(), (Predicate)predicate);
        SetUtilsTest.assertTrue((String)"returned object should be a PredicatedSet", (boolean)(set instanceof PredicatedSet));
        try {
            SetUtils.predicatedSet(new HashSet(), null);
            SetUtilsTest.fail((String)"Expecting IllegalArgumentException for null predicate.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            SetUtils.predicatedSet(null, (Predicate)predicate);
            SetUtilsTest.fail((String)"Expecting IllegalArgumentException for null set.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEmptyIfNull() {
        SetUtilsTest.assertTrue((boolean)SetUtils.emptyIfNull(null).isEmpty());
        HashSet set = new HashSet();
        SetUtilsTest.assertSame(set, (Object)SetUtils.emptyIfNull(set));
    }

    public void testEquals() {
        List<String> data = Arrays.asList("a", "b", "c");
        HashSet<String> a = new HashSet<String>(data);
        HashSet<String> b = new HashSet<String>(data);
        SetUtilsTest.assertEquals((boolean)true, (boolean)a.equals(b));
        SetUtilsTest.assertEquals((boolean)true, (boolean)SetUtils.isEqualSet(a, b));
        a.clear();
        SetUtilsTest.assertEquals((boolean)false, (boolean)SetUtils.isEqualSet(a, b));
        SetUtilsTest.assertEquals((boolean)false, (boolean)SetUtils.isEqualSet(a, null));
        SetUtilsTest.assertEquals((boolean)false, (boolean)SetUtils.isEqualSet(null, b));
        SetUtilsTest.assertEquals((boolean)true, (boolean)SetUtils.isEqualSet(null, null));
    }

    public void testHashCode() {
        List<String> data = Arrays.asList("a", "b", "c");
        HashSet<String> a = new HashSet<String>(data);
        HashSet<String> b = new HashSet<String>(data);
        SetUtilsTest.assertEquals((boolean)true, (a.hashCode() == b.hashCode() ? 1 : 0) != 0);
        SetUtilsTest.assertEquals((boolean)true, (a.hashCode() == SetUtils.hashCodeForSet(a) ? 1 : 0) != 0);
        SetUtilsTest.assertEquals((boolean)true, (b.hashCode() == SetUtils.hashCodeForSet(b) ? 1 : 0) != 0);
        SetUtilsTest.assertEquals((boolean)true, (SetUtils.hashCodeForSet(a) == SetUtils.hashCodeForSet(b) ? 1 : 0) != 0);
        a.clear();
        SetUtilsTest.assertEquals((boolean)false, (SetUtils.hashCodeForSet(a) == SetUtils.hashCodeForSet(b) ? 1 : 0) != 0);
        SetUtilsTest.assertEquals((int)0, (int)SetUtils.hashCodeForSet(null));
    }
}

