/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.ClosureUtils;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.FactoryUtils;
import org.apache.commons.collections4.FunctorException;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.TestUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import org.apache.commons.collections4.functors.CloneTransformer;
import org.apache.commons.collections4.functors.ConstantTransformer;
import org.apache.commons.collections4.functors.EqualPredicate;
import org.apache.commons.collections4.functors.ExceptionTransformer;
import org.apache.commons.collections4.functors.FalsePredicate;
import org.apache.commons.collections4.functors.NOPTransformer;
import org.apache.commons.collections4.functors.StringValueTransformer;
import org.apache.commons.collections4.functors.TruePredicate;

public class TransformerUtilsTest
extends TestCase {
    private static final Object cObject = new Object();
    private static final Object cString = "Hello";
    private static final Object cInteger = 6;

    public void setUp() {
    }

    public void tearDown() {
    }

    public void testExceptionTransformer() {
        TransformerUtilsTest.assertNotNull((Object)TransformerUtils.exceptionTransformer());
        TransformerUtilsTest.assertSame((Object)TransformerUtils.exceptionTransformer(), (Object)TransformerUtils.exceptionTransformer());
        try {
            TransformerUtils.exceptionTransformer().transform(null);
        }
        catch (FunctorException ex) {
            try {
                TransformerUtils.exceptionTransformer().transform(cString);
            }
            catch (FunctorException ex2) {
                return;
            }
        }
        TransformerUtilsTest.fail();
    }

    public void testNullTransformer() {
        TransformerUtilsTest.assertNotNull((Object)TransformerUtils.nullTransformer());
        TransformerUtilsTest.assertSame((Object)TransformerUtils.nullTransformer(), (Object)TransformerUtils.nullTransformer());
        TransformerUtilsTest.assertEquals(null, (Object)TransformerUtils.nullTransformer().transform(null));
        TransformerUtilsTest.assertEquals(null, (Object)TransformerUtils.nullTransformer().transform(cObject));
        TransformerUtilsTest.assertEquals(null, (Object)TransformerUtils.nullTransformer().transform(cString));
        TransformerUtilsTest.assertEquals(null, (Object)TransformerUtils.nullTransformer().transform(cInteger));
    }

    public void testNopTransformer() {
        TransformerUtilsTest.assertNotNull((Object)TransformerUtils.nullTransformer());
        TransformerUtilsTest.assertSame((Object)TransformerUtils.nullTransformer(), (Object)TransformerUtils.nullTransformer());
        TransformerUtilsTest.assertEquals(null, (Object)TransformerUtils.nopTransformer().transform(null));
        TransformerUtilsTest.assertEquals((Object)cObject, (Object)TransformerUtils.nopTransformer().transform(cObject));
        TransformerUtilsTest.assertEquals((Object)cString, (Object)TransformerUtils.nopTransformer().transform(cString));
        TransformerUtilsTest.assertEquals((Object)cInteger, (Object)TransformerUtils.nopTransformer().transform(cInteger));
    }

    public void testConstantTransformer() {
        TransformerUtilsTest.assertEquals((Object)cObject, (Object)TransformerUtils.constantTransformer((Object)cObject).transform(null));
        TransformerUtilsTest.assertEquals((Object)cObject, (Object)TransformerUtils.constantTransformer((Object)cObject).transform(cObject));
        TransformerUtilsTest.assertEquals((Object)cObject, (Object)TransformerUtils.constantTransformer((Object)cObject).transform(cString));
        TransformerUtilsTest.assertEquals((Object)cObject, (Object)TransformerUtils.constantTransformer((Object)cObject).transform(cInteger));
        TransformerUtilsTest.assertSame((Object)ConstantTransformer.NULL_INSTANCE, (Object)TransformerUtils.constantTransformer(null));
    }

    public void testCloneTransformer() {
        TransformerUtilsTest.assertEquals(null, (Object)TransformerUtils.cloneTransformer().transform(null));
        TransformerUtilsTest.assertEquals((Object)cString, (Object)TransformerUtils.cloneTransformer().transform(cString));
        TransformerUtilsTest.assertEquals((Object)cInteger, (Object)TransformerUtils.cloneTransformer().transform(cInteger));
        try {
            TransformerUtilsTest.assertEquals((Object)cObject, (Object)TransformerUtils.cloneTransformer().transform(cObject));
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        TransformerUtilsTest.fail();
    }

    public void testMapTransformer() {
        HashMap<Object, Integer> map = new HashMap<Object, Integer>();
        map.put(null, 0);
        map.put(cObject, 1);
        map.put(cString, 2);
        TransformerUtilsTest.assertEquals((Object)0, (Object)TransformerUtils.mapTransformer(map).transform(null));
        TransformerUtilsTest.assertEquals((Object)1, (Object)TransformerUtils.mapTransformer(map).transform(cObject));
        TransformerUtilsTest.assertEquals((Object)2, (Object)TransformerUtils.mapTransformer(map).transform(cString));
        TransformerUtilsTest.assertEquals(null, (Object)TransformerUtils.mapTransformer(map).transform(cInteger));
        TransformerUtilsTest.assertSame((Object)ConstantTransformer.NULL_INSTANCE, (Object)TransformerUtils.mapTransformer(null));
    }

    public void testExecutorTransformer() {
        TransformerUtilsTest.assertEquals(null, (Object)TransformerUtils.asTransformer((Closure)ClosureUtils.nopClosure()).transform(null));
        TransformerUtilsTest.assertEquals((Object)cObject, (Object)TransformerUtils.asTransformer((Closure)ClosureUtils.nopClosure()).transform(cObject));
        TransformerUtilsTest.assertEquals((Object)cString, (Object)TransformerUtils.asTransformer((Closure)ClosureUtils.nopClosure()).transform(cString));
        TransformerUtilsTest.assertEquals((Object)cInteger, (Object)TransformerUtils.asTransformer((Closure)ClosureUtils.nopClosure()).transform(cInteger));
        try {
            TransformerUtils.asTransformer((Closure)null);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        TransformerUtilsTest.fail();
    }

    public void testPredicateTransformer() {
        TransformerUtilsTest.assertEquals((Object)Boolean.TRUE, (Object)TransformerUtils.asTransformer((Predicate)TruePredicate.truePredicate()).transform(null));
        TransformerUtilsTest.assertEquals((Object)Boolean.TRUE, (Object)TransformerUtils.asTransformer((Predicate)TruePredicate.truePredicate()).transform(cObject));
        TransformerUtilsTest.assertEquals((Object)Boolean.TRUE, (Object)TransformerUtils.asTransformer((Predicate)TruePredicate.truePredicate()).transform(cString));
        TransformerUtilsTest.assertEquals((Object)Boolean.TRUE, (Object)TransformerUtils.asTransformer((Predicate)TruePredicate.truePredicate()).transform(cInteger));
        try {
            TransformerUtils.asTransformer((Predicate)null);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        TransformerUtilsTest.fail();
    }

    public void testFactoryTransformer() {
        TransformerUtilsTest.assertEquals(null, (Object)TransformerUtils.asTransformer((Factory)FactoryUtils.nullFactory()).transform(null));
        TransformerUtilsTest.assertEquals(null, (Object)TransformerUtils.asTransformer((Factory)FactoryUtils.nullFactory()).transform(cObject));
        TransformerUtilsTest.assertEquals(null, (Object)TransformerUtils.asTransformer((Factory)FactoryUtils.nullFactory()).transform(cString));
        TransformerUtilsTest.assertEquals(null, (Object)TransformerUtils.asTransformer((Factory)FactoryUtils.nullFactory()).transform(cInteger));
        try {
            TransformerUtils.asTransformer((Factory)null);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        TransformerUtilsTest.fail();
    }

    public void testChainedTransformer() {
        Transformer a = TransformerUtils.constantTransformer((Object)"A");
        Transformer b = TransformerUtils.constantTransformer((Object)"B");
        TransformerUtilsTest.assertEquals((Object)"A", (Object)TransformerUtils.chainedTransformer((Transformer[])new Transformer[]{b, a}).transform(null));
        TransformerUtilsTest.assertEquals((Object)"B", (Object)TransformerUtils.chainedTransformer((Transformer[])new Transformer[]{a, b}).transform(null));
        TransformerUtilsTest.assertEquals((Object)"A", (Object)TransformerUtils.chainedTransformer((Transformer[])new Transformer[]{b, a}).transform(null));
        ArrayList<Transformer> coll = new ArrayList<Transformer>();
        coll.add(b);
        coll.add(a);
        TransformerUtilsTest.assertEquals((Object)"A", (Object)TransformerUtils.chainedTransformer(coll).transform(null));
        TransformerUtilsTest.assertSame((Object)NOPTransformer.INSTANCE, (Object)TransformerUtils.chainedTransformer((Transformer[])new Transformer[0]));
        TransformerUtilsTest.assertSame((Object)NOPTransformer.INSTANCE, (Object)TransformerUtils.chainedTransformer(Collections.emptyList()));
        try {
            TransformerUtils.chainedTransformer((Transformer[])new Transformer[]{null, null});
            TransformerUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            TransformerUtils.chainedTransformer((Transformer[])null);
            TransformerUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            TransformerUtils.chainedTransformer((Collection)null);
            TransformerUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            TransformerUtils.chainedTransformer((Transformer[])new Transformer[]{null, null});
            TransformerUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            coll = new ArrayList();
            coll.add(null);
            coll.add(null);
            TransformerUtils.chainedTransformer(coll);
            TransformerUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    public void testSwitchTransformer() {
        Transformer a = TransformerUtils.constantTransformer((Object)"A");
        Transformer b = TransformerUtils.constantTransformer((Object)"B");
        Transformer c = TransformerUtils.constantTransformer((Object)"C");
        TransformerUtilsTest.assertEquals((String)"A", (String)((String)TransformerUtils.switchTransformer((Predicate)TruePredicate.truePredicate(), (Transformer)a, (Transformer)b).transform(null)));
        TransformerUtilsTest.assertEquals((String)"B", (String)((String)TransformerUtils.switchTransformer((Predicate)FalsePredicate.falsePredicate(), (Transformer)a, (Transformer)b).transform(null)));
        TransformerUtilsTest.assertEquals(null, (Object)TransformerUtils.switchTransformer((Predicate[])new Predicate[]{EqualPredicate.equalPredicate((Object)"HELLO"), EqualPredicate.equalPredicate((Object)"THERE")}, (Transformer[])new Transformer[]{a, b}).transform((Object)"WELL"));
        TransformerUtilsTest.assertEquals((Object)"A", (Object)TransformerUtils.switchTransformer((Predicate[])new Predicate[]{EqualPredicate.equalPredicate((Object)"HELLO"), EqualPredicate.equalPredicate((Object)"THERE")}, (Transformer[])new Transformer[]{a, b}).transform((Object)"HELLO"));
        TransformerUtilsTest.assertEquals((Object)"B", (Object)TransformerUtils.switchTransformer((Predicate[])new Predicate[]{EqualPredicate.equalPredicate((Object)"HELLO"), EqualPredicate.equalPredicate((Object)"THERE")}, (Transformer[])new Transformer[]{a, b}).transform((Object)"THERE"));
        TransformerUtilsTest.assertEquals((Object)"C", (Object)TransformerUtils.switchTransformer((Predicate[])new Predicate[]{EqualPredicate.equalPredicate((Object)"HELLO"), EqualPredicate.equalPredicate((Object)"THERE")}, (Transformer[])new Transformer[]{a, b}, (Transformer)c).transform((Object)"WELL"));
        HashMap<Predicate, Transformer> map = new HashMap<Predicate, Transformer>();
        map.put(EqualPredicate.equalPredicate((Object)"HELLO"), a);
        map.put(EqualPredicate.equalPredicate((Object)"THERE"), b);
        TransformerUtilsTest.assertEquals(null, (String)((String)TransformerUtils.switchTransformer(map).transform((Object)"WELL")));
        TransformerUtilsTest.assertEquals((String)"A", (String)((String)TransformerUtils.switchTransformer(map).transform((Object)"HELLO")));
        TransformerUtilsTest.assertEquals((String)"B", (String)((String)TransformerUtils.switchTransformer(map).transform((Object)"THERE")));
        map.put(null, c);
        TransformerUtilsTest.assertEquals((String)"C", (String)((String)TransformerUtils.switchTransformer(map).transform((Object)"WELL")));
        TransformerUtilsTest.assertEquals((Object)ConstantTransformer.NULL_INSTANCE, (Object)TransformerUtils.switchTransformer((Predicate[])new Predicate[0], (Transformer[])new Transformer[0]));
        TransformerUtilsTest.assertEquals((Object)ConstantTransformer.NULL_INSTANCE, (Object)TransformerUtils.switchTransformer(new HashMap()));
        map = new HashMap();
        map.put(null, null);
        TransformerUtilsTest.assertEquals((Object)ConstantTransformer.NULL_INSTANCE, (Object)TransformerUtils.switchTransformer(map));
        try {
            TransformerUtils.switchTransformer(null, null);
            TransformerUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            TransformerUtils.switchTransformer((Predicate[])null, (Transformer[])null);
            TransformerUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            TransformerUtils.switchTransformer((Map)null);
            TransformerUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            TransformerUtils.switchTransformer((Predicate[])new Predicate[2], (Transformer[])new Transformer[2]);
            TransformerUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            TransformerUtils.switchTransformer((Predicate[])new Predicate[]{TruePredicate.truePredicate()}, (Transformer[])new Transformer[]{a, b});
            TransformerUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    public void testSwitchMapTransformer() {
        Transformer a = TransformerUtils.constantTransformer((Object)"A");
        Transformer b = TransformerUtils.constantTransformer((Object)"B");
        Transformer c = TransformerUtils.constantTransformer((Object)"C");
        HashMap<String, Transformer> map = new HashMap<String, Transformer>();
        map.put("HELLO", a);
        map.put("THERE", b);
        TransformerUtilsTest.assertEquals(null, (String)((String)TransformerUtils.switchMapTransformer(map).transform((Object)"WELL")));
        TransformerUtilsTest.assertEquals((String)"A", (String)((String)TransformerUtils.switchMapTransformer(map).transform((Object)"HELLO")));
        TransformerUtilsTest.assertEquals((String)"B", (String)((String)TransformerUtils.switchMapTransformer(map).transform((Object)"THERE")));
        map.put(null, c);
        TransformerUtilsTest.assertEquals((String)"C", (String)((String)TransformerUtils.switchMapTransformer(map).transform((Object)"WELL")));
        TransformerUtilsTest.assertSame((Object)ConstantTransformer.NULL_INSTANCE, (Object)TransformerUtils.switchMapTransformer(new HashMap()));
        map = new HashMap();
        map.put(null, null);
        TransformerUtilsTest.assertSame((Object)ConstantTransformer.NULL_INSTANCE, (Object)TransformerUtils.switchMapTransformer(map));
        try {
            TransformerUtils.switchMapTransformer(null);
            TransformerUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    public void testInvokerTransformer() {
        ArrayList<Object> list = new ArrayList<Object>();
        TransformerUtilsTest.assertEquals((Object)0, (Object)TransformerUtils.invokerTransformer((String)"size").transform(list));
        list.add(new Object());
        TransformerUtilsTest.assertEquals((Object)1, (Object)TransformerUtils.invokerTransformer((String)"size").transform(list));
        TransformerUtilsTest.assertEquals(null, (Object)TransformerUtils.invokerTransformer((String)"size").transform(null));
        try {
            TransformerUtils.invokerTransformer(null);
            TransformerUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            TransformerUtils.invokerTransformer((String)"noSuchMethod").transform(new Object());
            TransformerUtilsTest.fail();
        }
        catch (FunctorException functorException) {
            // empty catch block
        }
    }

    public void testInvokerTransformer2() {
        ArrayList<Object> list = new ArrayList<Object>();
        TransformerUtilsTest.assertEquals((Object)Boolean.FALSE, (Object)TransformerUtils.invokerTransformer((String)"contains", (Class[])new Class[]{Object.class}, (Object[])new Object[]{cString}).transform(list));
        list.add(cString);
        TransformerUtilsTest.assertEquals((Object)Boolean.TRUE, (Object)TransformerUtils.invokerTransformer((String)"contains", (Class[])new Class[]{Object.class}, (Object[])new Object[]{cString}).transform(list));
        TransformerUtilsTest.assertEquals(null, (Object)TransformerUtils.invokerTransformer((String)"contains", (Class[])new Class[]{Object.class}, (Object[])new Object[]{cString}).transform(null));
        try {
            TransformerUtils.invokerTransformer(null, null, null);
            TransformerUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            TransformerUtils.invokerTransformer((String)"noSuchMethod", (Class[])new Class[]{Object.class}, (Object[])new Object[]{cString}).transform(new Object());
            TransformerUtilsTest.fail();
        }
        catch (FunctorException ex) {
            // empty catch block
        }
        try {
            TransformerUtils.invokerTransformer((String)"badArgs", null, (Object[])new Object[]{cString});
            TransformerUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            TransformerUtils.invokerTransformer((String)"badArgs", (Class[])new Class[]{Object.class}, null);
            TransformerUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            TransformerUtils.invokerTransformer((String)"badArgs", (Class[])new Class[0], (Object[])new Object[]{cString});
            TransformerUtilsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testStringValueTransformer() {
        TransformerUtilsTest.assertNotNull((String)"StringValueTransformer should NEVER return a null value.", (Object)TransformerUtils.stringValueTransformer().transform(null));
        TransformerUtilsTest.assertEquals((String)"StringValueTransformer should return \"null\" when given a null argument.", (String)"null", (String)((String)TransformerUtils.stringValueTransformer().transform(null)));
        TransformerUtilsTest.assertEquals((String)"StringValueTransformer should return toString value", (String)"6", (String)((String)TransformerUtils.stringValueTransformer().transform((Object)6)));
    }

    public void testInstantiateTransformerNull() {
        try {
            TransformerUtils.instantiateTransformer(null, (Object[])new Object[]{"str"});
            TransformerUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            TransformerUtils.instantiateTransformer((Class[])new Class[0], (Object[])new Object[]{"str"});
            TransformerUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        Transformer trans = TransformerUtils.instantiateTransformer((Class[])new Class[]{Long.class}, (Object[])new Object[]{null});
        try {
            trans.transform(String.class);
            TransformerUtilsTest.fail();
        }
        catch (FunctorException functorException) {
            // empty catch block
        }
        trans = TransformerUtils.instantiateTransformer();
        TransformerUtilsTest.assertEquals((Object)"", (Object)trans.transform(String.class));
        trans = TransformerUtils.instantiateTransformer((Class[])new Class[]{Long.TYPE}, (Object[])new Object[]{new Long(1000L)});
        TransformerUtilsTest.assertEquals((Object)new Date(1000L), (Object)trans.transform(Date.class));
    }

    public void testSingletonPatternInSerialization() {
        Object[] singletones;
        for (Object original : singletones = new Object[]{CloneTransformer.INSTANCE, ExceptionTransformer.INSTANCE, NOPTransformer.INSTANCE, StringValueTransformer.stringValueTransformer()}) {
            TestUtils.assertSameAfterSerialization("Singleton pattern broken for " + original.getClass(), original);
        }
    }
}

