/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bag;

import java.util.Iterator;
import org.apache.commons.collections4.SortedBag;
import org.apache.commons.collections4.bag.AbstractBagTest;
import org.apache.commons.collections4.bag.CollectionSortedBag;
import org.apache.commons.collections4.bag.TreeBag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSortedBagTest<T>
extends AbstractBagTest<T> {
    public AbstractSortedBagTest(String testName) {
        super(testName);
    }

    @Override
    public void verify() {
        super.verify();
        Iterator colliter = this.getCollection().iterator();
        Iterator confiter = this.getConfirmed().iterator();
        Object first = null;
        Object last = null;
        while (colliter.hasNext()) {
            last = first == null ? (first = colliter.next()) : colliter.next();
            AbstractSortedBagTest.assertEquals((String)"Element appears to be out of order.", last, confiter.next());
        }
        if (this.getCollection().size() > 0) {
            AbstractSortedBagTest.assertEquals((String)"Incorrect element returned by first().", first, (Object)this.getCollection().first());
            AbstractSortedBagTest.assertEquals((String)"Incorrect element returned by last().", last, (Object)this.getCollection().last());
        }
    }

    @Override
    public boolean isNullSupported() {
        return false;
    }

    @Override
    public abstract SortedBag<T> makeObject();

    @Override
    public SortedBag<T> makeFullCollection() {
        return (SortedBag)super.makeFullCollection();
    }

    @Override
    public SortedBag<T> makeConfirmedCollection() {
        return new TreeBag();
    }

    @Override
    public void resetEmpty() {
        this.setCollection(CollectionSortedBag.collectionSortedBag(this.makeObject()));
        this.setConfirmed(this.makeConfirmedCollection());
    }

    @Override
    public void resetFull() {
        this.setCollection(CollectionSortedBag.collectionSortedBag(this.makeFullCollection()));
        this.setConfirmed(this.makeConfirmedFullCollection());
    }

    @Override
    public T[] getFullNonNullElements() {
        Object[] elements = new Object[30];
        for (int i = 0; i < 30; ++i) {
            elements[i] = i + i + 1;
        }
        return elements;
    }

    @Override
    public T[] getOtherNonNullElements() {
        Object[] elements = new Object[30];
        for (int i = 0; i < 30; ++i) {
            elements[i] = i + i + 2;
        }
        return elements;
    }

    @Override
    public SortedBag<T> getCollection() {
        return (SortedBag)super.getCollection();
    }
}

