/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bag;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.bag.CollectionBag;
import org.apache.commons.collections4.bag.HashBag;
import org.apache.commons.collections4.collection.AbstractCollectionTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionBagTest<T>
extends AbstractCollectionTest<T> {
    public CollectionBagTest(String testName) {
        super(testName);
    }

    @Override
    public Bag<T> makeObject() {
        return CollectionBag.collectionBag((Bag)new HashBag());
    }

    @Override
    public Collection<T> makeConfirmedCollection() {
        return new ArrayList();
    }

    @Override
    public Collection<T> makeConfirmedFullCollection() {
        Collection<T> set = this.makeConfirmedCollection();
        set.addAll(Arrays.asList(this.getFullElements()));
        return set;
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    public void testEmptyBagCompatibility() throws IOException, ClassNotFoundException {
        Bag<T> bag = this.makeObject();
        if (bag instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            Bag bag2 = (Bag)this.readExternalFormFromDisk(this.getCanonicalEmptyCollectionName(bag));
            CollectionBagTest.assertTrue((String)"Bag is empty", (bag2.size() == 0 ? 1 : 0) != 0);
            CollectionBagTest.assertEquals(bag, (Object)bag2);
        }
    }

    public void testFullBagCompatibility() throws IOException, ClassNotFoundException {
        Bag bag = (Bag)this.makeFullCollection();
        if (bag instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            Bag bag2 = (Bag)this.readExternalFormFromDisk(this.getCanonicalFullCollectionName(bag));
            CollectionBagTest.assertEquals((String)"Bag is the right size", (int)bag.size(), (int)bag2.size());
            CollectionBagTest.assertEquals((Object)bag, (Object)bag2);
        }
    }
}

