/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bag;

import junit.framework.Test;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.bag.AbstractBagTest;
import org.apache.commons.collections4.bag.HashBag;
import org.apache.commons.collections4.bag.TransformedBag;
import org.apache.commons.collections4.collection.TransformedCollectionTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformedBagTest<T>
extends AbstractBagTest<T> {
    public TransformedBagTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(TransformedBagTest.class);
    }

    @Override
    public Bag<T> makeObject() {
        return TransformedBag.transformingBag((Bag)new HashBag(), TransformedCollectionTest.NOOP_TRANSFORMER);
    }

    public void testTransformedBag() {
        Bag bag = TransformedBag.transformingBag((Bag)new HashBag(), TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        TransformedBagTest.assertEquals((int)0, (int)bag.size());
        Object[] els = new Object[]{"1", "3", "5", "7", "2", "4", "6"};
        for (int i = 0; i < els.length; ++i) {
            bag.add(els[i]);
            TransformedBagTest.assertEquals((int)(i + 1), (int)bag.size());
            TransformedBagTest.assertEquals((boolean)true, (boolean)bag.contains((Object)Integer.valueOf((String)els[i])));
            TransformedBagTest.assertEquals((boolean)false, (boolean)bag.contains(els[i]));
        }
        TransformedBagTest.assertEquals((boolean)false, (boolean)bag.remove(els[0]));
        TransformedBagTest.assertEquals((boolean)true, (boolean)bag.remove((Object)Integer.valueOf((String)els[0])));
    }

    public void testTransformedBag_decorateTransform() {
        Object[] els;
        HashBag originalBag = new HashBag();
        for (Object el : els = new Object[]{"1", "3", "5", "7", "2", "4", "6"}) {
            originalBag.add(el);
        }
        Bag bag = TransformedBag.transformedBag((Bag)originalBag, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        TransformedBagTest.assertEquals((int)els.length, (int)bag.size());
        for (Object el : els) {
            TransformedBagTest.assertEquals((boolean)true, (boolean)bag.contains((Object)Integer.valueOf((String)el)));
            TransformedBagTest.assertEquals((boolean)false, (boolean)bag.contains(el));
        }
        TransformedBagTest.assertEquals((boolean)false, (boolean)bag.remove(els[0]));
        TransformedBagTest.assertEquals((boolean)true, (boolean)bag.remove((Object)Integer.valueOf((String)els[0])));
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

