/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bidimap;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.iterators.AbstractMapIteratorTest;
import org.apache.commons.collections4.map.AbstractIterableMapTest;
import org.apache.commons.collections4.map.AbstractMapTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBidiMapTest<K, V>
extends AbstractIterableMapTest<K, V> {
    public AbstractBidiMapTest(String testName) {
        super(testName);
    }

    public AbstractBidiMapTest() {
        super("Inverse");
    }

    @Override
    public BidiMap<K, V> makeFullMap() {
        return (BidiMap)super.makeFullMap();
    }

    @Override
    public abstract BidiMap<K, V> makeObject();

    @Override
    public boolean isAllowDuplicateValues() {
        return false;
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    public void testBidiPut() {
        if (!this.isPutAddSupported() || !this.isPutChangeSupported()) {
            return;
        }
        BidiMap<K, V> map = this.makeObject();
        BidiMap inverse = map.inverseBidiMap();
        AbstractBidiMapTest.assertEquals((int)0, (int)map.size());
        AbstractBidiMapTest.assertEquals((int)map.size(), (int)inverse.size());
        map.put((Object)"A", (Object)"B");
        AbstractBidiMapTest.assertEquals((int)1, (int)map.size());
        AbstractBidiMapTest.assertEquals((int)map.size(), (int)inverse.size());
        AbstractBidiMapTest.assertEquals((Object)"B", (Object)map.get((Object)"A"));
        AbstractBidiMapTest.assertEquals((Object)"A", (Object)inverse.get((Object)"B"));
        map.put((Object)"A", (Object)"C");
        AbstractBidiMapTest.assertEquals((int)1, (int)map.size());
        AbstractBidiMapTest.assertEquals((int)map.size(), (int)inverse.size());
        AbstractBidiMapTest.assertEquals((Object)"C", (Object)map.get((Object)"A"));
        AbstractBidiMapTest.assertEquals((Object)"A", (Object)inverse.get((Object)"C"));
        map.put((Object)"B", (Object)"C");
        AbstractBidiMapTest.assertEquals((int)1, (int)map.size());
        AbstractBidiMapTest.assertEquals((int)map.size(), (int)inverse.size());
        AbstractBidiMapTest.assertEquals((Object)"C", (Object)map.get((Object)"B"));
        AbstractBidiMapTest.assertEquals((Object)"B", (Object)inverse.get((Object)"C"));
        map.put((Object)"E", (Object)"F");
        AbstractBidiMapTest.assertEquals((int)2, (int)map.size());
        AbstractBidiMapTest.assertEquals((int)map.size(), (int)inverse.size());
        AbstractBidiMapTest.assertEquals((Object)"F", (Object)map.get((Object)"E"));
        AbstractBidiMapTest.assertEquals((Object)"E", (Object)inverse.get((Object)"F"));
    }

    @Override
    public void verify() {
        this.verifyInverse();
        super.verify();
    }

    public void verifyInverse() {
        AbstractBidiMapTest.assertEquals((int)this.map.size(), (int)((BidiMap)this.map).inverseBidiMap().size());
        HashMap map1 = new HashMap(this.map);
        HashMap map2 = new HashMap(((BidiMap)this.map).inverseBidiMap());
        Set keys1 = map1.keySet();
        Set keys2 = map2.keySet();
        Collection values1 = map1.values();
        Collection values2 = map2.values();
        AbstractBidiMapTest.assertEquals((boolean)true, (boolean)keys1.containsAll(values2));
        AbstractBidiMapTest.assertEquals((boolean)true, (boolean)values2.containsAll(keys1));
        AbstractBidiMapTest.assertEquals((boolean)true, (boolean)values1.containsAll(keys2));
        AbstractBidiMapTest.assertEquals((boolean)true, (boolean)keys2.containsAll(values1));
    }

    public void testBidiGetKey() {
        this.doTestGetKey(this.makeFullMap(), this.getSampleKeys()[0], this.getSampleValues()[0]);
    }

    public void testBidiGetKeyInverse() {
        this.doTestGetKey(this.makeFullMap().inverseBidiMap(), this.getSampleValues()[0], this.getSampleKeys()[0]);
    }

    private void doTestGetKey(BidiMap<?, ?> map, Object key, Object value) {
        AbstractBidiMapTest.assertEquals((String)"Value not found for key.", (Object)value, (Object)map.get(key));
        AbstractBidiMapTest.assertEquals((String)"Key not found for value.", (Object)key, (Object)map.getKey(value));
    }

    public void testBidiInverse() {
        BidiMap<K, V> map = this.makeFullMap();
        BidiMap inverseMap = map.inverseBidiMap();
        AbstractBidiMapTest.assertSame((String)"Inverse of inverse is not equal to original.", map, (Object)inverseMap.inverseBidiMap());
        AbstractBidiMapTest.assertEquals((String)"Value not found for key.", this.getSampleKeys()[0], (Object)inverseMap.get(this.getSampleValues()[0]));
        AbstractBidiMapTest.assertEquals((String)"Key not found for value.", this.getSampleValues()[0], (Object)inverseMap.getKey(this.getSampleKeys()[0]));
    }

    public void testBidiModifyEntrySet() {
        if (!this.isSetValueSupported()) {
            return;
        }
        this.modifyEntrySet(this.makeFullMap());
        this.modifyEntrySet(this.makeFullMap().inverseBidiMap());
    }

    private <T> void modifyEntrySet(BidiMap<?, T> map) {
        Map.Entry entry = (Map.Entry)map.entrySet().iterator().next();
        Object key = entry.getKey();
        Object oldValue = entry.getValue();
        String newValue = "newValue";
        entry.setValue(newValue);
        AbstractBidiMapTest.assertEquals((String)"Modifying entrySet did not affect underlying Map.", (Object)newValue, (Object)map.get(key));
        AbstractBidiMapTest.assertNull((String)"Modifying entrySet did not affect inverse Map.", (Object)map.getKey(oldValue));
    }

    public void testBidiClear() {
        if (!this.isRemoveSupported()) {
            try {
                this.makeFullMap().clear();
                AbstractBidiMapTest.fail();
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
            return;
        }
        BidiMap map = this.makeFullMap();
        map.clear();
        AbstractBidiMapTest.assertTrue((String)"Map was not cleared.", (boolean)map.isEmpty());
        AbstractBidiMapTest.assertTrue((String)"Inverse map was not cleared.", (boolean)map.inverseBidiMap().isEmpty());
        map = this.makeFullMap().inverseBidiMap();
        map.clear();
        AbstractBidiMapTest.assertTrue((String)"Map was not cleared.", (boolean)map.isEmpty());
        AbstractBidiMapTest.assertTrue((String)"Inverse map was not cleared.", (boolean)map.inverseBidiMap().isEmpty());
    }

    public void testBidiRemove() {
        if (!this.isRemoveSupported()) {
            try {
                this.makeFullMap().remove(this.getSampleKeys()[0]);
                AbstractBidiMapTest.fail();
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
            try {
                this.makeFullMap().removeValue(this.getSampleValues()[0]);
                AbstractBidiMapTest.fail();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return;
        }
        this.remove(this.makeFullMap(), this.getSampleKeys()[0]);
        this.remove(this.makeFullMap().inverseBidiMap(), this.getSampleValues()[0]);
        this.removeValue(this.makeFullMap(), this.getSampleValues()[0]);
        this.removeValue(this.makeFullMap().inverseBidiMap(), this.getSampleKeys()[0]);
        AbstractBidiMapTest.assertEquals(null, (Object)this.makeFullMap().removeValue((Object)"NotPresent"));
    }

    private void remove(BidiMap<?, ?> map, Object key) {
        Object value = map.remove(key);
        AbstractBidiMapTest.assertTrue((String)"Key was not removed.", (!map.containsKey(key) ? 1 : 0) != 0);
        AbstractBidiMapTest.assertNull((String)"Value was not removed.", (Object)map.getKey(value));
    }

    private void removeValue(BidiMap<?, ?> map, Object value) {
        Object key = map.removeValue(value);
        AbstractBidiMapTest.assertTrue((String)"Key was not removed.", (!map.containsKey(key) ? 1 : 0) != 0);
        AbstractBidiMapTest.assertNull((String)"Value was not removed.", (Object)map.getKey(value));
    }

    public void testBidiKeySetValuesOrder() {
        this.resetFull();
        Iterator keys = this.map.keySet().iterator();
        Iterator values = this.map.values().iterator();
        while (keys.hasNext() && values.hasNext()) {
            Object key = keys.next();
            Object value = values.next();
            AbstractBidiMapTest.assertSame(this.map.get(key), value);
        }
        AbstractBidiMapTest.assertEquals((boolean)false, (boolean)keys.hasNext());
        AbstractBidiMapTest.assertEquals((boolean)false, (boolean)values.hasNext());
    }

    public void testBidiRemoveByKeySet() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.removeByKeySet(this.makeFullMap(), this.getSampleKeys()[0], this.getSampleValues()[0]);
        this.removeByKeySet(this.makeFullMap().inverseBidiMap(), this.getSampleValues()[0], this.getSampleKeys()[0]);
    }

    private void removeByKeySet(BidiMap<?, ?> map, Object key, Object value) {
        map.keySet().remove(key);
        AbstractBidiMapTest.assertTrue((String)"Key was not removed.", (!map.containsKey(key) ? 1 : 0) != 0);
        AbstractBidiMapTest.assertTrue((String)"Value was not removed.", (!map.containsValue(value) ? 1 : 0) != 0);
        AbstractBidiMapTest.assertTrue((String)"Key was not removed from inverse map.", (!map.inverseBidiMap().containsValue(key) ? 1 : 0) != 0);
        AbstractBidiMapTest.assertTrue((String)"Value was not removed from inverse map.", (!map.inverseBidiMap().containsKey(value) ? 1 : 0) != 0);
    }

    public void testBidiRemoveByEntrySet() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.removeByEntrySet(this.makeFullMap(), this.getSampleKeys()[0], this.getSampleValues()[0]);
        this.removeByEntrySet(this.makeFullMap().inverseBidiMap(), this.getSampleValues()[0], this.getSampleKeys()[0]);
    }

    private void removeByEntrySet(BidiMap<?, ?> map, Object key, Object value) {
        HashMap<Object, Object> temp = new HashMap<Object, Object>();
        temp.put(key, value);
        map.entrySet().remove(temp.entrySet().iterator().next());
        AbstractBidiMapTest.assertTrue((String)"Key was not removed.", (!map.containsKey(key) ? 1 : 0) != 0);
        AbstractBidiMapTest.assertTrue((String)"Value was not removed.", (!map.containsValue(value) ? 1 : 0) != 0);
        AbstractBidiMapTest.assertTrue((String)"Key was not removed from inverse map.", (!map.inverseBidiMap().containsValue(key) ? 1 : 0) != 0);
        AbstractBidiMapTest.assertTrue((String)"Value was not removed from inverse map.", (!map.inverseBidiMap().containsKey(value) ? 1 : 0) != 0);
    }

    @Override
    public BidiMap<K, V> getMap() {
        return (BidiMap)super.getMap();
    }

    @Override
    public BulkTest bulkTestMapEntrySet() {
        return new TestBidiMapEntrySet();
    }

    public BulkTest bulkTestInverseMap() {
        return new TestInverseBidiMap(this);
    }

    public BulkTest bulkTestBidiMapIterator() {
        return new TestBidiMapIterator();
    }

    public void testBidiMapIteratorSet() {
        Object newValue1 = this.getOtherValues()[0];
        Object newValue2 = this.getOtherValues()[1];
        this.resetFull();
        BidiMap<K, V> bidi = this.getMap();
        MapIterator it = bidi.mapIterator();
        AbstractBidiMapTest.assertEquals((boolean)true, (boolean)it.hasNext());
        Object key1 = it.next();
        if (!this.isSetValueSupported()) {
            try {
                it.setValue(newValue1);
                AbstractBidiMapTest.fail();
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
            return;
        }
        it.setValue(newValue1);
        this.confirmed.put(key1, newValue1);
        AbstractBidiMapTest.assertSame((Object)key1, (Object)it.getKey());
        AbstractBidiMapTest.assertSame(newValue1, (Object)it.getValue());
        AbstractBidiMapTest.assertEquals((boolean)true, (boolean)bidi.containsKey(key1));
        AbstractBidiMapTest.assertEquals((boolean)true, (boolean)bidi.containsValue(newValue1));
        AbstractBidiMapTest.assertEquals(newValue1, (Object)bidi.get(key1));
        this.verify();
        it.setValue(newValue1);
        this.confirmed.put(key1, newValue1);
        AbstractBidiMapTest.assertSame((Object)key1, (Object)it.getKey());
        AbstractBidiMapTest.assertSame(newValue1, (Object)it.getValue());
        AbstractBidiMapTest.assertEquals((boolean)true, (boolean)bidi.containsKey(key1));
        AbstractBidiMapTest.assertEquals((boolean)true, (boolean)bidi.containsValue(newValue1));
        AbstractBidiMapTest.assertEquals(newValue1, (Object)bidi.get(key1));
        this.verify();
        Object key2 = it.next();
        it.setValue(newValue2);
        this.confirmed.put(key2, newValue2);
        AbstractBidiMapTest.assertSame((Object)key2, (Object)it.getKey());
        AbstractBidiMapTest.assertSame(newValue2, (Object)it.getValue());
        AbstractBidiMapTest.assertEquals((boolean)true, (boolean)bidi.containsKey(key2));
        AbstractBidiMapTest.assertEquals((boolean)true, (boolean)bidi.containsValue(newValue2));
        AbstractBidiMapTest.assertEquals(newValue2, (Object)bidi.get(key2));
        this.verify();
        try {
            it.setValue(newValue1);
            AbstractBidiMapTest.fail();
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        this.confirmed.put(key2, newValue1);
        this.getConfirmed().remove(key1);
        AbstractBidiMapTest.assertEquals(newValue1, (Object)it.getValue());
        AbstractBidiMapTest.assertEquals((boolean)true, (boolean)bidi.containsKey(it.getKey()));
        AbstractBidiMapTest.assertEquals((boolean)true, (boolean)bidi.containsValue(newValue1));
        AbstractBidiMapTest.assertEquals(newValue1, (Object)bidi.get(it.getKey()));
        AbstractBidiMapTest.assertEquals((boolean)false, (boolean)bidi.containsKey(key1));
        AbstractBidiMapTest.assertEquals((boolean)false, (boolean)bidi.containsValue(newValue2));
        this.verify();
        it.next();
        if (this.isRemoveSupported()) {
            it.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TestBidiMapIterator
    extends AbstractMapIteratorTest<K, V> {
        public TestBidiMapIterator() {
            super("TestBidiMapIterator");
        }

        @Override
        public V[] addSetValues() {
            return AbstractBidiMapTest.this.getNewSampleValues();
        }

        @Override
        public boolean supportsRemove() {
            return AbstractBidiMapTest.this.isRemoveSupported();
        }

        @Override
        public boolean supportsSetValue() {
            return AbstractBidiMapTest.this.isSetValueSupported();
        }

        @Override
        public MapIterator<K, V> makeEmptyIterator() {
            AbstractBidiMapTest.this.resetEmpty();
            return AbstractBidiMapTest.this.getMap().mapIterator();
        }

        @Override
        public MapIterator<K, V> makeObject() {
            AbstractBidiMapTest.this.resetFull();
            return AbstractBidiMapTest.this.getMap().mapIterator();
        }

        @Override
        public BidiMap<K, V> getMap() {
            return AbstractBidiMapTest.this.getMap();
        }

        @Override
        public Map<K, V> getConfirmedMap() {
            return AbstractBidiMapTest.this.getConfirmed();
        }

        @Override
        public void verify() {
            super.verify();
            AbstractBidiMapTest.this.verify();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TestInverseBidiMap
    extends AbstractBidiMapTest<V, K> {
        final AbstractBidiMapTest<K, V> main;

        public TestInverseBidiMap(AbstractBidiMapTest<K, V> main) {
            this.main = main;
        }

        @Override
        public BidiMap<V, K> makeObject() {
            return this.main.makeObject().inverseBidiMap();
        }

        @Override
        public BidiMap<V, K> makeFullMap() {
            return this.main.makeFullMap().inverseBidiMap();
        }

        @Override
        public V[] getSampleKeys() {
            return this.main.getSampleValues();
        }

        @Override
        public K[] getSampleValues() {
            return this.main.getSampleKeys();
        }

        @Override
        public String getCompatibilityVersion() {
            return this.main.getCompatibilityVersion();
        }

        @Override
        public boolean isAllowNullKey() {
            return this.main.isAllowNullKey();
        }

        @Override
        public boolean isAllowNullValue() {
            return this.main.isAllowNullValue();
        }

        @Override
        public boolean isPutAddSupported() {
            return this.main.isPutAddSupported();
        }

        @Override
        public boolean isPutChangeSupported() {
            return this.main.isPutChangeSupported();
        }

        @Override
        public boolean isSetValueSupported() {
            return this.main.isSetValueSupported();
        }

        @Override
        public boolean isRemoveSupported() {
            return this.main.isRemoveSupported();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TestBidiMapEntrySet
    extends AbstractMapTest.TestMapEntrySet {
        public void testMapEntrySetIteratorEntrySetValueCrossCheck() {
            Object key1 = AbstractBidiMapTest.this.getSampleKeys()[0];
            Object key2 = AbstractBidiMapTest.this.getSampleKeys()[1];
            Object newValue1 = AbstractBidiMapTest.this.getNewSampleValues()[0];
            Object newValue2 = AbstractBidiMapTest.this.getNewSampleValues()[1];
            this.resetFull();
            Iterator it = this.getCollection().iterator();
            Map.Entry entry1 = this.getEntry(it, key1);
            it = this.getCollection().iterator();
            Map.Entry entry2 = this.getEntry(it, key2);
            Iterator itConfirmed = this.getConfirmed().iterator();
            Map.Entry entryConfirmed1 = this.getEntry(itConfirmed, key1);
            itConfirmed = this.getConfirmed().iterator();
            Map.Entry entryConfirmed2 = this.getEntry(itConfirmed, key2);
            this.verify();
            if (!AbstractBidiMapTest.this.isSetValueSupported()) {
                try {
                    entry1.setValue(newValue1);
                }
                catch (UnsupportedOperationException ex) {
                    // empty catch block
                }
                return;
            }
            entry1.setValue(newValue1);
            entryConfirmed1.setValue(newValue1);
            entry2.setValue(newValue2);
            entryConfirmed2.setValue(newValue2);
            try {
                entry2.setValue(newValue1);
            }
            catch (IllegalArgumentException ex) {
                return;
            }
            entryConfirmed2.setValue(newValue1);
            AbstractBidiMapTest.this.getConfirmed().remove(key1);
            TestBidiMapEntrySet.assertEquals(newValue1, entry2.getValue());
            TestBidiMapEntrySet.assertEquals((boolean)true, (boolean)AbstractBidiMapTest.this.getMap().containsKey(entry2.getKey()));
            TestBidiMapEntrySet.assertEquals((boolean)true, (boolean)AbstractBidiMapTest.this.getMap().containsValue(newValue1));
            TestBidiMapEntrySet.assertEquals(newValue1, (Object)AbstractBidiMapTest.this.getMap().get(entry2.getKey()));
            TestBidiMapEntrySet.assertEquals((boolean)false, (boolean)AbstractBidiMapTest.this.getMap().containsKey(key1));
            TestBidiMapEntrySet.assertEquals((boolean)false, (boolean)AbstractBidiMapTest.this.getMap().containsValue(newValue2));
            this.verify();
            it.next();
            if (this.isRemoveSupported()) {
                it.remove();
            }
        }
    }
}

